/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.mestrelab.components.client.moleditor.IFrameworkServices;
import com.mestrelab.components.client.moleditor.IPluginInfo;
import com.mestrelab.components.client.moleditor.TBasePlugin;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TRtti;
import com.mestrelab.components.client.moleditor.command.TCmdToggleMoleculeLabelMacro;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QUuid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TMoleculePlugin
extends TBasePlugin
implements IPluginInfo {
    @Override
    public void registered(IFrameworkServices aIEvtFilterSrvs) {
        super.registered(aIEvtFilterSrvs);
    }

    public TCanvasMolecule activeMolecule() {
        return (TCanvasMolecule)this.activeItem(TRtti.TRtti_Molecule);
    }

    public void onToggleMacroAction(QString aMacro) {
        TCanvasMolecule cnvMolecule = this.activeMolecule();
        if (cnvMolecule != null) {
            QList<TCanvasItem> itemList = this.fFramework.rttiSelection(TRtti.TRtti_Molecule);
            TCmdToggleMoleculeLabelMacro cmd = new TCmdToggleMoleculeLabelMacro(aMacro, itemList);
            this.fFramework.doCommand(cmd);
        }
    }

    public QList<TCanvasItem> getSelectedMolecules() {
        return this.getfFramework().rttiSelection(TRtti.TRtti_Molecule);
    }

    private QList<TCanvasItem> getByRtti(QList<TCanvasItem> items, TRtti aRtti) {
        QList<TCanvasItem> result = new QList<TCanvasItem>();
        for (TCanvasItem item : items) {
            if (item.rtti() != aRtti) continue;
            result.append(item);
        }
        return result;
    }

    private TCanvasItem getItem(QList<TCanvasItem> items, QUuid aId) {
        for (TCanvasItem item : items) {
            if (item == null || !item.itemId().equals(aId)) continue;
            return item;
        }
        return null;
    }

    public QList<TCanvasItem> getAllMolecules() {
        QList<TCanvasItem> list = this.getfFramework().allDocumentItems();
        return this.getByRtti(list, TRtti.TRtti_Molecule);
    }

    public TCanvasMolecule getCanvasMolecule(QUuid aId) {
        QList<TCanvasItem> list = this.fFramework.allDocumentItems();
        QList<TCanvasItem> listResult = this.getByRtti(list, TRtti.TRtti_Molecule);
        return (TCanvasMolecule)this.getItem(listResult, aId);
    }

    public TMolecule molecule(QUuid aMolID) {
        TCanvasMolecule molItem = this.getCanvasMolecule(aMolID);
        if (molItem != null) {
            return molItem.getMolecule();
        }
        return null;
    }
}

