/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.moleditor.ICanvas;
import com.mestrelab.components.client.moleditor.IFrameworkServices;
import com.mestrelab.components.client.moleditor.QtCanvas;
import com.mestrelab.components.client.moleditor.QtCanvasView;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TMoleculePluginDockWidgetFactory;
import com.mestrelab.components.client.moleditor.TMoleculeTableFactory;
import com.mestrelab.components.client.moleditor.TRtti;
import com.mestrelab.components.client.moleditor.Types_Framework_TModeFlag;
import com.mestrelab.components.client.moleditor.command.TCommand;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygon;
import com.mestrelab.components.shared.qt.QPolygonF;
import com.mestrelab.components.shared.qt.QRect;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QUuid;
import java.util.Stack;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFrameworkGui
extends IFrameworkServices {
    private QtCanvasView canvasView = null;
    private QUuid mode;
    private QUuid plugin;
    private boolean isExclusive;
    private boolean isCheckable;
    private boolean isTemporal;
    private Logger logger = Logger.getLogger(TFrameworkGui.class.getName());
    private Stack<QtCanvas> undo = new Stack();
    private Stack<QtCanvas> redo = new Stack();
    private Stack<TCommand> undoComand = new Stack();
    private Stack<TCommand> redoComand = new Stack();

    public TFrameworkGui(QtCanvasView canvasView) {
        this.canvasView = canvasView;
        this.mode = new QUuid();
        this.plugin = new QUuid();
        this.isExclusive = false;
        this.isCheckable = false;
        this.isTemporal = false;
    }

    @Override
    public TCanvasItem activeItem(TRtti aRtti) {
        return this.canvasView.canvas().allItems().first();
    }

    @Override
    public void addDockWidgetFactory(TMoleculeTableFactory fMoleculeTableFactory) {
    }

    @Override
    public void addDockWidgetFactory(TMoleculePluginDockWidgetFactory fDockWidgetFactory) {
    }

    @Override
    public QList<TCanvasItem> allDocumentItems() {
        return this.allPageItems();
    }

    @Override
    public QList<TCanvasItem> allPageItems() {
        return this.canvasView.canvas().allItems();
    }

    @Override
    public QtCanvasView canvasView() {
        return this.canvasView;
    }

    @Override
    public QUuid currentMode() {
        return this.mode;
    }

    @Override
    public QtCanvas currentPage() {
        return this.canvasView.canvas();
    }

    @Override
    public QPoint<Double> cursorPos() throws Exception {
        throw new Exception("method not implemented");
    }

    @Override
    public void doCommand(TCommand aCmd) {
        this.undo.push(this.currentPage().clone());
        this.undoComand.push(aCmd);
        while (!this.redo.isEmpty()) {
            this.redo.pop();
            this.redoComand.pop();
        }
        if (aCmd != null) {
            aCmd.doCommand();
        }
    }

    @Override
    public Widget mainWnd() {
        return this.canvasView.canvas().getPainter();
    }

    @Override
    public QPoint<Double> map(QPoint<Integer> aPoint, IFrameworkServices.TMapMode from, IFrameworkServices.TMapMode to) {
        QPoint<Double> aPointCanvas = new QPoint<Double>();
        if (from == IFrameworkServices.TMapMode.MAP_DOCWND) {
            ICanvas canvas = this.canvasView.canvas().getPainter().getCanvas();
            double x = aPoint.x() - canvas.getAbsoluteLeft() * (canvas.getCoordinateSpaceWidth() / canvas.getOffsetWidth());
            double y = aPoint.y() - canvas.getAbsoluteTop() * (canvas.getCoordinateSpaceHeight() / canvas.getOffsetHeight());
            aPointCanvas.setX(x > 0.0 ? x : 0.0);
            aPointCanvas.setY(y > 0.0 ? y : 0.0);
            return aPointCanvas;
        }
        aPointCanvas.setX(Double.valueOf(aPoint.x().intValue()));
        aPointCanvas.setY(Double.valueOf(aPoint.y().intValue()));
        return aPointCanvas;
    }

    @Override
    public QRectF map(QRect aRect, IFrameworkServices.TMapMode from, IFrameworkServices.TMapMode to) {
        ICanvas canvas = this.canvasView.canvas().getPainter().getCanvas();
        QPoint<Double> tlPt = this.map(aRect.topLeft(), from, to);
        QPoint<Double> brPt = this.map(aRect.bottomRight(), from, to);
        return new QRectF(tlPt, brPt);
    }

    @Override
    public QPolygonF map(QPolygon aPolygon, IFrameworkServices.TMapMode from, IFrameworkServices.TMapMode to) {
        QPolygonF pol = new QPolygonF(aPolygon.size());
        for (int i = 0; i < aPolygon.size(); ++i) {
            pol.set(i, this.map(aPolygon.at(i).toPoint(), from, to));
        }
        return pol;
    }

    @Override
    public void setMode(QUuid aMode, QUuid aPlugin, Types_Framework_TModeFlag aFlags) {
        this.mode = aMode;
        this.plugin = aPlugin;
        this.isCheckable = (aFlags.getValue() & Types_Framework_TModeFlag.mf_Checkable.getValue()) == 1;
        this.isExclusive = (aFlags.getValue() & Types_Framework_TModeFlag.mf_Exclusive.getValue()) == 1;
        this.isTemporal = (aFlags.getValue() & Types_Framework_TModeFlag.mf_Temporal.getValue()) == 1;
    }

    @Override
    public void update() {
    }

    @Override
    public void update(QRect rect) {
    }

    @Override
    public void update(QRect rect, boolean adjust) {
        this.update(rect);
    }

    @Override
    public void update(QPolygon pol) {
    }

    private QList<TCanvasItem> getByRtti(TRtti aRtti, QList<TCanvasItem> list) {
        QList<TCanvasItem> result = new QList<TCanvasItem>();
        for (TCanvasItem item : list) {
            if (item.rtti() != aRtti) continue;
            result.append(item);
        }
        return result;
    }

    @Override
    public QList<TCanvasItem> rttiSelection(TRtti aRtti) {
        TCanvasItem active;
        QList<TCanvasItem> result = this.getByRtti(aRtti, this.selection());
        if (result.isEmpty() && (active = this.activeItem(aRtti)) != null) {
            result.append(active);
        }
        return result;
    }

    @Override
    public QList<TCanvasItem> selection() {
        QList<TCanvasItem> result = new QList<TCanvasItem>();
        if (result.isEmpty()) {
            result = this.canvasView.canvas().allItems();
        }
        return result;
    }

    @Override
    public void setSelection(QList<TCanvasItem> items) {
        this.canvasView.canvas().allItems().clear();
        this.canvasView.canvas().allItems().append(items);
    }

    @Override
    public void updateItem(TCanvasItem lnkItem, boolean b) {
    }

    @Override
    public void updateSelectionEventFilter() {
    }

    @Override
    public void redo() {
        if (!this.redo.isEmpty()) {
            this.undo.push(this.currentPage().clone());
            if (!this.redoComand.isEmpty()) {
                TCommand newCommand = this.redoComand.pop();
                newCommand.doCmd();
                this.undoComand.add(newCommand);
            }
            this.canvasView.setCanvas(this.redo.pop());
        }
        this.canvasView.canvas().update();
    }

    @Override
    public void undo() {
        if (!this.undo.isEmpty()) {
            this.redo.push(this.currentPage().clone());
            this.canvasView.setCanvas(this.undo.pop());
            if (!this.undoComand.isEmpty()) {
                TCommand old = this.undoComand.pop();
                if (!this.undo.isEmpty()) {
                    old.undoCmd();
                }
                this.redoComand.add(old);
            }
        }
        this.canvasView.canvas().update();
    }

    @Override
    public int getNumberUndo() {
        return this.undo.size();
    }

    @Override
    public void resetMemento() {
        this.undo.clear();
        this.undoComand.clear();
        this.redo.clear();
        this.redoComand.clear();
    }
}

