/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.core.client.GWT;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.mestrelab.components.client.moleditor.QFont;
import com.mestrelab.components.client.moleditor.QFontMetricsF;
import com.mestrelab.components.client.moleditor.QFontWeight;
import com.mestrelab.components.client.moleditor.QPainter;
import com.mestrelab.components.client.moleditor.QPainterPath;
import com.mestrelab.components.client.moleditor.QPen;
import com.mestrelab.components.client.moleditor.Qt;
import com.mestrelab.components.client.moleditor.QtBrushStyle;
import com.mestrelab.components.client.moleditor.QtCanvas;
import com.mestrelab.components.client.moleditor.QtPenStyle;
import com.mestrelab.components.client.moleditor.TAtomLabelParser;
import com.mestrelab.components.client.moleditor.TAtomTextProp;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TCanvasMoleculeSettings;
import com.mestrelab.components.client.moleditor.TEmptyPlugin;
import com.mestrelab.components.client.moleditor.TMoleculeHotArea;
import com.mestrelab.components.client.moleditor.TRtti;
import com.mestrelab.components.client.moleditor.TTemplateType;
import com.mestrelab.components.client.moleditor.constants.Canvas;
import com.mestrelab.components.client.moleditor.constants.UtilsPainter;
import com.mestrelab.components.shared.ICanvasMoleculeSettingTO;
import com.mestrelab.components.shared.ICanvasMoleculeTO;
import com.mestrelab.components.shared.IMoleculeTO;
import com.mestrelab.components.shared.IMoleculeTOFactory;
import com.mestrelab.components.shared.TAssignmentStability;
import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TAtomData;
import com.mestrelab.components.shared.TAtomLabelInfo;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TBondStereo;
import com.mestrelab.components.shared.TBondType;
import com.mestrelab.components.shared.TBracket;
import com.mestrelab.components.shared.TBracketType;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.TMoleculeHolder;
import com.mestrelab.components.shared.TMoleculeLabelParser;
import com.mestrelab.components.shared.TNeighbour;
import com.mestrelab.components.shared.TPolymer;
import com.mestrelab.components.shared.TStereoDescriptor;
import com.mestrelab.components.shared.qt.QColor;
import com.mestrelab.components.shared.qt.QLineF;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QMatrix;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygon;
import com.mestrelab.components.shared.qt.QPolygonF;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QSize;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QUuid;
import com.mestrelab.components.shared.qt.QVector;
import com.mestrelab.components.shared.util.Cutils;
import com.mestrelab.components.shared.util.StringHEX;
import com.mestrelab.components.shared.util.TDataStream;
import com.mestrelab.components.shared.util.UtilGeometry;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCanvasMolecule
extends TCanvasItem
implements ICanvasMoleculeTO {
    public static final double cFactorFont = 0.8;
    public static final QString cDefTitleFormat = new QString("{path,0} #{molNum}");
    public static final double cMinBondSpacing = 6.0;
    public static final double cMinAtomFontSize = 12.0;
    public static final double cMinNumberFontSize = 8.5;
    private TMolecule fMolecule;
    private QSize<Double> fSize;
    private QSize<Double> fOriginalSize;
    public QSize<Double> fCanvasSize;
    private QSize<Double> fOriginalCanvasSize;
    double fDx;
    double fDy;
    double fScaleFactor;
    QPoint<Double> fOriginalMolCenter;
    QList<QList<Boolean>> fShowAtomProp;
    QMap<Integer, TAtomTextProp> fAtomTextProp;
    QString fTitleFormat;
    TCanvasMoleculeSettings fSettings;
    QList<QPolygonF> fGraphPoly;
    QList<TBracket> fBrackets;
    QVector<QPoint<Double>> fAtomCoords;
    QVector<QPoint<Double>> fStoreAtomCoords;
    QVector<Integer> fSelectedAtoms;
    boolean fFixAtomPositions;
    QPoint<Double> fCursorPosition;
    boolean fDrawChain;
    QRectF fStorePolygon;
    QFont fAtomFont;
    QFont fNumberFont;
    QFont fHIndexFont;
    QFont fChargeFont;
    QFont fIsotopeFont;
    QFont fMoleculeLabelFont;
    QList<TMoleculeHotArea> fHotAreas;
    private TEmptyPlugin fPlugin;

    public TCanvasMolecule(TMolecule aMolecule, QtCanvas aCanvas) {
        this(aMolecule, aCanvas, null);
    }

    public TCanvasMolecule(TMolecule aMolecule, QtCanvas aCanvas, TCanvasMoleculeSettings aSettings) {
        super(TRtti.TRtti_Molecule);
        this.fMolecule = new TMoleculeHolder(aMolecule).getMolecule();
        this.fSize = new QSize<Double>(800.0, 800.0);
        this.fScaleFactor = 1.0;
        this.fSettings = aSettings != null ? aSettings : new TCanvasMoleculeSettings();
        this.fGraphPoly = new QList();
        this.fHotAreas = new QList();
        this.fTitleFormat = cDefTitleFormat;
        this.fBrackets = new QList();
        this.fAtomCoords = new QVector();
        this.fSelectedAtoms = new QVector();
        this.fFixAtomPositions = false;
        this.fCursorPosition = new QPoint<Double>(0.0, 0.0);
        this.fStoreAtomCoords = new QVector();
        this.fOriginalMolCenter = new QPoint();
        this.fDrawChain = false;
        this.fStorePolygon = new QRectF();
        this.fShowAtomProp = new QList();
        this.fAtomTextProp = new QMap();
        this.fPlugin = TEmptyPlugin.getInstance();
        this.calcSterodescriptors();
        if (aSettings != null) {
            this.setSettings(aSettings);
        }
        double factor = 0.0;
        QRectF bound = this.fMolecule.getBound();
        bound = bound.normalized();
        factor = this.resize();
        this.setSize(bound.width() * factor, bound.height() * factor);
        this.setOriginalSize(this.fSize.width(), this.fSize.height());
        this.setScaleFactor(new QRectF(new QPoint<Double>(this.x(), this.y()), this.fSize));
        this.setFonts();
        this.setShowProperties();
        this.setAtomTextProp();
        this.fDy = 0.0;
        this.fDx = 0.0;
        this.fCanvasSize = new QSize<Double>(this.fSize.width(), this.fSize.height());
        this.changeCanvasSize(new QRectF());
        this.setOriginalCanvasSize(this.fCanvasSize.width(), this.fCanvasSize.height());
        QMatrix m = this.moleculeToFSizeNoXY();
        this.fOriginalMolCenter = m.map(this.fMolecule.getBound().center());
        this.readPolymersInfo();
        this.fillAtomCoords();
        this.mapAtomCoords(this.moleculeToFSizeNoXY());
        this.calcGraphPoly();
        this.setup(aCanvas);
    }

    public void readPolymersInfo() {
        int polyCount = this.fMolecule.polymerCount();
        if (polyCount != 0) {
            for (int pNum = 1; pNum <= polyCount; ++pNum) {
                TPolymer poly = this.fMolecule.getPolymer(pNum);
                for (int i = 0; i < poly.getBrackets().size(); ++i) {
                    TBracket bracket = poly.getBrackets().at(i);
                    TBracketType bt = TBracketType.btBrackets;
                    if (poly.getSgBrStyle() == 1) {
                        bt = TBracketType.btParentheses;
                    } else if (poly.getSgBrStyle() == 2) {
                        bt = TBracketType.btBraces;
                    }
                    QMatrix m = this.moleculeToFSizeNoXY();
                    QRectF rect = new QRectF(m.map(bracket.getRect().topLeft()), m.map(bracket.getRect().bottomRight()));
                    QPoint<Double> aux = new QPoint<Double>(-this.fOriginalMolCenter.x().doubleValue(), -this.fOriginalMolCenter.y().doubleValue());
                    rect.translate(aux);
                    if (!bracket.isLeft() || poly.getBrackets().size() == 1) {
                        this.addBracket(new TBracket(rect, bt, poly.getTopText(), poly.getBottomText()));
                        continue;
                    }
                    this.addBracket(new TBracket(rect, bt));
                }
            }
        }
    }

    public void deleteMolecule() throws Exception {
        throw new Exception("Method not implemented");
    }

    @Override
    public void drawShape(QPainter aPainter) {
        QMatrix rotMatrix = this.getRotationMatrix();
        if (this.fHotAreas.isEmpty()) {
            QRectF haRect = new QRectF();
            for (int i = 0; i < this.fAtomTextProp.keys().size(); ++i) {
                haRect = this.fAtomTextProp.find(this.fAtomTextProp.keys().at(i)).getTextRectPositioned().translated(this.x() - this.fDx, this.y() - this.fDy);
                if (this.fSettings.fRotateTextWithMol) {
                    haRect = rotMatrix.mapRect(haRect);
                }
                this.fHotAreas.append(new TMoleculeHotArea(TMoleculeHotArea.TMoleculeHotAreaType.mha_Atom.getValue(), haRect, this.fAtomTextProp.keys().at(i), this.itemId()));
            }
        }
        aPainter.setFont(UtilsPainter.fontSizeInPixels(this.fAtomFont));
        aPainter.setPen(this.fSettings.fBondPen);
        if (this.getSettings().fShowWM) {
            aPainter.save();
            aPainter.getCanvas().setGlobalAlpha(0.5);
            QFont font = new QFont("Arial", 10.0, QFontWeight.Bold, false);
            QColor color = new QColor(QColor.RED.getHexValue());
            this.drawWatermark(aPainter, font, color);
            aPainter.restore();
        }
        aPainter.save();
        QMatrix m = this.fSizeToFSize(true);
        if (this.fSettings.fRotateTextWithMol) {
            aPainter.setMatrix(rotMatrix, true);
        }
        for (int natom = 0; natom < this.fShowAtomProp.size(); ++natom) {
            if (this.fShowAtomProp.at(natom).count() <= 0 || !this.fAtomTextProp.contains(natom)) continue;
            this.drawAtom(natom, m, aPainter);
        }
        QList<TBond> aromaticList = new QList<TBond>();
        for (int i = 0; i < this.fMolecule.bonds().count(); ++i) {
            boolean emptyBond;
            TBond bond = this.fMolecule.bonds().at(i);
            QLineF lineUp = new QLineF();
            Object lineDown = new QLineF();
            int natom1 = bond.atom1();
            int natom2 = bond.atom2();
            TAtom atom1 = this.atom(natom1);
            TAtom atom2 = this.atom(natom2);
            QRectF rectText1 = new QRectF();
            QRectF rectText2 = new QRectF();
            if (natom1 < this.fShowAtomProp.size() && this.fShowAtomProp.at(natom1).count(true) > 0) {
                rectText1 = this.fAtomTextProp.find(natom1).getTextRectPositioned();
                rectText1 = rectText1.translated(this.x() - this.fDx, this.y() - this.fDy);
            }
            if (natom2 < this.fShowAtomProp.size() && this.fShowAtomProp.at(natom2).count(true) > 0) {
                rectText2 = this.fAtomTextProp.find(natom2).getTextRectPositioned();
                rectText2 = rectText2.translated(this.x() - this.fDx, this.y() - this.fDy);
            }
            QLineF line = new QLineF(m.map(this.getAtomCoord(natom1)), m.map(this.getAtomCoord(natom2)));
            QLineF lineBond = this.diffBondText(line, rectText1, rectText2);
            boolean bl = emptyBond = line.length() < 0.001;
            if (emptyBond) continue;
            switch (bond.bondType()) {
                case btSingle: {
                    if (bond.bondStereo().getValue() != 0) break;
                    aPainter.drawLine(lineBond);
                    break;
                }
                case btDouble: {
                    int recurrAt1 = atom1.getfNeighbours().size();
                    int recurrAt2 = atom2.getfNeighbours().size();
                    int dif = Math.abs(recurrAt1 - recurrAt2);
                    if (dif == 1 || dif == 0 && recurrAt1 != 1 && recurrAt2 != 1) {
                        this.insideDoubleBond(bond, lineUp);
                        aPainter.drawLine(lineBond);
                    } else {
                        this.parallelDoubleBond(bond, lineUp, (QLineF)lineDown);
                        lineDown = m.map((QLineF)lineDown);
                        lineDown = this.diffBondText((QLineF)lineDown, rectText1, rectText2);
                        aPainter.drawLine((QLineF)lineDown);
                    }
                    lineUp = m.map(lineUp);
                    lineUp = this.diffBondText(lineUp, rectText1, rectText2);
                    aPainter.drawLine(lineUp);
                    break;
                }
                case btTriple: {
                    this.tripleBond(bond, lineUp, (QLineF)lineDown);
                    lineUp = m.map(lineUp);
                    lineDown = m.map((QLineF)lineDown);
                    lineUp = this.diffBondText(lineUp, rectText1, rectText2);
                    lineDown = this.diffBondText((QLineF)lineDown, rectText1, rectText2);
                    aPainter.drawLine(lineBond);
                    aPainter.drawLine(lineUp);
                    aPainter.drawLine((QLineF)lineDown);
                    break;
                }
                case btAromatic: {
                    aPainter.drawLine(lineBond);
                    aromaticList.append(bond);
                    break;
                }
                default: {
                    this.drawDotLine(lineBond, aPainter);
                }
            }
            QPolygon triangle = new QPolygon();
            if (bond.bondStereo().getValue() != 0) {
                triangle = this.getTriangle(lineBond);
            }
            switch (bond.bondStereo()) {
                case bsUp: {
                    aPainter.save();
                    aPainter.setBrush(this.fSettings.fBondPen.brush());
                    aPainter.drawConvexPolygon(triangle);
                    aPainter.restore();
                    break;
                }
                case bsDown: {
                    this.drawTrianglePattern(lineBond, triangle, aPainter);
                    break;
                }
                case bsEither: {
                    this.drawTrianglePath(lineBond, triangle, aPainter);
                    break;
                }
            }
            QString stereoN = bond.stereoNotation();
            if (stereoN.isEmpty()) continue;
            QRectF rectStereoNotation = this.getTextRect(this.fAtomFont, stereoN);
            rectStereoNotation.moveCenter(line.pointAt(0.5));
            this.drawText(this.fAtomFont, rectStereoNotation, stereoN, aPainter, this.fSettings.fAtomFontColor);
        }
        QList<Object> lineList = new QList();
        QLineF minLine = new QLineF();
        QPolygonF ellipsePol = new QPolygonF();
        for (QPolygonF polygon : this.fGraphPoly) {
            lineList = this.distancesToCenter(m.map(polygon));
            if (lineList.size() <= 0) continue;
            minLine = this.minDistance(lineList);
            ellipsePol = this.circle(minLine, m.map(polygon));
            this.drawEllipse(ellipsePol, aPainter);
        }
        this.drawPolymerBrackets(aPainter);
        if (this.selectedAtoms().size() == 1 && !this.fCursorPosition.isNull()) {
            QPoint<Double> startPoint = m.map(this.getAtomCoord(this.selectedAtoms().get(0)));
            if (!this.fDrawChain) {
                QLineF line = new QLineF(startPoint, this.fCursorPosition);
                this.drawDotLine(line, aPainter);
            } else {
                QList<QPoint<Double>> points = this.calcChainCoords(startPoint, this.fCursorPosition);
                if (points.size() > 0) {
                    for (int i = 0; i < points.size(); ++i) {
                        QPoint<Double> prevPoint = i != 0 ? points.at(i - 1) : startPoint;
                        QLineF line = new QLineF(prevPoint, points.at(i));
                        this.drawDotLine(line, aPainter);
                    }
                }
            }
        }
        this.drawMoleculeLabel(aPainter);
        aPainter.restore();
    }

    public void drawMoleculeLabel(QPainter aPainter) {
        if (!this.fSettings.fShowMoleculeLabel || this.fSettings.fMoleculeLabelMacro.isEmpty()) {
            return;
        }
        QRectF molRect = this.areaPoints().boundingRect();
        QString macroExpr = this.fSettings.fMoleculeLabelMacro;
        TMoleculeLabelParser parser = new TMoleculeLabelParser(this.fMolecule);
        QString label = parser.parse(macroExpr);
        QRectF labelRect = this.getTextRect(this.fMoleculeLabelFont, label);
        labelRect.moveTop(molRect.bottom());
        this.drawText(this.fMoleculeLabelFont, labelRect, label, aPainter, this.fSettings.fMoleculeLabelFontColor);
    }

    public void drawWatermark(QPainter aPainter, QFont font, QColor color) {
        QRectF labelRect = this.getTextRect(font, new QString("213564023 2323234 43"));
        labelRect.moveBottomRight(new QPoint<Double>((double)aPainter.getWidth() * 0.9, (double)aPainter.getHeight() - labelRect.height()));
        this.drawText(font, labelRect, new QString(new String(StringHEX.unhexlate("4d65737472656c616220526573656172636820534c"))), aPainter, color);
    }

    public void drawPolymerBrackets(QPainter aPainter) {
        if (this.fBrackets.size() == 0) {
            return;
        }
        QMatrix rotMatrix = this.getRotationMatrix();
        QPoint<Double> molCenter = new QPoint<Double>(this.fOriginalMolCenter.x(), this.fOriginalMolCenter.y());
        QPoint<Double> aux = new QPoint<Double>(this.x() - this.fDx, this.y() - this.fDy);
        molCenter.setX(molCenter.x() + aux.x());
        molCenter.setY(molCenter.y() + aux.y());
        for (TBracket bracket : this.fBrackets) {
            boolean leftBracket;
            QRectF rect = new QRectF(bracket.getRect());
            rect.translate(molCenter);
            if (!this.fSize.equals(this.fOriginalSize)) {
                QLineF l1 = new QLineF(molCenter, rect.topLeft());
                QLineF l2 = new QLineF(molCenter, rect.bottomRight());
                l1.setLength(l1.length() * this.fScaleFactor);
                l2.setLength(l2.length() * this.fScaleFactor);
                rect.setTopLeft(l1.p2());
                rect.setBottomRight(l2.p2());
            }
            QLineF line1 = new QLineF(rotMatrix.map(rect.topLeft()), rotMatrix.map(rect.bottomRight()));
            QLineF line2 = new QLineF(line1.p1(), line1.p2());
            line2.setLength(line2.length() / 10.0);
            line2.setAngle(line1.angle() - 90.0);
            QLineF line3 = new QLineF(line1.p2(), line1.p1());
            line3.setLength(line3.length() / 10.0);
            line3.setAngle(line1.angle() - 90.0);
            QPoint<Double> p1 = line1.pointAt(0.1);
            QPoint<Double> p2 = line1.pointAt(0.9);
            QLineF line4 = new QLineF(line1.pointAt(0.5), line1.pointAt(0.6));
            line4.setAngle(line1.angle() + 90.0);
            QPainterPath path = new QPainterPath(line2.p2());
            switch (bracket.getType()) {
                case btBrackets: {
                    path.lineTo(line1.p1());
                    path.lineTo(line1.p2());
                    path.lineTo(line3.p2());
                    break;
                }
                case btParentheses: {
                    path.moveTo(line1.p1());
                    line4.setLength(line4.length() * 2.5);
                    path.quadTo(line4.p2(), line1.p2());
                    break;
                }
                case btBraces: {
                    path.quadTo(line1.p1(), p1);
                    path.lineTo(line1.pointAt(0.4));
                    path.quadTo(line4.p1(), line4.p2());
                    path.quadTo(line4.p1(), line1.pointAt(0.6));
                    path.lineTo(p2);
                    path.quadTo(line1.p2(), line3.p2());
                }
            }
            path.closePath();
            aPainter.drawPath(path);
            line2.setAngle(line2.angle() + 180.0);
            line3.setAngle(line3.angle() + 180.0);
            boolean bl = leftBracket = line2.p2().y() <= line3.p2().y();
            if (!bracket.getBottomText().isEmpty()) {
                QRectF indexRectL = this.getTextRect(this.atomFont(), bracket.getBottomText());
                if (leftBracket) {
                    indexRectL.moveBottomLeft(line3.p2());
                } else {
                    indexRectL.moveBottomRight(line2.p2());
                }
                this.drawText(this.atomFont(), indexRectL, bracket.getBottomText(), aPainter, this.fSettings.fAtomFontColor);
            }
            if (bracket.getTopText().isEmpty()) continue;
            QRectF indexRectU = this.getTextRect(this.atomFont(), bracket.getTopText());
            if (leftBracket) {
                indexRectU.moveTopLeft(line2.p2());
            } else {
                indexRectU.moveTopRight(line3.p2());
            }
            this.drawText(this.atomFont(), indexRectU, bracket.getTopText(), aPainter, this.fSettings.fAtomFontColor);
        }
    }

    public void store(TDataStream aStream) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void load(TDataStream aStream) throws Exception {
        throw new Exception("Method not implemented");
    }

    @Override
    public QPolygonF getPolygonF() {
        QRectF rect = new QRectF(new QPoint<Double>(this.x(), this.y()), this.fCanvasSize);
        if (!this.fStorePolygon.isEmpty()) {
            rect = new QRectF(new QPoint<Double>(this.x(), this.y()), this.fStorePolygon.size());
        }
        return new QPolygonF(rect);
    }

    @Override
    public void setPolygonF(QPolygonF aPol) {
        double factor;
        if (aPol.size() < 4) {
            return;
        }
        this.fHotAreas.clear();
        QRectF rect = new QRectF();
        rect.setCoords(aPol.at(0).x(), aPol.at(0).y(), aPol.at(2).x(), aPol.at(2).y());
        this.move(rect.x(), rect.y());
        this.fStorePolygon.setCoords(rect);
        double factorX = rect.width() / this.fOriginalCanvasSize.width();
        double factorY = rect.height() / this.fOriginalCanvasSize.height();
        double d = factor = factorX < factorY ? factorX : factorY;
        if (factor > 0.9999999999 && factor < 1.0000000001) {
            factor = 1.0;
        }
        QRectF newSize = new QRectF(this.x(), this.y(), this.fOriginalSize.width() * factor, this.fOriginalSize.height() * factor);
        this.setScaleFactor(newSize);
        this.setFonts();
        if (factor != 1.0) {
            QRectF rect1 = new QRectF(new QPoint<Double>(0.0, 0.0), this.fSize);
            this.setSize(newSize.width(), newSize.height());
            QRectF rect2 = new QRectF(new QPoint<Double>(0.0, 0.0), this.fSize);
            this.mapAtomCoords(UtilGeometry.rect2RectQt(rect1, rect2));
            this.fOriginalMolCenter = UtilGeometry.rect2RectQt(rect1, rect2).map(this.fOriginalMolCenter);
            this.recalcAtomCoords();
            this.changeCanvasSize(rect);
        }
    }

    public QPolygonF areaPoints() {
        QPolygonF pa = new QPolygonF();
        double pw = this.phw();
        QPoint<Double> point0 = new QPoint<Double>(this.x() - pw, this.y() - pw);
        QPoint<Double> point1 = new QPoint<Double>(point0.getXp() + (this.fCanvasSize.width() + pw * 2.0), point0.getYp());
        QPoint<Double> point2 = new QPoint<Double>(point1.getXp(), point1.getYp() + (this.fCanvasSize.height() + pw * 2.0));
        QPoint<Double> point3 = new QPoint<Double>(point0.getXp(), point0.getYp() + (this.fCanvasSize.height() + pw * 2.0));
        pa.add(point0);
        pa.add(point1);
        pa.add(point2);
        pa.add(point3);
        return this.getRotationMatrix().map(pa);
    }

    public QLineF bisectrix(QLineF aLine1, QLineF aLine2) {
        QLineF secondLine = new QLineF(aLine2);
        if (aLine2.length() != aLine1.length()) {
            secondLine.setLength(aLine1.length());
        }
        QLineF inverseLine1 = new QLineF(aLine1.p2(), aLine1.p1());
        QLineF inverseLine2 = new QLineF(secondLine.p2(), secondLine.p1());
        QPoint<Double> iPoint = new QPoint<Double>();
        QLineF bisectrix = new QLineF();
        switch (inverseLine1.normalVector().intersect(inverseLine2.normalVector(), iPoint)) {
            case NoIntersection: {
                bisectrix = new QLineF(aLine1.normalVector());
                break;
            }
            default: {
                bisectrix = new QLineF(inverseLine1.p2(), iPoint);
            }
        }
        bisectrix.setLength(2.0 * aLine1.length());
        return bisectrix;
    }

    public QLineF normalLine(QLineF aLine1, QLineF aLine2, double aLineLength) {
        QLineF normal = aLine1.normalVector();
        double angle = normal.angle(aLine2);
        if (angle <= 90.0) {
            normal.setLength(aLineLength);
        } else {
            normal.setLength(-aLineLength);
        }
        return normal;
    }

    public double resize() {
        this.fHotAreas.clear();
        double length = 0.0;
        double average = 0.0;
        double factor = 0.0;
        for (TBond bond : this.fMolecule.bonds()) {
            TAtom p1 = this.atom(bond.atom1());
            TAtom p2 = this.atom(bond.atom2());
            length = UtilGeometry.distance(p1, p2);
            average += length;
        }
        if (this.fMolecule.bonds().size() != 0) {
            average /= (double)this.fMolecule.bonds().size();
        } else if (this.fMolecule.atoms().count() > 1) {
            int ai = this.fMolecule.atoms().count() - 1;
            int bi = this.fMolecule.atoms().count() - 2;
            average = length = UtilGeometry.distance(this.atom(ai), this.atom(bi));
        } else {
            average = 1.0;
        }
        factor = average == 0.0 ? 1.0 : Math.abs(this.fSettings.fAverageBondSize * Canvas.dotsPerMm / average);
        return factor;
    }

    public QLineF shorten(QLineF aLine, QLineF aBisectrix) {
        QPoint<Double> interPoint = new QPoint<Double>();
        QPoint<Double> startPoint = aLine.p1();
        QPoint<Double> endPoint = aLine.p2();
        if (aLine.intersect(aBisectrix, interPoint) == QLineF.IntersectType.BoundedIntersection) {
            if (UtilGeometry.distance(interPoint, aLine.p1()) > aLine.length() / 2.0) {
                endPoint = interPoint;
            } else {
                startPoint = interPoint;
            }
        }
        QLineF shortLine = new QLineF(startPoint, endPoint);
        return shortLine;
    }

    public QLineF examBisectrix(QLineF aLine, QList<QLineF> bList) {
        QLineF bisec;
        QLineF finalLine = new QLineF(aLine);
        QLineF line = new QLineF(aLine);
        Iterator<QLineF> iterator = bList.iterator();
        while (iterator.hasNext() && ((finalLine = this.shorten(line, bisec = iterator.next())).p1() == line.p1() || finalLine.p2() == line.p2())) {
            line = finalLine;
        }
        return finalLine;
    }

    public QLineF parallel(QLineF aOriginalLine, QLineF aNormalLine, double aGap) {
        QLineF parallelLine = new QLineF(aOriginalLine);
        parallelLine.translate(aGap * aNormalLine.unitVector().dx(), aGap * aNormalLine.unitVector().dy());
        return parallelLine;
    }

    public double calcBondSpacing(int aIndex1, int aIndex2) {
        double bondSpacing = UtilGeometry.distance(this.getAtomCoord(aIndex1), this.getAtomCoord(aIndex2)) * this.fSettings.fBondSpacing;
        if (bondSpacing < 6.0) {
            bondSpacing = Math.min(2.0 * bondSpacing, 6.0);
        }
        return bondSpacing;
    }

    public void allBisectrixOrNormal(int atomStartInd, int atomEndInd, boolean bisectrixFlag, QList<QLineF> lineList) {
        double bondSpacing = this.calcBondSpacing(atomStartInd, atomEndInd);
        TAtom atomStart = this.atom(atomStartInd);
        for (TNeighbour nb : atomStart.getfNeighbours()) {
            int neighInd = nb.getfBond().getSecond(atomStartInd);
            if (neighInd == atomEndInd) continue;
            QLineF line1 = new QLineF(this.getAtomCoord(atomStartInd), this.getAtomCoord(atomEndInd));
            QLineF line2 = new QLineF(this.getAtomCoord(atomStartInd), this.getAtomCoord(neighInd));
            QLineF line = bisectrixFlag ? this.bisectrix(line1, line2) : this.normalLine(line1, line2, bondSpacing);
            if (lineList.contains(line)) continue;
            lineList.append(line);
        }
    }

    public void tripleBond(TBond aBond, QLineF aLineUp, QLineF aLineDown) {
        QLineF normal = new QLineF();
        double bondSpacing = 0.0;
        this.makeParallelLines(aBond, aLineUp, aLineDown, normal, bondSpacing, 1);
        QList<QLineF> bisecList = new QList<QLineF>();
        this.allBisectrixOrNormal(aBond.atom1(), aBond.atom2(), true, bisecList);
        this.allBisectrixOrNormal(aBond.atom2(), aBond.atom1(), true, bisecList);
        QLineF shortLineUp = this.examBisectrix(aLineUp, bisecList);
        aLineDown = this.parallel(shortLineUp, normal, -bondSpacing * 2.0);
        QLineF shortLineDown = this.examBisectrix(aLineDown, bisecList);
        if (shortLineDown.p1() != aLineDown.p1() || shortLineDown.p2() != aLineDown.p2()) {
            shortLineUp = this.parallel(shortLineDown, normal, bondSpacing * 2.0);
        }
        aLineUp = shortLineUp;
        aLineDown = shortLineDown;
    }

    public void makeParallelLines(TBond aBond, QLineF aLineUp, QLineF aLineDown, QLineF aNormal, double aBondSpacing, int coef) {
        QPoint<Double> atomCoord1 = this.getAtomCoord(aBond.atom1());
        QPoint<Double> atomCoord2 = this.getAtomCoord(aBond.atom2());
        aBondSpacing = this.calcBondSpacing(aBond.atom1(), aBond.atom2());
        QLineF lineBond1 = new QLineF(atomCoord1, atomCoord2);
        int neigh = this.atom(aBond.atom1()).getNeighByNum(0, aBond.atom1());
        QLineF lineBond2 = new QLineF(atomCoord1, this.getAtomCoord(neigh));
        QLineF aNormalPar = this.normalLine(lineBond1, lineBond2, aBondSpacing);
        aNormal.setP1(aNormalPar.p1());
        aNormal.setP2(aNormalPar.p2());
        QLineF aLineUpPar = this.parallel(lineBond1, aNormal, aBondSpacing / (double)coef);
        aLineUp.setP1(aLineUpPar.p1());
        aLineUp.setP2(aLineUpPar.p2());
        QLineF aLineDownPar = this.parallel(lineBond1, aNormal, -aBondSpacing / (double)coef);
        aLineDown.setP1(aLineDownPar.p1());
        aLineDown.setP2(aLineDownPar.p2());
    }

    public void parallelDoubleBond(TBond aBond, QLineF aLineUp, QLineF aLineDown) {
        QLineF normal = new QLineF();
        double bondSpacing = 0.0;
        this.makeParallelLines(aBond, aLineUp, aLineDown, normal, bondSpacing, 2);
    }

    public void insideDoubleBond(TBond aBond, QLineF aLineUp) {
        QLineF aLineUpPar;
        QPoint<Double> startPoint = new QPoint();
        QPoint<Double> endPoint = new QPoint();
        QPoint<Double> centerPoint = new QPoint<Double>();
        QPoint<Double> interPoint = new QPoint<Double>();
        QList<QLineF> normalList = new QList<QLineF>();
        boolean intersected = false;
        QPoint<Double> atomCoord1 = this.getAtomCoord(aBond.atom1());
        QPoint<Double> atomCoord2 = this.getAtomCoord(aBond.atom2());
        double bondSpacing = this.calcBondSpacing(aBond.atom1(), aBond.atom2());
        QList<QLineF> bisecList = new QList<QLineF>();
        this.allBisectrixOrNormal(aBond.atom1(), aBond.atom2(), true, bisecList);
        this.allBisectrixOrNormal(aBond.atom2(), aBond.atom1(), true, bisecList);
        this.allBisectrixOrNormal(aBond.atom1(), aBond.atom2(), false, normalList);
        this.allBisectrixOrNormal(aBond.atom2(), aBond.atom1(), false, normalList);
        QLineF lineBond1 = new QLineF(atomCoord1, atomCoord2);
        if (bisecList.size() == 0) {
            QLineF normal = lineBond1.normalVector();
            QLineF aLineUpPar2 = this.parallel(lineBond1, normal, bondSpacing);
            aLineUp.setP1(aLineUpPar2.p1());
            aLineUp.setP2(aLineUpPar2.p2());
            return;
        }
        if (bisecList.size() == 1) {
            intersected = false;
        } else {
            QList<QLineF> resList = new QList<QLineF>();
            intersected = false;
            for (int k = 0; k < bisecList.size(); ++k) {
                QLineF bisec = bisecList.at(k);
                for (int h = k + 1; h < bisecList.size(); ++h) {
                    QLineF.IntersectType result = bisec.intersect(bisecList.at(h), centerPoint);
                    if (centerPoint.equals(lineBond1.p1()) || centerPoint.equals(lineBond1.p2()) || result != QLineF.IntersectType.BoundedIntersection) continue;
                    intersected = true;
                    QLineF normal = normalList.at(k);
                    QLineF aLineUpPar3 = this.parallel(lineBond1, normal, bondSpacing);
                    aLineUp.setP1(aLineUpPar3.p1());
                    aLineUp.setP2(aLineUpPar3.p2());
                    startPoint = new QPoint<Double>(aLineUp.p1().x(), aLineUp.p1().y());
                    endPoint = new QPoint<Double>(aLineUp.p2().x(), aLineUp.p2().y());
                    if (aLineUp.intersect(bisec, interPoint) == QLineF.IntersectType.BoundedIntersection) {
                        startPoint = new QPoint<Double>(interPoint.x(), interPoint.y());
                    }
                    if (aLineUp.intersect(bisecList.at(h), interPoint) == QLineF.IntersectType.BoundedIntersection) {
                        endPoint = new QPoint<Double>(interPoint.x(), interPoint.y());
                    }
                    aLineUpPar3 = new QLineF(startPoint, endPoint);
                    aLineUp.setP1(aLineUpPar3.p1());
                    aLineUp.setP2(aLineUpPar3.p2());
                    QLineF storeLine = new QLineF(aLineUp);
                    resList.append(storeLine);
                }
            }
            if (intersected && resList.size() != 0) {
                QList<Integer> ring;
                int ind = 0;
                if (resList.size() > 1 && (ring = this.fMolecule.findAromaRing(aBond.atom1(), aBond.atom2(), false)).size() != 0) {
                    QPolygonF pol = new QPolygonF();
                    for (int i = 0; i < ring.size(); ++i) {
                        pol.append(this.getAtomCoord(ring.at(i)));
                    }
                    QPoint<Double> center = this.centerOfPolygon(pol);
                    double minDist = 0.0;
                    for (int i = 0; i < resList.size(); ++i) {
                        double dist = UtilGeometry.distance(((QLineF)resList.at(i)).pointAt(0.5), center);
                        if (minDist != 0.0 && !(dist < minDist)) continue;
                        minDist = dist;
                        ind = i;
                    }
                }
                aLineUpPar = (QLineF)resList.at(ind);
                aLineUp.setP1(aLineUpPar.p1());
                aLineUp.setP2(aLineUpPar.p2());
            }
        }
        if (!intersected) {
            QLineF normal = normalList.at(0);
            QLineF bisec = bisecList.at(0);
            aLineUpPar = this.parallel(lineBond1, normal, bondSpacing);
            aLineUp.setP1(aLineUpPar.p1());
            aLineUp.setP2(aLineUpPar.p2());
            aLineUp = this.shorten(aLineUp, bisec);
        }
        bisecList.clear();
        normalList.clear();
    }

    public QRectF getTextRect(QFont aFont, QString aText) {
        QFontMetricsF fm = new QFontMetricsF(aFont);
        QRectF rectText = fm.boundingRect(aText);
        rectText.normalized();
        rectText.setHeight(fm.ascent());
        rectText.moveTopLeft(new QPoint<Double>(this.x(), this.y()));
        return rectText;
    }

    public QLineF diffBondText(QLineF aLine, QRectF aRect1, QRectF aRect2) {
        QLineF line = new QLineF(aLine);
        QRectF newRect1 = new QRectF(aRect1);
        QRectF newRect2 = new QRectF(aRect2);
        while (!newRect1.isEmpty() || !newRect2.isEmpty()) {
            QPoint<Double> pt1 = new QPoint<Double>(aLine.p1().x(), aLine.p1().y());
            QPoint<Double> pt2 = new QPoint<Double>(aLine.p2().x(), aLine.p2().y());
            if ((newRect1.isEmpty() || UtilGeometry.diffLineRect(pt1, pt2, newRect1)) && (newRect2.isEmpty() || UtilGeometry.diffLineRect(pt1, pt2, newRect2))) {
                return new QLineF(pt1, pt2);
            }
            this.adjustMarginWidth(newRect1, false);
            this.adjustMarginWidth(newRect2, false);
        }
        return line;
    }

    public QLineF diffBondText(QLineF aLine, QRectF aRect) {
        QPoint<Double> pt1 = new QPoint<Double>(aLine.p1().x(), aLine.p1().y());
        QPoint<Double> pt2 = new QPoint<Double>(aLine.p2().x(), aLine.p2().y());
        QLineF line = new QLineF(aLine);
        if (UtilGeometry.diffLineRect(pt1, pt2, aRect)) {
            line = new QLineF(pt1, pt2);
        }
        return line;
    }

    public void setSize(double aWidth, double aHeight) {
        this.fHotAreas.clear();
        this.fSize.setWd(aWidth);
        this.fSize.setHt(aHeight);
    }

    public QPolygon getTriangle(QLineF aLineBond) {
        QPolygon poly = new QPolygon();
        poly.add(aLineBond.p1());
        double boldWidth = this.fSettings.fBoldWidth * Canvas.dotsPerMm * Math.abs(this.fScaleFactor);
        QLineF inverseLineBond = new QLineF(aLineBond.p2(), aLineBond.p1());
        QLineF normal = inverseLineBond.normalVector();
        normal.setLength(boldWidth / 2.0);
        poly.add(normal.p2());
        normal.setLength(-boldWidth / 2.0);
        poly.add(normal.p2());
        return poly;
    }

    public void drawTrianglePattern(QLineF aLineBond, QPolygon aTriangle, QPainter aPaint) {
        if (aLineBond.isNull() || aTriangle.isEmpty()) {
            return;
        }
        QList<QLineF> lines = this.calcSmallLines(aLineBond, aTriangle);
        for (QLineF line : lines) {
            aPaint.drawLine(line);
        }
        QLineF baseLine = new QLineF(aTriangle.at(1), aTriangle.at(2));
        aPaint.drawLine(baseLine);
    }

    public void drawTrianglePath(QLineF aLineBond, QPolygon aTriangle, QPainter aPaint) {
        if (aLineBond.isNull() || aTriangle.isEmpty()) {
            return;
        }
        QList<QLineF> lines = this.calcSmallLines(aLineBond, aTriangle);
        QPainterPath path = new QPainterPath(aTriangle.at(1));
        path.lineTo(aTriangle.at(2));
        for (QLineF line : lines) {
            path.lineTo(line.p1());
            path.lineTo(line.p2());
        }
        path.lineTo(aTriangle.at(0));
        path.closePath();
        aPaint.drawPath(path);
    }

    public void drawDotLine(QLineF aLineBond, QPainter aPaint) {
        if (aLineBond.isNull()) {
            return;
        }
        aPaint.save();
        aPaint.setPen(QtPenStyle.DotLine);
        aPaint.drawLine(aLineBond);
        aPaint.restore();
    }

    public QList<QPolygonF> createPolygons(QList<TBond> aBondList) {
        int maxCon;
        QList<QPolygonF> polyList = new QList<QPolygonF>();
        QList<Integer> atomList = new QList<Integer>();
        int prev = 0;
        QList<Integer> atUsed = new QList<Integer>();
        if (aBondList.count() == 0) {
            return polyList;
        }
        for (TBond bond : aBondList) {
            if (!atomList.contains(bond.atom1())) {
                atomList.append(bond.atom1());
            }
            if (atomList.contains(bond.atom2())) continue;
            atomList.append(bond.atom2());
        }
        for (int i = 0; i < atomList.size(); ++i) {
            atUsed.append(0);
        }
        int minCon = maxCon = this.conAromat(this.atom((Integer)atomList.at(0)));
        Iterator iterator = atomList.iterator();
        while (iterator.hasNext()) {
            int ind = (Integer)iterator.next();
            TAtom atm = this.atom(ind);
            int neigh = this.conAromat(atm);
            if (neigh > maxCon) {
                maxCon = neigh;
            }
            if (neigh >= minCon) continue;
            minCon = neigh;
        }
        int iStartAtom = -1;
        for (int i = 0; i < atomList.size(); ++i) {
            if (this.conAromat(this.atom((Integer)atomList.at(i))) != maxCon) continue;
            iStartAtom = i;
            break;
        }
        QPolygonF poly = new QPolygonF();
        while (iStartAtom != -1) {
            poly.add(this.getAtomCoord((Integer)atomList.at(iStartAtom)));
            atUsed.replace(iStartAtom, 1);
            int next = this.nextAtom(atomList, atUsed, iStartAtom, iStartAtom);
            while (next > -1) {
                poly.add(this.getAtomCoord(next));
                atUsed.replace(atomList.indexOf(next), 1);
                prev = next;
                next = this.nextAtom(atomList, atUsed, atomList.indexOf(prev), iStartAtom);
            }
            if (poly.size() > 2) {
                TAtom prevAtom = this.atom(prev);
                for (int n = 0; n < prevAtom.getfNeighbours().size(); ++n) {
                    if (prevAtom.getNeighByNum(n, prev) != atomList.at(iStartAtom).intValue()) continue;
                    polyList.append(poly);
                    break;
                }
            }
            if (this.checkUsed(atUsed) < 1) {
                iStartAtom = -1;
                continue;
            }
            if (minCon != maxCon) {
                this.cleanMaxCon(atomList, atUsed, maxCon);
            }
            int iPrevStart = iStartAtom;
            iStartAtom = this.newStartAtom(atomList, atUsed, iPrevStart, maxCon);
            poly.clear();
        }
        return polyList;
    }

    public int conAromat(TAtom aAtom) {
        int con = aAtom.getfNeighbours().size();
        for (TNeighbour nb : aAtom.getfNeighbours()) {
            if (nb.getfBond().bondType() == TBondType.btAromatic) continue;
            --con;
        }
        return con;
    }

    public int nextAtom(QList<Integer> aAtomList, QList<Integer> aUsedAtoms, int aPrev, int aStartIndex) {
        QList<Integer> conList = new QList<Integer>();
        QList<Integer> validNeighList = new QList<Integer>();
        int nextAt = -1;
        int atomIndex = aAtomList.at(aPrev);
        TAtom atm = this.atom(atomIndex);
        for (int n = 0; n < atm.getfNeighbours().size(); ++n) {
            int index;
            int myAtom = atm.getNeighByNum(n, atomIndex);
            if (!aAtomList.contains(myAtom) || aUsedAtoms.at(index = aAtomList.indexOf(myAtom)) != 0) continue;
            conList.append(this.conAromat(this.atom(myAtom)));
            validNeighList.append(myAtom);
        }
        if (validNeighList.isEmpty()) {
            return nextAt;
        }
        if (validNeighList.size() == 1) {
            nextAt = (Integer)validNeighList.at(0);
        }
        if (nextAt < 0) {
            int maxValue = this.maxConnectivity(conList);
            if (conList.count() == 1) {
                nextAt = validNeighList.at(conList.indexOf(maxValue));
            }
        }
        if (nextAt < 0) {
            nextAt = this.checkDistance(validNeighList, aAtomList.at(aStartIndex));
        }
        if (nextAt < 0) {
            nextAt = (Integer)validNeighList.at(0);
        }
        return nextAt;
    }

    public int maxConnectivity(QList<Integer> aConList) {
        int maxValue = 0;
        for (int i = 0; i < aConList.size(); ++i) {
            if (aConList.at(i) <= maxValue) continue;
            maxValue = aConList.at(i);
        }
        return maxValue;
    }

    public int checkDistance(QList<Integer> aNeighList, int aStartAtom) {
        int min = -1;
        int ind = -1;
        for (int i = 0; i < aNeighList.size(); ++i) {
            int distance = (int)Math.round(Math.abs(UtilGeometry.distance(this.atom(aNeighList.at(i)), this.atom(aStartAtom))));
            if (min >= 0 && distance >= min) continue;
            min = distance;
            ind = aNeighList.at(i);
        }
        return ind;
    }

    public void cleanMaxCon(QList<Integer> aAtomList, QList<Integer> aUsedAtoms, int aConMax) {
        for (int i = 0; i < aAtomList.size(); ++i) {
            if (this.conAromat(this.atom(aAtomList.at(i))) != aConMax) continue;
            aUsedAtoms.replace(i, 0);
        }
    }

    public int newStartAtom(QList<Integer> aAtomList, QList<Integer> aUsedAtoms, int aPrevStart, int aConMax) {
        int i;
        int iStartAtom = -1;
        for (i = aPrevStart; i < aAtomList.size(); ++i) {
            if (aUsedAtoms.at(i) != 0 || this.conAromat(this.atom(aAtomList.at(i))) != aConMax || i == aPrevStart) continue;
            iStartAtom = i;
            break;
        }
        if (iStartAtom == -1) {
            for (i = 0; i < aAtomList.size(); ++i) {
                if (aUsedAtoms.at(i) != 0 || this.conAromat(this.atom(aAtomList.at(i))) != aConMax - 1 || i == aPrevStart) continue;
                iStartAtom = i;
                break;
            }
        }
        return iStartAtom;
    }

    public int checkUsed(QList<Integer> aUsedAtoms) {
        int count = 0;
        for (int k = 0; k < aUsedAtoms.size(); ++k) {
            if (aUsedAtoms.at(k) != 0) continue;
            ++count;
        }
        return count;
    }

    public QPoint<Double> centerOfPolygon(QPolygonF aPol) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < aPol.size(); ++i) {
            x += aPol.at(i).x().doubleValue();
            y += aPol.at(i).y().doubleValue();
        }
        QPoint<Double> center = new QPoint<Double>(x / (double)aPol.size(), y / (double)aPol.size());
        return center;
    }

    public QList<QLineF> distancesToCenter(QPolygonF aPol) {
        QList<QLineF> distanceList = new QList<QLineF>();
        if (aPol.isEmpty()) {
            return distanceList;
        }
        QPoint<Double> center = this.centerOfPolygon(aPol);
        for (int i = 0; i < aPol.size(); ++i) {
            int next = i + 1;
            if (next == aPol.size()) {
                next = 0;
            }
            QLineF line = new QLineF(aPol.at(i), aPol.at(next));
            QLineF lineToCenter = new QLineF(aPol.at(i), center);
            double angle = line.angle(lineToCenter);
            QLineF newLine = new QLineF(line);
            newLine.setLength(lineToCenter.length() * Math.cos(UtilGeometry.deg2Rad(angle)));
            QPoint<Double> endPoint = newLine.p2();
            QLineF pLine = new QLineF(center, endPoint);
            pLine.setLength(pLine.length() + 1.0);
            distanceList.append(pLine);
        }
        return distanceList;
    }

    public QLineF minDistance(QList<QLineF> aLineList) {
        QLineF minLine = new QLineF(aLineList.at(0));
        for (int i = 1; i < aLineList.size(); ++i) {
            if (!(aLineList.at(i).length() <= minLine.length())) continue;
            minLine = new QLineF(aLineList.at(i));
        }
        return minLine;
    }

    public QPolygonF circle(QLineF aMinLine, QPolygonF aMoleculePol) {
        QPolygonF circlePol = new QPolygonF();
        QPoint<Double> interPoint = new QPoint<Double>();
        for (int i = 0; i < aMoleculePol.size(); ++i) {
            QLineF lineBond;
            int next = i + 1;
            if (next == aMoleculePol.size()) {
                next = 0;
            }
            if ((lineBond = new QLineF(aMoleculePol.at(i), aMoleculePol.at(next))).intersect(aMinLine, interPoint) != QLineF.IntersectType.BoundedIntersection) continue;
            double separation = aMinLine.length() / 8.0;
            aMinLine.setLength(aMinLine.length() - 2.0 * separation);
        }
        QLineF semimajorAxis = aMinLine.normalVector();
        semimajorAxis.setLength(aMinLine.length());
        QLineF line = new QLineF(aMinLine);
        line.setLength(-aMinLine.length());
        QLineF minorAxis = new QLineF(aMinLine.p2(), line.p2());
        line = new QLineF(semimajorAxis);
        line.setLength(-semimajorAxis.length());
        QLineF majorAxis = new QLineF(semimajorAxis.p2(), line.p2());
        circlePol.add(minorAxis.p1());
        circlePol.add(minorAxis.p2());
        circlePol.add(majorAxis.p1());
        circlePol.add(majorAxis.p2());
        return circlePol;
    }

    public void drawEllipse(QPolygonF aPointsOfAxis, QPainter aPaint) {
        if (aPointsOfAxis.isEmpty()) {
            return;
        }
        QLineF minorAxis = new QLineF(aPointsOfAxis.at(0), aPointsOfAxis.at(1));
        QLineF majorAxis = new QLineF(aPointsOfAxis.at(2), aPointsOfAxis.at(3));
        QPoint<Double> center = this.centerOfPolygon(aPointsOfAxis);
        QRectF rect = new QRectF(aPointsOfAxis.at(0), new QSize<Double>(minorAxis.length(), majorAxis.length()));
        rect.moveCenter(center);
        aPaint.drawEllipse(rect);
    }

    public QString parseAtomLabel(TAtom atom) {
        QString macroExpr;
        if (atom == null) {
            return new QString("");
        }
        int atomIndex = this.fMolecule.atoms().indexOf(atom);
        TAtomLabelParser parser = new TAtomLabelParser(atom, atomIndex);
        QString atomLabelMacro = atom.getTatomData().labelMacro();
        QString qString = macroExpr = atomLabelMacro.isEmpty() ? this.fSettings.fLabelMacro : atomLabelMacro;
        if (macroExpr.endsWith(new QString(", {stereo}")) && atom.getTatomData().stereoDescriptor() == TStereoDescriptor.sd_None) {
            macroExpr.remove(new QString(", {stereo}"));
        }
        return parser.parse(macroExpr);
    }

    public void setShowProperties() {
        QList<Boolean> showProps = new QList<Boolean>();
        this.fShowAtomProp.clear();
        for (TAtom atom : this.fMolecule.atoms()) {
            if (atom.getfCharge() != 0 || this.fMolecule.invalidValence(atom) || atom.getfIsotope() != 0) {
                showProps.insert(AtomPropertiesIndex.apSymbol.getValue(), true);
            } else if (!atom.getfElement().getfElementSymbol().toString().equals("C")) {
                showProps.insert(AtomPropertiesIndex.apSymbol.getValue(), this.fSettings.fShowOthers);
            } else if (this.fSettings.fShowAllC) {
                showProps.insert(AtomPropertiesIndex.apSymbol.getValue(), true);
            } else if (atom.getfNeighbours().size() <= 1 && this.fSettings.fShowTermC) {
                showProps.insert(AtomPropertiesIndex.apSymbol.getValue(), true);
            } else {
                showProps.insert(AtomPropertiesIndex.apSymbol.getValue(), false);
            }
            boolean showSymbol = (Boolean)showProps.at(AtomPropertiesIndex.apSymbol.getValue());
            showProps.insert(AtomPropertiesIndex.apHydrogens.getValue(), showSymbol);
            showProps.insert(AtomPropertiesIndex.apCharge.getValue(), showSymbol);
            showProps.insert(AtomPropertiesIndex.apValence.getValue(), showSymbol);
            showProps.insert(AtomPropertiesIndex.apIsotope.getValue(), showSymbol);
            QString label = this.parseAtomLabel(atom);
            showProps.insert(AtomPropertiesIndex.apNumbering.getValue(), this.fSettings.fShowNumbers && !label.isEmpty());
            showProps.insert(AtomPropertiesIndex.apStereoNotation.getValue(), !atom.stereoNotation().isEmpty());
            this.fShowAtomProp.append(showProps);
            showProps.clear();
        }
    }

    public QString strCharge(int aCharge) {
        QString charge = new QString();
        QString str = new QString();
        if (Math.abs(aCharge) > 1) {
            charge.append("" + Math.abs(aCharge));
        }
        if (aCharge > 0) {
            charge.append("+");
        } else if (aCharge < 0) {
            charge.append("-");
        }
        return charge;
    }

    public boolean txtDirection(int atomIndex, QMatrix aMatrix) {
        TAtom atm = this.atom(atomIndex);
        boolean normalWrit = true;
        int left = 0;
        QPoint<Double> atomCoord1 = aMatrix.map(this.getAtomCoord(atomIndex));
        for (TNeighbour nb : atm.getfNeighbours()) {
            int nextIndex = nb.getfBond().getSecond(atomIndex);
            QPoint<Double> atomCoord2 = aMatrix.map(this.getAtomCoord(nextIndex));
            if (atomCoord1.x() < atomCoord2.x()) {
                ++left;
                continue;
            }
            if (!(atomCoord1.x() > atomCoord2.x())) continue;
            --left;
        }
        if (left > 0) {
            normalWrit = false;
        }
        return normalWrit;
    }

    public void setAtomTextProp() {
        this.fAtomTextProp.clear();
        for (int atomIndex = 0; atomIndex < this.fMolecule.atoms().size(); ++atomIndex) {
            TAtomTextProp structAtom = new TAtomTextProp();
            TAtom atom = this.fMolecule.atoms().at(atomIndex);
            QRectF rectSymbol = new QRectF();
            if (this.fShowAtomProp.at(atomIndex).count(true) <= 0) continue;
            if (this.fShowAtomProp.at(new Integer(atomIndex)).at(AtomPropertiesIndex.apSymbol.getValue()).booleanValue()) {
                rectSymbol = this.getTextRect(this.fAtomFont, atom.getfElement().getfElementSymbol());
            }
            structAtom.setTextRectSymbol(rectSymbol);
            structAtom.setTextRectPositioned(new QRectF());
            this.fAtomTextProp.add(new Integer(atomIndex), structAtom);
        }
    }

    public void updateAtomSymbolRect() {
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            TAtom atom = this.fMolecule.atoms().at(i);
            if (!this.fAtomTextProp.contains(i)) continue;
            QRectF rectSymbol = this.getTextRect(this.fAtomFont, atom.getfElement().getfElementSymbol());
            this.fAtomTextProp.find(i).setTextRectSymbol(rectSymbol);
        }
    }

    public void drawAtom(int aNAtom, QMatrix aMatrix, QPainter aPaint) {
        QColor numberColor;
        QString stereoN;
        QString alias;
        QColor color;
        TAtom atom = this.fMolecule.atom(aNAtom);
        int atomIndex = aNAtom;
        QPoint<Double> atomCoord = this.getAtomCoord(atomIndex);
        QRectF rectSymbol = new QRectF();
        QRectF rectHIndex = new QRectF();
        QRectF rectCharge = new QRectF();
        QRectF rectH = new QRectF();
        QRectF rect = new QRectF();
        QRectF rectIsotope = new QRectF();
        QRectF rectNumber = new QRectF();
        QRectF rectStereoNotation = new QRectF();
        int hydro = 0;
        QString charge = new QString();
        QString label = new QString();
        QColor customColor = atom.getTatomData().color();
        QColor qColor = color = customColor.isValid() ? customColor : this.fSettings.fAtomFontColor;
        if (this.fShowAtomProp.at(atomIndex).at(AtomPropertiesIndex.apSymbol.getValue()).booleanValue() && !(alias = atom.getfAlias()).isEmpty()) {
            QRectF rectLabel = this.getTextRect(this.fAtomFont, alias);
            rectLabel.moveCenter(aMatrix.map(atomCoord));
            this.drawText(this.fAtomFont, rectLabel, alias, aPaint, color);
            return;
        }
        this.calcDrawAtomRectangles(atomIndex, aMatrix, rectSymbol, rectHIndex, rectCharge, rectH, rectIsotope, rectNumber, rectStereoNotation, hydro, label, charge);
        hydro = this.fMolecule.atom(atomIndex).nH();
        if (this.fSettings.fShowAssignQuality && atom.getTatomData().data(TAtomData.cAssignmentQuality) != null) {
            boolean stable;
            double quality = atom.getTatomData().assignmentQuality();
            boolean bl = stable = atom.getTatomData().assignmentStability() == TAssignmentStability.sStable;
            QColor qualityColor = quality > 0.25 ? Qt.green.getQColor() : (quality > -0.25 ? Qt.yellow.getQColor() : Qt.red.getQColor());
            qualityColor.setAlphaF(0.55);
            this.drawAssignmentQuality(this.getTotalTextRect(rectSymbol, rectH, rectHIndex, rectCharge, rectIsotope, rectNumber, rectStereoNotation), aPaint, qualityColor, stable);
        }
        if (atom.getTatomData().highlightColor().isValid()) {
            QRectF highlightRect = this.getTotalTextRect(rectSymbol, rectH, rectHIndex, rectCharge, rectIsotope, rectNumber, rectStereoNotation);
            aPaint.save();
            aPaint.setPen(QtPenStyle.NoPen);
            aPaint.setBrush(atom.getTatomData().highlightColor());
            aPaint.drawRect(highlightRect);
            aPaint.restore();
        }
        this.drawText(this.fAtomFont, rectSymbol, atom.getfElement().getfElementSymbol(), aPaint, color);
        if (this.fMolecule.invalidValence(atom)) {
            aPaint.save();
            aPaint.setPen(new QPen(Qt.red, 3, QtPenStyle.DashLine));
            aPaint.drawLine(new QLineF(rectSymbol.topLeft(), rectSymbol.bottomRight()));
            aPaint.drawLine(new QLineF(rectSymbol.topRight(), rectSymbol.bottomLeft()));
            aPaint.restore();
        }
        if (hydro >= 1 && !atom.getfElement().getfElementSymbol().toString().equals("H")) {
            this.drawText(this.fAtomFont, rectH, new QString("H"), aPaint, color);
        }
        if (hydro >= 2) {
            this.drawText(this.fHIndexFont, rectHIndex, new QString("" + hydro), aPaint, color);
        }
        if (atom.getfCharge() != 0) {
            this.drawText(this.fChargeFont, rectCharge, charge, aPaint, color);
        }
        if (atom.getfIsotope() != 0) {
            this.drawText(this.fIsotopeFont, rectIsotope, new QString("" + atom.getfIsotope()), aPaint, color);
        }
        if (!(stereoN = atom.stereoNotation()).isEmpty()) {
            this.drawText(this.fAtomFont, rectStereoNotation, stereoN, aPaint, color);
        }
        QColor qColor2 = numberColor = customColor.isValid() ? customColor : this.fSettings.fNumberFontColor;
        if (atom.fixedNumber()) {
            aPaint.save();
            aPaint.setPen(new QPen(Qt.yellow, 3, QtPenStyle.SolidLine));
            aPaint.drawRect(rectNumber);
            aPaint.restore();
        }
        this.drawText(this.fNumberFont, rectNumber, label, aPaint, numberColor);
    }

    public void drawText(QFont aFont, QRectF aRect, QString aText, QPainter aPaint, QColor aColor) {
        if (aRect.isNull()) {
            return;
        }
        aPaint.save();
        aPaint.setFont(UtilsPainter.fontSizeInPixels(aFont));
        aPaint.setPen(aColor);
        aPaint.drawText(aRect.center(), aText);
        aPaint.restore();
    }

    public QRectF getTotalTextRect(QRectF aRectSymbol, QRectF aRectH, QRectF aRectHIndex, QRectF aRectCharge, QRectF aRectIsotope, QRectF aRectNumber, QRectF aRectStereoNotation) {
        QRectF rect = new QRectF(aRectSymbol.unite(aRectH));
        rect = rect.unite(aRectHIndex);
        rect = rect.unite(aRectCharge);
        rect = rect.unite(aRectIsotope);
        rect = rect.unite(aRectNumber);
        rect = rect.unite(aRectStereoNotation);
        this.adjustMarginWidth(rect, true);
        return rect;
    }

    public void calcGraphPoly() {
        QList<TBond> aromaticList = new QList<TBond>();
        for (TBond bond : this.fMolecule.bonds()) {
            if (bond.bondType() != TBondType.btAromatic) continue;
            aromaticList.append(bond);
        }
        if (aromaticList.size() == 0) {
            return;
        }
        this.fGraphPoly = this.createPolygons(aromaticList);
    }

    public QRectF atomCoordRect() {
        QMatrix m = this.fSizeToFSize(false);
        QPolygonF coordRect = new QPolygonF();
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            coordRect.add(m.map(this.getAtomCoord(i)));
        }
        if (fAngleDegrees == 0.0) {
            return coordRect.boundingRect();
        }
        return this.getRotMatrixFSize().inverted().map(coordRect).boundingRect();
    }

    public void setCanvasSize(QRectF aNewRect) {
        int i;
        QRectF sizeRectText = this.atomCoordRect();
        QRectF rectUnite = new QRectF(sizeRectText);
        double oldAngle = fAngleDegrees;
        if (this.fSettings.fRotateTextWithMol) {
            fAngleDegrees = 0.0;
        }
        QMatrix m = this.fSizeToFSize(false);
        if (this.fSettings.fShowAllC || this.fSettings.fShowTermC || this.fSettings.fShowOthers || this.fSettings.fShowNumbers) {
            for (i = 0; i < this.fMolecule.atoms().size(); ++i) {
                if (!this.fAtomTextProp.contains(i)) continue;
                QRectF rectText = this.fAtomTextProp.find(i).getTextRectPositioned();
                rectText = rectText.translated(this.x(), this.y());
                if (sizeRectText.contains(this.getRotMatrixFSize().inverted().mapRect(rectText))) continue;
                QPolygonF pol = new QPolygonF(rectText);
                double maxDistance = UtilGeometry.distance(pol.at(0), m.map(this.getAtomCoord(i)));
                for (int k = 1; k < pol.size(); ++k) {
                    double distance = UtilGeometry.distance(pol.at(k), m.map(this.getAtomCoord(i)));
                    if (!(distance > maxDistance)) continue;
                    maxDistance = distance;
                }
                rectText = new QRectF(m.map(this.getAtomCoord(i)).x() - maxDistance, m.map(this.getAtomCoord(i)).y() - maxDistance, maxDistance * 2.0, maxDistance * 2.0);
                if (TCanvasItem.angle() != 0.0) {
                    QRectF rectRotated = this.getRotMatrixFSize().inverted().mapRect(rectText);
                    rectText.moveCenter(rectRotated.center());
                }
                rectUnite = rectUnite.unite(rectText);
            }
        }
        for (i = 0; i < this.fMolecule.atoms().size(); ++i) {
            if (this.fAtomTextProp.contains(i)) continue;
            QPoint<Double> aux = m.map(this.getAtomCoord(i));
            aux.setX(aux.x() + this.fDx);
            aux.setY(aux.y() + this.fDy);
            QRectF rectText = this.createAtomRectSelection(aux);
            rectUnite = rectUnite.unite(rectText);
        }
        if (!aNewRect.isEmpty()) {
            double w = aNewRect.width() - rectUnite.width();
            double h = aNewRect.height() - rectUnite.height();
            rectUnite.adjust(-w / 2.0, -h / 2.0, w / 2.0, h / 2.0);
        }
        double storeDx = this.fDx;
        double storeDy = this.fDy;
        this.fDx = rectUnite.x() - this.x();
        this.fDy = rectUnite.y() - this.y();
        if (this.fSize.width() < 0.0) {
            this.fDx = rectUnite.x() + rectUnite.width() - this.x();
            rectUnite.setWidth(-rectUnite.width());
        }
        if (this.fSize.height() < 0.0) {
            this.fDy = rectUnite.y() + rectUnite.height() - this.y();
            rectUnite.setHeight(-rectUnite.height());
        }
        if (this.fFixAtomPositions) {
            this.myx = this.x() + this.fDx - storeDx;
            this.myy = this.y() + this.fDy - storeDy;
        }
        this.setAngle(oldAngle);
        this.fCanvasSize = new QSize<Double>(rectUnite.width(), rectUnite.height());
    }

    public void calcDrawAtomRectangles(int atomIndex, QMatrix aMatrix, QRectF rectSymbol, QRectF rectHIndex, QRectF rectCharge, QRectF rectH, QRectF rectIsotope, QRectF rectNumber, QRectF rectStereoNotation, Integer hydro, QString label, QString charge) {
        QString stereoN;
        boolean symbolFirst = true;
        TAtom atom = this.fMolecule.atom(atomIndex);
        QPoint<Double> atomCoord = this.getAtomCoord(atomIndex);
        label.clear();
        charge.clear();
        double posX = rectSymbol.left();
        double posY = rectSymbol.top();
        double semiRectSymbolHeight = rectSymbol.height() / 2.0;
        if (this.fShowAtomProp.at(atomIndex).at(AtomPropertiesIndex.apSymbol.getValue()).booleanValue()) {
            rectSymbol.setCoords(this.fAtomTextProp.find(atomIndex).getTextRectSymbol());
            rectSymbol.moveCenter(aMatrix.map(atomCoord));
            posX = rectSymbol.left();
            posY = rectSymbol.top();
            semiRectSymbolHeight = rectSymbol.height() / 2.0;
        }
        if (this.fShowAtomProp.at(atomIndex).at(AtomPropertiesIndex.apIsotope.getValue()).booleanValue() && atom.getfIsotope() != 0) {
            rectIsotope.setCoords(this.getTextRect(this.fIsotopeFont, new QString("" + atom.getfIsotope())));
            posX = rectSymbol.left() - rectIsotope.width();
            rectIsotope.moveTo(posX, posY - semiRectSymbolHeight);
        }
        if (this.fShowAtomProp.at(atomIndex).at(AtomPropertiesIndex.apHydrogens.getValue()).booleanValue()) {
            hydro = atom.nH();
            if (hydro >= 1 && !atom.elementSymbol().equals(new QString("H"))) {
                rectH.setCoords(this.getTextRect(this.fAtomFont, new QString("H")));
                symbolFirst = this.txtDirection(atomIndex, aMatrix);
            }
            if (hydro >= 2) {
                rectHIndex.setCoords(this.getTextRect(this.fHIndexFont, new QString("" + hydro)));
            }
            if (symbolFirst) {
                posX = posX + rectSymbol.width() + rectIsotope.width();
                rectH.moveTo(posX, posY);
                rectHIndex.moveTo(posX += rectH.width(), posY + semiRectSymbolHeight);
            } else {
                if (rectIsotope.isNull()) {
                    posX -= rectHIndex.width();
                }
                rectHIndex.moveTo(posX, posY + semiRectSymbolHeight);
                rectH.moveTo(posX -= rectH.width(), posY);
            }
        }
        if (this.fShowAtomProp.at(atomIndex).at(AtomPropertiesIndex.apCharge.getValue()).booleanValue() && atom.getfCharge() != 0) {
            charge.append(this.strCharge(atom.getfCharge()));
            rectCharge.setCoords(this.getTextRect(this.fChargeFont, charge));
            if (symbolFirst) {
                rectCharge.moveTo(posX, posY - semiRectSymbolHeight);
            } else {
                rectCharge.moveTo(rectSymbol.left() + rectSymbol.width(), posY - semiRectSymbolHeight);
            }
        }
        label.append(this.parseAtomLabel(atom));
        if (this.fShowAtomProp.at(atomIndex).at(AtomPropertiesIndex.apNumbering.getValue()).booleanValue() && !label.isEmpty()) {
            rectNumber.setCoords(this.getTextRect(this.fNumberFont, label));
            rectNumber.moveCenter(aMatrix.map(atomCoord));
            rectNumber.translate(0.0, rectSymbol.height());
        }
        if (!(stereoN = atom.stereoNotation()).isEmpty()) {
            rectStereoNotation.setCoords(this.getTextRect(this.fAtomFont, stereoN));
            rectStereoNotation.moveTo(aMatrix.map(atomCoord));
            QPoint<Double> bl = aMatrix.map(atomCoord);
            if (!rectCharge.isEmpty()) {
                bl = rectCharge.topRight();
            } else if (!rectSymbol.isEmpty()) {
                bl = rectSymbol.topRight();
            } else if (!rectNumber.isEmpty()) {
                bl = rectNumber.topRight();
            }
            rectStereoNotation.moveBottomLeft(bl);
        }
    }

    public void calcRectanglesText() {
        this.fHotAreas.clear();
        QRectF rectSymbol = new QRectF();
        QRectF rectHIndex = new QRectF();
        QRectF rectCharge = new QRectF();
        QRectF rectH = new QRectF();
        QRectF rect = new QRectF();
        QRectF rectIsotope = new QRectF();
        QRectF rectNumber = new QRectF();
        QRectF rectStereoNotation = new QRectF();
        Integer hydro = 0;
        QString charge = new QString();
        QString label = new QString();
        QMatrix m = this.fSizeToFSize(false);
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            QString alias;
            TAtom atom = this.fMolecule.atoms().at(i);
            rectSymbol = new QRectF();
            rectHIndex = new QRectF();
            rectCharge = new QRectF();
            rectH = new QRectF();
            rect = new QRectF();
            rectIsotope = new QRectF();
            rectNumber = new QRectF();
            rectStereoNotation = new QRectF();
            int atomIndex = i;
            QPoint<Double> atomCoord = this.getAtomCoord(atomIndex);
            rectSymbol = new QRectF();
            rectH = new QRectF();
            rectHIndex = new QRectF();
            rectCharge = new QRectF();
            rectIsotope = new QRectF();
            rectNumber = new QRectF();
            if (!this.fAtomTextProp.contains(atomIndex)) continue;
            if (this.fShowAtomProp.at(atomIndex).at(AtomPropertiesIndex.apSymbol.getValue()).booleanValue() && !(alias = atom.getfAlias()).isEmpty()) {
                rect.setCoords(this.getTextRect(this.fAtomFont, alias));
                rect.moveCenter(m.map(atomCoord));
                this.adjustMarginWidth(rect, true);
                rect.setCoords(rect.translated(-this.x(), -this.y()));
                this.fAtomTextProp.find(atomIndex).setTextRectPositioned(rect);
                continue;
            }
            this.calcDrawAtomRectangles(atomIndex, m, rectSymbol, rectHIndex, rectCharge, rectH, rectIsotope, rectNumber, rectStereoNotation, hydro, label, charge);
            rect.setCoords(this.getTotalTextRect(rectSymbol, rectH, rectHIndex, rectCharge, rectIsotope, rectNumber, rectStereoNotation));
            rect.setCoords(rect.translated(-this.x(), -this.y()));
            this.fAtomTextProp.find(atomIndex).setTextRectPositioned(rect);
        }
    }

    public void setAngle(double aAngleDegrees) {
        this.fHotAreas.clear();
        while (aAngleDegrees < 0.0) {
            aAngleDegrees += 360.0;
        }
        while (aAngleDegrees >= 360.0) {
            aAngleDegrees -= 360.0;
        }
        if (fAngleDegrees != aAngleDegrees) {
            fAngleDegrees = aAngleDegrees - fAngleDegrees;
            this.mapAtomCoords(this.getRotMatrixFSizeNoXY());
            this.recalcAtomCoords();
        }
        fAngleDegrees = aAngleDegrees;
        if (!this.fSettings.fRotateTextWithMol) {
            this.calcRectanglesText();
        }
    }

    @Override
    public void translate(QPoint<Double> aD) {
        this.fHotAreas.clear();
        this.translate(aD);
    }

    public void changeCanvasSize(QRectF aNewSize) {
        this.calcRectanglesText();
        this.setCanvasSize(aNewSize);
    }

    public QMatrix moleculeToFSize() {
        QRectF bound = this.fMolecule.getBound();
        return UtilGeometry.rect2RectQt(bound, new QRectF(new QPoint<Double>(this.x(), this.y()), this.fSize));
    }

    public QMatrix moleculeToFSizeNoXY() {
        QRectF bound = this.fMolecule.getBound();
        return UtilGeometry.rect2RectQt(bound, new QRectF(new QPoint<Double>(0.0, 0.0), this.fSize));
    }

    public QMatrix fSizeToFSize(boolean changeDx) {
        if (!this.hasAtomCoords()) {
            return this.moleculeToFSize();
        }
        QMatrix m = UtilGeometry.rect2RectQt(new QRectF(new QPoint<Double>(this.x(), this.y()), this.fSize), new QRectF(new QPoint<Double>(this.x(), this.y()), this.fSize));
        if (changeDx) {
            m.setMatrix(m.m11(), m.m12(), m.m21(), m.m22(), m.dx() + this.x() - this.fDx, m.dy() + this.y() - this.fDy);
        } else {
            m.setMatrix(m.m11(), m.m12(), m.m21(), m.m22(), m.dx() + this.x(), m.dy() + this.y());
        }
        return m;
    }

    public void setAtomCoord(int aAtomIndex, QPoint<Double> aValue) {
        this.fAtomCoords.set(aAtomIndex, aValue);
    }

    public QPoint<Double> getAtomCoord(int aAtomIndex) {
        if (this.hasAtomCoords() && aAtomIndex >= 0 && aAtomIndex < this.fAtomCoords.size()) {
            return this.fAtomCoords.get(aAtomIndex);
        }
        if (this.atom(aAtomIndex) != null) {
            return this.atom(aAtomIndex);
        }
        return new QPoint<Double>(0.0, 0.0);
    }

    public void fillAtomCoords() {
        for (int natom = 0; natom < this.fMolecule.atoms().size(); ++natom) {
            TAtom coord = this.fMolecule.atom(natom);
            this.fAtomCoords.append(coord);
        }
    }

    public void mapAtomCoords(QMatrix aMap) {
        for (int natom = 0; natom < this.fAtomCoords.size(); ++natom) {
            this.fAtomCoords.set(natom, aMap.map(this.fAtomCoords.get(natom)));
        }
    }

    public void increaseCanvasSize(QPoint<Double> aPos) {
        QRectF prRect = this.boundingRect();
        int marg = 100;
        QRectF rect = new QRectF();
        rect.setCoords(aPos.x() - (double)marg, aPos.y() - (double)marg, aPos.x() + (double)marg, aPos.y() + (double)marg);
        prRect = prRect.unite(rect);
        this.fDx -= this.myx - prRect.topLeft().x();
        this.fDy -= this.myy - prRect.topLeft().y();
        this.myx = prRect.topLeft().x();
        this.myy = prRect.topLeft().y();
        this.fCanvasSize = prRect.size();
    }

    @Override
    public QPoint<Double> getRotationCenter() {
        QRectF rect = new QRectF(this.x() - this.fDx, this.y() - this.fDy, this.fSize.width(), this.fSize.height());
        return rect.center();
    }

    @Override
    public QPoint<Double> getRotationCenterForPolygonF(QPolygonF aPoly) {
        QRectF rect = new QRectF();
        rect.setCoords(aPoly.at(0).x(), aPoly.at(0).y(), aPoly.at(2).x(), aPoly.at(2).y());
        double factorX = rect.width() / this.fOriginalCanvasSize.width();
        double factorY = rect.height() / this.fOriginalCanvasSize.height();
        double factor = factorX < factorY ? factorX : factorY;
        QRectF newSize = new QRectF(rect.x(), rect.y(), this.fOriginalSize.width() * factor, this.fOriginalSize.height() * factor);
        rect.setWidth(this.fOriginalSize.width() * factor);
        rect.setHeight(this.fOriginalSize.height() * factor);
        QRectF rotRect = new QRectF(rect.x() - this.fDx, rect.y() - this.fDy, rect.width(), rect.height());
        return rotRect.center();
    }

    public QMatrix getRotMatrixFSize() {
        QRectF rect = new QRectF(new QPoint<Double>(this.x(), this.y()), this.fSize);
        return UtilGeometry.rotate(rect.center(), UtilGeometry.deg2Rad(fAngleDegrees));
    }

    public QMatrix getRotMatrixFSizeNoXY() {
        QRectF rect = new QRectF(new QPoint<Double>(0.0, 0.0), this.fSize);
        return UtilGeometry.rotate(rect.center(), UtilGeometry.deg2Rad(fAngleDegrees));
    }

    public QRectF calcAtomRectSelection(int aAtomIndex, QPoint<Double> aAtomPoint) {
        QRectF rect = new QRectF();
        if (aAtomIndex < 0 || aAtomIndex > this.fMolecule.atoms().size()) {
            return rect;
        }
        if (this.fAtomTextProp.contains(aAtomIndex)) {
            rect = this.fAtomTextProp.find(aAtomIndex).getTextRectPositioned();
            rect = rect.translated(this.x() - this.fDx, this.y() - this.fDy);
        } else {
            rect = this.createAtomRectSelection(aAtomPoint);
        }
        return rect;
    }

    public void adjustMarginWidth(QRectF aRect, boolean addMargins) {
        double marginWidth = this.fSettings.fMarginWidth * Canvas.dotsPerMm * Math.abs(this.fScaleFactor);
        double d = marginWidth = marginWidth <= 0.0 ? 0.01 : marginWidth;
        if (addMargins) {
            aRect.adjust(-marginWidth, -marginWidth, marginWidth, marginWidth);
        } else {
            aRect.adjust(marginWidth, marginWidth, -marginWidth, -marginWidth);
        }
    }

    public QRectF createAtomRectSelection(QPoint<Double> aAtomPoint) {
        QRectF rect = new QRectF();
        QPoint<Double> atomPos = new QPoint<Double>();
        atomPos.setX(aAtomPoint.x() - this.fDx);
        atomPos.setY(aAtomPoint.y() - this.fDy);
        if (!this.fSettings.fRotateTextWithMol) {
            atomPos = this.getRotationMatrix().map(atomPos);
        }
        rect = this.getTextRect(this.fAtomFont, new QString("H"));
        this.adjustMarginWidth(rect, true);
        rect.moveCenter(atomPos);
        return rect;
    }

    public void setOriginalCanvasSize(double aWidth, double aHeight) {
        this.fOriginalCanvasSize = new QSize<Double>(aWidth, aHeight);
    }

    public void setOriginalSize(double aWidth, double aHeight) {
        this.fOriginalSize = new QSize<Double>(aWidth, aHeight);
    }

    public boolean updateMoleculeToCanvas(double aScaleFactor, boolean aWithScaling) {
        double factor = aWithScaling ? this.resize() : 1.0;
        QRectF bound = this.fMolecule.getBound();
        bound = bound.normalized();
        double w = bound.width() * factor * aScaleFactor;
        double h = bound.height() * factor * aScaleFactor;
        this.setSize(w, h);
        this.setOriginalSize(w / aScaleFactor, h / aScaleFactor);
        return true;
    }

    public void updateAll(boolean aWithScaling) {
        double storeScaleFactor = this.fScaleFactor;
        if (!aWithScaling) {
            this.fScaleFactor = 1.0;
        }
        this.updateMoleculeToCanvas(this.fScaleFactor, aWithScaling);
        this.setFonts();
        this.setShowProperties();
        this.setAtomTextProp();
        this.changeCanvasSize(new QRectF());
        this.setOriginalCanvasSize(this.fCanvasSize.width() / this.fScaleFactor, this.fCanvasSize.height() / this.fScaleFactor);
        if (!aWithScaling) {
            this.fScaleFactor = storeScaleFactor;
        }
    }

    public void setScaleFactor(QRectF aNewRect) {
        double w;
        double factor;
        QRectF originalSize = new QRectF(this.x(), this.y(), this.fOriginalSize.width(), this.fOriginalSize.height());
        double h = aNewRect.height() / originalSize.height();
        this.fScaleFactor = factor = h < (w = aNewRect.width() / originalSize.width()) ? h : w;
    }

    public void setFonts() {
        this.fAtomFont = new QFont(this.fSettings.fAtomFont);
        double atomFontSz = (double)this.fSettings.fAtomFont.pointSizeF() * Math.abs(this.fScaleFactor);
        if (atomFontSz < 12.0) {
            atomFontSz = Math.min(2.0 * atomFontSz, 12.0);
        }
        this.fAtomFont.setPointSizeF(atomFontSz);
        this.fHIndexFont = new QFont(this.fAtomFont);
        this.fHIndexFont.setPointSizeF((double)this.fAtomFont.pointSizeF() * 0.8);
        this.fChargeFont = new QFont(this.fAtomFont);
        this.fChargeFont.setPointSizeF((double)this.fAtomFont.pointSizeF() * 0.8);
        this.fIsotopeFont = new QFont(this.fAtomFont);
        this.fIsotopeFont.setPointSizeF((double)this.fAtomFont.pointSizeF() * 0.8);
        this.fNumberFont = new QFont(this.fSettings.fNumberFont);
        double numberFontSz = (double)this.fSettings.fNumberFont.pointSizeF() * Math.abs(this.fScaleFactor);
        if (numberFontSz < 8.5) {
            numberFontSz = Math.min(2.0 * numberFontSz, 8.5);
        }
        this.fNumberFont.setPointSizeF(numberFontSz);
        this.fMoleculeLabelFont = this.fSettings.fMoleculeLabelFont;
        this.updateAtomSymbolRect();
    }

    public QList<QLineF> calcSmallLines(QLineF aLineBond, QPolygon aTriangle) {
        QList<QLineF> smallLines = new QList<QLineF>();
        double hashSpacing = this.fSettings.fHashSpacing * Canvas.dotsPerMm * Math.abs(this.fScaleFactor);
        if (hashSpacing == 0.0) {
            return smallLines;
        }
        QLineF baseLine = new QLineF(aTriangle.at(1), aTriangle.at(2));
        int nLines = (int)((double)((int)aLineBond.length()) / hashSpacing);
        for (int i = 1; i <= nLines; ++i) {
            QLineF parallelLine = this.parallel(baseLine, baseLine.normalVector(), (double)i * hashSpacing);
            QPoint<Double> interPoint1 = parallelLine.p1();
            QPoint<Double> interPoint2 = parallelLine.p2();
            if (parallelLine.intersect(new QLineF(aTriangle.at(0), aTriangle.at(1)), interPoint1) == QLineF.IntersectType.BoundedIntersection && parallelLine.intersect(new QLineF(aTriangle.at(0), aTriangle.at(2)), interPoint2) == QLineF.IntersectType.BoundedIntersection) {
                parallelLine = new QLineF(interPoint1, interPoint2);
            }
            smallLines.append(parallelLine);
        }
        return smallLines;
    }

    public boolean atomRectContains(QRectF aRect, QPoint<Double> aPoint) {
        if (this.fSettings.fRotateTextWithMol) {
            QPoint<Double> noRotatedPos = this.getRotationMatrix().inverted().map(aPoint);
            return aRect.contains(noRotatedPos);
        }
        return aRect.contains(aPoint);
    }

    public void clear() {
        this.fShowAtomProp.clear();
        this.fAtomTextProp.clear();
        this.fGraphPoly.clear();
        this.fBrackets.clear();
        if (this.fMolecule != null) {
            this.fMolecule.clear();
        }
        this.fAtomCoords.clear();
        this.fStoreAtomCoords.clear();
    }

    @Override
    public QUuid dataId() {
        return this.fMolecule != null ? this.fMolecule.id() : new QUuid();
    }

    public void shareData(TCanvasItem aOriginalItem) throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean equalData(TCanvasItem aItem) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void setMolecule(TMolecule aMolecule) {
        this.fMolecule = aMolecule;
    }

    public QList<TCanvasItem> sameDataIdItems() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void updateAllItemsWithSameDataId(boolean aIncludingSelf) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void unshareData() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void createDuplicate() throws Exception {
        throw new Exception("Method not implemented");
    }

    public QList<TMoleculeHotArea> hotAreas() {
        return this.fHotAreas;
    }

    public QString title() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void addBracket(TBracket aBracket) {
        this.fBrackets.append(aBracket);
    }

    @Override
    public void recalcCoords() {
        QRectF rect1 = new QRectF(new QPoint<Double>(0.0, 0.0), this.fSize);
        this.mapAtomCoords(UtilGeometry.rect2RectQt(rect1, rect1));
    }

    public void recalcAtomCoords() {
        this.calcGraphPoly();
        this.calcSterodescriptors();
    }

    public QMatrix fSizeToMolecule(boolean aRotate) {
        QRectF rect = new QRectF(new QPoint<Double>(0.0, 0.0), this.fSize);
        QRectF bound = this.fMolecule.getBound();
        QMatrix m = UtilGeometry.rect2RectQt(rect, bound);
        if (aRotate) {
            m = UtilGeometry.rotate(rect.center(), UtilGeometry.deg2Rad(-fAngleDegrees)).multiply(m);
        }
        return m;
    }

    public void setBracketsCoords() {
        if (this.fBrackets.size() == 0) {
            return;
        }
        QMatrix m = this.fSizeToMolecule(false);
        int nBracket = 0;
        for (int pNum = 1; pNum <= this.fMolecule.polymerCount(); ++pNum) {
            TPolymer poly = this.fMolecule.getPolymer(pNum);
            for (int i = 0; i < poly.getBrackets().size(); ++i) {
                TBracket molB = poly.getBrackets().at(i);
                TBracket canvasB = this.fBrackets.at(nBracket);
                QRectF rect = canvasB.getRect();
                rect.translate(this.fOriginalMolCenter);
                rect = m.mapRect(rect);
                if (!molB.isLeft()) {
                    double h = rect.height();
                    rect.setTop(rect.top() + h);
                    rect.setHeight(-h);
                }
                molB.setRect(rect);
                poly.getBrackets().replace(i, molB);
                if (++nBracket >= this.fBrackets.size()) break;
            }
            if (nBracket >= this.fBrackets.size()) break;
        }
    }

    public void setMolCoords() {
        if (this.fMolecule == null) {
            return;
        }
        this.setBracketsCoords();
        QMatrix m = this.fSizeToMolecule(true);
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            TAtom atm = this.fMolecule.atom(i);
            QPoint<Double> coord = m.map(this.getAtomCoord(i));
            atm.setX(coord.x());
            atm.setY(coord.y());
        }
    }

    public void selectAtom(int aNum, boolean aClearOldSelection) {
        if (aClearOldSelection) {
            this.clearSelection();
        }
        if (!this.fSelectedAtoms.contains(aNum)) {
            this.fSelectedAtoms.append(aNum);
        }
    }

    public void clearSelection() {
        this.fSelectedAtoms.clear();
    }

    public void removeAtomCoord(int aIndex) {
        if (aIndex >= 0 && aIndex < this.fAtomCoords.size()) {
            this.fAtomCoords.remove(aIndex);
        }
    }

    public void addAtomCoord(QPoint<Double> aNewCoord) {
        this.fAtomCoords.append(aNewCoord);
    }

    public void removeAtom(int aIndex) {
        QList<Object> terminalNeighs = new QList<Integer>();
        if (!this.atom(aIndex).isHydrogen()) {
            terminalNeighs = this.getMolecule().atomTerminalNeighbours(this.atom(aIndex));
        }
        terminalNeighs.append(aIndex);
        Collections.sort(terminalNeighs.arrayList());
        for (int i = terminalNeighs.size() - 1; i >= 0; --i) {
            this.getMolecule().removeAtom((Integer)terminalNeighs.at(i));
            this.removeAtomCoord((Integer)terminalNeighs.at(i));
        }
    }

    public void removeBond(int atom1, int atom2) {
        int a1 = atom1;
        int a2 = atom2;
        if (a1 < a2) {
            Cutils.qSwap(a1, a2);
        }
        this.getMolecule().removeBond(atom1, atom2);
        if (this.getMolecule().atom(a1) != null && this.getMolecule().atom(a1).getfNeighbours().size() == 0) {
            this.removeAtom(a1);
        }
        if (this.getMolecule().atom(a2) != null && this.getMolecule().atom(a2).getfNeighbours().size() == 0) {
            this.removeAtom(a2);
        }
    }

    public void removeAtomList(QList<Integer> aList) {
        int i;
        if (aList.isEmpty()) {
            return;
        }
        QList<Object> terminalNeighs = new QList();
        QList<Integer> withTermList = new QList<Integer>(aList);
        for (i = 0; i < aList.size(); ++i) {
            int ai = aList.at(i);
            if (this.atom(ai).isHydrogen()) continue;
            terminalNeighs = this.getMolecule().atomTerminalNeighbours(this.atom(ai));
            for (int j = 0; j < terminalNeighs.size(); ++j) {
                if (withTermList.contains((Integer)terminalNeighs.at(j))) continue;
                withTermList.append((Integer)terminalNeighs.at(j));
            }
        }
        Collections.sort(withTermList.arrayList());
        for (i = withTermList.size() - 1; i >= 0; --i) {
            this.getMolecule().removeAtom(withTermList.at(i));
            this.removeAtomCoord(withTermList.at(i));
        }
    }

    public void mergeAtoms(int atom1, int atom2, boolean aLeaveFirstAtom, QPoint<Double> aPos) {
        int toStay;
        int toDel;
        if (aLeaveFirstAtom) {
            toDel = atom2;
            toStay = atom1;
        } else {
            toDel = atom1;
            toStay = atom2;
        }
        this.getMolecule().mergeAtoms(toDel, toStay);
        if (toDel < toStay) {
            --toStay;
        }
        this.removeAtomCoord(toDel);
        this.setAtomCoord(toStay, aPos);
    }

    public void changeAtomLabel(TAtomLabelInfo aALInfo) {
        TMolecule mol = this.getMolecule();
        TAtom atm = mol.atom(aALInfo.getfAtom());
        if (atm == null) {
            return;
        }
        if (atm.getfCharge() != aALInfo.getfCharge()) {
            atm.setfCharge(aALInfo.getfCharge());
            mol.checkValence(atm, false);
        }
        if (!aALInfo.getfNumber().isEmpty()) {
            mol.setNumber(aALInfo.getfAtom(), aALInfo.getfNumber());
        }
        if (!aALInfo.getfLabel().isEmpty()) {
            mol.setToElement(atm, aALInfo.getfLabel());
            mol.expandSimpleAliases();
        }
        if (atm.getfIsotope() != aALInfo.getfIsotope()) {
            atm.setfIsotope(aALInfo.getfIsotope());
        }
        if (atm.stereoNotation() != aALInfo.getfAddLabel()) {
            atm.setStereoNotation(aALInfo.getfAddLabel());
        }
    }

    @Override
    public void afterChangingMolecule() {
        this.recalcAtomCoords();
        this.setFixAtomPositions(true);
        this.updateAll(true);
        this.setFixAtomPositions(false);
        this.setMolCoords();
        this.clearSelection();
    }

    public void setCursorPosition(QPoint<Double> aCursorPosition) {
        this.fCursorPosition = new QPoint<Double>(aCursorPosition.x(), aCursorPosition.y());
    }

    public void setDrawChain(boolean aDrawChain) {
        this.fDrawChain = aDrawChain;
    }

    public void storeAtomCoords() {
        this.fStoreAtomCoords = new QVector<QPoint<Double>>(this.fAtomCoords);
    }

    public void setAtomCoords(QVector<QPoint<Double>> aAtomCoords) {
        this.fAtomCoords = new QVector<QPoint<Double>>(aAtomCoords);
    }

    public QVector<QPoint<Double>> getAtomCoords() {
        return this.fAtomCoords;
    }

    public QVector<QPoint<Double>> getStoreAtomCoords() {
        return this.fStoreAtomCoords;
    }

    public void drawAssignmentQuality(QRectF aRect, QPainter aPaint, QColor aColor, boolean aStable) {
        if (aRect.isNull()) {
            return;
        }
        QRectF rct = new QRectF(aRect);
        double width = rct.width() * 0.3;
        double height = rct.height() * 0.3;
        rct.adjust(-width, -height, width, height);
        aPaint.save();
        if (aStable) {
            aPaint.setPen(QtPenStyle.NoPen);
            aPaint.setBrush(aColor);
        } else {
            aPaint.setPen(new QPen(aColor, 13));
            aPaint.setBrush(QtBrushStyle.NoBrush);
        }
        aPaint.drawEllipse(rct);
        aPaint.restore();
    }

    public QPoint<Double> calculateNewAtomPos(int atomIndex) {
        return this.calculateNewAtomPos(atomIndex, false);
    }

    public QPoint<Double> calculateNewAtomPos(int atomIndex, boolean aDrawChain) {
        if (!this.hasAtomCoords()) {
            return new QPoint<Double>(0.0, 0.0);
        }
        TAtom atm = this.atom(atomIndex);
        QPoint<Double> aux = new QPoint<Double>(this.getAtomCoord(atomIndex).x(), this.getAtomCoord(atomIndex).y());
        aux.setX(aux.x() + 100.0);
        QLineF bestLine = new QLineF(this.getAtomCoord(atomIndex), aux);
        if (atm.getfNeighbours().size() > 1) {
            double maxAngle = 0.0;
            for (int i = 0; i < atm.getfNeighbours().size(); ++i) {
                QLineF line1 = new QLineF(this.getAtomCoord(atomIndex), this.getAtomCoord(atm.getNeighByNum(i, atomIndex)));
                double minAngle = 0.0;
                for (int j = 0; j < atm.getfNeighbours().size(); ++j) {
                    if (i == j) continue;
                    QLineF line2 = new QLineF(this.getAtomCoord(atomIndex), this.getAtomCoord(atm.getNeighByNum(j, atomIndex)));
                    double angle = line1.angleTo(line2);
                    if (minAngle != 0.0 && !(angle < minAngle)) continue;
                    minAngle = angle;
                }
                if (maxAngle != 0.0 && !(minAngle > maxAngle)) continue;
                maxAngle = minAngle;
                bestLine = line1;
            }
            bestLine.setAngle(bestLine.angle() + maxAngle / 2.0);
        } else if (atm.getfNeighbours().size() == 1) {
            int neigh = atm.getNeighByNum(0, atomIndex);
            bestLine = new QLineF(this.getAtomCoord(atomIndex), this.getAtomCoord(neigh));
            if (!aDrawChain) {
                bestLine.setAngle(bestLine.angle() + 120.0);
            } else {
                TAtom atm2 = this.atom(neigh);
                if (atm2.getfNeighbours().size() != 2) {
                    bestLine.setAngle(bestLine.angle() + 120.0);
                } else {
                    QLineF line2;
                    QLineF line1;
                    double angle;
                    int prev = atm2.getNeighByNum(0, neigh);
                    if (prev == atomIndex) {
                        prev = atm2.getNeighByNum(1, neigh);
                    }
                    if ((angle = (line1 = new QLineF(this.getAtomCoord(neigh), this.getAtomCoord(atomIndex))).angleTo(line2 = new QLineF(this.getAtomCoord(neigh), this.getAtomCoord(prev)))) < 180.0) {
                        bestLine.setAngle(bestLine.angle() + 120.0);
                    } else {
                        bestLine.setAngle(bestLine.angle() - 120.0);
                    }
                }
            }
        }
        bestLine.setLength(this.fSettings.fAverageBondSize * Canvas.dotsPerMm * Math.abs(this.fScaleFactor));
        return bestLine.p2();
    }

    public QList<QPoint<Double>> calculateExplicitHydrogensPos(int atomIndex, int aNH) {
        int i;
        QList<QPoint<Double>> res = new QList<QPoint<Double>>();
        if (!this.hasAtomCoords() || aNH == 0) {
            return res;
        }
        TAtom atm = this.atom(atomIndex);
        QPoint<Double> atomCoord = this.getAtomCoord(atomIndex);
        QPoint<Double> aux = new QPoint<Double>(atomCoord.x(), atomCoord.y());
        aux.setX(aux.x() + 100.0);
        QLineF bestLine = new QLineF(this.getAtomCoord(atomIndex), aux);
        bestLine.setLength(this.fSettings.fAverageBondSize * Canvas.dotsPerMm * Math.abs(this.fScaleFactor));
        double maxAngle = 0.0;
        int addNeigh = 1;
        if (atm.getfNeighbours().size() > 1) {
            for (i = 0; i < atm.getfNeighbours().size(); ++i) {
                QLineF line1 = new QLineF(this.getAtomCoord(atomIndex), this.getAtomCoord(atm.getNeighByNum(i, atomIndex)));
                double minAngle = 0.0;
                for (int j = 0; j < atm.getfNeighbours().size(); ++j) {
                    if (i == j) continue;
                    QLineF line2 = new QLineF(this.getAtomCoord(atomIndex), this.getAtomCoord(atm.getNeighByNum(j, atomIndex)));
                    double angle = line1.angleTo(line2);
                    if (minAngle != 0.0 && !(angle < minAngle)) continue;
                    minAngle = angle;
                }
                if (maxAngle != 0.0 && !(minAngle > maxAngle)) continue;
                maxAngle = minAngle;
                bestLine = line1;
            }
        } else if (atm.getfNeighbours().size() == 1) {
            bestLine = new QLineF(this.getAtomCoord(atomIndex), this.getAtomCoord(atm.getNeighByNum(0, atomIndex)));
            maxAngle = 360.0;
        } else {
            res.append(new QPoint<Double>(bestLine.p2().x(), bestLine.p2().y()));
            addNeigh = 0;
            maxAngle = 360.0;
        }
        for (i = 0; i < aNH; ++i) {
            double incAngle = maxAngle / (double)(aNH + addNeigh);
            if (incAngle > 120.0) {
                incAngle = 120.0;
            }
            bestLine.setAngle(bestLine.angle() + incAngle);
            res.append(new QPoint<Double>(bestLine.p2().x(), bestLine.p2().y()));
        }
        return res;
    }

    public int findAtomWithCoords(QPoint<Double> aPos) {
        if (this.hasAtomCoords()) {
            for (int i = 0; i < this.fAtomCoords.size(); ++i) {
                QPoint<Double> curr = this.getAtomCoord(i);
                if (!(UtilGeometry.distance(aPos, curr) < 2.0)) continue;
                return i;
            }
        }
        return -1;
    }

    public void jointFragments(TCanvasMolecule aMol, int aIndex1, int aIndex2, TBondStereo aStereo) {
        if (aMol == null || aIndex1 < 0 || aIndex2 < 0) {
            return;
        }
        TMolecule m = this.getMolecule();
        TMolecule mAdd = aMol.getMolecule();
        if (m == null || mAdd == null) {
            return;
        }
        m.addFragment(mAdd);
        TBond bnd = new TBond(aIndex1, aIndex2 += m.atoms().size(), TBondType.btSingle, aStereo);
        m.addBond(bnd, true);
        for (int i = 0; i < mAdd.atoms().size(); ++i) {
            QPoint<Double> coord = aMol.getAtomCoord(i);
            QPoint<Double> px = new QPoint<Double>(this.x() - this.fDx, this.y() - this.fDy);
            QPoint<Double> pxCanvas = new QPoint<Double>(aMol.x() - aMol.canvasDx(), aMol.y() - aMol.canvasDx());
            coord.setX(coord.x() - px.x() + pxCanvas.x());
            coord.setY(coord.y() - px.y() + pxCanvas.y());
            this.addAtomCoord(coord);
        }
    }

    public boolean getTemplateDrawingDirection(int atom1, int atom2) {
        QLineF line1 = new QLineF(this.getAtomCoord(atom1), this.getAtomCoord(atom2));
        int nNeg = 0;
        int nPos = 0;
        for (int i = 0; i < this.fAtomCoords.size(); ++i) {
            if (i == atom1 || i == atom2 || this.fMolecule.findBond(i, atom1) == null && this.fMolecule.findBond(i, atom2) == null) continue;
            QLineF line2 = new QLineF(this.getAtomCoord(atom1), this.getAtomCoord(i));
            double diff = line1.angleTo(line2);
            if (diff > 0.0 && diff < 180.0) {
                ++nNeg;
                continue;
            }
            if (diff == 0.0) continue;
            ++nPos;
        }
        return nNeg > nPos;
    }

    public int findOrAddNewAtom(int atomTo, QPoint<Double> aPos) {
        TMolecule mol = this.getMolecule();
        if (mol == null) {
            return -1;
        }
        int res = this.findAtomWithCoords(aPos);
        if (res == -1) {
            TAtom atm = this.atom(atomTo);
            if (atm != null) {
                mol.addNewAtomTo(atomTo, atm, TBondStereo.bsNone);
            } else {
                mol.addNewAtomTo(atomTo, this.fSizeToMolecule(true).map(aPos), TBondStereo.bsNone);
            }
            this.addAtomCoord(aPos);
            res = mol.atoms().size() - 1;
        }
        if (mol.findBond(atomTo, res) == null) {
            TBond bnd = new TBond(atomTo, res);
            mol.addBond(bnd, true);
        }
        return res;
    }

    public boolean canAddTemplate(int atom1, int atom2, int atomCount) {
        int nPrev = atom1;
        int nCurr = atom2;
        for (int i = 0; i < atomCount - 1; ++i) {
            QPoint<Double> pos1 = this.getAtomCoord(nPrev);
            QPoint<Double> pos2 = this.getAtomCoord(nCurr);
            QLineF line = new QLineF(pos2, pos1);
            line.setAngle(line.angle() + 180.0 - 360.0 / (double)atomCount);
            QPoint<Double> pos3 = line.p2();
            int nNext = this.findAtomWithCoords(pos3);
            if (nNext == -1) {
                return true;
            }
            if (this.fMolecule.findBond(nCurr, nNext) == null) {
                return true;
            }
            nPrev = nCurr;
            nCurr = nNext;
        }
        return false;
    }

    public void addTemplate(int atom1, int atom2, TTemplateType aTemplate) {
        int nCurr;
        int nPrev;
        if (aTemplate == TTemplateType.tt_None) {
            return;
        }
        TMolecule mol = this.getMolecule();
        if (mol == null) {
            return;
        }
        boolean attachToAtom = atom2 == -1;
        TAtom atm1 = mol.atom(atom1);
        TAtom atm2 = mol.atom(atom2);
        if (atm1 == null || !attachToAtom && atm2 == null) {
            return;
        }
        int atomCount = TTemplateType.templateAtomCount(aTemplate);
        if (attachToAtom) {
            QPoint<Double> addPos = this.calculateNewAtomPos(atom1);
            nPrev = this.findOrAddNewAtom(atom1, addPos);
            QLineF line = new QLineF(addPos, this.getAtomCoord(atom1));
            line.setAngle(line.angle() + 180.0 + 90.0 - 180.0 / (double)atomCount);
            nCurr = this.findOrAddNewAtom(nPrev, line.p2());
        } else {
            boolean flag1 = this.canAddTemplate(atom1, atom2, atomCount);
            boolean flag2 = this.canAddTemplate(atom2, atom1, atomCount);
            if (flag1 && (!flag2 || this.getTemplateDrawingDirection(atom1, atom2))) {
                nPrev = atom1;
                nCurr = atom2;
            } else if (flag2) {
                nPrev = atom2;
                nCurr = atom1;
            } else {
                return;
            }
        }
        QVector<Integer> atomIndexes = new QVector<Integer>();
        atomIndexes.append(nPrev);
        for (int i = 0; i < atomCount - 1; ++i) {
            QPoint<Double> pos1 = this.getAtomCoord(nPrev);
            QPoint<Double> pos2 = this.getAtomCoord(nCurr);
            QLineF line = new QLineF(pos2, pos1);
            line.setAngle(line.angle() + 180.0 - 360.0 / (double)atomCount);
            QPoint<Double> pos3 = line.p2();
            int nNext = this.findOrAddNewAtom(nCurr, pos3);
            atomIndexes.append(nCurr);
            nPrev = nCurr;
            nCurr = nNext;
        }
        if (TTemplateType.templateBenzene(aTemplate) && atomIndexes.size() == 6) {
            for (int n = 0; n < atomIndexes.size(); ++n) {
                nPrev = (Integer)atomIndexes.get(n);
                TBond bnd = mol.findBond(nPrev, nCurr = n < atomIndexes.size() - 1 ? ((Integer)atomIndexes.get(n + 1)).intValue() : ((Integer)atomIndexes.get(0)).intValue());
                if (bnd != null && bnd.bondType() == TBondType.btSingle && mol.changeBondMultiplicity(nPrev, nCurr)) {
                    bnd.setBondStereo(TBondStereo.bsNone);
                    ++n;
                    continue;
                }
                if (bnd == null || bnd.bondType() == TBondType.btSingle) continue;
                ++n;
            }
        }
    }

    public void calcSterodescriptors() {
        if (this.fMolecule == null) {
            return;
        }
        this.fMolecule.stereoProc();
    }

    public QList<QPoint<Double>> calcChainCoords(QPoint<Double> aStartPos, QPoint<Double> aEndPos) {
        double bondLength;
        double catLength;
        QList<QPoint<Double>> res = new QList<QPoint<Double>>();
        QLineF vect = new QLineF(aStartPos, aEndPos);
        double dist = vect.length();
        if (dist < (catLength = (bondLength = this.fSettings.fAverageBondSize * Canvas.dotsPerMm * Math.abs(this.fScaleFactor)) * Math.cos(UtilGeometry.deg2Rad(30.0))) / 4.0) {
            return res;
        }
        int pointsCount = (int)(dist / catLength);
        for (int i = 0; i < pointsCount; ++i) {
            QLineF currLine = new QLineF(vect);
            currLine.setLength(catLength * (double)(i + 1));
            QPoint<Double> currPoint = new QPoint<Double>(currLine.p2().x(), currLine.p2().y());
            if (i % 2 == 0) {
                QLineF line2 = new QLineF(currLine.p2(), currLine.p1());
                line2.setAngle(currLine.angle() + 90.0);
                line2.setLength(bondLength * Math.sin(UtilGeometry.deg2Rad(30.0)));
                currPoint = line2.p2();
            }
            res.append(currPoint);
        }
        return res;
    }

    public void addExplicitHydrogens() {
        if (this.fMolecule == null) {
            return;
        }
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            TAtom atom = this.fMolecule.atom(i);
            int hCount = atom.nH();
            if (hCount <= 0) continue;
            QList<QPoint<Double>> posList = this.calculateExplicitHydrogensPos(i, hCount);
            for (int j = 0; j < hCount; ++j) {
                QPoint<Double> pos = posList.at(j);
                this.fMolecule.addNewAtomTo(i, this.fSizeToMolecule(true).map(pos), TBondStereo.bsNone, new QString("H"));
                this.addAtomCoord(pos);
            }
        }
    }

    public void removeExplicitHydrogens() {
        if (this.fMolecule == null) {
            return;
        }
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            TAtom atom = this.fMolecule.atom(i);
            int hCount = atom.nExplicitH();
            if (hCount <= 0) continue;
            int _size = atom.getfNeighbours().size();
            for (int j = _size - 1; j >= 0; --j) {
                TNeighbour nb = atom.getfNeighbours().at(j);
                if (!nb.getfAtom().isHydrogen() || nb.getfBond().bondStereo() != TBondStereo.bsNone) continue;
                this.removeAtom(atom.getNeighByNum(j, i));
            }
        }
    }

    public void EditExplicitHydrogens(boolean aDoAdd) {
        if (aDoAdd) {
            this.addExplicitHydrogens();
        } else {
            this.removeExplicitHydrogens();
        }
    }

    public void updateShareData() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void numberOfAtomsChanged() {
        this.fAtomCoords.clear();
        this.fillAtomCoords();
        this.updateMoleculeToCanvas(this.fScaleFactor, true);
        this.mapAtomCoords(this.moleculeToFSizeNoXY());
        if (fAngleDegrees != 0.0) {
            this.mapAtomCoords(this.getRotMatrixFSizeNoXY());
        }
        this.recalcAtomCoords();
    }

    public boolean allFixed(QVector<Integer> atomSet) {
        int _size = atomSet.size();
        for (int i = 0; i < _size; ++i) {
            int ind = atomSet.get(i);
            if (this.atom(ind).fixedNumber()) continue;
            return false;
        }
        return true;
    }

    public void markAsFixed(QVector<Integer> atomSet, boolean aFixed) {
        int _size = atomSet.size();
        for (int i = 0; i < _size; ++i) {
            int ind = atomSet.get(i);
            this.getMolecule().atom(ind).setFixedNumber(aFixed);
        }
    }

    public void setSettings(TCanvasMoleculeSettings aSettings) {
        this.fSettings = aSettings;
    }

    public TAtom atom(int aIndex) {
        return this.fMolecule.atom(aIndex);
    }

    public TBond bond(int aIndex) {
        return this.fMolecule.bond(aIndex);
    }

    public boolean isRotatingTextWithMol() {
        return this.fSettings.fRotateTextWithMol;
    }

    public QVector<Integer> selectedAtoms() {
        return this.fSelectedAtoms;
    }

    public QFont atomFont() {
        return this.fAtomFont;
    }

    public boolean hasAtomCoords() {
        return this.fAtomCoords.size() > 0;
    }

    public TMolecule getMolecule() {
        return this.fMolecule;
    }

    public void setFixAtomPositions(boolean aValue) {
        this.fFixAtomPositions = aValue;
    }

    public double canvasDx() {
        return this.fDx;
    }

    public double canvasDy() {
        return this.fDy;
    }

    public double marginWidth() {
        return this.fSettings.fMarginWidth * Canvas.dotsPerMm * Math.abs(this.fScaleFactor);
    }

    public TCanvasMoleculeSettings getSettings() {
        return this.fSettings;
    }

    @Override
    public int compareTo(TCanvasItem o) {
        return 0;
    }

    public void setSelectedAtoms(QVector<Integer> storeSelection) {
        this.fSelectedAtoms = storeSelection;
    }

    public void setCanvasDx(double fDx2) {
        this.fDx = fDx2;
    }

    public void setCanvasDy(double fDy2) {
        this.fDy = fDy2;
    }

    public ICanvasMoleculeTO canvasMoleculeTOJson(IMoleculeTOFactory factory, TCanvasMolecule canvasMolecule) {
        ICanvasMoleculeTO canvasMolTO = (ICanvasMoleculeTO)factory.canvasMolecule().as();
        IMoleculeTO molTO = canvasMolecule.getMolecule().moleculeTOJson(factory, canvasMolecule.getMolecule());
        canvasMolTO.setMoleculeAB(molTO);
        ICanvasMoleculeSettingTO settingsTO = canvasMolecule.getSettings().settingsTOJson(factory, canvasMolecule.getSettings());
        canvasMolTO.setCanvasMoleculeSettingAB(settingsTO);
        return canvasMolTO;
    }

    public TCanvasMolecule jsonTOCanvasMolecule(IMoleculeTOFactory factory, ICanvasMoleculeTO canvasMoleculeTO) {
        TMolecule molecule = new TMolecule();
        molecule = molecule.jsonTOMolecule(factory, canvasMoleculeTO.getMoleculeAB());
        TCanvasMoleculeSettings settings = new TCanvasMoleculeSettings();
        settings = settings.jsonTOCanvasSettings(factory, canvasMoleculeTO.getCanvasMoleculeSettingAB());
        QtCanvas canvas = new QtCanvas(this.canvas().getPainter());
        TCanvasMolecule canvasMolecule = new TCanvasMolecule(molecule, canvas, settings);
        return canvasMolecule;
    }

    @Override
    public IMoleculeTO getMoleculeAB() {
        TMolecule molecule = this.getMolecule();
        IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
        IMoleculeTO molTO = molecule.moleculeTOJson(factory, molecule);
        return molTO;
    }

    @Override
    public void setMoleculeAB(IMoleculeTO moleculeTO) {
        IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
        this.setMolecule(this.getMolecule().jsonTOMolecule(factory, moleculeTO));
    }

    @Override
    public ICanvasMoleculeSettingTO getCanvasMoleculeSettingAB() {
        TCanvasMoleculeSettings settings = this.getSettings();
        IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
        ICanvasMoleculeSettingTO settingsTO = settings.settingsTOJson(factory, settings);
        return settingsTO;
    }

    @Override
    public void setCanvasMoleculeSettingAB(ICanvasMoleculeSettingTO settingsTO) {
        IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
        this.setSettings(this.getSettings().jsonTOCanvasSettings(factory, settingsTO));
    }

    public String toJson() {
        TCanvasMolecule canvasMolecule = this;
        IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
        ICanvasMoleculeTO canvasMolTO = canvasMolecule.canvasMoleculeTOJson(factory, canvasMolecule);
        AutoBean autoBean = factory.create(ICanvasMoleculeTO.class, canvasMolTO);
        String json = AutoBeanCodex.encode((AutoBean)autoBean).getPayload();
        return json;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AtomPropertiesIndex {
        apSymbol(0),
        apHydrogens(1),
        apCharge(2),
        apValence(3),
        apIsotope(4),
        apNumbering(5),
        apStereoNotation(6);

        private int value;

        private AtomPropertiesIndex(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

