/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.mestrelab.components.client.moleditor.QPainter;
import com.mestrelab.components.client.moleditor.QtCanvas;
import com.mestrelab.components.client.moleditor.TRtti;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QMatrix;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygonF;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QUuid;
import com.mestrelab.components.shared.util.UtilGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCanvasItem
implements Comparable<TCanvasItem> {
    private TRtti type;
    private boolean fNeedSetZ;
    protected static double fAngleDegrees;
    private QUuid fId;
    private QUuid fLinkID;
    public double myx;
    public double myy;
    private QtCanvas setup_cnv;
    private QtCanvas cnv;
    private boolean visible;
    private QMap<QUuid, QList<QUuid>> fLinks;

    public TCanvasItem(TRtti id) {
        this.type = id;
        this.myx = 0.0;
        this.myy = 0.0;
        this.fLinkID = this.fId = new QUuid();
        this.fLinks = new QMap();
        this.show();
    }

    public double x() {
        return this.myx;
    }

    public double y() {
        return this.myy;
    }

    public static double angle() {
        return fAngleDegrees;
    }

    protected QMatrix getRotationMatrix() {
        if (fAngleDegrees == 0.0) {
            return new QMatrix();
        }
        return UtilGeometry.rotate(this.getRotationCenter(), UtilGeometry.deg2Rad(fAngleDegrees));
    }

    public QPoint<Double> getRotationCenter() {
        return this.getRotationCenterForPolygonF(this.getPolygonF());
    }

    public QRectF boundingRect() {
        QRectF result = this.getPolygonF().boundingRect();
        return result;
    }

    public abstract QPolygonF getPolygonF();

    public abstract void setPolygonF(QPolygonF var1);

    public abstract void recalcCoords();

    public void setBoundingRect(QRectF aRect) {
        this.setPolygonF(UtilGeometry.rect2RectQt(this.boundingRect(), aRect).map(this.getPolygonF()));
    }

    protected void moveBy(double dx, double dy) {
        this.myx += dx;
        this.myy += dy;
    }

    protected void move(double x, double y) {
        this.moveBy(x - this.myx, y - this.myy);
    }

    public QPoint<Double> getRotationCenterForPolygonF(QPolygonF aPoly) {
        return aPoly.boundingRect().center();
    }

    public QUuid itemId() {
        return this.fId;
    }

    public void setfId(QUuid fId) {
        this.fId = fId;
    }

    public abstract void drawShape(QPainter var1);

    public abstract void afterChangingMolecule();

    public abstract QUuid dataId();

    public void update() {
        if (this.canvas() != null && this.visible) {
            this.drawShape(this.canvas().getPainter());
        }
    }

    public void invalidate() {
        if (this.canvas() != null) {
            this.canvas().getPainter().clear();
        }
    }

    public TRtti rtti() {
        return this.type;
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean yes) {
        this.visible = yes;
    }

    public boolean isVisible() {
        return true;
    }

    public QtCanvas canvas() {
        return this.cnv != null ? this.cnv : this.setup_cnv;
    }

    void setup(QtCanvas aCanvas) {
        this.setup_cnv = aCanvas;
    }

    public void setXY(QPoint<Double> aP) {
        this.setX(aP.x());
        this.setY(aP.y());
    }

    public void setX(double a) {
        this.move(a, this.y());
    }

    public void setY(double a) {
        this.move(this.x(), a);
    }

    public QtCanvas setup_canvas() {
        return this.setup_cnv;
    }

    public void resetKiller() {
    }

    public void setKiller(QUuid id) {
    }

    public void setCanvas(QtCanvas aCanvas) {
        this.cnv = aCanvas;
    }

    public boolean selected() {
        return true;
    }

    public QUuid linkId() {
        return this.fLinkID;
    }

    public void needSetZ(boolean aValue) {
        this.fNeedSetZ = aValue;
    }

    public void translate(QPoint<Double> aD) {
        this.moveBy(aD.x(), aD.y());
    }

    public void translateR(QPoint<Double> aD) {
        QPoint<Double> rc = this.getRotationCenter();
        QPoint<Double> sum = new QPoint<Double>(rc.getXp(), rc.getYp());
        sum.setXp(sum.getXp() + aD.getXp());
        sum.setYp(sum.getYp() + aD.getYp());
        QPoint<Double> rotMatriSum = this.getRotationMatrix().map(sum);
        rotMatriSum.setX(rotMatriSum.x() - rc.x());
        rotMatriSum.setY(rotMatriSum.y() - rc.y());
        this.translate(rotMatriSum);
    }

    public QList<QUuid> links(QUuid aRole) {
        if (aRole.isNull()) {
            QList<QUuid> linkedIds = new QList<QUuid>();
            for (QList<QUuid> linkedList : this.fLinks.values()) {
                linkedIds.append(linkedList);
            }
            return linkedIds;
        }
        if (this.fLinks.contains(aRole)) {
            return this.fLinks.find(aRole);
        }
        return new QList<QUuid>();
    }

    public double phw() {
        double pw = 0.0;
        if (this.canvas() != null && (pw = (this.canvas().getPainter().getCanvas().getLineWidth() + 1.0) / 2.0) < 1.0) {
            pw = 1.0;
        }
        return pw;
    }
}

