/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.mestrelab.components.client.moleditor.QFont;
import com.mestrelab.components.client.moleditor.QFontMetricsF;
import com.mestrelab.components.client.moleditor.QFontWeight;
import com.mestrelab.components.client.moleditor.QPainter;
import com.mestrelab.components.client.moleditor.QPen;
import com.mestrelab.components.client.moleditor.Qt;
import com.mestrelab.components.client.moleditor.QtCanvas;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TEmptyPlugin;
import com.mestrelab.components.client.moleditor.TRtti;
import com.mestrelab.components.client.moleditor.constants.Canvas;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.TMoleculeHolder;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygonF;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QSize;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QUuid;
import com.mestrelab.components.shared.util.TDataStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCanvasCompound
extends TCanvasItem {
    private QFont fFont;
    private QSize<Double> fTextSize;
    private TEmptyPlugin fPlugin;
    private TMolecule fMolecule;

    public TCanvasCompound(TRtti id) {
        super(id);
    }

    public TCanvasCompound(TMolecule aMolecule, QString aName, QString aShortName, QtCanvas aCanvas) {
        super(TRtti.TRtti_Compound);
        this.fMolecule = new TMoleculeHolder(aMolecule).getMolecule();
        this.fTextSize = new QSize();
        this.fFont = new QFont("Arial", 30.0, QFontWeight.Normal, false);
        this.fPlugin = TEmptyPlugin.getInstance();
        this.fMolecule.setName(aName);
        this.fMolecule.setLabel(aShortName);
        QFontMetricsF fm = new QFontMetricsF(this.fFont);
        QRectF textRect = fm.boundingRect(this.fMolecule.label());
        textRect.normalized();
        double marginWidth = 0.5 * Canvas.dotsPerMm;
        textRect.adjust(-marginWidth, -marginWidth, marginWidth, marginWidth);
        this.fTextSize = textRect.size();
        this.setup(aCanvas);
    }

    @Override
    public void drawShape(QPainter aPainter) {
        aPainter.save();
        aPainter.setMatrix(this.getRotationMatrix(), true);
        aPainter.setFont(this.fFont);
        QPen aPen = new QPen();
        aPen.setColor(Qt.black.getQColor());
        aPainter.setPen(aPen);
        QRectF textRect = new QRectF(new QPoint<Double>(this.x(), this.y()), this.fTextSize);
        aPainter.drawText(textRect.center(), this.fMolecule.label());
        aPainter.restore();
    }

    @Override
    public QPolygonF getPolygonF() {
        QRectF rect = new QRectF(new QPoint<Double>(this.x(), this.y()), this.fTextSize);
        QPolygonF result = new QPolygonF(rect);
        return result;
    }

    @Override
    public void setPolygonF(QPolygonF aPol) {
        double compoundTextFactor = 1.0;
        QRectF bRect = aPol.boundingRect();
        this.move(bRect.x(), bRect.y());
        double newWidth = bRect.width();
        compoundTextFactor = newWidth / this.fTextSize.width();
        this.fFont.setPointSizeF((double)this.fFont.pointSizeF() * Math.abs(compoundTextFactor));
        if (newWidth != this.fTextSize.width()) {
            this.invalidate();
            this.fTextSize = bRect.size();
            this.update();
        }
    }

    @Override
    public QPoint<Double> getRotationCenter() {
        return super.getRotationCenter();
    }

    @Override
    public QPoint<Double> getRotationCenterForPolygonF(QPolygonF aPoly) {
        return super.getRotationCenterForPolygonF(aPoly);
    }

    public QPolygonF areaPoints() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void store(TDataStream aStream) throws Exception {
        throw new Exception("method not implemented");
    }

    public void load(TDataStream aStream) throws Exception {
        throw new Exception("method not implemented");
    }

    public void deleteMolecule() throws Exception {
        throw new Exception("method not implemented");
    }

    public QRectF getHLRect() {
        QRectF textRect = this.getPolygonF().boundingRect();
        double marginWidth = 0.5 * Canvas.dotsPerMm;
        textRect.adjust(marginWidth, marginWidth, -marginWidth, -marginWidth);
        return textRect;
    }

    public QRectF getSelectionRect() {
        QRectF textRect = this.getHLRect();
        double marginWidth = 0.5 * Canvas.dotsPerMm;
        textRect.adjust(marginWidth *= 0.5, marginWidth, -marginWidth, -marginWidth);
        return textRect;
    }

    @Override
    public QUuid dataId() {
        return this.fMolecule.id();
    }

    @Override
    public int compareTo(TCanvasItem o) {
        return 0;
    }

    @Override
    public void recalcCoords() {
    }

    @Override
    public void afterChangingMolecule() {
    }
}

