/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TMacroParser;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAtomLabelParser
extends TMacroParser {
    private TAtom fAtom;
    private int fAtomIndex;

    public TAtomLabelParser(TAtom aAtom, int aAtomIndex) {
        this.fAtom = aAtom;
        this.fAtomIndex = aAtomIndex;
    }

    @Override
    public QString getMacroValue(QString aName, QList<QString> aArgs) {
        if (aName.toString().equals("atomNum")) {
            return this.fAtom.getTatomData().number();
        }
        if (aName.toString().equals("atomIndex")) {
            return new QString("" + (this.fAtomIndex + 1));
        }
        if (aName.toString().equals("annotation")) {
            return this.fAtom.getTatomData().annotation();
        }
        if (aName.toString().equals("stereo")) {
            return this.fAtom.getTatomData().stereoDescriptorStr();
        }
        if (aName.toString().equals("custom") && aArgs.count() != 0) {
            QString tmp = aArgs.at(0);
            tmp.remove(new QString("\""));
            QMap<QString, QVariant> customMap = this.fAtom.getTatomData().customData();
            if (customMap.contains(tmp)) {
                QString parm = (QString)customMap.find(tmp);
                return parm;
            }
        }
        return new QString("");
    }
}

