/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.mestrelab.components.client.moleditor.QPainter;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TCanvasMoleculeSettings;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QRectF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QtCanvas {
    private QPainter painter = null;
    private QList<TCanvasItem> items = null;

    public QtCanvas(QPainter canvas) {
        this.painter = canvas;
        this.items = new QList();
    }

    public QList<TCanvasItem> collisions(QPoint<Double> aPos) {
        QList<TCanvasItem> list = new QList<TCanvasItem>();
        for (int i = 0; i < this.items.size(); ++i) {
            list.append(this.items.at(i));
        }
        return list;
    }

    public QList<TCanvasItem> allItems() {
        return this.items;
    }

    public QPainter getPainter() {
        return this.painter;
    }

    public void setPainter(QPainter p) {
        this.painter = p;
    }

    public void update() {
    }

    public void setCenter(TCanvasMoleculeSettings tCanvasMoleculeSettings) {
        if (tCanvasMoleculeSettings.scaleDraw) {
            for (TCanvasItem item : this.items) {
                QRectF areaMolecule = new QRectF(0.0, 0.0, item.canvas().getPainter().getWidth(), item.canvas().getPainter().getHeight());
                areaMolecule.adjust(areaMolecule.width() * tCanvasMoleculeSettings.marginDrawWidth, areaMolecule.height() * tCanvasMoleculeSettings.marginDrawHeight, -areaMolecule.width() * tCanvasMoleculeSettings.marginDrawWidth, -areaMolecule.height() * tCanvasMoleculeSettings.marginDrawHeight);
                item.setBoundingRect(areaMolecule);
            }
        } else {
            for (TCanvasItem item : this.items) {
                TCanvasMolecule activeMolecule = (TCanvasMolecule)item;
                QRectF bound = activeMolecule.boundingRect();
                QRectF areaMolecule = new QRectF(activeMolecule.fDx, activeMolecule.fDy, bound.width(), bound.height());
                QPoint<Double> center = new QPoint<Double>((double)activeMolecule.canvas().getPainter().getWidth() * 0.5, (double)activeMolecule.canvas().getPainter().getHeight() * 0.5);
                areaMolecule.moveCenter(center);
                activeMolecule.setBoundingRect(areaMolecule);
            }
        }
    }

    public boolean addToDocument() {
        return false;
    }

    public void deleteFromDocument() {
    }

    public boolean addChild(TCanvasItem aItem) {
        this.items.append(aItem);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.painter == null ? 0 : ((Object)((Object)this.painter)).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QtCanvas other = (QtCanvas)obj;
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        return !(this.painter == null ? other.painter != null : !((Object)((Object)this.painter)).equals((Object)other.painter));
    }

    public QtCanvas clone() {
        QtCanvas c = new QtCanvas(this.painter);
        for (TCanvasItem item : this.items) {
            TCanvasMolecule cmFrom = new TCanvasMolecule(new TMolecule(((TCanvasMolecule)item).getMolecule()), c, new TCanvasMoleculeSettings(((TCanvasMolecule)item).getSettings()));
            c.items.append(cmFrom);
        }
        return c;
    }
}

