/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.event.dom.client.DragEnterHandler;
import com.google.gwt.event.dom.client.DragLeaveHandler;
import com.google.gwt.event.dom.client.DragOverHandler;
import com.google.gwt.event.dom.client.DropHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.HasDragEnterHandlers;
import com.google.gwt.event.dom.client.HasDragLeaveHandlers;
import com.google.gwt.event.dom.client.HasDragOverHandlers;
import com.google.gwt.event.dom.client.HasDropHandlers;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.moleditor.CanvasHTML5;
import com.mestrelab.components.client.moleditor.ICanvas;
import com.mestrelab.components.client.moleditor.PathElement;
import com.mestrelab.components.client.moleditor.QFont;
import com.mestrelab.components.client.moleditor.QPainterPath;
import com.mestrelab.components.client.moleditor.QPen;
import com.mestrelab.components.client.moleditor.Qt;
import com.mestrelab.components.client.moleditor.QtBrushStyle;
import com.mestrelab.components.client.moleditor.QtPenStyle;
import com.mestrelab.components.client.util.FileUtilDND;
import com.mestrelab.components.shared.qt.QColor;
import com.mestrelab.components.shared.qt.QLineF;
import com.mestrelab.components.shared.qt.QMatrix;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygon;
import com.mestrelab.components.shared.qt.QRect;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVector;
import java.util.Stack;
import org.vectomatic.dnd.DropPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QPainter
extends Composite
implements HasAllKeyHandlers,
HasAllMouseHandlers,
HasDropHandlers,
HasDragEnterHandlers,
HasDragLeaveHandlers,
HasDragOverHandlers {
    private QFont fQFont;
    static final String upgradeMessage = "Your browser does not support the HTML5 Canvas!";
    private ICanvas canvas;
    private Stack<QtPenStyle> pen = new Stack();
    private Stack<QColor> brush = new Stack();
    private HorizontalPanel containerSVG;
    private FocusPanel focusPanel = null;
    private DropPanel dropPanel = null;
    private Boolean focus = false;
    private int widthLine = 1;
    private int width = 0;
    private int height = 0;

    public QPainter(int width, int height) {
        this.fQFont = new QFont();
        this.width = width;
        this.height = height;
        this.containerSVG = new HorizontalPanel();
        this.focusPanel = new FocusPanel();
        this.containerSVG.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.containerSVG.setBorderWidth(this.widthLine);
        this.canvas = new CanvasHTML5();
        if (!this.canvas.isSupported()) {
            this.containerSVG.add((Widget)new Label(upgradeMessage));
            this.initWidget((Widget)this.containerSVG);
            return;
        }
        this.focusPanel.setWidget((Widget)this.containerSVG);
        this.canvas.setWidth(width + "px");
        this.canvas.setHeight(height + "px");
        this.canvas.setCoordinateSpaceWidth(width);
        this.canvas.setCoordinateSpaceHeight(height);
        this.initializeBrush();
        this.canvas.setTextAlign(Context2d.TextAlign.CENTER);
        this.canvas.setTextBaseline(Context2d.TextBaseline.MIDDLE);
        this.canvas.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                QPainter.this.focusPanel.setFocus(true);
            }
        });
        this.containerSVG.add(this.canvas.getWidget());
        if (FileUtilDND.supportFileAPI()) {
            this.dropPanel = new DropPanel();
            this.dropPanel.add((Widget)this.focusPanel);
            this.initWidget((Widget)this.dropPanel);
        } else {
            this.initWidget((Widget)this.focusPanel);
        }
        this.sinkEvents(262144);
        this.sinkEvents(2);
        this.sinkEvents(896);
    }

    public void initializeBrush() {
        this.canvas.setFillStyle(CssColor.make((String)"white"));
        this.canvas.setStrokeStyle(CssColor.make((String)"black"));
    }

    public void setMatrix(QMatrix rotMatrix, boolean b) {
        this.canvas.setTransform(rotMatrix.m11(), rotMatrix.m12(), rotMatrix.m21(), rotMatrix.m22(), rotMatrix.dx(), rotMatrix.dy());
    }

    public void drawLine(QPoint<Double> pt1, QPoint<Double> pt2) {
        this.drawLine(new QLineF(pt1, pt2));
    }

    public void drawLine(QLineF lineBond) {
        if (this.pen.isEmpty()) {
            this.pen.push(QtPenStyle.SolidLine);
        }
        QtPenStyle penActual = this.pen.pop();
        this.canvas.beginPath();
        if (penActual == QtPenStyle.SolidLine) {
            this.canvas.moveTo(lineBond.p1().x(), lineBond.p1().y());
            this.canvas.lineTo(lineBond.p2().x(), lineBond.p2().y());
        } else if (penActual == QtPenStyle.DotLine) {
            double[] dashArray = new double[]{5.0, 10.0};
            this.canvas.moveTo(lineBond.p1().x(), lineBond.p1().y());
            this.dashedLine(lineBond.p1().x(), lineBond.p1().y(), lineBond.p2().x(), lineBond.p2().y(), dashArray);
        } else if (penActual == QtPenStyle.DashLine) {
            double[] dashArray = new double[]{10.0, 10.0};
            this.canvas.moveTo(lineBond.p1().x(), lineBond.p1().y());
            this.dashedLine(lineBond.p1().x(), lineBond.p1().y(), lineBond.p2().x(), lineBond.p2().y(), dashArray);
        } else if (penActual == QtPenStyle.DashDotLine) {
            double[] dashArray = new double[]{10.0, 10.0, 5.0, 10.0};
            this.canvas.moveTo(lineBond.p1().x(), lineBond.p1().y());
            this.dashedLine(lineBond.p1().x(), lineBond.p1().y(), lineBond.p2().x(), lineBond.p2().y(), dashArray);
        } else if (penActual == QtPenStyle.DashDotDotLine) {
            double[] dashArray = new double[]{10.0, 10.0, 5.0, 5.0, 5.0, 10.0, 5.0, 10.0};
            this.canvas.moveTo(lineBond.p1().x(), lineBond.p1().y());
            this.dashedLine(lineBond.p1().x(), lineBond.p1().y(), lineBond.p2().x(), lineBond.p2().y(), dashArray);
        }
        this.canvas.stroke();
        this.canvas.fill();
        this.canvas.closePath();
        this.pen.push(penActual);
    }

    public void save() {
        this.canvas.save();
    }

    public void drawConvexPolygon(QPolygon triangle) {
        QPainterPath path = new QPainterPath(triangle.at(0));
        for (int i = 1; i < triangle.size(); ++i) {
            path.lineTo(triangle.at(i));
        }
        path.lineTo(triangle.at(0));
        path.closePath();
        this.drawPath(path);
    }

    public void drawPolyline(QVector<QPoint<Double>> lassoPoints) {
        QPainterPath path = new QPainterPath(lassoPoints.get(0));
        for (int i = 1; i < lassoPoints.size(); ++i) {
            path.lineTo(lassoPoints.get(i));
        }
        path.closeStrokePath();
        this.drawPath(path);
    }

    public void restore() {
        this.canvas.restore();
        if (!this.pen.isEmpty()) {
            this.pen.pop();
        }
        if (!this.brush.isEmpty()) {
            this.brush.pop();
        }
    }

    public void drawRect(QRectF rect) {
        this.canvas.beginPath();
        this.canvas.moveTo((float)rect.x(), (float)rect.y());
        this.canvas.rect((float)rect.x(), (float)rect.y(), (float)rect.width(), (float)rect.height());
        this.canvas.fill();
        this.canvas.stroke();
        this.canvas.closePath();
    }

    public void drawRect(QRect rect) {
        this.canvas.beginPath();
        this.canvas.moveTo(rect.x(), rect.y());
        this.canvas.rect(rect.x(), rect.y(), rect.width(), rect.height());
        this.canvas.stroke();
        this.canvas.closePath();
    }

    public void drawEllipse(QRectF rect) {
        this.canvas.save();
        this.canvas.scale(0.75, 1);
        this.canvas.beginPath();
        this.canvas.arc(rect.x(), rect.y(), rect.width(), rect.height(), Math.PI * 2, false);
        this.canvas.stroke();
        this.canvas.closePath();
        this.canvas.restore();
    }

    public void setFont(QFont fontSizeInPixels) {
        this.fQFont = fontSizeInPixels;
        StringBuffer font = new StringBuffer();
        if (this.fQFont.isItalic()) {
            font.append("italic ");
        }
        switch (this.fQFont.getFontWeight()) {
            case Light: {
                font.append("lighter ");
                break;
            }
            case Bold: {
                font.append("bold ");
                break;
            }
            case DemiBold: {
                font.append("bolder ");
                break;
            }
            default: {
                font.append("normal ");
            }
        }
        font.append(this.fQFont.pointSizeF() + "px ");
        font.append(this.fQFont.getFamily());
        this.canvas.setFont(font.toString());
    }

    public void drawText(QPoint<Double> bottomLeft, QString aText) {
        this.canvas.beginPath();
        this.canvas.fillText(aText.toString(), bottomLeft.x(), bottomLeft.y());
        this.canvas.closePath();
    }

    public void setBrush(QtBrushStyle style) {
        if (style == QtBrushStyle.NoBrush) {
            this.setBrush(QColor.WHITE);
        }
    }

    public void setBrush(QColor aColor) {
        this.canvas.setFillStyle(CssColor.make((String)aColor.getHexValue()));
        this.canvas.setGlobalAlpha(aColor.getAlphaF());
        this.brush.push(aColor);
    }

    public void clear() {
        this.canvas.clearRect(0, 0, this.width, this.height);
    }

    public ICanvas getCanvas() {
        return this.canvas;
    }

    public void setPen(QPen fBondPen) {
        this.canvas.setLineJoin(fBondPen.getJoinStyle().getValue());
        this.canvas.setLineWidth(fBondPen.getWidth());
        this.canvas.setLineCap(fBondPen.getCapStyle().getValue());
        this.canvas.setStrokeStyle(fBondPen.getBrush().color().getValue());
        this.canvas.setFillStyle(fBondPen.getBrush().color().getValue());
        this.pen.push(fBondPen.getStyle());
    }

    public void drawPath(QPainterPath path) {
        if (path != null && !path.getElements().isEmpty()) {
            for (PathElement el : path.getElements()) {
                el.drawCanvas(this);
            }
        }
    }

    public void setPen(QtPenStyle nopen) {
        this.pen.push(nopen);
        this.canvas.setStrokeStyle(CssColor.make((String)Qt.black.getQColor().getValue()));
        if (QtPenStyle.NoPen == nopen) {
            this.canvas.setStrokeStyle(CssColor.make((String)Qt.white.getQColor().getValue()));
        }
    }

    public void setPen(QColor aColor) {
        this.canvas.setStrokeStyle(CssColor.make((String)aColor.getValue()));
        this.canvas.setFillStyle(CssColor.make((String)aColor.getValue()));
    }

    private void dashedLine(double x, double y, double x2, double y2, double[] dashArray) {
        int dashCount = dashArray.length;
        this.canvas.moveTo(x, y);
        double dx = x2 - x;
        double dy = y2 - y;
        QPoint<Double> p1 = new QPoint<Double>(x, y);
        QPoint<Double> p2 = new QPoint<Double>(x2, y2);
        QLineF line = new QLineF(p2, p1);
        double angle = line.angle();
        double distRemaining = Math.sqrt(dx * dx + dy * dy);
        if (dx == 0.0) {
            dx = 1.0;
        }
        double slope = Math.abs(dy / dx);
        int dashIndex = 0;
        boolean draw = true;
        while (distRemaining >= 0.1 && dashIndex < 10000) {
            double dashLength;
            if ((dashLength = dashArray[dashIndex++ % dashCount]) == 0.0) {
                dashLength = 0.001;
            }
            if (dashLength > distRemaining) {
                dashLength = distRemaining;
            }
            double xStep = Math.sqrt(dashLength * dashLength / (1.0 + slope * slope));
            if (angle <= 90.0) {
                x -= xStep;
                y += slope * xStep;
            } else if (angle < 180.0) {
                x += xStep;
                y += slope * xStep;
            } else if (angle < 270.0) {
                x += xStep;
                y -= slope * xStep;
            } else {
                x -= xStep;
                y -= slope * xStep;
            }
            if (draw) {
                this.canvas.lineTo(x, y);
            } else {
                this.canvas.moveTo(x, y);
            }
            distRemaining -= dashLength;
            draw = !draw;
        }
        this.canvas.moveTo(x2, y2);
    }

    public Stack<QtPenStyle> getPen() {
        return this.pen;
    }

    public Stack<QColor> getBrush() {
        return this.brush;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addKeyUpHandler(handler);
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addKeyDownHandler(handler);
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addKeyPressHandler(handler);
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addMouseDownHandler(handler);
    }

    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addMouseUpHandler(handler);
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addMouseOutHandler(handler);
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addMouseOverHandler(handler);
    }

    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addMouseMoveHandler(handler);
    }

    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        this.setFocus(true);
        return this.focusPanel.addMouseWheelHandler(handler);
    }

    public void setFocus(Boolean value) {
        this.focusPanel.setFocus(value.booleanValue());
        this.focus = (boolean)value;
    }

    public Boolean getFocus() {
        return this.focus;
    }

    public void drawPolygon(QPolygon polygon) {
        this.drawConvexPolygon(polygon);
    }

    public HandlerRegistration addDropHandler(DropHandler handler) {
        this.setFocus(true);
        if (FileUtilDND.supportFileAPI()) {
            return this.dropPanel.addDropHandler(handler);
        }
        return null;
    }

    public HandlerRegistration addDragEnterHandler(DragEnterHandler handler) {
        this.setFocus(true);
        if (FileUtilDND.supportFileAPI()) {
            return this.dropPanel.addDragEnterHandler(handler);
        }
        return null;
    }

    public HandlerRegistration addDragLeaveHandler(DragLeaveHandler handler) {
        this.setFocus(true);
        if (FileUtilDND.supportFileAPI()) {
            return this.dropPanel.addDragLeaveHandler(handler);
        }
        return null;
    }

    public HandlerRegistration addDragOverHandler(DragOverHandler handler) {
        this.setFocus(true);
        if (FileUtilDND.supportFileAPI()) {
            return this.dropPanel.addDragOverHandler(handler);
        }
        return null;
    }

    public void setBorderWidth(int width) {
        this.widthLine = width;
        this.containerSVG.setBorderWidth(this.widthLine);
    }

    public int getBorderWidth() {
        return this.widthLine;
    }
}

