/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.dom.client.PartialSupport;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.moleditor.ICanvas;
import java.util.Stack;
import org.vaadin.gwtgraphics.client.DrawingArea;
import org.vaadin.gwtgraphics.client.VectorObject;
import org.vaadin.gwtgraphics.client.shape.Path;
import org.vaadin.gwtgraphics.client.shape.Rectangle;
import org.vaadin.gwtgraphics.client.shape.Text;

@PartialSupport
public class CanvasSVG
implements ICanvas {
    private DrawingArea canvas = null;
    private Stack<Path> paths = new Stack();

    public CanvasSVG() {
        this.canvas = new DrawingArea(400, 400);
    }

    public boolean isSupported() {
        return this.canvas != null;
    }

    public void addFocusHandler(FocusHandler focusHandler) {
    }

    public void arc(double x, double y, double width, double height, double d, boolean b) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.arc(Math.round((float)width), Math.round((float)height), 0, true, b, Math.round((float)x), Math.round((float)y));
            this.paths.push(path);
        }
    }

    public void beginPath() {
        Path path = new Path(0, 0);
        this.paths.push(path);
    }

    public void closePath() {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.close();
            this.canvas.add((VectorObject)path);
        }
    }

    public void clearRect(int i, int j, int width, int height) {
        this.canvas.clear();
        this.paths = new Stack();
    }

    public void fill() {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.setFillColor("red");
            this.paths.push(path);
        }
    }

    public void fillRect(int i, int j, int width, int height) {
        Rectangle rectangle = new Rectangle(Math.round(i), Math.round(j), Math.round(width), Math.round(height));
        this.canvas.add((VectorObject)rectangle);
    }

    public void fillText(String textString, Double x, Double y) {
        Text text = new Text(Math.round(x.floatValue()), Math.round(y.floatValue()), textString);
        this.canvas.add((VectorObject)text);
    }

    public int getAbsoluteLeft() {
        return this.canvas.getAbsoluteLeft();
    }

    public int getAbsoluteTop() {
        return this.canvas.getAbsoluteTop();
    }

    public int getCoordinateSpaceHeight() {
        return this.canvas.getHeight();
    }

    public int getCoordinateSpaceWidth() {
        return this.canvas.getWidth();
    }

    public int getOffsetHeight() {
        return this.canvas.getOffsetHeight();
    }

    public int getOffsetWidth() {
        return this.canvas.getOffsetWidth();
    }

    public Widget getWidget() {
        return this.canvas;
    }

    public void lineTo(double doubleValue, double doubleValue2) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.lineTo(Math.round((float)doubleValue), Math.round((float)doubleValue2));
            this.paths.push(path);
        }
    }

    public int measureText(String string) {
        Text text = new Text(0, 0, string);
        return text.getTextWidth();
    }

    public void moveTo(double doubleValue, double doubleValue2) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.moveTo(Math.round((float)doubleValue), Math.round((float)doubleValue2));
            this.paths.push(path);
        }
    }

    public void quadraticCurveTo(Integer x, Integer y, Integer x2, Integer y2) {
    }

    public void rect(float x, float y, float width, float height) {
        Rectangle rectangle = new Rectangle(Math.round(x), Math.round(y), Math.round(width), Math.round(height));
        this.canvas.add((VectorObject)rectangle);
    }

    public void save() {
    }

    public void restore() {
    }

    public void scale(double d, int i) {
    }

    public void translate(double d, double i) {
    }

    public void setCoordinateSpaceHeight(int height) {
        this.canvas.setHeight(height);
    }

    public void setCoordinateSpaceWidth(int width) {
        this.canvas.setWidth(width);
    }

    public void setFillStyle(CssColor make) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.setFillColor(make.value());
            this.paths.push(path);
        }
    }

    public void setFillStyle(String value) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.setFillColor(value);
            this.paths.push(path);
        }
    }

    public void setFont(String string) {
    }

    public void setGlobalAlpha(double alphaF) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.setFillOpacity(alphaF);
            this.paths.push(path);
        }
    }

    public void setHeight(String height) {
        this.canvas.setHeight(height);
    }

    public void setLineCap(String value) {
    }

    public void setLineJoin(String value) {
    }

    public void setLineWidth(double width) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.setStrokeWidth(Math.round((float)width));
            this.paths.push(path);
        }
    }

    public double getLineWidth() {
        double r = 0.0;
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            r = path.getStrokeWidth();
            this.paths.push(path);
        }
        return r;
    }

    public void setStrokeStyle(CssColor make) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.setStrokeColor(make.value());
            this.paths.push(path);
        }
    }

    public void setStrokeStyle(String value) {
        if (!this.paths.isEmpty()) {
            Path path = this.paths.pop();
            path.setStrokeColor(value);
            this.paths.push(path);
        }
    }

    public void setTextAlign(Context2d.TextAlign center) {
    }

    public void setTextBaseline(Context2d.TextBaseline middle) {
    }

    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
    }

    public void setWidth(String width) {
        this.canvas.setWidth(width);
    }

    public void stroke() {
    }

    public String toDataUrl() {
        return null;
    }
}

