/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.js;

import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.jsonp.client.JsonpRequestBuilder;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.mestrelab.components.client.PanelMolEditor;
import com.mestrelab.components.client.js.JsClosure;
import com.mestrelab.components.client.js.JsTCanvasMoleculeSettings;
import com.mestrelab.components.client.js.SettingsFactory;
import com.mestrelab.components.client.moleditor.TCanvasMoleculeSettings;
import com.mestrelab.components.client.util.Utils_Molfile;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.util.StringHEX;
import com.mestrelab.components.shared.util.UrlServices;
import org.timepedia.exporter.client.Export;
import org.timepedia.exporter.client.ExportPackage;
import org.timepedia.exporter.client.Exportable;

@ExportPackage(value="mestrelab")
@Export
public class JsMoleculeEditor
extends PanelMolEditor
implements Exportable {
    public JsMoleculeEditor(String id, int width, int height, String editMolecule) {
        super(id, width, height, Boolean.parseBoolean(editMolecule));
    }

    public JsMoleculeEditor(String id, int width, int height, String editMolecule, String settingsJSON) {
        super(id, width, height, Boolean.parseBoolean(editMolecule));
        if (this.getCanvasMolecule() != null) {
            SettingsFactory factory = (SettingsFactory)GWT.create(SettingsFactory.class);
            AutoBean bean = AutoBeanCodex.decode((AutoBeanFactory)factory, JsTCanvasMoleculeSettings.class, (String)settingsJSON);
            JsTCanvasMoleculeSettings settings = (JsTCanvasMoleculeSettings)bean.as();
            TCanvasMoleculeSettings molSettings = this.getCanvasMolecule().getSettings() != null ? this.getCanvasMolecule().getSettings() : new TCanvasMoleculeSettings();
            molSettings.fRotateTextWithMol = settings.getfRotateTextWithMol() != null ? new Boolean(settings.getfRotateTextWithMol()) : molSettings.fRotateTextWithMol;
            molSettings.fAtomFontColor.setColor(settings.getfAtomFontColor() != null ? CssColor.make((String)settings.getfAtomFontColor()).toString() : molSettings.fAtomFontColor.getHexValue());
            molSettings.fBondPen.brush().setColor(settings.getfBondFontColor() != null ? CssColor.make((String)settings.getfBondFontColor()).toString() : molSettings.fBondPen.brush().getHexValue());
            molSettings.fNumberFontColor.setColor(settings.getfNumberFontColor() != null ? CssColor.make((String)settings.getfNumberFontColor()).toString() : molSettings.fNumberFontColor.getHexValue());
            molSettings.fMarginWidth = settings.getfMarginWidth() != null ? new Double(settings.getfMarginWidth()) : molSettings.fMarginWidth;
            molSettings.fBondSpacing = settings.getfBondSpacing() != null ? new Double(settings.getfBondSpacing()) : molSettings.fBondSpacing;
            molSettings.fBoldWidth = settings.getfBoldWidth() != null ? new Double(settings.getfBoldWidth()) : molSettings.fBoldWidth;
            molSettings.fHashSpacing = settings.getfHashSpacing() != null ? new Double(settings.getfHashSpacing()) : molSettings.fHashSpacing;
            molSettings.fAverageBondSize = settings.getfAverageBondSize() != null ? new Double(settings.getfAverageBondSize()) : molSettings.fAverageBondSize;
            molSettings.fShowOthers = settings.getfShowOthers() != null ? new Boolean(settings.getfShowOthers()) : molSettings.fShowOthers;
            molSettings.fShowAllC = settings.getfShowAllC() != null ? new Boolean(settings.getfShowAllC()) : molSettings.fShowAllC;
            molSettings.fShowTermC = settings.getfShowTermC() != null ? new Boolean(settings.getfShowTermC()) : molSettings.fShowTermC;
            boolean bl = molSettings.fShowNumbers = settings.getfShowNumbers() != null ? new Boolean(settings.getfShowNumbers()) : molSettings.fShowNumbers;
            if (settings.getfLabelMacro() != null) {
                molSettings.fLabelMacro.clear();
                molSettings.fLabelMacro.append(settings.getfLabelMacro());
            }
            molSettings.marginDrawHeight = settings.getmarginDrawHeight() != null ? new Double(settings.getmarginDrawHeight()) : molSettings.marginDrawHeight;
            molSettings.marginDrawWidth = settings.getmarginDrawWidth() != null ? new Double(settings.getmarginDrawWidth()) : molSettings.marginDrawWidth;
            molSettings.scaleDraw = settings.getscaleDraw() != null ? new Boolean(settings.getscaleDraw()) : molSettings.scaleDraw;
            molSettings.sameScale = settings.getsameScale() != null ? new Boolean(settings.getsameScale()) : molSettings.sameScale;
            this.getCanvasMolecule().setSettings(molSettings);
        }
    }

    public String getMoleculeFormula() {
        if (this.getCanvasMolecule() != null) {
            return this.getCanvasMolecule().getMolecule().molecularFormula().toString();
        }
        return "";
    }

    public String getAverageMass() {
        if (this.getCanvasMolecule() != null) {
            return NumberFormat.getFormat((String)"#####0.00").format(this.getCanvasMolecule().getMolecule().averageMass()).toString();
        }
        return "0";
    }

    public String getMonoisotopicMass() {
        if (this.getCanvasMolecule() != null) {
            return NumberFormat.getFormat((String)"#####0.00").format(this.getCanvasMolecule().getMolecule().monoisotopicMass()).toString();
        }
        return "0";
    }

    public boolean isStructureModified() {
        return super.isStructureModified();
    }

    public void resetMemory() {
        super.resetMemory();
    }

    public int getNumberAtoms() {
        return super.getNumberAtoms();
    }

    public void importMolfile(final String molfile) {
        if (this.getCanvasMolecule().getSettings().fShowWM) {
            JsonpRequestBuilder jsonp = new JsonpRequestBuilder();
            if (molfile != null || !molfile.equals("")) {
                String url = new String(StringHEX.unhexlate(UrlServices.getRenderService())) + StringHEX.hexlate(molfile.getBytes());
                jsonp.requestObject(url, (AsyncCallback)new AsyncCallback<JavaScriptObject>(){

                    public void onFailure(Throwable arg0) {
                        Window.alert((String)new String(StringHEX.unhexlate(UrlServices.getError())));
                    }

                    public void onSuccess(JavaScriptObject results) {
                        QByteArray<QString> aMolContent = new QByteArray<QString>();
                        aMolContent.append(new QString(molfile));
                        JsMoleculeEditor.this.setMolfile(Utils_Molfile.read(aMolContent, false));
                    }
                });
            }
        } else {
            QByteArray<QString> aMolContent = new QByteArray<QString>();
            aMolContent.append(new QString(molfile));
            this.setMolfile(Utils_Molfile.read(aMolContent, false));
        }
    }

    public String exportJson() {
        return super.toJson();
    }

    public void importJson(String jsonCanvasMolecule) {
        super.fromJson(jsonCanvasMolecule);
    }

    public void exportMolfile(final JsClosure result) {
        final String molfile = Utils_Molfile.writeUnique(this.gettMoleculePlugin().activeMolecule().getMolecule()).toString();
        if (this.getCanvasMolecule().getSettings().fShowWM) {
            JsonpRequestBuilder jsonp = new JsonpRequestBuilder();
            if (molfile != null || !molfile.equals("")) {
                String url = new String(StringHEX.unhexlate(UrlServices.getRenderService())) + StringHEX.hexlate(molfile.getBytes());
                jsonp.requestObject(url, (AsyncCallback)new AsyncCallback<JavaScriptObject>(){

                    public void onFailure(Throwable arg0) {
                        Window.alert((String)new String(StringHEX.unhexlate(UrlServices.getError())));
                    }

                    public void onSuccess(JavaScriptObject results) {
                        result.execute(molfile);
                    }
                });
            }
        } else {
            result.execute(molfile);
        }
    }

    public String exportImage(int width, int height) {
        if (this.getCanvasMolecule() != null) {
            TCanvasMoleculeSettings defaultSettings = new TCanvasMoleculeSettings();
            this.getCanvasMolecule().getSettings().marginDrawHeight = defaultSettings.marginDrawHeight;
            this.getCanvasMolecule().getSettings().marginDrawWidth = defaultSettings.marginDrawWidth;
            return this.getImage(width, height);
        }
        return null;
    }

    public String exportImageMargin(int width, int height, double porcentageMargin) {
        if (this.getCanvasMolecule() != null) {
            this.getCanvasMolecule().getSettings().marginDrawHeight = porcentageMargin;
            this.getCanvasMolecule().getSettings().marginDrawWidth = porcentageMargin;
            return this.getImage(width, height);
        }
        return null;
    }

    public void addTypeUpload(String type) {
        super.addTypeUpload(type);
    }

    public void removeTypeUpload() {
        super.resetTypeUpload();
    }

    public void activeStoreSetting() {
        if (this.getCanvasMolecule() != null) {
            this.getCanvasMolecule().getSettings().fStoreSettings = true;
        }
    }

    public void setDefaultSetting(JsClosure result) {
        if (this.getCanvasMolecule() != null) {
            result.execute(this.getCanvasMolecule().getSettings().toJson());
        }
    }

    public void setRestoreSetting(String settingsJson) {
        if (this.getCanvasMolecule() != null) {
            super.setRestoreSettings(settingsJson);
        }
    }
}

