/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.PanelMolEditor;
import com.mestrelab.components.shared.event.ModalLeftEvent;
import java.util.ArrayList;
import java.util.List;

public class UploadFileDialog
extends PopupPanel {
    final HorizontalPanel containerFileUpload;
    final VerticalPanel cont_fileupload;
    final Button button;
    final PanelMolEditor panelMolEditor;
    private HandlerRegistration handlerRegistration;
    public FileUpload upload;
    public List<String> formats;

    public UploadFileDialog(PanelMolEditor panelMolEditor) {
        this.panelMolEditor = panelMolEditor;
        this.formats = new ArrayList<String>();
        this.containerFileUpload = new HorizontalPanel();
        this.containerFileUpload.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.containerFileUpload.setWidth("100px");
        this.cont_fileupload = new VerticalPanel();
        this.cont_fileupload.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        this.containerFileUpload.setWidth("100%");
        this.cont_fileupload.setSpacing(10);
        this.containerFileUpload.add((Widget)this.cont_fileupload);
        final FormPanel form = new FormPanel();
        form.setAction(GWT.getModuleBaseURL() + "fileupload");
        form.setEncoding("multipart/form-data");
        form.setMethod("post");
        this.upload = new FileUpload();
        this.upload.setName("uploadFormElement");
        form.add((Widget)this.upload);
        this.button = new Button("Submit");
        form.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                if (event.getResults() != null && event.getResults().length() > 3) {
                    UploadFileDialog.this.getPanelMolEditor().setMolfile(event.getResults());
                } else {
                    Window.alert((String)"Molfile is not valid");
                }
                UploadFileDialog.this.hide();
                UploadFileDialog.this.getPanelMolEditor().getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)UploadFileDialog.this.button));
            }
        });
        final Button buttonClose = new Button("Close");
        form.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                if (UploadFileDialog.this.upload.getFilename().length() == 0 || !UploadFileDialog.this.formatValid(UploadFileDialog.this.upload.getFilename())) {
                    Window.alert((String)"File is empty or format invalid.");
                    event.cancel();
                    UploadFileDialog.this.getPanelMolEditor().getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)UploadFileDialog.this.button));
                }
            }
        });
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_RIGHT);
        buttonClose.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                UploadFileDialog.this.getPanel().hide();
                UploadFileDialog.this.getPanelMolEditor().getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)buttonClose));
            }
        });
        buttonPanel.add((Widget)this.button);
        buttonPanel.add((Widget)buttonClose);
        this.cont_fileupload.add((Widget)form);
        this.cont_fileupload.add((Widget)buttonPanel);
        this.cont_fileupload.setCellHorizontalAlignment((Widget)buttonPanel, HasHorizontalAlignment.ALIGN_RIGHT);
        if (this.handlerRegistration != null) {
            this.handlerRegistration.removeHandler();
        }
        this.handlerRegistration = this.button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                if (UploadFileDialog.this.upload.getFilename() != null) {
                    form.submit();
                }
            }
        });
        this.add((Widget)this.containerFileUpload);
        this.setPopupPosition(this.panelMolEditor.getAbsoluteLeft() + 20, this.panelMolEditor.getContainerEditor().getAbsoluteTop() + 50);
        this.removeTypeFile();
    }

    public HorizontalPanel getContainerMolfile() {
        return this.containerFileUpload;
    }

    public VerticalPanel getCont_molfile() {
        return this.cont_fileupload;
    }

    public PanelMolEditor getPanelMolEditor() {
        return this.panelMolEditor;
    }

    public UploadFileDialog getPanel() {
        return this;
    }

    public void removeTypeFile() {
        this.upload.getElement().removeAttribute("accept");
        this.formats.clear();
        this.formats.add("mol");
        this.upload.getElement().setAttribute("accept", ".mol");
    }

    public void addTypeFile(String type) {
        this.upload.getElement().setAttribute("accept", this.upload.getElement().getAttribute("accept") + ",." + type);
        this.formats.add(type);
    }

    public boolean formatValid(String fileName) {
        for (String f : this.formats) {
            if (!fileName.contains("." + f)) continue;
            return true;
        }
        return false;
    }
}

