/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.jsonp.client.JsonpRequestBuilder;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.mestrelab.components.client.AboutConstants;
import com.mestrelab.components.client.AboutDialog;
import com.mestrelab.components.client.MolfilePanel;
import com.mestrelab.components.client.UploadFileDialog;
import com.mestrelab.components.client.moleditor.QPainter;
import com.mestrelab.components.client.moleditor.QtCanvas;
import com.mestrelab.components.client.moleditor.QtCanvasView;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TCanvasMoleculeSettings;
import com.mestrelab.components.client.moleditor.TFrameworkGui;
import com.mestrelab.components.client.moleditor.TMoleculePluginGui;
import com.mestrelab.components.client.moleditor.WOpsinDialog;
import com.mestrelab.components.client.moleditor.command.TCmdMoleculeProperties;
import com.mestrelab.components.client.util.FileUtilDND;
import com.mestrelab.components.client.util.Utils_Molfile;
import com.mestrelab.components.client.widget.ToggleButtonPanel;
import com.mestrelab.components.shared.ICanvasMoleculeTO;
import com.mestrelab.components.shared.IMoleculeTO;
import com.mestrelab.components.shared.IMoleculeTOFactory;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.event.ModalEnteredEvent;
import com.mestrelab.components.shared.handler.MolEditorHandler;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.util.StringHEX;
import com.mestrelab.components.shared.util.UrlServices;
import java.util.ArrayList;
import java.util.List;

public class PanelMolEditor
extends Composite {
    private QPainter qpainter = null;
    final HorizontalPanel containerEditor;
    final VerticalPanel cont_draw;
    private HandlerManager eventBus = null;
    private boolean editorMode = false;
    private TMoleculePluginGui tMoleculePlugin = null;
    private MolEditorHandler handler = null;
    private ArrayList<HandlerRegistration> handlerRegistration = new ArrayList();
    private QtCanvas canvas = null;
    private PopupPanel loadingPanel = null;
    final MenuBar menuBar;
    final DisclosurePanel buttonBar;
    final List<MenuItem> items = new ArrayList<MenuItem>();
    final UploadFileDialog panel;

    public HandlerManager getEventBus() {
        return this.eventBus;
    }

    public PanelMolEditor(String id, int width, int height, boolean editMolecule) {
        AboutConstants configurationParameters = (AboutConstants)GWT.create(AboutConstants.class);
        RootPanel root = RootPanel.get((String)id);
        this.editorMode = editMolecule;
        this.containerEditor = new HorizontalPanel();
        this.containerEditor.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.containerEditor.setBorderWidth(1);
        this.containerEditor.setSpacing(10);
        this.cont_draw = new VerticalPanel();
        this.cont_draw.setVerticalAlignment(VerticalPanel.ALIGN_TOP);
        this.containerEditor.add((Widget)this.cont_draw);
        if (editMolecule) {
            this.menuBar = this.createMenu();
            this.buttonBar = new DisclosurePanel("");
        } else {
            this.menuBar = null;
            this.buttonBar = null;
        }
        this.initWidget((Widget)this.containerEditor);
        this.panel = new UploadFileDialog(this.getPanel());
        this.initialization(width, height, (Panel)root);
        if (this.getCanvasMolecule().getSettings().fShowWM || !configurationParameters.domainRestriction().isEmpty()) {
            this.menuItem("Import File", false);
            this.menuItem("Save File", false);
            this.menuItem("Import Text", true);
            this.menuItem("Export Text", true);
        }
        if (!configurationParameters.domainRestriction().isEmpty() && !Window.Location.getHostName().equals(configurationParameters.domainRestriction())) {
            this.containerEditor.clear();
            this.containerEditor.add((Widget)new Label(new String(StringHEX.unhexlate(UrlServices.getError()))));
        }
    }

    public PanelMolEditor(boolean editMolecule) {
        this.editorMode = editMolecule;
        this.containerEditor = new HorizontalPanel();
        this.containerEditor.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.containerEditor.setBorderWidth(1);
        this.containerEditor.setSpacing(10);
        this.cont_draw = new VerticalPanel();
        this.cont_draw.setVerticalAlignment(VerticalPanel.ALIGN_TOP);
        this.containerEditor.add((Widget)this.cont_draw);
        if (editMolecule) {
            this.menuBar = this.createMenu();
            this.buttonBar = new DisclosurePanel("");
        } else {
            this.menuBar = null;
            this.buttonBar = null;
        }
        this.initWidget((Widget)this.containerEditor);
        this.panel = new UploadFileDialog(this.getPanel());
        AboutConstants configurationParameters = (AboutConstants)GWT.create(AboutConstants.class);
        if (!configurationParameters.domainRestriction().isEmpty() && !Window.Location.getHostName().equals(configurationParameters.domainRestriction())) {
            this.containerEditor.clear();
            this.containerEditor.add((Widget)new Label(new String(StringHEX.unhexlate(UrlServices.getError()))));
        }
        if (!configurationParameters.domainRestriction().isEmpty()) {
            this.menuItem("Import File", false);
            this.menuItem("Save File", false);
            this.menuItem("Import Text", true);
            this.menuItem("Export Text", true);
        }
    }

    public void initialization(int width, int height, Panel root) {
        this.qpainter = new QPainter(width, height);
        this.canvas = new QtCanvas(this.qpainter);
        if (this.editorMode) {
            this.buttonBar.setAnimationEnabled(true);
            this.buttonBar.setOpen(true);
            this.buttonBar.setContent(this.createButtonsActions());
            this.buttonBar.getContent().setStyleName("");
            this.cont_draw.add((Widget)this.menuBar);
            this.cont_draw.add((Widget)this.buttonBar);
        }
        this.loadingPanel = new PopupPanel(false);
        this.loadingPanel.setWidget((Widget)new Label("Loading....."));
        AbsolutePanel abs = new AbsolutePanel();
        abs.add((Widget)this.canvas.getPainter());
        abs.add((Widget)this.loadingPanel, width / 2 - this.loadingPanel.getOffsetWidth() / 2, height / 2 - this.loadingPanel.getOffsetHeight() / 2);
        this.loadingPanel.setVisible(false);
        this.cont_draw.add((Widget)abs);
        this.activateHandler();
        if (root != null) {
            root.add((Widget)this);
        } else {
            RootPanel.get().add((Widget)this);
        }
    }

    public PanelMolEditor(String id, int width, int height, boolean editMolecule, boolean showMenubar) {
        this(id, width, height, editMolecule);
        if (!showMenubar && editMolecule) {
            this.cont_draw.remove(0);
        }
    }

    private MenuBar createMenu() {
        MenuBar menu = new MenuBar();
        MenuBar fileMenu = new MenuBar(true);
        this.items.clear();
        this.items.add(fileMenu.addItem("Import Text", (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                MolfilePanel panel = new MolfilePanel(PanelMolEditor.this.getPanel(), false);
                PanelMolEditor.this.eventBus.fireEvent((GwtEvent)new ModalEnteredEvent((Widget)panel));
                panel.show();
            }
        }));
        this.items.add(fileMenu.addItem("Export Text", (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                try {
                    TMolecule molecule = PanelMolEditor.this.gettMoleculePlugin().activeMolecule().getMolecule();
                    final MolfilePanel panel = new MolfilePanel(PanelMolEditor.this.getPanel(), true);
                    PanelMolEditor.this.eventBus.fireEvent((GwtEvent)new ModalEnteredEvent((Widget)panel));
                    final QByteArray aMolContent = Utils_Molfile.writeUnique(molecule);
                    if (PanelMolEditor.this.getCanvasMolecule().getSettings().fShowWM) {
                        JsonpRequestBuilder jsonp = new JsonpRequestBuilder();
                        if (aMolContent.toString() != null || !aMolContent.toString().equals("")) {
                            String url = new String(StringHEX.unhexlate(UrlServices.getRenderService())) + StringHEX.hexlate(aMolContent.toString().getBytes());
                            jsonp.requestObject(url, (AsyncCallback)new AsyncCallback<JavaScriptObject>(){

                                public void onFailure(Throwable arg0) {
                                    Window.alert((String)new String(StringHEX.unhexlate(UrlServices.getError())));
                                }

                                public void onSuccess(JavaScriptObject results) {
                                    panel.getMolfileText().setValue((Object)(!aMolContent.isEmpty() ? aMolContent.toString() : "Error"));
                                    panel.show();
                                }
                            });
                        }
                    } else {
                        panel.getMolfileText().setValue((Object)(!aMolContent.isEmpty() ? aMolContent.toString() : "Error"));
                        panel.show();
                    }
                }
                catch (Exception e) {
                    Window.alert((String)"Molecule is not valid");
                }
            }
        }));
        this.items.add(fileMenu.addItem("Import File", (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                ((InputElement)PanelMolEditor.this.panel.upload.getElement().cast()).click();
                PanelMolEditor.this.eventBus.fireEvent((GwtEvent)new ModalEnteredEvent((Widget)PanelMolEditor.this.panel));
                PanelMolEditor.this.panel.show();
            }
        }));
        this.items.add(fileMenu.addItem("Save File", (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                TMolecule molecule = PanelMolEditor.this.gettMoleculePlugin().activeMolecule().getMolecule();
                IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
                IMoleculeTO molTO = molecule.moleculeTOJson(factory, molecule);
                AutoBean autoBean = factory.create(IMoleculeTO.class, molTO);
                String json = AutoBeanCodex.encode((AutoBean)autoBean).getPayload();
                RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, GWT.getModuleBaseURL() + "filesave");
                builder.setHeader("Content-type", "application/x-www-form-urlencoded");
                try {
                    builder.sendRequest("moleculeJSON=" + json, new RequestCallback(){

                        public void onResponseReceived(Request request, Response response) {
                            Frame fileDownloadFrame = new Frame(GWT.getModuleBaseURL() + "filesave?id=" + response.getText());
                            fileDownloadFrame.setSize("0px", "0px");
                            fileDownloadFrame.setVisible(false);
                            fileDownloadFrame.getElement().setId("downloadFile");
                            RootPanel panel = RootPanel.get((String)"downloadFile");
                            if (panel != null) {
                                panel.remove((Widget)fileDownloadFrame);
                            } else {
                                panel = RootPanel.get();
                            }
                            panel.add((Widget)fileDownloadFrame);
                        }

                        public void onError(Request request, Throwable exception) {
                            Window.alert((String)exception.getLocalizedMessage());
                        }
                    });
                }
                catch (RequestException e) {
                    Window.alert((String)e.getLocalizedMessage());
                }
            }
        }));
        menu.addItem("File", fileMenu);
        this.menuItem("Import Text", false);
        this.menuItem("Export Text", false);
        MenuBar fileMenuDialog = new MenuBar(true);
        fileMenuDialog.addItem("IUPAC name conversion", (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                WOpsinDialog dialogIupac = new WOpsinDialog(PanelMolEditor.this.getPanel());
                PanelMolEditor.this.eventBus.fireEvent((GwtEvent)new ModalEnteredEvent((Widget)dialogIupac.getDialog()));
                dialogIupac.exec();
            }
        });
        menu.addItem("Tools", fileMenuDialog);
        MenuBar helpMenu = new MenuBar(true);
        helpMenu.addItem("About", (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AboutDialog aboutBox = new AboutDialog(PanelMolEditor.this.getPanel());
                aboutBox.show();
            }
        });
        menu.addItem("Help", helpMenu);
        return menu;
    }

    public boolean menuItem(String title, Boolean visible) {
        for (MenuItem i : this.items) {
            if (!i.getText().trim().equals(title)) continue;
            i.setVisible(visible.booleanValue());
            return true;
        }
        return false;
    }

    private Widget createButtonsActions() {
        final ToggleButtonPanel panel = new ToggleButtonPanel(this, this.qpainter.getWidth());
        PushButton bNew = new PushButton();
        bNew.setTitle("new");
        bNew.getElement().setAttribute("name", "new");
        ToggleButton bMove = new ToggleButton();
        bMove.setTitle("move");
        bMove.getElement().setAttribute("name", "moleculeMove");
        ToggleButton bDraw = new ToggleButton();
        bDraw.setTitle("draw");
        bDraw.getElement().setAttribute("name", "moleculeDraw");
        ToggleButton bDrawChain = new ToggleButton();
        bDrawChain.setTitle("draw chain");
        bDrawChain.getElement().setAttribute("name", "moleculeDrawChain");
        ToggleButton bUp = new ToggleButton();
        bUp.setTitle("bondUp");
        bUp.getElement().setAttribute("name", "moleculeUp");
        ToggleButton bDown = new ToggleButton();
        bDown.setTitle("bondDown");
        bDown.getElement().setAttribute("name", "moleculeDown");
        ToggleButton bDelete = new ToggleButton();
        bDelete.setTitle("delete");
        bDelete.getElement().setAttribute("name", "moleculeDelete");
        final ToggleButton bTemplateCyclo = new ToggleButton();
        bTemplateCyclo.setTitle("benzene");
        bTemplateCyclo.getElement().setAttribute("name", "moleculeTemplateBenzene");
        final ToggleButton bTemplateAux = new ToggleButton();
        bTemplateAux.setTitle("charge Minus");
        bTemplateAux.getElement().setAttribute("name", "moleculeAtomChargeMinus");
        PushButton bProperties = new PushButton();
        bProperties.setTitle("molecule Properties");
        bProperties.getElement().setAttribute("name", "moleculeProperties");
        final ListBox listCiclo = new ListBox();
        listCiclo.addItem("benzene", "moleculeTemplateBenzene");
        listCiclo.addItem("cyclopropane", "moleculeTemplateRing3");
        listCiclo.addItem("cyclobutane", "moleculeTemplateRing4");
        listCiclo.addItem("cyclopentane", "moleculeTemplateRing5");
        listCiclo.addItem("cyclohexane", "moleculeTemplateRing6");
        listCiclo.addItem("cycloheptane", "moleculeTemplateRing7");
        listCiclo.addItem("cyclooctane", "moleculeTemplateRing8");
        listCiclo.setWidth("15px");
        listCiclo.setItemSelected(0, true);
        listCiclo.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                bTemplateCyclo.setTitle(listCiclo.getItemText(listCiclo.getSelectedIndex()));
                panel.updateTemplateCyclo(listCiclo.getValue(listCiclo.getSelectedIndex()));
            }
        });
        final ListBox listAux = new ListBox();
        listAux.addItem("charge Minus", "moleculeAtomChargeMinus");
        listAux.addItem("charge Plus", "moleculeAtomChargePlus");
        listAux.setWidth("15px");
        listAux.setItemSelected(0, true);
        listAux.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                bTemplateAux.setTitle(listAux.getItemText(listAux.getSelectedIndex()));
                panel.updateTemplateAux(listAux.getValue(listAux.getSelectedIndex()));
            }
        });
        panel.add((Widget)bNew);
        panel.add((Widget)bMove);
        panel.add((Widget)bDraw);
        panel.add((Widget)bDrawChain);
        panel.add((Widget)bUp);
        panel.add((Widget)bDown);
        panel.add((Widget)bDelete);
        PushButton bUndo = new PushButton();
        bUndo.setTitle("undo");
        bUndo.getElement().setAttribute("name", "undo");
        PushButton bredo = new PushButton();
        bredo.setTitle("redo");
        bredo.getElement().setAttribute("name", "redo");
        PushButton bzoomIn = new PushButton();
        bzoomIn.setTitle("zoomIn");
        bzoomIn.getElement().setAttribute("name", "zoomIn");
        PushButton bzoomOut = new PushButton();
        bzoomOut.setTitle("zoomOut");
        bzoomOut.getElement().setAttribute("name", "zoomOut");
        PushButton bzoomFull = new PushButton();
        bzoomFull.setTitle("zoomFull");
        bzoomFull.getElement().setAttribute("name", "zoomFull");
        panel.add((Widget)bUndo);
        panel.add((Widget)bredo);
        panel.add((Widget)bzoomIn);
        panel.add((Widget)bzoomOut);
        panel.add((Widget)bzoomFull);
        HorizontalPanel internal = new HorizontalPanel();
        internal.add((Widget)bTemplateCyclo);
        internal.add((Widget)listCiclo);
        internal.add((Widget)bTemplateAux);
        internal.add((Widget)listAux);
        panel.add((Widget)internal);
        panel.add((Widget)bProperties);
        return panel;
    }

    private void activateHandler() {
        this.eventBus = new HandlerManager((Object)this);
        this.tMoleculePlugin = new TMoleculePluginGui(this.eventBus);
        this.getCanvas().allItems().clear();
        this.getCanvas().allItems().append(new TCanvasMolecule(new TMolecule(), this.getCanvas()));
        this.tMoleculePlugin.registered(new TFrameworkGui(new QtCanvasView(this.getCanvas())));
        this.handler = new MolEditorHandler(this);
        this.updateRegistrationHandler();
    }

    public void setMolfile(TMolecule molecule) {
        if (molecule != null) {
            molecule.detectAromaticAtoms();
            if (this.getCanvasMolecule().getSettings().sameScale && !this.editorMode) {
                this.tMoleculePlugin.updateTMoleculeSameScale(molecule, this.canvas);
                QRectF moleculeRect = this.tMoleculePlugin.activeMolecule().boundingRect();
                this.qpainter = new QPainter(Math.round((float)Math.floor(moleculeRect.width())), Math.round((float)Math.floor(moleculeRect.height())));
                this.qpainter.setBorderWidth(this.canvas.getPainter().getBorderWidth());
                this.canvas.setPainter(this.qpainter);
                this.updateQtCanvas(Math.round((float)Math.floor(moleculeRect.width())), Math.round((float)Math.floor(moleculeRect.height())));
                this.tMoleculePlugin.updateTMoleculeSameScale(molecule, this.getCanvasMolecule().canvas());
            } else {
                this.tMoleculePlugin.updateTMolecule(molecule, this.getCanvasMolecule().canvas());
            }
        }
    }

    public void setMolfile(String moleculeJson) {
        if (!moleculeJson.equals("")) {
            IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
            IMoleculeTO moleculeTO = (IMoleculeTO)AutoBeanCodex.decode((AutoBeanFactory)factory, IMoleculeTO.class, (String)moleculeJson).as();
            TMolecule molecule = new TMolecule();
            molecule = molecule.jsonTOMolecule(factory, moleculeTO);
            this.setMolfile(molecule);
        }
    }

    public void setMolfile(TMolecule molecule, TCanvasMoleculeSettings settings) {
        this.getCanvasMolecule().setSettings(settings);
        if (molecule != null) {
            molecule.detectAromaticAtoms();
            if (this.getCanvasMolecule().getSettings().sameScale && !this.editorMode) {
                this.tMoleculePlugin.updateTMoleculeSameScale(molecule, this.canvas);
                QRectF moleculeRect = this.tMoleculePlugin.activeMolecule().boundingRect();
                this.qpainter = new QPainter(Math.round((float)Math.floor(moleculeRect.width())), Math.round((float)Math.floor(moleculeRect.height())));
                this.qpainter.setBorderWidth(this.canvas.getPainter().getBorderWidth());
                this.canvas.setPainter(this.qpainter);
                this.updateQtCanvas(Math.round((float)Math.floor(moleculeRect.width())), Math.round((float)Math.floor(moleculeRect.height())));
                this.tMoleculePlugin.updateTMoleculeSameScale(molecule, this.getCanvasMolecule().canvas());
            } else {
                this.tMoleculePlugin.updateTMolecule(molecule, this.getCanvasMolecule().canvas());
            }
        }
    }

    public void setMolfile(String moleculeJson, String settingsJson) {
        if (!moleculeJson.equals("") && !settingsJson.equals("")) {
            IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
            IMoleculeTO moleculeTO = (IMoleculeTO)AutoBeanCodex.decode((AutoBeanFactory)factory, IMoleculeTO.class, (String)moleculeJson).as();
            TMolecule molecule = new TMolecule();
            molecule = molecule.jsonTOMolecule(factory, moleculeTO);
            TCanvasMoleculeSettings settings = new TCanvasMoleculeSettings();
            settings = settings.fromJson(settingsJson);
            this.setMolfile(molecule, settings);
        }
    }

    public String getImage(int width, int height) {
        QPainter painter = new QPainter(width, height);
        QtCanvas canvas = new QtCanvas(painter);
        TCanvasMolecule canvasMolecule = new TCanvasMolecule(this.getCanvasMolecule().getMolecule(), canvas, this.getCanvasMolecule().getSettings());
        canvas.addChild(canvasMolecule);
        canvasMolecule.canvas().update();
        canvasMolecule.canvas().setCenter(canvasMolecule.getSettings());
        canvasMolecule.update();
        String image = canvasMolecule.canvas().getPainter().getCanvas().toDataUrl();
        return image;
    }

    public boolean isStructureModified() {
        return this.gettMoleculePlugin().isStructureModified();
    }

    public void resetMemory() {
        this.gettMoleculePlugin().resetMemory();
    }

    public int getNumberAtoms() {
        return this.getCanvasMolecule().getMolecule().getAtoms().size();
    }

    private QPainter getPainter() {
        return this.canvas.getPainter();
    }

    private QtCanvas getCanvas() {
        return this.canvas;
    }

    public HorizontalPanel getContainerEditor() {
        return this.containerEditor;
    }

    public VerticalPanel getCont_draw() {
        return this.cont_draw;
    }

    public TCanvasMolecule getCanvasMolecule() {
        return this.tMoleculePlugin.activeMolecule();
    }

    public TMoleculePluginGui gettMoleculePlugin() {
        return this.tMoleculePlugin;
    }

    public PanelMolEditor getPanel() {
        return this;
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public Widget getButtonBar() {
        return this.buttonBar;
    }

    public PopupPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    public void setBorderWidthCanvas(int width) {
        this.qpainter.setBorderWidth(width);
    }

    public void updateQtCanvas(int width, int height) {
        if (!this.editorMode) {
            this.cont_draw.clear();
            AbsolutePanel abs = new AbsolutePanel();
            abs.add((Widget)this.canvas.getPainter());
            abs.add((Widget)this.loadingPanel, width / 2 - this.loadingPanel.getOffsetWidth() / 2, height / 2 - this.loadingPanel.getOffsetHeight() / 2);
            this.loadingPanel.setVisible(false);
            this.cont_draw.add((Widget)abs);
        }
    }

    public void updateRegistrationHandler() {
        if (!this.handlerRegistration.isEmpty()) {
            for (HandlerRegistration r : this.handlerRegistration) {
                r.removeHandler();
            }
        }
        if (this.editorMode) {
            this.handlerRegistration.add(this.getCont_draw().addHandler((EventHandler)this.handler, (GwtEvent.Type)MouseUpEvent.getType()));
            this.handlerRegistration.add(this.getPainter().addMouseUpHandler(this.handler));
            this.handlerRegistration.add(this.getPainter().addMouseDownHandler(this.handler));
            this.handlerRegistration.add(this.getPainter().addMouseMoveHandler(this.handler));
            this.handlerRegistration.add(this.getPainter().addMouseOverHandler(this.handler));
            this.handlerRegistration.add(this.getPainter().addMouseOutHandler(this.handler));
            this.handlerRegistration.add(this.getPainter().addMouseWheelHandler(this.handler));
            this.handlerRegistration.add(this.getPainter().addKeyUpHandler(this.handler));
            this.handlerRegistration.add(this.getPainter().addKeyDownHandler(this.handler));
            if (FileUtilDND.supportFileAPI()) {
                this.handlerRegistration.add(this.getPainter().addDragEnterHandler(this.handler));
                this.handlerRegistration.add(this.getPainter().addDragLeaveHandler(this.handler));
                this.handlerRegistration.add(this.getPainter().addDragOverHandler(this.handler));
                this.handlerRegistration.add(this.getPainter().addDropHandler(this.handler));
            }
            this.handlerRegistration.add(this.getPainter().addHandler((EventHandler)this.handler, (GwtEvent.Type)ContextMenuEvent.getType()));
            this.handlerRegistration.add(this.getPainter().addHandler((EventHandler)this.handler, (GwtEvent.Type)DoubleClickEvent.getType()));
        }
    }

    public void fromJson(String jsonCanvasMolecule) {
        IMoleculeTOFactory factory = (IMoleculeTOFactory)GWT.create(IMoleculeTOFactory.class);
        ICanvasMoleculeTO canvasMolTO = (ICanvasMoleculeTO)AutoBeanCodex.decode((AutoBeanFactory)factory, ICanvasMoleculeTO.class, (String)jsonCanvasMolecule).as();
        TCanvasMolecule canvasMol = this.getCanvasMolecule().jsonTOCanvasMolecule(factory, canvasMolTO);
        this.getCanvasMolecule().setSettings(canvasMol.getSettings());
        TCmdMoleculeProperties cmd = new TCmdMoleculeProperties(this.getCanvasMolecule(), this.getCanvasMolecule().getSettings());
        this.gettMoleculePlugin().getfFramework().doCommand(cmd);
        this.setMolfile(canvasMol.getMolecule());
    }

    public String toJson() {
        return this.getCanvasMolecule().toJson();
    }

    public void resetTypeUpload() {
        this.panel.removeTypeFile();
    }

    public void addTypeUpload(String type) {
        this.panel.addTypeFile(type);
    }

    public void setRestoreSettings(String settingsJson) {
        this.getCanvasMolecule().getSettings().fromJson(settingsJson);
        TCmdMoleculeProperties cmd = new TCmdMoleculeProperties(this.getCanvasMolecule(), this.getCanvasMolecule().getSettings());
        this.gettMoleculePlugin().getfFramework().doCommand(cmd);
        this.setMolfile(this.getCanvasMolecule().getMolecule());
    }
}

