/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.jsonp.client.JsonpRequestBuilder;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.PanelMolEditor;
import com.mestrelab.components.client.util.Utils_Molfile;
import com.mestrelab.components.shared.event.ModalLeftEvent;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.util.StringHEX;
import com.mestrelab.components.shared.util.UrlServices;
import java.util.ArrayList;
import java.util.List;

public class MolfilePanel
extends PopupPanel {
    final HorizontalPanel containerMolfile;
    final VerticalPanel cont_molfile;
    final TextArea molfileText;
    final Button button;
    final PanelMolEditor panelMolEditor;
    private List<HandlerRegistration> handlerRegistration = new ArrayList<HandlerRegistration>();

    public MolfilePanel(PanelMolEditor panelMolEditor, boolean exportMenu) {
        this.panelMolEditor = panelMolEditor;
        this.containerMolfile = new HorizontalPanel();
        this.containerMolfile.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.containerMolfile.setWidth("400px");
        this.cont_molfile = new VerticalPanel();
        this.cont_molfile.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        this.cont_molfile.setWidth("400px");
        this.cont_molfile.setSpacing(10);
        this.containerMolfile.add((Widget)this.cont_molfile);
        this.molfileText = new TextArea();
        this.molfileText.setText("");
        this.molfileText.setWidth("100%");
        this.molfileText.setHeight("450px");
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        this.button = new Button("Load Molfile");
        final Button buttonClose = new Button("Close");
        if (!exportMenu) {
            buttonPanel.add((Widget)this.button);
        }
        buttonPanel.add((Widget)buttonClose);
        this.cont_molfile.add((Widget)this.molfileText);
        this.cont_molfile.add((Widget)buttonPanel);
        this.cont_molfile.setCellHorizontalAlignment((Widget)buttonPanel, HasHorizontalAlignment.ALIGN_RIGHT);
        if (!this.handlerRegistration.isEmpty()) {
            for (HandlerRegistration r : this.handlerRegistration) {
                r.removeHandler();
            }
        }
        if (!exportMenu) {
            this.handlerRegistration.add(this.button.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    String text = MolfilePanel.this.getMolfileText().getText();
                    if (text != null && !text.equals("")) {
                        final QByteArray<QString> aMolContent = new QByteArray<QString>();
                        aMolContent.append(new QString(text));
                        String molfile = text;
                        if (MolfilePanel.this.getPanelMolEditor().getCanvasMolecule().getSettings().fShowWM) {
                            JsonpRequestBuilder jsonp = new JsonpRequestBuilder();
                            if (molfile != null || !molfile.equals("")) {
                                String url = new String(StringHEX.unhexlate(UrlServices.getRenderService())) + StringHEX.hexlate(molfile.getBytes());
                                jsonp.requestObject(url, (AsyncCallback)new AsyncCallback<JavaScriptObject>(){

                                    public void onFailure(Throwable arg0) {
                                        Window.alert((String)new String(StringHEX.unhexlate(UrlServices.getError())));
                                    }

                                    public void onSuccess(JavaScriptObject results) {
                                        MolfilePanel.this.getPanelMolEditor().setMolfile(Utils_Molfile.read(aMolContent, false));
                                    }
                                });
                            }
                        } else {
                            MolfilePanel.this.getPanelMolEditor().setMolfile(Utils_Molfile.read(aMolContent, false));
                        }
                    }
                    MolfilePanel.this.getMolfilePanel().hide();
                    MolfilePanel.this.getPanelMolEditor().getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)MolfilePanel.this.button));
                }
            }));
        }
        this.handlerRegistration.add(buttonClose.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                MolfilePanel.this.getMolfilePanel().hide();
                MolfilePanel.this.getPanelMolEditor().getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)buttonClose));
            }
        }));
        this.add((Widget)this.containerMolfile);
        this.setPopupPosition(this.panelMolEditor.getAbsoluteLeft() + 20, this.panelMolEditor.getAbsoluteTop() + 20);
    }

    public HorizontalPanel getContainerMolfile() {
        return this.containerMolfile;
    }

    public VerticalPanel getCont_molfile() {
        return this.cont_molfile;
    }

    public TextArea getMolfileText() {
        return this.molfileText;
    }

    public PanelMolEditor getPanelMolEditor() {
        return this.panelMolEditor;
    }

    public MolfilePanel getMolfilePanel() {
        return this;
    }
}

