/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.sf.jnati.ArtefactDescriptor;
import net.sf.jnati.FileUtils;
import net.sf.jnati.NativeCodeException;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.artefact.ConfigManager;
import net.sf.jnati.deploy.repository.ClasspathRepository;
import net.sf.jnati.deploy.repository.LocalRepository;
import net.sf.jnati.deploy.repository.RemoteRepository;
import net.sf.jnati.deploy.resolver.ArtefactNotFoundException;
import net.sf.jnati.deploy.resolver.ArtefactResolver;
import net.sf.jnati.deploy.source.ArtefactSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeArtefactLocator {
    private static final Logger LOG = Logger.getLogger(NativeArtefactLocator.class);

    public Artefact getArtefact(String id, String version) throws NativeCodeException {
        return this.getArtefact(id, version, null);
    }

    public Artefact getArtefact(String id, String version, Properties configuration) throws NativeCodeException {
        Artefact artefact = new Artefact(id, version);
        ConfigManager.loadConfiguration(artefact, configuration);
        List<? extends ArtefactSource> classpathSources = this.findClasspathSources(artefact);
        if (this.findArtefactOnFilesystem(artefact, classpathSources)) {
            return artefact;
        }
        LocalRepository localRepo = new LocalRepository(artefact.getLocalRepository());
        if (this.findArtefactInLocalRepository(artefact, localRepo)) {
            return artefact;
        }
        if (this.deployArtefactToLocalRepository(artefact, classpathSources, localRepo)) {
            return artefact;
        }
        if (this.deployArtefactFromRemoteRepository(artefact, localRepo)) {
            return artefact;
        }
        throw new ArtefactNotFoundException("Artefact not found: " + artefact);
    }

    private boolean deployArtefactFromRemoteRepository(Artefact artefact, LocalRepository localRepo) throws NativeCodeException {
        if (artefact.getAllowDownload()) {
            List<String> urls = artefact.getRepositoryUrls();
            Collections.shuffle(urls);
            for (String u : urls) {
                List<? extends ArtefactSource> remoteSources = this.findRemoteSources(artefact, u);
                if (remoteSources.isEmpty()) continue;
                File target = localRepo.createArtefact(artefact);
                for (ArtefactSource artefactSource : remoteSources) {
                    try {
                        new ArtefactResolver().resolve(artefact, artefactSource, target);
                        LOG.info((Object)("Artefact (" + artefact + ") location: " + artefact.getPath()));
                        return true;
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Error resolving artefact to local repository", (Throwable)e);
                    }
                }
                FileUtils.delTree((File)target);
            }
        }
        return false;
    }

    private List<? extends ArtefactSource> findRemoteSources(Artefact artefact, String u) {
        try {
            URL url = new URL(u);
            RemoteRepository remoteRepo = new RemoteRepository(url);
            try {
                List<? extends ArtefactSource> remoteSources = remoteRepo.getArtefactSource(artefact);
                return remoteSources;
            }
            catch (IOException e) {
                LOG.warn((Object)"Error accessing remote repository", (Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)"Malformed URL", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private boolean deployArtefactToLocalRepository(Artefact artefact, List<? extends ArtefactSource> classpathSources, LocalRepository localRepo) throws NativeCodeException {
        if (!classpathSources.isEmpty()) {
            File target = localRepo.createArtefact(artefact);
            for (ArtefactSource artefactSource : classpathSources) {
                try {
                    new ArtefactResolver().resolve(artefact, artefactSource, target);
                    LOG.info((Object)("Artefact (" + artefact + ") location: " + artefact.getPath()));
                    return true;
                }
                catch (IOException e) {
                    LOG.warn((Object)"Error resolving artefact to local repository", (Throwable)e);
                }
            }
            FileUtils.delTree((File)target);
        }
        return false;
    }

    private boolean findArtefactInLocalRepository(Artefact artefact, LocalRepository localRepo) {
        List<? extends ArtefactSource> localSources = localRepo.getArtefactSource(artefact);
        for (ArtefactSource artefactSource : localSources) {
            if (!artefactSource.isLocal()) continue;
            try {
                artefactSource.loadManifest(artefact);
                artefact.setPath(artefactSource.getPath());
                LOG.info((Object)("Artefact (" + artefact + ") location: " + artefact.getPath()));
                return true;
            }
            catch (IOException e) {
                LOG.warn((Object)"Error loading manifest", (Throwable)e);
            }
        }
        return false;
    }

    private boolean findArtefactInLocalRepository(Artefact artefact, LocalRepository localRepo, int index) {
        List<? extends ArtefactSource> localSources = localRepo.getArtefactSource(artefact, index);
        for (ArtefactSource artefactSource : localSources) {
            if (!artefactSource.isLocal()) continue;
            try {
                artefactSource.loadManifest(artefact);
                artefact.setPath(artefactSource.getPath());
                LOG.info((Object)("Artefact (" + artefact + ") location: " + artefact.getPath()));
                return true;
            }
            catch (IOException e) {
                LOG.warn((Object)"Error loading manifest", (Throwable)e);
            }
        }
        return false;
    }

    private boolean findArtefactOnFilesystem(Artefact artefact, List<? extends ArtefactSource> classpathSources) {
        if (artefact.getAllowLocal()) {
            for (ArtefactSource artefactSource : classpathSources) {
                if (!artefactSource.isLocal()) continue;
                try {
                    artefactSource.loadManifest(artefact);
                    artefact.setPath(artefactSource.getPath());
                    LOG.info((Object)("Artefact (" + artefact + ") location: " + artefact.getPath()));
                    return true;
                }
                catch (IOException e) {
                    LOG.warn((Object)"Error loading manifest", (Throwable)e);
                }
            }
        }
        return false;
    }

    private List<? extends ArtefactSource> findClasspathSources(Artefact artefact) {
        ClasspathRepository cpRepo = new ClasspathRepository();
        List<ArtefactSource> cpSources = null;
        try {
            cpSources = cpRepo.getArtefactSource(artefact);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error searching classpath", (Throwable)e);
            cpSources = Collections.emptyList();
        }
        return cpSources;
    }

    public Artefact redeployArtefact(Artefact artefact, int index) throws NativeCodeException, IOException {
        Artefact redeploy = new Artefact(artefact);
        LocalRepository localRepo = new LocalRepository(artefact.getLocalRepository());
        if (this.findArtefactInLocalRepository(redeploy, localRepo, index)) {
            return redeploy;
        }
        List<? extends ArtefactSource> sources = localRepo.getArtefactSource(artefact);
        if (!sources.isEmpty()) {
            ArtefactSource source = sources.get(0);
            File target = localRepo.createArtefact(artefact, index);
            source.loadManifest(redeploy);
            new ArtefactResolver().resolve(redeploy, source, target);
            return redeploy;
        }
        return null;
    }

    public static ArtefactDescriptor findArtefact(String id, String version) throws NativeCodeException {
        return NativeArtefactLocator.findArtefact(id, version, null);
    }

    public static ArtefactDescriptor findArtefact(String id, String version, Properties configuration) throws NativeCodeException {
        NativeArtefactLocator loc = new NativeArtefactLocator();
        Artefact artefact = loc.getArtefact(id, version, configuration);
        return artefact.getArtefactLocation();
    }
}

