function inspect(s) {
	return "<pre>"
			+ s.replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/\"/g,
					"&quot;") + "</pre>"
}

function src(id) {
	return document.getElementById(id).innerHTML;
}

function example(id, format, engine) {
	var result;
	try {
		result = Viz(src(id), format, engine);
		if (format === "svg")
			return result;
		else
			return inspect(result);
	} catch (e) {
		return inspect(e.toString());
	}
}

function jsonLoader(elementId, fileName, callback) {
	$.ajax({
		url : fileName,
		dataType : 'json',
		success : function(data) {
			try {
				callback(data);
			} catch (e) {
				document.getElementById(elementId).innerHTML = inspect(e
						.toString());
			}
		},
		error : function(d1, errText, eCode) {
			document.getElementById(elementId).innerHTML = d1 + "<br/>"
					+ errText + "<br/>" + eCode;
		}
	});

}
function loadDot(elementId, content) {
			loadDot2(elementId, content);
}
function loadDot2(elementId, content) {
			try {
				document.getElementById(elementId).innerHTML = Viz(
						content, "svg");
			} catch (e) {
				document.getElementById(elementId).innerHTML = inspect(e
						.toString());
			}
}

function loadRaw(elementId, content){
	$('#frogfoot').append('<pre id="d_'+elementId+'" ></pre>');
	try {
	    $('#d_'+elementId).html(content);
	} catch (e) {
		document.getElementById('d_'+elementId).innerHTML = inspect(elementId+","+e.toString()+","+e.stack);
	}
}

function loadTable(elementId, content){
			$('#frogfoot').append('<table class="display" id="t_'+elementId+'" ></table>');
			try {
			    $('#t_'+elementId).dataTable( {
			        "bPaginate": false,
			        "bLengthChange": true,
			        "bFilter": true,
			        "bSort": true,
			        "bInfo": true,
			        "bAutoWidth": true,
			        
			        "aaData": content.aaData,
			        "aoColumns":content.aoColumns
			    });
			} catch (e) {
				document.getElementById(elementId).innerHTML = inspect(elementId+","+e.toString()+","+e.stack);
			}
}