function stackedBar(containerName,categories,groups,values) {
	$(function() {
		$("#"+containerName).after("<div id=\"chart"+containerName+"\"></div>");
		var chart=c3.generate({
		bindto: "#chart"+containerName,
	    data: {
	        columns: values,
	        type: 'bar',
	        groups: [groups]
	    },
	    axis: {
	        rotated: true,
	        x: {
	        	type: 'category',
	        	categories: categories
	        }
	    },
		});
	})
	
};

function loadStackedBar(elementId,content){
			try {
			    	stackedBar(elementId,content.categories,content.groups,content.values);
			} catch (e) {
				document.getElementById(elementId).innerHTML = inspect(e
						.toString());
			}
}

function distributionBar(containerName,xsData,values) {
	$(function () {
		$("#"+containerName).after("<div id=\"chart"+containerName+"\"></div><div style='text-align: center; font-size: small; color:dimgray;'>(click on legend to filter)</div>");
		var chart=c3.generate({
			bindto: "#chart"+containerName,
		    data: {
		    	xs: xsData,
		        columns: values,
		        hide: true
		    }
		});
	})
};

function loadDistributions(elementId,data) {
			try {
				distributionBar(elementId,data.xsData,data.values);
			} catch (e) {
				document.getElementById(elementId).innerHTML = inspect(e
						.toString());
			}
	}

function loadDistributions0(elementId,fileName) {
	$.ajax({
		url : fileName,
		dataType : 'json',
		success : function(data) {
			try {
				distributionBar(elementId,data.xsData,data.values);
			} catch (e) {
				document.getElementById(elementId).innerHTML = inspect(e
						.toString());
			}
		},
		error : function(d1, errText, eCode) {
			document.getElementById(elementId).innerHTML = d1 + "<br/>"
					+ errText + "<br/>" + eCode;
		}
	});
}

