/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AnnotationSpec {
    public final TypeName type;
    public final Map<String, List<CodeBlock>> members;

    private AnnotationSpec(Builder builder) {
        this.type = builder.type;
        this.members = Util.immutableMultimap(builder.members);
    }

    void emit(CodeWriter codeWriter, boolean inline) throws IOException {
        String memberSeparator;
        String whitespace = inline ? "" : "\n";
        String string = memberSeparator = inline ? ", " : ",\n";
        if (this.members.isEmpty()) {
            codeWriter.emit("@$T", this.type);
        } else if (this.members.size() == 1 && this.members.containsKey("value")) {
            codeWriter.emit("@$T(", this.type);
            this.emitAnnotationValues(codeWriter, whitespace, memberSeparator, this.members.get("value"));
            codeWriter.emit(")", new Object[0]);
        } else {
            codeWriter.emit("@$T(" + whitespace, this.type);
            codeWriter.indent(2);
            Iterator<Map.Entry<String, List<CodeBlock>>> i = this.members.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, List<CodeBlock>> entry = i.next();
                codeWriter.emit("$L = ", entry.getKey());
                this.emitAnnotationValues(codeWriter, whitespace, memberSeparator, entry.getValue());
                if (!i.hasNext()) continue;
                codeWriter.emit(memberSeparator, new Object[0]);
            }
            codeWriter.unindent(2);
            codeWriter.emit(whitespace + ")", new Object[0]);
        }
    }

    private void emitAnnotationValues(CodeWriter codeWriter, String whitespace, String memberSeparator, List<CodeBlock> values) throws IOException {
        if (values.size() == 1) {
            codeWriter.indent(2);
            codeWriter.emit(values.get(0));
            codeWriter.unindent(2);
            return;
        }
        codeWriter.emit("{" + whitespace, new Object[0]);
        codeWriter.indent(2);
        boolean first = true;
        for (CodeBlock codeBlock : values) {
            if (!first) {
                codeWriter.emit(memberSeparator, new Object[0]);
            }
            codeWriter.emit(codeBlock);
            first = false;
        }
        codeWriter.unindent(2);
        codeWriter.emit(whitespace + "}", new Object[0]);
    }

    public static Builder builder(ClassName type) {
        Util.checkNotNull(type, "type == null", new Object[0]);
        return new Builder(type);
    }

    public static Builder builder(Class<?> type) {
        return AnnotationSpec.builder(ClassName.get(type));
    }

    public boolean equals(Object o) {
        return o instanceof AnnotationSpec && ((AnnotationSpec)o).type.equals(this.type) && ((AnnotationSpec)o).members.equals(this.members);
    }

    public int hashCode() {
        return this.type.hashCode() + 37 * this.members.hashCode();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            CodeWriter codeWriter = new CodeWriter(out);
            codeWriter.emit("$L", this);
            return out.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static final class Builder {
        private final TypeName type;
        private final Map<String, List<CodeBlock>> members = new LinkedHashMap<String, List<CodeBlock>>();

        private Builder(TypeName type) {
            this.type = type;
        }

        public Builder addMember(String name, String format, Object ... args) {
            return this.addMember(name, CodeBlock.builder().add(format, args).build());
        }

        public Builder addMember(String name, CodeBlock codeBlock) {
            List<CodeBlock> values = this.members.get(name);
            if (values == null) {
                values = new ArrayList<CodeBlock>();
                this.members.put(name, values);
            }
            values.add(codeBlock);
            return this;
        }

        public AnnotationSpec build() {
            return new AnnotationSpec(this);
        }
    }
}

