/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillTextElement;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintText;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.fill.JRTemplateText;
import net.sf.jasperreports.engine.fill.SimpleTextFormat;
import net.sf.jasperreports.engine.fill.TextFormat;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillTextField
extends JRFillTextElement
implements JRTextField {
    protected static final Log log = LogFactory.getLog(JRFillTextField.class);
    protected final Map<Pair<JRStyle, TextFormat>, JRTemplateElement> textTemplates;
    private JRGroup evaluationGroup;
    private Object value;
    private TextFormat textFormat;
    private String pattern;
    private String anchorName;
    private String hyperlinkReference;
    private Boolean hyperlinkWhen;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    private static final String NULL_VALUE = new String();
    private final Map<String, String> localizedProperties;
    private Map<String, TimeZone> generalPatternTimeZones = new HashMap<String, TimeZone>();

    protected JRFillTextField(JRBaseFiller filler, JRTextField textField, JRFillObjectFactory factory) {
        super(filler, textField, factory);
        this.textTemplates = new HashMap<Pair<JRStyle, TextFormat>, JRTemplateElement>();
        this.evaluationGroup = factory.getGroup(textField.getEvaluationGroup());
        this.localizedProperties = new HashMap<String, String>();
    }

    protected JRFillTextField(JRFillTextField textField, JRFillCloneFactory factory) {
        super(textField, factory);
        this.textTemplates = textField.textTemplates;
        this.evaluationGroup = textField.evaluationGroup;
        this.localizedProperties = textField.localizedProperties;
    }

    @Override
    public boolean isStretchWithOverflow() {
        return ((JRTextField)this.parent).isStretchWithOverflow();
    }

    @Override
    public void setStretchWithOverflow(boolean isStretchWithOverflow) {
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return ((JRTextField)this.parent).getEvaluationTimeValue();
    }

    protected TextFormat getTextFormat() {
        return this.textFormat;
    }

    @Override
    public String getPattern() {
        if (this.getPatternExpression() == null) {
            return this.getStyleResolver().getPattern(this);
        }
        return this.pattern;
    }

    protected String getDatePattern(Object value) {
        String pattern = this.getPattern();
        if (pattern != null || value == null) {
            return pattern;
        }
        String property = value instanceof Date ? "net.sf.jasperreports.text.pattern.date" : (value instanceof Time ? "net.sf.jasperreports.text.pattern.time" : "net.sf.jasperreports.text.pattern.datetime");
        return this.getLocalizedProperty(property);
    }

    protected String getNumberPattern(Object value) {
        String pattern = this.getPattern();
        if (pattern != null || value == null) {
            return pattern;
        }
        String property = value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof BigInteger ? "net.sf.jasperreports.text.pattern.integer" : "net.sf.jasperreports.text.pattern.number";
        return this.getLocalizedProperty(property);
    }

    protected String getLocalizedProperty(String property) {
        String value = this.localizedProperties.get(property);
        if (value == null) {
            value = this.filler.getPropertiesUtil().getLocalizedProperty(property, this.filler.getLocale());
            this.localizedProperties.put(property, value == null ? NULL_VALUE : value);
        } else if (value == NULL_VALUE) {
            value = null;
        }
        return value;
    }

    @Override
    public String getOwnPattern() {
        return this.providerStyle == null || this.providerStyle.getOwnPattern() == null ? ((JRTextField)this.parent).getOwnPattern() : this.providerStyle.getOwnPattern();
    }

    @Override
    public void setPattern(String pattern) {
    }

    @Override
    public boolean isBlankWhenNull() {
        return this.getStyleResolver().isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.providerStyle == null || this.providerStyle.isOwnBlankWhenNull() == null ? ((JRTextField)this.parent).isOwnBlankWhenNull() : this.providerStyle.isOwnBlankWhenNull();
    }

    @Override
    public void setBlankWhenNull(boolean isBlank) {
    }

    @Override
    public void setBlankWhenNull(Boolean isBlank) {
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return ((JRTextField)this.parent).getHyperlinkTypeValue();
    }

    @Override
    public byte getHyperlinkTarget() {
        return ((JRTextField)this.parent).getHyperlinkTarget();
    }

    @Override
    public String getLinkTarget() {
        return ((JRTextField)this.parent).getLinkTarget();
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return ((JRTextField)this.parent).getExpression();
    }

    @Override
    public JRExpression getPatternExpression() {
        return ((JRTextField)this.parent).getPatternExpression();
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return ((JRTextField)this.parent).getAnchorNameExpression();
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRTextField)this.parent).getHyperlinkReferenceExpression();
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return ((JRTextField)this.parent).getHyperlinkWhenExpression();
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRTextField)this.parent).getHyperlinkAnchorExpression();
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return ((JRTextField)this.parent).getHyperlinkPageExpression();
    }

    protected Object getValue() {
        return this.value;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateText getJRTemplateText() {
        return (JRTemplateText)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        JRTemplateText template = new JRTemplateText(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
        template.copyParagraph(this.getPrintParagraph());
        template.copyLineBox(this.getPrintLineBox());
        template.setTextFormat(this.textFormat);
        return template;
    }

    protected void evaluateTextFormat(Format format, Object value, TimeZone ownTimeZone) {
        if (value != null) {
            if (value instanceof String) {
                this.textFormat = null;
            } else {
                SimpleTextFormat simpleTextFormat = new SimpleTextFormat();
                simpleTextFormat.setValueClassName(value.getClass().getName());
                String pattern = this.getTemplatePattern(format, value);
                if (pattern != null) {
                    simpleTextFormat.setPattern(pattern);
                }
                if (!this.filler.hasMasterFormatFactory()) {
                    simpleTextFormat.setFormatFactoryClass(this.filler.getFormatFactory().getClass().getName());
                }
                if (!this.filler.hasMasterLocale()) {
                    simpleTextFormat.setLocaleCode(JRDataUtils.getLocaleCode(this.filler.getLocale()));
                }
                if (value instanceof java.util.Date) {
                    TimeZone formatTimeZone;
                    TimeZone timeZone = formatTimeZone = ownTimeZone == null ? this.filler.getTimeZone() : ownTimeZone;
                    if (!formatTimeZone.equals(this.filler.fillContext.getMasterTimeZone())) {
                        simpleTextFormat.setTimeZoneId(JRDataUtils.getTimeZoneId(formatTimeZone));
                    }
                }
                this.textFormat = simpleTextFormat;
            }
        }
    }

    @Override
    protected JRTemplateElement getTemplate(JRStyle style) {
        Pair<JRStyle, TextFormat> key = new Pair<JRStyle, TextFormat>(style, this.textFormat);
        return this.textTemplates.get(key);
    }

    @Override
    protected void registerTemplate(JRStyle style, JRTemplateElement template) {
        Pair<JRStyle, TextFormat> key = new Pair<JRStyle, TextFormat>(style, this.textFormat);
        this.textTemplates.put(key, template);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created " + template + " for " + key));
        }
    }

    @Override
    protected boolean delayedEvaluationUpdatesTemplate() {
        return true;
    }

    protected TimeZone toFormatTimeZone(String timezoneId) {
        JRFillDataset dataset = this.expressionEvaluator.getFillDataset();
        TimeZone reportTimeZone = dataset == null ? this.filler.getTimeZone() : dataset.timeZone;
        return JRDataUtils.resolveFormatTimeZone(timezoneId, reportTimeZone);
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.evaluateText(evaluation);
        }
    }

    protected void evaluateText(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        this.evaluateStyle(evaluation);
        this.value = this.evaluateExpression(this.getExpression(), evaluation);
        String strValue = null;
        this.pattern = (String)this.evaluateExpression(this.getPatternExpression(), evaluation);
        if (this.value == null) {
            strValue = this.isBlankWhenNull() ? "" : null;
        } else {
            TimeZone ownTimeZone = this.determineOwnTimeZone();
            Format format = this.getFormat(this.value, ownTimeZone);
            this.evaluateTextFormat(format, this.value, ownTimeZone);
            if (format == null) {
                strValue = this.value.toString();
            } else {
                strValue = format.format(this.value);
                if (this.value instanceof java.util.Date && log.isDebugEnabled()) {
                    log.debug((Object)(this.getUUID() + ": formatted value " + this.value + " (" + this.value.getClass().getName() + "/" + ((java.util.Date)this.value).getTime() + ") to " + strValue));
                }
            }
        }
        String oldRawText = this.getRawText();
        String newRawText = this.processMarkupText(String.valueOf(strValue));
        this.setRawText(newRawText);
        this.resetTextChunk();
        this.setValueRepeating(oldRawText == null && newRawText == null || oldRawText != null && oldRawText.equals(newRawText));
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkWhen = (Boolean)this.evaluateExpression(this.getHyperlinkWhenExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
    }

    protected TimeZone determineOwnTimeZone() {
        TimeZone ownTimeZone = null;
        if (this.value instanceof java.util.Date) {
            String ownTimezoneId = this.hasProperties() ? this.getPropertiesMap().getProperty("net.sf.jasperreports.pattern.timezone") : null;
            ownTimeZone = this.toFormatTimeZone(ownTimezoneId);
            if (ownTimeZone == null) {
                if (this.value instanceof Date) {
                    ownTimeZone = this.getPatternTimeZone("net.sf.jasperreports.sql.date.pattern.timezone");
                } else if (this.value instanceof Timestamp) {
                    ownTimeZone = this.getPatternTimeZone("net.sf.jasperreports.sql.timestamp.pattern.timezone");
                } else if (this.value instanceof Time) {
                    ownTimeZone = this.getPatternTimeZone("net.sf.jasperreports.sql.time.pattern.timezone");
                }
            }
            if (ownTimeZone == null) {
                ownTimeZone = this.getPatternTimeZone("net.sf.jasperreports.pattern.timezone");
            }
        }
        return ownTimeZone;
    }

    protected TimeZone getPatternTimeZone(String property) {
        if (this.generalPatternTimeZones.containsKey(property)) {
            return this.generalPatternTimeZones.get(property);
        }
        String propertyVal = this.filler.propertiesUtil.getProperty(this.filler.jasperReport, property);
        TimeZone timeZone = this.toFormatTimeZone(propertyVal);
        this.generalPatternTimeZones.put(property, timeZone);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getUUID() + ": pattern timezone property " + property + " is " + propertyVal + ", resolved to " + timeZone));
        }
        return timeZone;
    }

    @Override
    public boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.isEvaluateNow()) {
            if (isOverflow) {
                if (this.getPositionTypeValue() == PositionTypeEnum.FIX_RELATIVE_TO_BOTTOM) {
                    this.resetTextChunk();
                }
                if (!(this.getTextEnd() < this.getText().length() && this.isStretchWithOverflow() && this.getRotationValue().equals(RotationEnum.NONE) || !this.isAlreadyPrinted())) {
                    if (this.isPrintWhenDetailOverflows()) {
                        this.resetTextChunk();
                        isReprinted = true;
                    } else {
                        isToPrint = false;
                    }
                }
                if (isToPrint && this.isPrintWhenExpressionNull() && !this.isPrintRepeatedValues() && this.isValueRepeating()) {
                    isToPrint = false;
                }
            } else if (!(!this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()))) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (availableHeight >= this.getRelativeY() + this.getHeight()) {
                    if (this.getTextEnd() < this.getText().length() || this.getTextEnd() == 0) {
                        if (this.isStretchWithOverflow() && this.getRotationValue().equals(RotationEnum.NONE)) {
                            this.chopTextElement(availableHeight - this.getRelativeY() - this.getHeight());
                            if (this.getTextEnd() < this.getText().length()) {
                                willOverflow = true;
                            }
                        } else {
                            this.chopTextElement(0);
                        }
                    } else {
                        isToPrint = false;
                    }
                } else {
                    isToPrint = false;
                    willOverflow = true;
                }
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getText().substring(this.getTextStart(), this.getTextEnd()).trim().length() == 0) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted()) {
                if (this.isPrintWhenDetailOverflows()) {
                    isReprinted = true;
                } else {
                    isToPrint = false;
                }
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    @Override
    public JRPrintElement fill() throws JRException {
        JRTemplatePrintText text;
        JRRecordedValuesPrintText recordedValuesText;
        EvaluationTimeEnum evaluationTime = this.getEvaluationTimeValue();
        if (this.isEvaluateAuto()) {
            recordedValuesText = new JRRecordedValuesPrintText(this.getJRTemplateText(), this.printElementOriginator);
            text = recordedValuesText;
        } else {
            text = new JRTemplatePrintText(this.getJRTemplateText(), this.printElementOriginator);
            recordedValuesText = null;
        }
        text.setUUID(this.getUUID());
        text.setX(this.getX());
        text.setY(this.getRelativeY());
        text.setWidth(this.getWidth());
        text.setHeight(this.getStretchHeight());
        text.setRunDirection(this.getRunDirectionValue());
        text.setBookmarkLevel(this.getBookmarkLevel());
        if (this.isEvaluateNow()) {
            this.copy(text);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint(recordedValuesText);
        } else {
            this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)text, evaluationTime, this.getEvaluationGroup(), this.band);
        }
        return text;
    }

    protected void copy(JRPrintText text) {
        text.setLineSpacingFactor(this.getLineSpacingFactor());
        text.setLeadingOffset(this.getLeadingOffset());
        text.setTextHeight(this.getTextHeight());
        text.setValue(this.getValue());
        this.setPrintText(text);
        text.setAnchorName(this.getAnchorName());
        if (this.getHyperlinkWhenExpression() == null || Boolean.TRUE.equals(this.hyperlinkWhen)) {
            text.setHyperlinkReference(this.getHyperlinkReference());
            text.setHyperlinkAnchor(this.getHyperlinkAnchor());
            text.setHyperlinkPage(this.getHyperlinkPage());
            text.setHyperlinkTooltip(this.getHyperlinkTooltip());
            text.setHyperlinkParameters(this.hyperlinkParameters);
        } else {
            if (text instanceof JRTemplatePrintText) {
                ((JRTemplatePrintText)text).setHyperlinkOmitted(true);
            }
            text.setHyperlinkReference(null);
        }
        this.transferProperties(text);
    }

    @Override
    protected void setPrintText(JRPrintText printText, String text) {
        Object printValue = printText.getValue();
        String textObj = text;
        if (text != null && printValue != null && printValue instanceof String && text.equals(printValue)) {
            textObj = (String)printValue;
        }
        super.setPrintText(printText, textObj);
    }

    protected Format getFormat(Object value, TimeZone ownTimeZone) {
        Format format = null;
        if (value instanceof java.util.Date) {
            format = this.filler.getDateFormat(this.getDatePattern(value), ownTimeZone);
        } else if (value instanceof Number) {
            format = this.filler.getNumberFormat(this.getNumberPattern(value));
        }
        return format;
    }

    protected String getTemplatePattern(Format format, Object value) {
        String originalPattern;
        String pattern = null;
        if (value instanceof java.util.Date) {
            originalPattern = this.getDatePattern(value);
            if (format instanceof SimpleDateFormat) {
                pattern = ((SimpleDateFormat)format).toPattern();
            }
        } else if (value instanceof Number) {
            originalPattern = this.getNumberPattern(value);
            if (format instanceof DecimalFormat) {
                pattern = ((DecimalFormat)format).toPattern();
            }
        } else {
            originalPattern = this.getPattern();
        }
        if (pattern == null) {
            pattern = originalPattern;
        }
        return pattern;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitTextField(this);
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateText(evaluation);
        this.chopTextElement(0);
        this.copy((JRPrintText)element);
        this.filler.updateBookmark(element);
    }

    @Override
    public int getBookmarkLevel() {
        return ((JRTextField)this.parent).getBookmarkLevel();
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillTextField(this, factory);
    }

    @Override
    protected void collectDelayedEvaluations() {
        super.collectDelayedEvaluations();
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getPatternExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkWhenExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRTextField)this.parent).getHyperlinkParameters();
    }

    @Override
    public String getLinkType() {
        return ((JRTextField)this.parent).getLinkType();
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRTextField)this.parent).getHyperlinkTooltipExpression();
    }

    @Override
    protected boolean canOverflow() {
        return this.isStretchWithOverflow() && this.getRotationValue().equals(RotationEnum.NONE) && this.isEvaluateNow() && this.filler.isBandOverFlowAllowed();
    }
}

