/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import net.sf.jasperreports.data.cache.CachedDataset;
import net.sf.jasperreports.data.cache.DataRecorder;
import net.sf.jasperreports.data.cache.DataSnapshot;
import net.sf.jasperreports.data.cache.DataSnapshotException;
import net.sf.jasperreports.data.cache.DatasetRecorder;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.DatasetPropertyExpression;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.EvaluationType;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributor;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.ParameterContributorFactory;
import net.sf.jasperreports.engine.data.IndexedDataSource;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DatasetFillContext;
import net.sf.jasperreports.engine.fill.DatasetSortUtil;
import net.sf.jasperreports.engine.fill.FillDatasetPosition;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRDistinctCountIncrementerFactory;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillDatasetScriptlet;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.SortedDataSource;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactoryContext;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ParameterEvaluationTimeEnum;
import net.sf.jasperreports.engine.type.PropertyEvaluationTimeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.DigestUtils;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.MD5Digest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillDataset
implements JRDataset,
DatasetFillContext {
    private static final Log log = LogFactory.getLog(JRFillDataset.class);
    public static final String EXCEPTION_MESSAGE_KEY_NO_SUCH_FIELD = "fill.dataset.no.such.field";
    public static final String EXCEPTION_MESSAGE_KEY_NO_SUCH_PARAMETER = "fill.dataset.no.such.parameter";
    public static final String EXCEPTION_MESSAGE_KEY_NO_SUCH_SNAPSHOT_DATA = "fill.dataset.no.such.snapshot.data";
    public static final String EXCEPTION_MESSAGE_KEY_NO_SUCH_SNAPSHOT_PARAMETER = "fill.dataset.no.such.snapshot.parameter";
    public static final String EXCEPTION_MESSAGE_KEY_NO_SUCH_VARIABLE = "fill.dataset.no.such.variable";
    private final BaseReportFiller filler;
    private JasperReportsContext jasperReportsContext;
    private JRPropertiesUtil propertiesUtil;
    private final JRDataset parent;
    private final boolean isMain;
    protected JRQuery query;
    private boolean useDatasourceParamValue;
    private boolean useConnectionParamValue;
    protected JRFillParameter[] parameters;
    protected Map<String, JRFillParameter> parametersMap;
    protected JRFillField[] fields;
    protected Map<String, JRFillField> fieldsMap;
    protected JRFillVariable[] variables;
    protected Map<String, JRFillVariable> variablesMap;
    protected Set<VariableCalculationReq> variableCalculationReqs;
    protected JRFillElementDataset[] elementDatasets;
    protected JRFillElementDataset[] origElementDatasets;
    protected JRFillGroup[] groups;
    protected String resourceBundleBaseName;
    protected WhenResourceMissingTypeEnum whenResourceMissingType;
    protected String scriptletClassName;
    protected JRDataSource dataSource;
    protected Locale locale;
    protected ResourceBundle resourceBundle;
    protected TimeZone timeZone;
    protected int reportCount;
    protected JRCalculator calculator;
    protected List<JRAbstractScriptlet> scriptlets;
    protected List<DatasetPropertyExpression> propertyExpressions;
    protected JRPropertiesMap staticProperties;
    protected JRPropertiesMap mergedProperties;
    protected JRAbstractScriptlet delegateScriptlet = new JRFillDatasetScriptlet(this);
    protected Integer reportMaxCount;
    private JRQueryExecuter queryExecuter;
    private List<ParameterContributor> parameterContributors;
    protected DatasetFilter filter;
    protected FillDatasetPosition fillPosition;
    protected DatasetRecorder dataRecorder;
    private Map<Integer, CacheRecordIndexCallback> cacheRecordIndexCallbacks;
    private boolean cacheSkipped;
    private CachedDataset cachedDataset;
    private boolean sortedDataSource;
    private boolean ended;
    private int cacheRecordCount;
    private int previousCacheRecordIndex;
    private int currentCacheRecordIndex;

    public JRFillDataset(BaseReportFiller filler, JRDataset dataset, JRFillObjectFactory factory) {
        factory.put(dataset, this);
        this.filler = filler;
        this.propertiesUtil = filler == null ? JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()) : filler.getPropertiesUtil();
        this.parent = dataset;
        this.isMain = dataset.isMainDataset();
        this.scriptletClassName = dataset.getScriptletClass();
        this.resourceBundleBaseName = dataset.getResourceBundle();
        this.whenResourceMissingType = dataset.getWhenResourceMissingTypeValue();
        this.query = dataset.getQuery();
        this.setParameters(dataset, factory);
        this.setFields(dataset, factory);
        this.setVariables(dataset, factory);
        this.setGroups(dataset, factory);
        this.mergedProperties = this.staticProperties = dataset.hasProperties() ? dataset.getPropertiesMap().cloneProperties() : null;
        DatasetPropertyExpression[] datasetPropertyExpressions = dataset.getPropertyExpressions();
        this.propertyExpressions = datasetPropertyExpressions == null ? new ArrayList<DatasetPropertyExpression>(0) : new ArrayList<DatasetPropertyExpression>(Arrays.asList(datasetPropertyExpressions));
    }

    private void setParameters(JRDataset dataset, JRFillObjectFactory factory) {
        JRParameter[] jrParameters = dataset.getParameters();
        if (jrParameters != null && jrParameters.length > 0) {
            this.parameters = new JRFillParameter[jrParameters.length];
            this.parametersMap = new HashMap<String, JRFillParameter>();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getParameter(jrParameters[i]);
                this.parametersMap.put(this.parameters[i].getName(), this.parameters[i]);
            }
        }
    }

    private void setGroups(JRDataset dataset, JRFillObjectFactory factory) {
        JRGroup[] jrGroups = dataset.getGroups();
        if (jrGroups != null && jrGroups.length > 0) {
            this.groups = new JRFillGroup[jrGroups.length];
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = factory.getGroup(jrGroups[i]);
            }
        }
    }

    private void setVariables(JRDataset dataset, JRFillObjectFactory factory) {
        JRVariable[] jrVariables = dataset.getVariables();
        if (jrVariables != null && jrVariables.length > 0) {
            ArrayList<JRFillVariable> variableList = new ArrayList<JRFillVariable>(jrVariables.length * 3);
            this.variablesMap = new HashMap<String, JRFillVariable>();
            for (int i = 0; i < jrVariables.length; ++i) {
                this.addVariable(jrVariables[i], variableList, factory);
            }
            this.setVariables(variableList);
        }
    }

    private JRFillVariable addVariable(JRVariable parentVariable, List<JRFillVariable> variableList, JRFillObjectFactory factory) {
        JRFillVariable variable = factory.getVariable(parentVariable);
        CalculationEnum calculation = variable.getCalculationValue();
        switch (calculation) {
            case AVERAGE: 
            case VARIANCE: {
                JRVariable countVar = this.createHelperVariable(parentVariable, "_COUNT", CalculationEnum.COUNT);
                JRFillVariable fillCountVar = this.addVariable(countVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
                JRVariable sumVar = this.createHelperVariable(parentVariable, "_SUM", CalculationEnum.SUM);
                JRFillVariable fillSumVar = this.addVariable(sumVar, variableList, factory);
                variable.setHelperVariable(fillSumVar, (byte)1);
                break;
            }
            case STANDARD_DEVIATION: {
                JRVariable varianceVar = this.createHelperVariable(parentVariable, "_VARIANCE", CalculationEnum.VARIANCE);
                JRFillVariable fillVarianceVar = this.addVariable(varianceVar, variableList, factory);
                variable.setHelperVariable(fillVarianceVar, (byte)2);
                break;
            }
            case DISTINCT_COUNT: {
                JRVariable countVar = this.createDistinctCountHelperVariable(parentVariable);
                JRFillVariable fillCountVar = this.addVariable(countVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
                break;
            }
        }
        variableList.add(variable);
        return variable;
    }

    private JRVariable createHelperVariable(JRVariable variable, String nameSuffix, CalculationEnum calculation) {
        JRDesignVariable helper = new JRDesignVariable();
        helper.setName(variable.getName() + nameSuffix);
        helper.setValueClassName(variable.getValueClassName());
        helper.setIncrementerFactoryClassName(variable.getIncrementerFactoryClassName());
        helper.setResetType(variable.getResetTypeValue());
        helper.setResetGroup(variable.getResetGroup());
        helper.setIncrementType(variable.getIncrementTypeValue());
        helper.setIncrementGroup(variable.getIncrementGroup());
        helper.setCalculation(calculation);
        helper.setSystemDefined(true);
        helper.setExpression(variable.getExpression());
        return helper;
    }

    private JRVariable createDistinctCountHelperVariable(JRVariable variable) {
        JRDesignVariable helper = new JRDesignVariable();
        helper.setName(variable.getName() + "_DISTINCT_COUNT");
        helper.setValueClassName(variable.getValueClassName());
        helper.setIncrementerFactoryClassName(JRDistinctCountIncrementerFactory.class.getName());
        helper.setResetType(ResetTypeEnum.REPORT);
        if (variable.getIncrementTypeValue() != IncrementTypeEnum.NONE) {
            helper.setResetType(ResetTypeEnum.getByValue(variable.getIncrementTypeValue().getValue()));
        }
        helper.setResetGroup(variable.getIncrementGroup());
        helper.setCalculation(CalculationEnum.NOTHING);
        helper.setSystemDefined(true);
        helper.setExpression(variable.getExpression());
        return helper;
    }

    private void setVariables(List<JRFillVariable> variableList) {
        this.variables = new JRFillVariable[variableList.size()];
        this.variables = variableList.toArray(this.variables);
        for (int i = 0; i < this.variables.length; ++i) {
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
    }

    private void setFields(JRDataset dataset, JRFillObjectFactory factory) {
        JRField[] jrFields = dataset.getFields();
        if (jrFields != null && jrFields.length > 0) {
            this.fields = new JRFillField[jrFields.length];
            this.fieldsMap = new HashMap<String, JRFillField>();
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = factory.getField(jrFields[i]);
                this.fieldsMap.put(this.fields[i].getName(), this.fields[i]);
            }
        }
    }

    public void createCalculator(JasperReport jasperReport) throws JRException {
        this.setCalculator(JRFillDataset.createCalculator(this.getJasperReportsContext(), jasperReport, this));
    }

    protected void setCalculator(JRCalculator calculator) {
        this.calculator = calculator;
    }

    protected static JRCalculator createCalculator(JasperReportsContext jasperReportsContext, JasperReport jasperReport, JRDataset dataset) throws JRException {
        JREvaluator evaluator = JasperCompileManager.getInstance(jasperReportsContext).getEvaluator(jasperReport, dataset);
        return new JRCalculator(evaluator);
    }

    public void initCalculator() throws JRException {
        this.calculator.init(this);
    }

    public void inheritFromMain() {
        if (this.resourceBundleBaseName == null && !this.isMain) {
            this.resourceBundleBaseName = this.filler.jasperReport.getResourceBundle();
            this.whenResourceMissingType = this.filler.jasperReport.getWhenResourceMissingTypeValue();
        }
    }

    protected List<JRAbstractScriptlet> createScriptlets(Map<String, Object> parameterValues) throws JRException {
        ScriptletFactoryContext context = new ScriptletFactoryContext(this.getJasperReportsContext(), this, parameterValues);
        this.scriptlets = new ArrayList<JRAbstractScriptlet>();
        List<ScriptletFactory> factories = this.getJasperReportsContext().getExtensions(ScriptletFactory.class);
        for (ScriptletFactory factory : factories) {
            List<JRAbstractScriptlet> tmpScriptlets = factory.getScriplets(context);
            if (tmpScriptlets == null) continue;
            this.scriptlets.addAll(tmpScriptlets);
        }
        if (this.scriptlets.size() == 0) {
            this.scriptlets.add(0, new JRDefaultScriptlet());
        }
        return this.scriptlets;
    }

    protected void initElementDatasets(JRFillObjectFactory factory) {
        this.elementDatasets = factory.getElementDatasets(this);
    }

    protected void filterElementDatasets(JRFillElementDataset elementDataset) {
        this.origElementDatasets = this.elementDatasets;
        this.elementDatasets = new JRFillElementDataset[]{elementDataset};
    }

    protected void restoreElementDatasets() {
        if (this.origElementDatasets != null) {
            this.elementDatasets = this.origElementDatasets;
            this.origElementDatasets = null;
        }
    }

    protected ResourceBundle loadResourceBundle() {
        ResourceBundle loadedBundle = this.resourceBundleBaseName == null ? null : JRResourcesUtil.loadResourceBundle(this.getJasperReportsContext(), this.resourceBundleBaseName, this.locale);
        return loadedBundle;
    }

    public void setParameterValues(Map<String, Object> parameterValues) throws JRException {
        parameterValues.put("REPORT_PARAMETERS_MAP", parameterValues);
        parameterValues.put("JASPER_REPORTS_CONTEXT", this.getJasperReportsContext());
        if (this.filler != null) {
            parameterValues.put("JASPER_REPORT", this.filler.getJasperReport());
        }
        this.reportMaxCount = (Integer)parameterValues.get("REPORT_MAX_COUNT");
        this.locale = (Locale)parameterValues.get("REPORT_LOCALE");
        if (this.locale == null) {
            this.locale = this.defaultLocale();
            parameterValues.put("REPORT_LOCALE", this.locale);
        }
        this.resourceBundle = (ResourceBundle)parameterValues.get("REPORT_RESOURCE_BUNDLE");
        if (this.resourceBundle == null) {
            this.resourceBundle = this.loadResourceBundle();
            if (this.resourceBundle != null) {
                parameterValues.put("REPORT_RESOURCE_BUNDLE", this.resourceBundle);
            }
        }
        this.timeZone = (TimeZone)parameterValues.get("REPORT_TIME_ZONE");
        if (this.timeZone == null) {
            this.timeZone = this.defaultTimeZone();
            parameterValues.put("REPORT_TIME_ZONE", this.timeZone);
        }
        this.scriptlets = this.createScriptlets(parameterValues);
        this.delegateScriptlet.setData(this.parametersMap, this.fieldsMap, this.variablesMap, this.groups);
        this.cacheInit();
        this.setFillParameterValuesFromMap(parameterValues, true);
        this.setFillParameterValuesFromCache(parameterValues);
        this.evaluateParameterValues(ParameterEvaluationTimeEnum.EARLY, parameterValues);
        this.mergedProperties = this.staticProperties;
        this.evaluateProperties(PropertyEvaluationTimeEnum.EARLY);
        this.contributeParameters(parameterValues);
        this.setFillParameterValuesFromMap(parameterValues, false);
        this.evaluateParameterValues(ParameterEvaluationTimeEnum.LATE, parameterValues);
        this.evaluateProperties(PropertyEvaluationTimeEnum.LATE);
        this.filter = (DatasetFilter)parameterValues.get("FILTER");
        this.cacheInitRecording();
        if (this.filter != null) {
            this.filter.init(this);
        }
    }

    protected Locale defaultLocale() {
        String localeCode = this.propertiesUtil.getProperty(this, "net.sf.jasperreports.default.locale");
        Locale locale = localeCode == null || localeCode.isEmpty() ? Locale.getDefault() : JRDataUtils.getLocale(localeCode);
        return locale;
    }

    protected TimeZone defaultTimeZone() {
        String timezoneId = this.propertiesUtil.getProperty(this, "net.sf.jasperreports.default.timezone");
        TimeZone timezone = timezoneId == null || timezoneId.isEmpty() ? TimeZone.getDefault() : JRDataUtils.getTimeZone(timezoneId);
        return timezone;
    }

    public void initDatasource() throws JRException {
        this.queryExecuter = null;
        this.dataSource = null;
        if (this.cachedDataset != null) {
            this.dataSource = this.cachedDataset.getDataSource();
        }
        if (this.dataSource == null) {
            this.dataSource = (JRDataSource)this.getParameterValue("REPORT_DATA_SOURCE");
            if (!this.useDatasourceParamValue && (this.useConnectionParamValue || this.dataSource == null)) {
                this.dataSource = this.createQueryDatasource();
                this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
            }
        }
        if (DatasetSortUtil.needSorting(this)) {
            this.dataSource = DatasetSortUtil.getSortedDataSource(this.filler, this, this.locale);
            this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
            this.sortedDataSource = true;
        }
    }

    public FillDatasetPosition getFillPosition() {
        return this.fillPosition;
    }

    public void setFillPosition(FillDatasetPosition fillPosition) {
        if (fillPosition != null) {
            fillPosition.addAttribute("datasetUUID", this.getUUID());
            if (this.query != null) {
                MD5Digest queryMD5 = DigestUtils.instance().md5(this.query.getText());
                fillPosition.addAttribute("queryMD5", queryMD5);
            }
        }
        this.fillPosition = fillPosition;
    }

    public void setCacheSkipped(boolean cacheSkipped) {
        this.cacheSkipped = cacheSkipped;
        if (cacheSkipped && log.isDebugEnabled()) {
            log.debug((Object)("data cache skipped at position " + this.fillPosition));
        }
    }

    protected void cacheInit() throws DataSnapshotException {
        this.cachedDataset = null;
        this.dataRecorder = null;
        if (this.fillPosition == null) {
            log.debug((Object)"No fill position present, not using the data cache");
            return;
        }
        if (this.filler != null) {
            this.cacheInitSnapshot();
        }
    }

    protected void cacheInitSnapshot() throws DataSnapshotException {
        if (this.cacheSkipped) {
            return;
        }
        DataSnapshot dataSnapshot = this.filler.fillContext.getDataSnapshot();
        if (dataSnapshot != null) {
            this.cachedDataset = dataSnapshot.getCachedData(this.fillPosition);
            if (this.cachedDataset == null) {
                throw new DataSnapshotException(EXCEPTION_MESSAGE_KEY_NO_SUCH_SNAPSHOT_DATA, new Object[]{this.fillPosition});
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using cached data for " + this.fillPosition));
            }
        }
    }

    protected void cacheInitRecording() {
        if (this.cacheSkipped) {
            return;
        }
        if (this.cachedDataset != null) {
            return;
        }
        if (this.filler == null) {
            return;
        }
        DataRecorder cacheRecorder = this.filler.fillContext.getDataRecorder();
        if (cacheRecorder != null && cacheRecorder.isEnabled()) {
            boolean dataRecorable = JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getBooleanProperty(this, "net.sf.jasperreports.data.cache.recordable", true);
            if (dataRecorable) {
                boolean dataPersistable = JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getBooleanProperty(this, "net.sf.jasperreports.data.cache.persistable", true);
                if (!dataPersistable) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("data not persistable by property for " + this.fillPosition));
                    }
                    cacheRecorder.disablePersistence();
                }
                this.dataRecorder = cacheRecorder.createRecorder();
                this.dataRecorder.start(this.parent.getFields());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Populating data cache for " + this.fillPosition));
                }
                for (JRFillParameter parameter : this.parameters) {
                    boolean includedInCache;
                    if (!parameter.hasProperties() || !(includedInCache = this.isIncludedInDataCache(parameter))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("storing value of paramter " + parameter.getName() + " in data snapshot"));
                    }
                    Object value = parameter.getValue();
                    this.dataRecorder.addParameter(parameter.getName(), value);
                }
                this.cacheRecordIndexCallbacks = new HashMap<Integer, CacheRecordIndexCallback>();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("data recording inhibited by property for " + this.fillPosition));
                }
                cacheRecorder.disableRecording();
            }
        }
    }

    protected boolean isIncludedInDataCache(JRFillParameter parameter) {
        String includedProp = JRPropertiesUtil.getOwnProperty(parameter, "net.sf.jasperreports.data.cache.included");
        return JRPropertiesUtil.asBoolean(includedProp);
    }

    protected ParameterEvaluationTimeEnum getDefaultParameterEvaluationTime() {
        String evalTimeProp = this.propertiesUtil.getProperty("net.sf.jasperreports.parameter.evaluation.time", this);
        return ParameterEvaluationTimeEnum.byName(evalTimeProp);
    }

    protected PropertyEvaluationTimeEnum getDefaultPropertyEvaluationTime() {
        String evalTimeProp = this.propertiesUtil.getProperty("net.sf.jasperreports.property.evaluation.time", this);
        return PropertyEvaluationTimeEnum.byName(evalTimeProp);
    }

    protected void cacheRecord() {
        if (this.dataRecorder != null && !this.dataRecorder.hasEnded()) {
            Object[] values;
            if (this.fields == null) {
                values = new Object[]{};
            } else {
                values = new Object[this.fields.length];
                for (int i = 0; i < this.fields.length; ++i) {
                    values[i] = this.fields[i].getValue();
                }
            }
            this.dataRecorder.addRecord(values);
        }
    }

    protected void cacheEnd() {
        if (this.dataRecorder != null && !this.dataRecorder.hasEnded()) {
            Object recorded;
            if (this.sortedDataSource) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"populating unsorted cache");
                }
                int recordIndex = 0;
                List<SortedDataSource.SortRecord> sortRecords = ((SortedDataSource)this.dataSource).getRecords();
                for (SortedDataSource.SortRecord sortRecord : sortRecords) {
                    CacheRecordIndexCallback recordIndexCallback;
                    Object[] fieldValues;
                    if (!sortRecord.isFiltered()) continue;
                    Object[] recordValues = sortRecord.getValues();
                    if (this.fields.length == recordValues.length) {
                        fieldValues = recordValues;
                    } else {
                        fieldValues = new Object[this.fields.length];
                        System.arraycopy(recordValues, 0, fieldValues, 0, this.fields.length);
                    }
                    this.dataRecorder.addRecord(fieldValues);
                    ++recordIndex;
                    int originalIndex = sortRecord.getRecordIndex() + 1;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("unsorted index " + recordIndex + " for original index " + originalIndex));
                    }
                    if ((recordIndexCallback = this.cacheRecordIndexCallbacks.get(originalIndex)) == null) continue;
                    recordIndexCallback.cacheRecordIndexAvailable(recordIndex);
                }
            }
            if ((recorded = this.dataRecorder.end()) != null) {
                this.filler.fillContext.addDataRecordResult(this.fillPosition, recorded);
            }
        }
    }

    private void evaluateParameterValues(ParameterEvaluationTimeEnum evaluationTime, Map<String, Object> parameterValues) throws JRException {
        if (this.parameters != null && this.parameters.length > 0) {
            ParameterEvaluationTimeEnum defaultEvaluationTime = this.getDefaultParameterEvaluationTime();
            for (int i = 0; i < this.parameters.length; ++i) {
                ParameterEvaluationTimeEnum paramEvalTime;
                JRFillParameter parameter = this.parameters[i];
                String paramName = parameter.getName();
                ParameterEvaluationTimeEnum parameterEvaluationTimeEnum = paramEvalTime = parameter.getEvaluationTime() == null ? defaultEvaluationTime : parameter.getEvaluationTime();
                if (parameterValues.containsKey(paramName) || parameter.isSystemDefined() || evaluationTime != paramEvalTime || this.isIncludedInDataCache(parameter) && this.cachedDataset != null) continue;
                Object value = this.calculator.evaluate(parameter.getDefaultValueExpression(), (byte)3);
                if (value != null) {
                    parameterValues.put(paramName, value);
                }
                this.setParameter(parameter, value);
            }
        }
    }

    private void setFillParameterValuesFromMap(Map<String, Object> parameterValues, boolean reset) throws JRException {
        if (this.parameters != null && this.parameters.length > 0) {
            for (int i = 0; i < this.parameters.length; ++i) {
                JRFillParameter parameter = this.parameters[i];
                String paramName = parameter.getName();
                Object value = null;
                if (parameterValues.containsKey(paramName)) {
                    value = parameterValues.get(paramName);
                    this.setParameter(parameter, value);
                    continue;
                }
                if (!reset) continue;
                this.setParameter(parameter, null);
            }
        }
    }

    private void setFillParameterValuesFromCache(Map<String, Object> parameterValues) throws JRException {
        if (this.parameters != null && this.parameters.length > 0) {
            for (int i = 0; i < this.parameters.length; ++i) {
                JRFillParameter parameter = this.parameters[i];
                String paramName = parameter.getName();
                if (parameterValues.containsKey(paramName) || parameter.isSystemDefined() || !this.isIncludedInDataCache(parameter) || this.cachedDataset == null) continue;
                if (!this.cachedDataset.hasParameter(paramName)) {
                    throw new DataSnapshotException(EXCEPTION_MESSAGE_KEY_NO_SUCH_SNAPSHOT_PARAMETER, new Object[]{paramName});
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("loading parameter " + paramName + " value from data snapshot"));
                }
                Object value = this.cachedDataset.getParameterValue(paramName);
                this.setParameter(parameter, value);
            }
        }
    }

    public void evaluateFieldProperties() throws JRException {
        if (this.fields != null && this.fields.length > 0) {
            for (JRFillField field : this.fields) {
                field.evaluateProperties();
            }
        }
    }

    public void contributeParameters(Map<String, Object> parameterValues) throws JRException {
        this.parameterContributors = this.getParameterContributors(new ParameterContributorContext(this.getJasperReportsContext(), this, parameterValues));
        if (this.parameterContributors != null) {
            for (ParameterContributor contributor : this.parameterContributors) {
                contributor.contributeParameters(parameterValues);
            }
        }
    }

    public void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        if (jasperReportsContext != null) {
            this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        }
    }

    protected JasperReportsContext getJasperReportsContext() {
        return this.filler == null ? (this.jasperReportsContext == null ? DefaultJasperReportsContext.getInstance() : this.jasperReportsContext) : this.filler.getJasperReportsContext();
    }

    public void disposeParameterContributors() {
        if (this.parameterContributors != null) {
            for (ParameterContributor contributor : this.parameterContributors) {
                contributor.dispose();
            }
        }
    }

    private List<ParameterContributor> getParameterContributors(ParameterContributorContext context) throws JRException {
        ArrayList<ParameterContributor> allContributors = null;
        List<ParameterContributorFactory> factories = this.getJasperReportsContext().getExtensions(ParameterContributorFactory.class);
        if (factories != null && factories.size() > 0) {
            allContributors = new ArrayList<ParameterContributor>();
            for (ParameterContributorFactory factory : factories) {
                List<ParameterContributor> contributors = factory.getContributors(context);
                if (contributors == null) continue;
                allContributors.addAll(contributors);
            }
        }
        return allContributors;
    }

    protected Map<String, Object> getParameterValuesMap() {
        JRFillParameter paramValuesParameter = this.parametersMap.get("REPORT_PARAMETERS_MAP");
        return (Map)paramValuesParameter.getValue();
    }

    private JRDataSource createQueryDatasource() throws JRException {
        if (this.query == null) {
            return null;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.filler.fillerId + ": Creating " + this.query.getLanguage() + " query executer"));
            }
            QueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getInstance(this.getJasperReportsContext()).getExecuterFactory(this.query.getLanguage());
            this.queryExecuter = queryExecuterFactory.createQueryExecuter(this.getJasperReportsContext(), this, this.parametersMap);
            this.filler.fillContext.setRunningQueryExecuter(this.queryExecuter);
            JRDataSource jRDataSource = this.queryExecuter.createDatasource();
            return jRDataSource;
        }
        finally {
            this.filler.fillContext.clearRunningQueryExecuter();
        }
    }

    protected void reset() {
        this.useDatasourceParamValue = false;
        this.useConnectionParamValue = false;
    }

    public void setDatasourceParameterValue(Map<String, Object> parameterValues, JRDataSource ds) {
        this.useDatasourceParamValue = true;
        if (ds != null) {
            parameterValues.put("REPORT_DATA_SOURCE", ds);
        }
    }

    public void setConnectionParameterValue(Map<String, Object> parameterValues, Connection conn) {
        this.useConnectionParamValue = true;
        if (conn != null) {
            parameterValues.put("REPORT_CONNECTION", conn);
        }
    }

    public void closeDatasource() {
        this.closeQueryExecuter();
        this.reset();
        if (this.ended) {
            this.cacheEnd();
        }
    }

    protected void closeQueryExecuter() {
        if (this.queryExecuter != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.filler.fillerId + ": closing query executer"));
            }
            this.queryExecuter.close();
            this.queryExecuter = null;
        }
    }

    public void start() {
        this.resetVariables();
        this.reportCount = 0;
        this.ended = false;
        this.cacheRecordCount = 0;
        this.previousCacheRecordIndex = 0;
        this.currentCacheRecordIndex = 0;
    }

    protected void resetVariables() {
        if (this.variables != null) {
            for (JRFillVariable variable : this.variables) {
                variable.reset();
            }
        }
    }

    public boolean next() throws JRException {
        return this.next(false);
    }

    protected boolean next(boolean sorting) throws JRException {
        boolean hasNext = false;
        if (this.dataSource != null) {
            boolean includeRow = true;
            do {
                if (!(hasNext = this.advanceDataSource(!sorting))) continue;
                this.setOldValues();
                this.calculator.estimateVariables();
                if (!sorting) {
                    includeRow = true;
                    JRExpression filterExpression = this.getFilterExpression();
                    if (filterExpression != null) {
                        Boolean filterExprResult = (Boolean)this.calculator.evaluate(filterExpression, (byte)2);
                        boolean bl = includeRow = filterExprResult != null && filterExprResult != false;
                    }
                    if (includeRow) {
                        this.advanceCacheRecordIndexes();
                        if (this.sortedDataSource) {
                            ((SortedDataSource)this.dataSource).setRecordFilteredIndex(this.cacheRecordCount - 1);
                        } else {
                            this.cacheRecord();
                        }
                        if (this.filter != null) {
                            includeRow = this.filter.matches(EvaluationType.ESTIMATED);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Record matched by filter: " + includeRow));
                            }
                        }
                    }
                }
                if (includeRow) continue;
                this.revertToOldValues();
            } while (hasNext && !includeRow);
            if (hasNext) {
                ++this.reportCount;
            }
        }
        if (!hasNext) {
            this.ended = true;
        }
        return hasNext;
    }

    protected void advanceCacheRecordIndexes() {
        ++this.cacheRecordCount;
        this.previousCacheRecordIndex = this.currentCacheRecordIndex;
        if (this.cachedDataset != null) {
            int dataSourceIndex = ((IndexedDataSource)this.dataSource).getRecordIndex();
            this.currentCacheRecordIndex = dataSourceIndex + 1;
        } else {
            this.currentCacheRecordIndex = this.cacheRecordCount;
        }
    }

    protected void setOldValues() throws JRException {
        int i;
        if (this.fields != null && this.fields.length > 0) {
            for (i = 0; i < this.fields.length; ++i) {
                JRFillField field = this.fields[i];
                field.setPreviousOldValue(field.getOldValue());
                field.setOldValue(field.getValue());
                field.setValue(this.dataSource.getFieldValue(field));
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                variable.setPreviousOldValue(variable.getOldValue());
                variable.setOldValue(variable.getValue());
            }
        }
    }

    protected void revertToOldValues() {
        int i;
        if (this.fields != null && this.fields.length > 0) {
            for (i = 0; i < this.fields.length; ++i) {
                JRFillField field = this.fields[i];
                field.setValue(field.getOldValue());
                field.setOldValue(field.getPreviousOldValue());
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                variable.setValue(variable.getOldValue());
                variable.setOldValue(variable.getPreviousOldValue());
            }
        }
    }

    protected boolean advanceDataSource(boolean limit) throws JRException {
        boolean hasNext = limit && this.reportMaxCount != null && this.reportCount >= this.reportMaxCount ? false : this.dataSource.next();
        return hasNext;
    }

    protected void setParameter(String parameterName, Object value) throws JRException {
        JRFillParameter parameter = this.parametersMap.get(parameterName);
        if (parameter != null) {
            this.setParameter(parameter, value);
        }
    }

    protected void setParameter(JRFillParameter parameter, Object value) throws JRException {
        parameter.setValue(value);
    }

    public JRFillVariable getVariable(String variableName) {
        return this.variablesMap.get(variableName);
    }

    public Object getVariableValue(String variableName) {
        return this.getVariableValue(variableName, EvaluationType.DEFAULT);
    }

    @Override
    public Object getVariableValue(String variableName, EvaluationType evaluation) {
        JRFillVariable var = this.variablesMap.get(variableName);
        if (var == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_SUCH_VARIABLE, new Object[]{variableName});
        }
        return var.getValue(evaluation.getType());
    }

    public JRFillVariable getFillVariable(String variableName) {
        return this.variablesMap.get(variableName);
    }

    @Override
    public Object getParameterValue(String parameterName) {
        return this.getParameterValue(parameterName, false);
    }

    public Object getParameterValue(String parameterName, boolean ignoreMissing) {
        Object value;
        JRFillParameter param = this.parametersMap.get(parameterName);
        if (param == null) {
            if (!ignoreMissing) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_SUCH_PARAMETER, new Object[]{parameterName});
            }
            Map<String, Object> valuesMap = this.getParameterValuesMap();
            value = valuesMap == null ? null : valuesMap.get(parameterName);
        } else {
            value = param.getValue();
        }
        return value;
    }

    public Object getFieldValue(String fieldName) {
        return this.getFieldValue(fieldName, EvaluationType.DEFAULT);
    }

    @Override
    public Object getFieldValue(String fieldName, EvaluationType evaluation) {
        JRFillField field = this.fieldsMap.get(fieldName);
        if (field == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_SUCH_FIELD, new Object[]{fieldName});
        }
        return field.getValue(evaluation.getType());
    }

    public JRFillField getFillField(String fieldName) {
        return this.fieldsMap.get(fieldName);
    }

    protected void addVariableCalculationReq(String variableName, CalculationEnum calculation) {
        if (this.variableCalculationReqs == null) {
            this.variableCalculationReqs = new HashSet<VariableCalculationReq>();
        }
        this.variableCalculationReqs.add(new VariableCalculationReq(variableName, calculation));
    }

    protected void checkVariableCalculationReqs(JRFillObjectFactory factory) {
        if (this.variableCalculationReqs != null && !this.variableCalculationReqs.isEmpty()) {
            ArrayList<JRFillVariable> variableList = new ArrayList<JRFillVariable>(this.variables.length * 2);
            for (int i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                this.checkVariableCalculationReq(variable, variableList, factory);
            }
            this.setVariables(variableList);
        }
    }

    private void checkVariableCalculationReq(JRFillVariable variable, List<JRFillVariable> variableList, JRFillObjectFactory factory) {
        JRFillVariable fillCountVar;
        JRVariable countVar;
        JRVariable parentVariable = variable.getParent();
        if (this.hasVariableCalculationReq(variable, CalculationEnum.AVERAGE) || this.hasVariableCalculationReq(variable, CalculationEnum.VARIANCE)) {
            if (variable.getHelperVariable((byte)0) == null) {
                countVar = this.createHelperVariable(parentVariable, "_COUNT", CalculationEnum.COUNT);
                fillCountVar = factory.getVariable(countVar);
                this.checkVariableCalculationReq(fillCountVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
            }
            if (variable.getHelperVariable((byte)1) == null) {
                JRVariable sumVar = this.createHelperVariable(parentVariable, "_SUM", CalculationEnum.SUM);
                JRFillVariable fillSumVar = factory.getVariable(sumVar);
                this.checkVariableCalculationReq(fillSumVar, variableList, factory);
                variable.setHelperVariable(fillSumVar, (byte)1);
            }
        }
        if (this.hasVariableCalculationReq(variable, CalculationEnum.STANDARD_DEVIATION) && variable.getHelperVariable((byte)2) == null) {
            JRVariable varianceVar = this.createHelperVariable(parentVariable, "_VARIANCE", CalculationEnum.VARIANCE);
            JRFillVariable fillVarianceVar = factory.getVariable(varianceVar);
            this.checkVariableCalculationReq(fillVarianceVar, variableList, factory);
            variable.setHelperVariable(fillVarianceVar, (byte)2);
        }
        if (this.hasVariableCalculationReq(variable, CalculationEnum.DISTINCT_COUNT) && variable.getHelperVariable((byte)0) == null) {
            countVar = this.createDistinctCountHelperVariable(parentVariable);
            fillCountVar = factory.getVariable(countVar);
            this.checkVariableCalculationReq(fillCountVar, variableList, factory);
            variable.setHelperVariable(fillCountVar, (byte)0);
        }
        variableList.add(variable);
    }

    private boolean hasVariableCalculationReq(JRVariable var, CalculationEnum calculation) {
        return this.variableCalculationReqs.contains(new VariableCalculationReq(var.getName(), calculation));
    }

    @Override
    public UUID getUUID() {
        return this.parent.getUUID();
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public String getScriptletClass() {
        return this.parent.getScriptletClass();
    }

    @Override
    public JRScriptlet[] getScriptlets() {
        return this.parent.getScriptlets();
    }

    @Override
    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public Map<String, JRFillParameter> getParametersMap() {
        return this.parametersMap;
    }

    @Override
    public JRQuery getQuery() {
        return this.query;
    }

    @Override
    public JRField[] getFields() {
        return this.fields;
    }

    @Override
    public JRSortField[] getSortFields() {
        return this.parent.getSortFields();
    }

    @Override
    public JRVariable[] getVariables() {
        return this.variables;
    }

    @Override
    public JRGroup[] getGroups() {
        return this.groups;
    }

    @Override
    public boolean isMainDataset() {
        return this.isMain;
    }

    @Override
    public String getResourceBundle() {
        return this.parent.getResourceBundle();
    }

    @Override
    public WhenResourceMissingTypeEnum getWhenResourceMissingTypeValue() {
        return this.whenResourceMissingType;
    }

    @Override
    public void setWhenResourceMissingType(WhenResourceMissingTypeEnum whenResourceMissingType) {
        this.whenResourceMissingType = whenResourceMissingType;
    }

    @Override
    public boolean hasProperties() {
        return this.mergedProperties != null && this.mergedProperties.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.mergedProperties;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return this.isMain ? null : this.filler.getJasperReport();
    }

    @Override
    public DatasetPropertyExpression[] getPropertyExpressions() {
        return this.propertyExpressions.toArray(new DatasetPropertyExpression[this.propertyExpressions.size()]);
    }

    protected void evaluateProperties(PropertyEvaluationTimeEnum evaluationTime) throws JRException {
        if (!this.propertyExpressions.isEmpty()) {
            JRPropertiesMap dynamicProperties = new JRPropertiesMap();
            PropertyEvaluationTimeEnum defaultEvaluationTime = this.getDefaultPropertyEvaluationTime();
            for (DatasetPropertyExpression prop : this.propertyExpressions) {
                PropertyEvaluationTimeEnum propEvalTime = prop.getEvaluationTime() == null ? defaultEvaluationTime : prop.getEvaluationTime();
                if (evaluationTime != propEvalTime) continue;
                String value = (String)this.evaluateExpression(prop.getValueExpression(), (byte)3);
                dynamicProperties.setProperty(prop.getName(), value);
            }
            JRPropertiesMap newMergedProperties = dynamicProperties.cloneProperties();
            newMergedProperties.setBaseProperties(this.mergedProperties);
            this.mergedProperties = newMergedProperties;
        }
    }

    @Override
    public JRExpression getFilterExpression() {
        return this.parent.getFilterExpression();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.calculator.evaluate(expression, evaluation);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public FillDatasetPosition getDatasetPosition() {
        return this.fillPosition;
    }

    protected void addCacheRecordIndexCallback(int recordIndex, CacheRecordIndexCallback callback) {
        CacheRecordIndexCallback existingCallback = this.cacheRecordIndexCallbacks.get(recordIndex);
        if (existingCallback == null) {
            this.cacheRecordIndexCallbacks.put(recordIndex, callback);
        } else {
            CacheRecordIndexChainedCallback chainedCallback = new CacheRecordIndexChainedCallback(existingCallback, callback);
            this.cacheRecordIndexCallbacks.put(recordIndex, chainedCallback);
        }
    }

    public void setCacheRecordIndex(FillDatasetPosition position, byte evaluationType) {
        int recordIndex;
        switch (evaluationType) {
            case 1: {
                recordIndex = this.previousCacheRecordIndex;
                break;
            }
            default: {
                recordIndex = this.currentCacheRecordIndex;
            }
        }
        if (this.sortedDataSource && this.dataRecorder != null) {
            FillDatasetPositionRecordIndexCallback callback = new FillDatasetPositionRecordIndexCallback(position);
            this.addCacheRecordIndexCallback(recordIndex, callback);
            if (log.isDebugEnabled()) {
                log.debug((Object)("registered cache callback for index " + recordIndex));
            }
        } else {
            FillDatasetPositionRecordIndexCallback.setRecordIndex(position, recordIndex);
        }
    }

    protected static class CacheRecordIndexChainedCallback
    implements CacheRecordIndexCallback {
        private final CacheRecordIndexCallback first;
        private final CacheRecordIndexCallback second;

        public CacheRecordIndexChainedCallback(CacheRecordIndexCallback first, CacheRecordIndexCallback second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void cacheRecordIndexAvailable(int recordIndex) {
            this.first.cacheRecordIndexAvailable(recordIndex);
            this.second.cacheRecordIndexAvailable(recordIndex);
        }
    }

    protected static class FillDatasetPositionRecordIndexCallback
    implements CacheRecordIndexCallback {
        private final FillDatasetPosition position;

        protected static void setRecordIndex(FillDatasetPosition position, int recordIndex) {
            position.addAttribute("rowIndex", Integer.valueOf(recordIndex));
        }

        public FillDatasetPositionRecordIndexCallback(FillDatasetPosition position) {
            this.position = position;
        }

        @Override
        public void cacheRecordIndexAvailable(int recordIndex) {
            FillDatasetPositionRecordIndexCallback.setRecordIndex(this.position, recordIndex);
        }
    }

    protected static interface CacheRecordIndexCallback {
        public void cacheRecordIndexAvailable(int var1);
    }

    protected static class VariableCalculationReq {
        String variableName;
        CalculationEnum calculation;

        VariableCalculationReq(String variableName, CalculationEnum calculation) {
            this.variableName = variableName;
            this.calculation = calculation;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof VariableCalculationReq)) {
                return false;
            }
            VariableCalculationReq r = (VariableCalculationReq)o;
            return this.variableName.equals(r.variableName) && this.calculation == r.calculation;
        }

        public int hashCode() {
            return 31 * this.calculation.ordinal() + this.variableName.hashCode();
        }
    }
}

