/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.PrintParts;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementXmlHandler;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRXmlExporterContext;
import net.sf.jasperreports.engine.export.XmlResourceHandler;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.XmlValueHandlerUtils;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.XmlExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersXmlExporterOutput;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;
import org.w3c.tools.codec.Base64Encoder;

public class JRXmlExporter
extends JRAbstractExporter<ReportExportConfiguration, ExporterConfiguration, XmlExporterOutput, JRXmlExporterContext> {
    private static final String XML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xml.";
    public static final String EXCEPTION_MESSAGE_KEY_EMBEDDING_IMAGE_ERROR = "export.xml.embedding.image.error";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_STYLE_NOT_FOUND = "export.xml.report.style.not.found";
    public static final String XML_EXPORTER_KEY = "net.sf.jasperreports.xml";
    public static final String PROPERTY_START_PAGE_INDEX = "net.sf.jasperreports.export.xml.start.page.index";
    public static final String PROPERTY_END_PAGE_INDEX = "net.sf.jasperreports.export.xml.end.page.index";
    public static final String PROPERTY_PAGE_COUNT = "net.sf.jasperreports.export.xml.page.count";
    public static final String PROPERTY_REPLACE_INVALID_CHARS = "net.sf.jasperreports.export.xml.replace.invalid.chars";
    protected static final String DEFAULT_OBJECT_TYPE = "java.lang.String";
    protected static final String IMAGE_PREFIX = "img_";
    public static final XmlNamespace JASPERPRINT_NAMESPACE = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/print", null, "http://jasperreports.sourceforge.net/xsd/jasperprint.xsd");
    protected JRXmlWriteHelper xmlWriter;
    protected String version;
    protected VersionComparator versionComparator = new VersionComparator();
    protected Map<String, String> rendererToImagePathMap;
    protected RenderersCache renderersCache;
    protected Map<String, JRStyle> stylesMap = new HashMap<String, JRStyle>();
    protected boolean isEmbeddingImages = true;
    private static int imageId;

    public JRXmlExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<ExporterConfiguration> getConfigurationInterface() {
        return ExporterConfiguration.class;
    }

    @Override
    protected Class<ReportExportConfiguration> getItemConfigurationInterface() {
        return ReportExportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersXmlExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        Boolean lcIsEmbeddingImages = ((XmlExporterOutput)this.getExporterOutput()).isEmbeddingImages();
        if (lcIsEmbeddingImages == null) {
            lcIsEmbeddingImages = Boolean.TRUE;
        }
        this.isEmbeddingImages = lcIsEmbeddingImages;
        if (!this.isEmbeddingImages) {
            this.rendererToImagePathMap = new HashMap<String, String>();
        }
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
        Writer writer = ((XmlExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToStream(writer);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            ((XmlExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
    }

    protected XmlNamespace getNamespace() {
        return JASPERPRINT_NAMESPACE;
    }

    protected void exportReportToStream(Writer writer) throws JRException, IOException {
        JRStyle[] styles;
        this.version = this.getPropertiesUtil().getProperty(this.jasperPrint, "net.sf.jasperreports.report.version");
        this.xmlWriter = new JRXmlWriteHelper(writer);
        this.xmlWriter.writeProlog(((XmlExporterOutput)this.getExporterOutput()).getEncoding());
        this.xmlWriter.startElement("jasperPrint", this.getNamespace());
        this.xmlWriter.addEncodedAttribute("name", this.jasperPrint.getName());
        this.xmlWriter.addAttribute("pageWidth", this.jasperPrint.getPageWidth());
        this.xmlWriter.addAttribute("pageHeight", this.jasperPrint.getPageHeight());
        this.xmlWriter.addAttribute("topMargin", this.jasperPrint.getTopMargin());
        this.xmlWriter.addAttribute("leftMargin", this.jasperPrint.getLeftMargin());
        this.xmlWriter.addAttribute("bottomMargin", this.jasperPrint.getBottomMargin());
        this.xmlWriter.addAttribute("rightMargin", this.jasperPrint.getRightMargin());
        this.xmlWriter.addAttribute("orientation", this.jasperPrint.getOrientationValue(), OrientationEnum.PORTRAIT);
        this.xmlWriter.addAttribute("formatFactoryClass", this.jasperPrint.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", this.jasperPrint.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", this.jasperPrint.getTimeZoneId());
        this.setCurrentExporterInputItem(this.exporterInput.getItems().get(0));
        List<JRPrintPage> pages = this.jasperPrint.getPages();
        JRAbstractExporter.PageRange pageRange = this.getPageRange();
        int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
        int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_START_PAGE_INDEX);
        this.xmlWriter.addEncodedAttribute("value", String.valueOf(startPageIndex));
        this.xmlWriter.closeElement();
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_END_PAGE_INDEX);
        this.xmlWriter.addEncodedAttribute("value", String.valueOf(endPageIndex));
        this.xmlWriter.closeElement();
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_PAGE_COUNT);
        this.xmlWriter.addEncodedAttribute("value", this.jasperPrint.getPages() == null ? null : String.valueOf(this.jasperPrint.getPages().size()));
        this.xmlWriter.closeElement();
        this.exportProperties(this.jasperPrint);
        JROrigin[] origins = this.jasperPrint.getOrigins();
        if (origins != null && origins.length > 0) {
            for (int i = 0; i < origins.length; ++i) {
                this.exportOrigin(origins[i]);
            }
        }
        if ((styles = this.jasperPrint.getStyles()) != null && styles.length > 0) {
            for (int i = 0; i < styles.length; ++i) {
                this.stylesMap.put(styles[i].getName(), styles[i]);
                this.exportStyle(styles[i]);
            }
        }
        this.exportBookmarks(this.jasperPrint.getBookmarks());
        PrintParts parts = this.jasperPrint.getParts();
        if (parts != null && parts.hasParts()) {
            Iterator<Map.Entry<Integer, PrintPart>> it = parts.partsIterator();
            while (it.hasNext()) {
                Map.Entry<Integer, PrintPart> partsEntry = it.next();
                this.exportPart(partsEntry.getKey(), partsEntry.getValue());
            }
        }
        if (pages != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i = startPageIndex; i <= endPageIndex; ++i) {
                if (Thread.interrupted()) {
                    throw new ExportInterruptedException();
                }
                page = pages.get(i);
                this.exportPage(page);
            }
        }
        this.xmlWriter.closeElement();
        writer.flush();
    }

    protected void exportProperties(JRPropertiesHolder propertiesHolder) throws IOException {
        JRPropertiesMap propertiesMap;
        String[] propertyNames;
        if (propertiesHolder.hasProperties() && (propertyNames = (propertiesMap = propertiesHolder.getPropertiesMap()).getPropertyNames()) != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                this.xmlWriter.startElement("property");
                this.xmlWriter.addEncodedAttribute("name", propertyNames[i]);
                String value = propertiesMap.getProperty(propertyNames[i]);
                if (value != null) {
                    String encodedValue = JRStringUtil.encodeXmlAttribute(value);
                    if (this.isNewerVersionOrEqual("6.4.0") && encodedValue.length() != value.length()) {
                        this.xmlWriter.writeCDATA(value);
                    } else {
                        this.xmlWriter.addAttribute("value", encodedValue);
                    }
                }
                this.xmlWriter.closeElement();
            }
        }
    }

    protected void exportStyle(JRStyle style) throws IOException {
        this.xmlWriter.startElement("style");
        this.xmlWriter.addEncodedAttribute("name", style.getName());
        this.xmlWriter.addAttribute("isDefault", style.isDefault(), false);
        if (style.getStyle() != null) {
            JRStyle baseStyle = this.stylesMap.get(style.getStyle().getName());
            if (baseStyle != null) {
                this.xmlWriter.addEncodedAttribute("style", style.getStyle().getName());
            } else {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_REPORT_STYLE_NOT_FOUND, new Object[]{style.getStyle().getName()});
            }
        }
        this.xmlWriter.addAttribute("mode", style.getOwnModeValue());
        this.xmlWriter.addAttribute("forecolor", style.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", style.getOwnBackcolor());
        this.xmlWriter.addAttribute("fill", style.getOwnFillValue());
        this.xmlWriter.addAttribute("radius", style.getOwnRadius());
        this.xmlWriter.addAttribute("scaleImage", style.getOwnScaleImageValue());
        this.xmlWriter.addAttribute("hTextAlign", style.getOwnHorizontalTextAlign());
        this.xmlWriter.addAttribute("hImageAlign", style.getOwnHorizontalImageAlign());
        VerticalTextAlignEnum vTextAlign = style.getOwnVerticalTextAlign();
        if (this.isOlderVersionThan("6.2.1")) {
            vTextAlign = vTextAlign == VerticalTextAlignEnum.JUSTIFIED ? VerticalTextAlignEnum.TOP : vTextAlign;
        }
        this.xmlWriter.addAttribute("vTextAlign", vTextAlign);
        this.xmlWriter.addAttribute("vImageAlign", style.getOwnVerticalImageAlign());
        this.xmlWriter.addAttribute("rotation", style.getOwnRotationValue());
        this.xmlWriter.addAttribute("markup", style.getOwnMarkup());
        this.xmlWriter.addEncodedAttribute("fontName", style.getOwnFontName());
        this.xmlWriter.addAttribute("fontSize", style.getOwnFontsize(), true);
        this.xmlWriter.addAttribute("isBold", style.isOwnBold());
        this.xmlWriter.addAttribute("isItalic", style.isOwnItalic());
        this.xmlWriter.addAttribute("isUnderline", style.isOwnUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", style.isOwnStrikeThrough());
        this.xmlWriter.addEncodedAttribute("pdfFontName", style.getOwnPdfFontName());
        this.xmlWriter.addEncodedAttribute("pdfEncoding", style.getOwnPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", style.isOwnPdfEmbedded());
        this.exportPen(style.getLinePen());
        this.exportBox(style.getLineBox());
        this.exportParagraph(style.getParagraph());
        this.xmlWriter.closeElement();
    }

    protected void exportOrigin(JROrigin origin) throws IOException {
        this.xmlWriter.startElement("origin");
        this.xmlWriter.addEncodedAttribute("report", origin.getReportName());
        this.xmlWriter.addEncodedAttribute("group", origin.getGroupName());
        this.xmlWriter.addAttribute("band", origin.getBandTypeValue());
        this.xmlWriter.closeElement();
    }

    protected void exportBookmarks(List<PrintBookmark> bookmarks) throws IOException {
        if (bookmarks != null && bookmarks.size() > 0) {
            for (PrintBookmark bookmark : bookmarks) {
                this.exportBookmark(bookmark);
            }
        }
    }

    protected void exportBookmark(PrintBookmark bookmark) throws IOException {
        if (bookmark != null) {
            this.xmlWriter.startElement("bookmark");
            this.xmlWriter.addEncodedAttribute("label", bookmark.getLabel());
            this.xmlWriter.addAttribute("pageIndex", bookmark.getPageIndex());
            this.xmlWriter.addEncodedAttribute("elementAddress", bookmark.getElementAddress());
            this.exportBookmarks(bookmark.getBookmarks());
            this.xmlWriter.closeElement();
        }
    }

    protected void exportPart(Integer pageIndex, PrintPart part) throws JRException, IOException {
        this.xmlWriter.startElement("part");
        this.xmlWriter.addAttribute("pageIndex", pageIndex);
        this.xmlWriter.addEncodedAttribute("name", part.getName());
        PrintPageFormat pageFormat = part.getPageFormat();
        this.xmlWriter.addAttribute("pageWidth", pageFormat.getPageWidth());
        this.xmlWriter.addAttribute("pageHeight", pageFormat.getPageHeight());
        this.xmlWriter.addAttribute("topMargin", pageFormat.getTopMargin());
        this.xmlWriter.addAttribute("leftMargin", pageFormat.getLeftMargin());
        this.xmlWriter.addAttribute("bottomMargin", pageFormat.getBottomMargin());
        this.xmlWriter.addAttribute("rightMargin", pageFormat.getRightMargin());
        this.xmlWriter.addAttribute("orientation", pageFormat.getOrientation(), OrientationEnum.PORTRAIT);
        this.xmlWriter.closeElement();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.xmlWriter.startElement("page");
        this.exportElements(page.getElements());
        this.xmlWriter.closeElement();
        JRExportProgressMonitor progressMonitor = this.getCurrentItemConfiguration().getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator<JRPrintElement> it = elements.iterator();
            while (it.hasNext()) {
                this.exportElement(it.next());
            }
        }
    }

    public void exportElement(JRPrintElement element) throws IOException, JRException {
        if (this.filter == null || this.filter.isToExport(element)) {
            if (element instanceof JRPrintLine) {
                this.exportLine((JRPrintLine)element);
            } else if (element instanceof JRPrintRectangle) {
                this.exportRectangle((JRPrintRectangle)element);
            } else if (element instanceof JRPrintEllipse) {
                this.exportEllipse((JRPrintEllipse)element);
            } else if (element instanceof JRPrintImage) {
                this.exportImage((JRPrintImage)element);
            } else if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
            } else if (element instanceof JRPrintFrame) {
                this.exportFrame((JRPrintFrame)element);
            } else if (element instanceof JRGenericPrintElement) {
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.xmlWriter.startElement("line");
        this.xmlWriter.addAttribute("direction", line.getDirectionValue(), LineDirectionEnum.TOP_DOWN);
        this.exportReportElement(line);
        this.exportGraphicElement(line);
        this.xmlWriter.closeElement();
    }

    protected void exportReportElement(JRPrintElement element) throws IOException {
        int printId;
        int elementId;
        this.xmlWriter.startElement("reportElement");
        if (this.isNewerVersionOrEqual("4.7.0")) {
            this.xmlWriter.addEncodedAttribute("uuid", element.getUUID() == null ? null : element.getUUID().toString());
        }
        this.xmlWriter.addEncodedAttribute("key", element.getKey());
        JRStyle style = element.getStyle();
        if (style != null) {
            this.xmlWriter.addEncodedAttribute("style", style.getName());
        }
        this.xmlWriter.addAttribute("mode", element.getOwnModeValue());
        this.xmlWriter.addAttribute("x", element.getX() + this.getOffsetX());
        this.xmlWriter.addAttribute("y", element.getY() + this.getOffsetY());
        this.xmlWriter.addAttribute("width", element.getWidth());
        this.xmlWriter.addAttribute("height", element.getHeight());
        this.xmlWriter.addAttribute("forecolor", element.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", element.getOwnBackcolor());
        JROrigin origin = element.getOrigin();
        if (origin != null) {
            this.xmlWriter.addAttribute("origin", this.jasperPrint.getOriginsMap().get(origin));
        }
        if ((elementId = element.getSourceElementId()) != 0) {
            this.xmlWriter.addAttribute("srcId", elementId);
        }
        if ((printId = element.getPrintElementId()) != 0) {
            this.xmlWriter.addAttribute("printId", printId);
        }
        this.exportProperties(element);
        this.xmlWriter.closeElement();
    }

    protected void exportGraphicElement(JRPrintGraphicElement element) throws IOException {
        this.xmlWriter.startElement("graphicElement");
        this.xmlWriter.addAttribute("fill", element.getOwnFillValue());
        this.exportPen(element.getLinePen());
        this.xmlWriter.closeElement(true);
    }

    protected void exportPen(JRPen pen) throws IOException {
        this.exportPen("pen", pen);
    }

    protected void exportPen(String element, JRPen pen) throws IOException {
        this.xmlWriter.startElement(element);
        this.xmlWriter.addAttribute("lineWidth", pen.getOwnLineWidth());
        this.xmlWriter.addAttribute("lineStyle", pen.getOwnLineStyleValue());
        this.xmlWriter.addAttribute("lineColor", pen.getOwnLineColor());
        this.xmlWriter.closeElement(true);
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.xmlWriter.startElement("rectangle");
        this.xmlWriter.addAttribute("radius", rectangle.getOwnRadius());
        this.exportReportElement(rectangle);
        this.exportGraphicElement(rectangle);
        this.xmlWriter.closeElement();
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.xmlWriter.startElement("ellipse");
        this.exportReportElement(ellipse);
        this.exportGraphicElement(ellipse);
        this.xmlWriter.closeElement();
    }

    public void exportImage(JRPrintImage image) throws JRException, IOException {
        this.xmlWriter.startElement("image");
        this.xmlWriter.addAttribute("scaleImage", image.getOwnScaleImageValue());
        this.xmlWriter.addAttribute("hAlign", image.getOwnHorizontalImageAlign());
        this.xmlWriter.addAttribute("vAlign", image.getOwnVerticalImageAlign());
        Renderable renderer = image.getRenderer();
        boolean isLazy = RendererUtil.isLazy(renderer);
        this.xmlWriter.addAttribute("isLazy", isLazy, false);
        this.xmlWriter.addAttribute("onErrorType", image.getOnErrorTypeValue(), OnErrorTypeEnum.ERROR);
        JRHyperlinkProducerFactory hyperlinkProducerFactory = this.getCurrentItemConfiguration().getHyperlinkProducerFactory();
        if (hyperlinkProducerFactory == null) {
            this.xmlWriter.addEncodedAttribute("hyperlinkType", image.getLinkType(), HyperlinkTypeEnum.NONE.getName());
            this.xmlWriter.addEncodedAttribute("hyperlinkReference", image.getHyperlinkReference());
            this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", image.getHyperlinkAnchor());
            this.xmlWriter.addAttribute("hyperlinkPage", image.getHyperlinkPage());
        } else {
            String reference = hyperlinkProducerFactory.produceHyperlink(image);
            if (reference != null) {
                this.xmlWriter.addAttribute("hyperlinkType", HyperlinkTypeEnum.REFERENCE);
                this.xmlWriter.addEncodedAttribute("hyperlinkReference", reference);
            }
        }
        this.xmlWriter.addAttribute("hyperlinkTarget", image.getLinkTarget(), HyperlinkTargetEnum.SELF.getName());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", image.getHyperlinkTooltip());
        this.xmlWriter.addEncodedAttribute("anchorName", image.getAnchorName());
        this.xmlWriter.addAttribute("bookmarkLevel", image.getBookmarkLevel(), 0);
        this.exportReportElement(image);
        this.exportBox(image.getLineBox());
        this.exportGraphicElement(image);
        if (renderer != null) {
            this.xmlWriter.startElement("imageSource");
            this.xmlWriter.addAttribute("isEmbedded", this.isEmbeddingImages && !isLazy, false);
            String imageSource = "";
            if (isLazy) {
                imageSource = RendererUtil.getResourceLocation(renderer);
            } else {
                if (renderer instanceof ResourceRenderer) {
                    renderer = this.renderersCache.getLoadedRenderer((ResourceRenderer)renderer);
                }
                if (!this.isEmbeddingImages && renderer instanceof DataRenderable && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                    imageSource = this.rendererToImagePathMap.get(renderer.getId());
                } else if (this.isEmbeddingImages) {
                    DataRenderable dataRenderer = this.getRendererUtil().getDataRenderable(renderer, new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(dataRenderer.getData(this.jasperReportsContext));
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Base64Encoder encoder = new Base64Encoder(bais, baos);
                        encoder.process();
                        imageSource = new String(baos.toByteArray(), "UTF-8");
                    }
                    catch (IOException e) {
                        throw new JRException(EXCEPTION_MESSAGE_KEY_EMBEDDING_IMAGE_ERROR, null, e);
                    }
                } else {
                    XmlResourceHandler imageHandler = ((XmlExporterOutput)this.getExporterOutput()).getImageHandler();
                    if (imageHandler != null) {
                        DataRenderable dataRenderer = this.getRendererUtil().getDataRenderable(renderer, new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                        String imageName = IMAGE_PREFIX + JRXmlExporter.getNextImageId();
                        imageHandler.handleResource(imageName, dataRenderer.getData(this.jasperReportsContext));
                        imageSource = imageHandler.getResourceSource(imageName);
                        if (dataRenderer == renderer) {
                            this.rendererToImagePathMap.put(renderer.getId(), imageSource);
                        }
                    }
                }
            }
            this.xmlWriter.writeCDATA(imageSource);
            this.xmlWriter.closeElement();
        }
        if (hyperlinkProducerFactory == null) {
            this.exportHyperlinkParameters(image);
        }
        this.xmlWriter.closeElement();
    }

    public void exportText(JRPrintText text) throws IOException {
        this.xmlWriter.startElement("text");
        this.xmlWriter.addAttribute("textAlignment", text.getOwnHorizontalTextAlign());
        VerticalTextAlignEnum vTextAlign = text.getOwnVerticalTextAlign();
        if (this.isOlderVersionThan("6.2.1")) {
            vTextAlign = vTextAlign == VerticalTextAlignEnum.JUSTIFIED ? VerticalTextAlignEnum.TOP : vTextAlign;
        }
        this.xmlWriter.addAttribute("verticalAlignment", vTextAlign);
        this.xmlWriter.addAttribute("textHeight", text.getTextHeight());
        this.xmlWriter.addAttribute("rotation", text.getOwnRotationValue());
        this.xmlWriter.addAttribute("runDirection", text.getRunDirectionValue(), RunDirectionEnum.LTR);
        this.xmlWriter.addAttribute("markup", text.getOwnMarkup());
        this.xmlWriter.addAttribute("lineSpacingFactor", text.getLineSpacingFactor(), 0.0f);
        this.xmlWriter.addAttribute("leadingOffset", text.getLeadingOffset(), 0.0f);
        JRHyperlinkProducerFactory hyperlinkProducerFactory = this.getCurrentItemConfiguration().getHyperlinkProducerFactory();
        if (hyperlinkProducerFactory == null) {
            this.xmlWriter.addEncodedAttribute("hyperlinkType", text.getLinkType());
            this.xmlWriter.addEncodedAttribute("hyperlinkReference", text.getHyperlinkReference());
            this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", text.getHyperlinkAnchor());
            this.xmlWriter.addAttribute("hyperlinkPage", text.getHyperlinkPage());
        } else {
            String reference = hyperlinkProducerFactory.produceHyperlink(text);
            if (reference != null) {
                this.xmlWriter.addAttribute("hyperlinkType", HyperlinkTypeEnum.REFERENCE);
                this.xmlWriter.addEncodedAttribute("hyperlinkReference", reference);
            }
        }
        this.xmlWriter.addAttribute("hyperlinkTarget", text.getLinkTarget());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", text.getHyperlinkTooltip());
        this.xmlWriter.addEncodedAttribute("anchorName", text.getAnchorName());
        this.xmlWriter.addAttribute("bookmarkLevel", text.getBookmarkLevel(), 0);
        this.xmlWriter.addAttribute("valueClass", text.getValueClassName());
        this.xmlWriter.addEncodedAttribute("pattern", text.getPattern());
        this.xmlWriter.addAttribute("formatFactoryClass", text.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", text.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", text.getTimeZoneId());
        this.exportReportElement(text);
        this.exportBox(text.getLineBox());
        this.exportFont(text);
        this.exportParagraph(text.getParagraph());
        if (text.getOriginalText() != null) {
            this.xmlWriter.writeCDATAElement("textContent", text.getOriginalText(), "truncateIndex", text.getTextTruncateIndex());
        }
        this.xmlWriter.writeCDATAElement("textTruncateSuffix", text.getTextTruncateSuffix());
        short[] lineBreakOffsets = text.getLineBreakOffsets();
        if (lineBreakOffsets != null) {
            StringBuilder offsetsString = this.formatTextLineBreakOffsets(lineBreakOffsets);
            this.xmlWriter.writeCDATAElement("lineBreakOffsets", offsetsString.toString());
        }
        if (hyperlinkProducerFactory == null) {
            this.exportHyperlinkParameters(text);
        }
        this.xmlWriter.closeElement();
    }

    protected StringBuilder formatTextLineBreakOffsets(short[] lineBreakOffsets) {
        StringBuilder offsetsString = new StringBuilder();
        for (int i = 0; i < lineBreakOffsets.length; ++i) {
            if (i > 0) {
                offsetsString.append(",");
            }
            offsetsString.append(lineBreakOffsets[i]);
        }
        return offsetsString;
    }

    private void exportBox(JRLineBox box) throws IOException {
        if (box != null) {
            this.xmlWriter.startElement("box");
            this.xmlWriter.addAttribute("padding", box.getOwnPadding());
            this.xmlWriter.addAttribute("topPadding", box.getOwnTopPadding());
            this.xmlWriter.addAttribute("leftPadding", box.getOwnLeftPadding());
            this.xmlWriter.addAttribute("bottomPadding", box.getOwnBottomPadding());
            this.xmlWriter.addAttribute("rightPadding", box.getOwnRightPadding());
            this.exportPen("pen", box.getPen());
            this.exportPen("topPen", box.getTopPen());
            this.exportPen("leftPen", box.getLeftPen());
            this.exportPen("bottomPen", box.getBottomPen());
            this.exportPen("rightPen", box.getRightPen());
            this.xmlWriter.closeElement(true);
        }
    }

    private void exportParagraph(JRParagraph paragraph) throws IOException {
        if (paragraph != null) {
            this.xmlWriter.startElement("paragraph");
            this.xmlWriter.addAttribute("lineSpacing", paragraph.getOwnLineSpacing());
            this.xmlWriter.addAttribute("lineSpacingSize", paragraph.getOwnLineSpacingSize());
            this.xmlWriter.addAttribute("firstLineIndent", paragraph.getOwnFirstLineIndent());
            this.xmlWriter.addAttribute("leftIndent", paragraph.getOwnLeftIndent());
            this.xmlWriter.addAttribute("rightIndent", paragraph.getOwnRightIndent());
            this.xmlWriter.addAttribute("spacingBefore", paragraph.getOwnSpacingBefore());
            this.xmlWriter.addAttribute("spacingAfter", paragraph.getOwnSpacingAfter());
            this.xmlWriter.addAttribute("tabStopWidth", paragraph.getOwnTabStopWidth());
            TabStop[] tabStops = paragraph.getTabStops();
            if (tabStops != null && tabStops.length > 0) {
                for (int i = 0; i < tabStops.length; ++i) {
                    this.exportTabStop(tabStops[i]);
                }
            }
            this.xmlWriter.closeElement(true);
        }
    }

    public void exportTabStop(TabStop tabStop) throws IOException {
        if (tabStop != null) {
            this.xmlWriter.startElement("tabStop");
            this.xmlWriter.addAttribute("position", tabStop.getPosition());
            this.xmlWriter.addAttribute("alignment", tabStop.getAlignment());
            this.xmlWriter.closeElement(true);
        }
    }

    protected void exportFont(JRFont font) throws IOException {
        if (font != null) {
            this.xmlWriter.startElement("font");
            this.xmlWriter.addEncodedAttribute("fontName", font.getOwnFontName());
            this.xmlWriter.addAttribute("size", font.getOwnFontsize(), true);
            this.xmlWriter.addAttribute("isBold", font.isOwnBold());
            this.xmlWriter.addAttribute("isItalic", font.isOwnItalic());
            this.xmlWriter.addAttribute("isUnderline", font.isOwnUnderline());
            this.xmlWriter.addAttribute("isStrikeThrough", font.isOwnStrikeThrough());
            this.xmlWriter.addEncodedAttribute("pdfFontName", font.getOwnPdfFontName());
            this.xmlWriter.addEncodedAttribute("pdfEncoding", font.getOwnPdfEncoding());
            this.xmlWriter.addAttribute("isPdfEmbedded", font.isOwnPdfEmbedded());
            this.xmlWriter.closeElement(true);
        }
    }

    protected void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        this.xmlWriter.startElement("frame");
        this.setFrameElementsOffset(frame, true);
        try {
            this.exportReportElement(frame);
            this.exportBox(frame.getLineBox());
            this.exportElements(frame.getElements());
            this.xmlWriter.closeElement();
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private static synchronized int getNextImageId() {
        return imageId++;
    }

    protected void exportHyperlinkParameters(JRPrintHyperlink hyperlink) throws IOException {
        JRPrintHyperlinkParameters hyperlinkParameters = hyperlink.getHyperlinkParameters();
        if (hyperlinkParameters != null) {
            for (JRPrintHyperlinkParameter parameter : hyperlinkParameters.getParameters()) {
                this.exportHyperlinkParameter(parameter);
            }
        }
    }

    protected void exportHyperlinkParameter(JRPrintHyperlinkParameter parameter) throws IOException {
        this.xmlWriter.startElement("hyperlinkParameter");
        this.xmlWriter.addEncodedAttribute("name", parameter.getName());
        this.xmlWriter.addAttribute("class", parameter.getValueClass(), DEFAULT_OBJECT_TYPE);
        if (parameter.getValue() != null) {
            String data = JRValueStringUtils.serialize(parameter.getValueClass(), parameter.getValue());
            this.xmlWriter.writeCDATAElement("hyperlinkParameterValue", data);
        }
        this.xmlWriter.closeElement();
    }

    protected void exportGenericElement(JRGenericPrintElement element) throws IOException {
        GenericElementXmlHandler handler = (GenericElementXmlHandler)GenericElementHandlerEnviroment.getInstance(this.jasperReportsContext).getElementHandler(element.getGenericType(), this.getExporterKey());
        if (handler != null) {
            handler.exportElement((JRXmlExporterContext)this.exporterContext, element);
        } else {
            this.xmlWriter.startElement("genericElement");
            this.exportReportElement(element);
            JRGenericElementType genericType = element.getGenericType();
            this.xmlWriter.startElement("genericElementType");
            this.xmlWriter.addEncodedAttribute("namespace", genericType.getNamespace());
            this.xmlWriter.addEncodedAttribute("name", genericType.getName());
            this.xmlWriter.closeElement();
            Set<String> names = element.getParameterNames();
            for (String name : names) {
                Object value = element.getParameterValue(name);
                this.xmlWriter.startElement("genericElementParameter");
                this.xmlWriter.addAttribute("name", name);
                if (value != null) {
                    String valueClass = value.getClass().getName();
                    boolean builtinSerialization = JRValueStringUtils.hasSerializer(valueClass);
                    if (!builtinSerialization) {
                        boolean bl = builtinSerialization = !XmlValueHandlerUtils.instance().writeToXml(value, this);
                    }
                    if (builtinSerialization) {
                        String data = JRValueStringUtils.serialize(valueClass, value);
                        this.xmlWriter.startElement("genericElementParameterValue");
                        this.xmlWriter.addAttribute("class", valueClass);
                        this.xmlWriter.writeCDATA(data);
                        this.xmlWriter.closeElement();
                    }
                }
                this.xmlWriter.closeElement();
            }
            this.xmlWriter.closeElement();
        }
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return XML_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    public String getExporterKey() {
        return XML_EXPORTER_KEY;
    }

    public JRXmlWriteHelper getXmlWriteHelper() {
        return this.xmlWriter;
    }

    protected boolean isNewerVersionOrEqual(String oldVersion) {
        return this.versionComparator.compare(this.version, oldVersion) >= 0;
    }

    protected boolean isOlderVersionThan(String version) {
        return this.versionComparator.compare(this.version, version) < 0;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXmlExporterContext {
        protected ExporterContext() {
        }
    }
}

