/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.license.model;

import com.mestrelab.license.model.TLicense;
import com.mestrelab.license.util.Constants;

public class TLicenseHolder {
    private TLicense fLicense;
    private Constants.TLicenseError fLicStatus;
    private TLoadLicErr fStatus;
    private String fFilename;

    public TLicenseHolder() {
        this.fStatus = TLoadLicErr.errNotLoad;
    }

    public TLicenseHolder(String filename) {
        this();
        this.fFilename = filename;
    }

    public TLicenseHolder(String filename, TLoadLicErr status) {
        this.fFilename = filename;
        this.fStatus = status;
    }

    public TLicenseHolder(String filename, TLoadLicErr status, TLicense license) {
        this(filename, status);
        this.fLicense = license;
    }

    public TLoadLicErr getfStatus() {
        return this.fStatus;
    }

    public Constants.TLicenseError getfLicStatus() {
        return this.fLicStatus;
    }

    public void setfLicStatus(Constants.TLicenseError fLicStatus) {
        this.fLicStatus = fLicStatus;
    }

    public String getfFilename() {
        return this.fFilename;
    }

    public TLicense getfLicense() {
        return this.fLicense;
    }

    public static String statusString(TLoadLicErr aStatus) {
        switch (aStatus) {
            case errOk: {
                return "License file was loaded successfully";
            }
            case errInvalid: {
                return "License file is invalid";
            }
            case errExpired: {
                return "License file has expired";
            }
            case errAExists: {
                return "Another license for the same product already exists";
            }
        }
        return "License file was not loaded";
    }

    public Boolean isServerBased() {
        return this.fLicense != null && (this.fLicense.getFLicType() == TLicense.TLicType.LIC_FLOATING || this.fLicense.getFLicType() == TLicense.TLicType.LIC_CAMPUS);
    }

    public static enum TLoadLicErr {
        errOk,
        errNotLoad,
        errInvalid,
        errExpired,
        errAExists;

    }
}

