/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.license.model;

import com.mestrelab.license.exception.LicenseException;
import com.mestrelab.license.util.Constants;
import com.mestrelab.license.util.Util;
import com.mestrelab.license.util.crypt.RC4;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.Signature;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TLicense {
    private final int LIC_VER_MAJ = 1;
    private final int LIC_VER_MIN = 0;
    private String fLicVer;
    private UUID fLicId;
    private TLicType fLicType;
    private String[] fHostIds;
    private String fVendor;
    private String fPurchaser;
    private String fName;
    private UUID fUuid;
    private String fVer;
    private int fCount;
    private Date fIssueDate;
    private Date fExpireDate;
    private Date fUpdateDate;
    private byte[] fSign;
    private SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateInstance();
    private static final Logger logger = LoggerFactory.getLogger(TLicense.class);

    public TLicense() {
        this.fCount = Constants.cDefCount;
        this.fVendor = Constants.cDefVendor;
        this.fLicVer = Constants.cCurVer;
        this.fLicType = TLicType.LIC_DEMO;
        this.fLicId = UUID.randomUUID();
        Calendar issue = Calendar.getInstance();
        issue.add(6, -1);
        this.fIssueDate = issue.getTime();
        this.dateFormat.applyPattern("yyyy-MM-dd");
    }

    public String getFLicVer() {
        return this.fLicVer;
    }

    public void setFLicVer(String fLicVer) {
        this.fLicVer = fLicVer;
    }

    public UUID getFLicId() {
        return this.fLicId;
    }

    public void setFLicId(UUID licId) {
        this.fLicId = licId;
    }

    public TLicType getFLicType() {
        return this.fLicType;
    }

    public void setFLicType(TLicType licType) {
        this.fLicType = licType;
    }

    public String[] getFHostIds() {
        return this.fHostIds;
    }

    public void setFHostIds(String[] hostIds) {
        this.fHostIds = hostIds;
    }

    public String getFVendor() {
        return this.fVendor;
    }

    public void setFVendor(String vendor) {
        this.fVendor = vendor;
    }

    public String getFPurchaser() {
        return this.fPurchaser;
    }

    public void setFPurchaser(String purchaser) {
        this.fPurchaser = purchaser;
    }

    public String getFName() {
        return this.fName;
    }

    public void setFName(String name) {
        this.fName = name;
    }

    public UUID getFUuid() {
        return this.fUuid;
    }

    public void setFUuid(UUID uuid) {
        this.fUuid = uuid;
    }

    public String getFVer() {
        return this.fVer;
    }

    public void setFVer(String ver) {
        this.fVer = ver;
    }

    public int getFCount() {
        return this.fCount;
    }

    public void setFCount(int count) {
        this.fCount = count;
    }

    public Date getFIssueDate() {
        return this.fIssueDate;
    }

    public void setFIssueDate(Date issueDate) {
        this.fIssueDate = issueDate;
    }

    public void setFIssueDate(String issueDate) {
        try {
            this.fIssueDate = this.dateFormat.parse(issueDate);
        }
        catch (ParseException e) {
            this.fIssueDate = null;
        }
    }

    public Date getFExpireDate() {
        return this.fExpireDate;
    }

    public String getFExpireDateAsString() {
        return this.getFExpireDate() != null ? this.dateFormat.format(this.getFExpireDate()) : Constants.NO_EXPIRES;
    }

    public String getFExpireDateAsStringLabel() {
        return this.getFExpireDate() != null ? this.dateFormat.format(this.getFExpireDate()) : "NO_EXPIRES";
    }

    public void setFExpireDate(Date expireDate) throws ParseException {
        this.fExpireDate = expireDate;
    }

    public void setFExpireDate(String expireDate) {
        if (expireDate.toLowerCase().equals("forever") || expireDate.toLowerCase().equals("never")) {
            this.fExpireDate = null;
        }
        try {
            this.fExpireDate = this.dateFormat.parse(expireDate);
        }
        catch (ParseException e) {
            this.fExpireDate = null;
        }
    }

    public Date getFUpdateDate() {
        return this.fUpdateDate;
    }

    public String getFUpdateDateAsString() {
        return this.getFUpdateDate() != null ? this.dateFormat.format(this.getFUpdateDate()) : this.getDefaultDate();
    }

    public String getFUpdateDateAsStringLabel() {
        return this.getFUpdateDate() != null ? this.dateFormat.format(this.getFUpdateDate()) : "NO_UPDATE";
    }

    public void setFUpdateDate(Date updateDate) throws ParseException {
        this.fUpdateDate = updateDate;
    }

    public void setFUpdateDate(String updateDate) {
        if (updateDate.toLowerCase().equals("forever") || updateDate.toLowerCase().equals("never")) {
            this.fUpdateDate = new Date();
        }
        try {
            this.fUpdateDate = this.dateFormat.parse(updateDate);
        }
        catch (ParseException e) {
            this.fUpdateDate = null;
        }
    }

    public byte[] getFSign() {
        return this.fSign;
    }

    public void setFSign(byte[] sign) {
        this.fSign = sign;
    }

    public byte[] msgToVerify() {
        try {
            ByteArrayOutputStream file = new ByteArrayOutputStream();
            ByteBuffer licVer = this.getQString(this.getFLicVer());
            file.write(licVer.array());
            file.write(this.getQUuid(this.getFLicId()).array());
            file.write(Integer.valueOf(this.getFLicType().getValue()).byteValue());
            if (this.getFHostIds() != null) {
                ByteBuffer items = ByteBuffer.allocate(4);
                items.putInt(this.getFHostIds().length);
                file.write(items.array());
                for (String host : this.getFHostIds()) {
                    file.write(this.getQString(host.trim()).array());
                }
            }
            file.write(this.getQString(this.getFVendor().trim()).array());
            file.write(this.getQString(this.getFPurchaser().trim()).array());
            file.write(this.getQString(this.getFName().trim()).array());
            file.write(this.getQString(this.getFVer().trim()).array());
            file.write(this.getQUuid(this.getFUuid()).array());
            ByteBuffer number = ByteBuffer.allocate(4);
            number.putInt(this.getFCount());
            file.write(number.array());
            file.write(this.getQString(this.dateFormat.format(this.getFIssueDate())).array());
            String expDate = this.getFExpireDateAsStringLabel();
            file.write(this.getQString(expDate.trim()).array());
            String updDate = this.getFUpdateDateAsStringLabel();
            file.write(this.getQString(updDate).array());
            file.close();
            return file.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean verify(PublicKey publicKey) {
        try {
            Signature signer = Signature.getInstance("SHA1withRSA", "SunJSSE");
            signer.initVerify(publicKey);
            signer.update(this.msgToVerify());
            return signer.verify(this.getFSign());
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage());
            return false;
        }
    }

    public boolean load(String path) {
        File file = new File(path);
        try {
            FileInputStream is = new FileInputStream(file);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            while (((InputStream)is).available() != 0) {
                buffer.write(((InputStream)is).read());
            }
            ((InputStream)is).close();
            byte[] bytes = buffer.toByteArray();
            buffer.close();
            return this.fromXml(bytes);
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage());
            return false;
        }
    }

    private Boolean fromXml(byte[] data) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(data));
            doc.getDocumentElement().normalize();
            this.readLicenseData(doc);
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage());
            return false;
        }
    }

    private void readLicenseData(Document doc) throws LicenseException {
        String lVer = this.readSingleNodeAttribute(doc, "mlic", "version");
        if (!this.checkCurrentVersion(lVer)) {
            throw new LicenseException("Invalid license file");
        }
        this.setFLicVer(lVer);
        String licID = this.readSingleNode(doc, "licid");
        licID = licID.substring(1, licID.length() - 1);
        this.setFLicId(UUID.fromString(licID));
        String type = this.readSingleNode(doc, "type");
        this.setFLicType(TLicense.string2licType(type));
        String[] host = this.readMultipleNode(doc, "hostid");
        this.setFHostIds(host);
        String vendor = this.readSingleNode(doc, "vendor");
        this.setFVendor(vendor);
        String purchaser = this.readSingleNode(doc, "purchaser");
        this.setFPurchaser(purchaser);
        String product = this.readSingleNode(doc, "product");
        this.setFName(product);
        String version = this.readSingleNode(doc, "version");
        this.setFVer(version);
        String uuid = this.readSingleNode(doc, "uuid");
        uuid = uuid.substring(1, uuid.length() - 1);
        this.setFUuid(UUID.fromString(uuid));
        String count = this.readSingleNode(doc, "count");
        this.xmlTag2Count(count);
        String issued = this.readSingleNode(doc, "issued");
        this.setFIssueDate(issued);
        String expires = this.readSingleNode(doc, "expires");
        this.setFExpireDate(expires);
        String update = this.readSingleNode(doc, "update");
        this.setFUpdateDate(update);
        String sign = this.readSingleNode(doc, "sign");
        this.setFSign(Base64.decodeBase64((String)sign));
    }

    private String readSingleNode(Document doc, String tag) throws LicenseException {
        NodeList nodeList = doc.getElementsByTagName(tag);
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new LicenseException("Invalid license file");
        }
        String value = nodeList.item(0).getFirstChild().getNodeValue();
        if (value == null || value.trim().length() == 0) {
            throw new LicenseException("Invalid license file");
        }
        return value.trim();
    }

    private String[] readMultipleNode(Document doc, String tag) throws LicenseException {
        NodeList nodeList = doc.getElementsByTagName(tag);
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new LicenseException("Invalid license file");
        }
        String[] values = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            values[i] = nodeList.item(i).getFirstChild().getNodeValue();
            if (values[i] == null || values[i].trim().length() == 0) {
                throw new LicenseException("Invalid license file");
            }
            values[i] = values[i].trim();
        }
        return values;
    }

    private String readSingleNodeAttribute(Document doc, String tag, String attr) throws LicenseException {
        NodeList nodeList = doc.getElementsByTagName(tag);
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new LicenseException("Invalid license file");
        }
        Node node = nodeList.item(0);
        Node attrNode = node.getAttributes().getNamedItem(attr);
        String value = attrNode.getFirstChild().getNodeValue();
        if (value == null || value.trim().length() == 0) {
            throw new LicenseException("Invalid license file");
        }
        return value;
    }

    public boolean checkCurrentVersion(String aVer) {
        List<Integer> vVer = this.parseVersionString(aVer);
        if (vVer.size() != 2) {
            return false;
        }
        if (vVer.get(0) > 1) {
            return false;
        }
        return vVer.get(0) != 1 || vVer.get(1) >= 0;
    }

    public void xmlTag2Count(String aCount) {
        if (aCount.toLowerCase().equals("unlimited")) {
            this.fCount = Integer.MAX_VALUE;
        }
        try {
            this.fCount = Integer.valueOf(aCount);
        }
        catch (NumberFormatException ex) {
            this.fCount = -1;
        }
    }

    public static TLicType string2licType(String licType) {
        if (licType.equals("evaluation")) {
            return TLicType.LIC_DEMO;
        }
        return TLicType.LIC_SINGLE;
    }

    private String getDefaultDate() {
        Calendar c = Calendar.getInstance();
        c.add(1, 1);
        return this.dateFormat.format(c.getTime());
    }

    private ByteBuffer getQUuid(UUID uid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uid.getMostSignificantBits());
        bb.putLong(uid.getLeastSignificantBits());
        return bb;
    }

    private ByteBuffer getQString(String data) {
        try {
            int len = data.length() * 2;
            ByteBuffer dataQString = ByteBuffer.allocate(len + 4);
            dataQString.putInt(len);
            dataQString.put(data.getBytes("UTF-16BE"));
            return dataQString;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean checkProductVersion(String aProdVer, Date aProdReleaseDate) {
        List<Integer> prodVer = this.parseVersionString(aProdVer);
        if (prodVer.size() == 0) {
            return false;
        }
        List<Integer> licVer = this.parseVersionString(this.fVer);
        if (licVer.size() == 0) {
            return false;
        }
        if (prodVer.size() < 2) {
            return false;
        }
        if (licVer.size() < 2) {
            return false;
        }
        if (prodVer.get(0) > licVer.get(0) || prodVer.get(0) == licVer.get(0) && prodVer.get(1) > licVer.get(1)) {
            return this.checkUpdateDate(aProdReleaseDate);
        }
        return true;
    }

    public List<Integer> parseVersionString(String sVer) {
        String[] vers = sVer.trim().split("\\.");
        ArrayList<Integer> nums = new ArrayList<Integer>();
        for (String sNum : vers) {
            try {
                int num = Integer.parseInt(sNum);
                nums.add(num);
            }
            catch (NumberFormatException ex) {
                nums.clear();
                return nums;
            }
        }
        return nums;
    }

    public Boolean checkUpdateDate(Date aProdReleaseDate) {
        Date today = new Date();
        if (today.before(Constants.cRefDate) || aProdReleaseDate.after(today) || this.fIssueDate.after(today)) {
            return false;
        }
        if (this.fUpdateDate != null && this.fUpdateDate.before(aProdReleaseDate)) {
            return false;
        }
        return true;
    }

    public Boolean checkExpiredDate(Date aProdReleaseDate) {
        Date today = new Date();
        if (today.before(Constants.cRefDate) || aProdReleaseDate.after(today) || this.fIssueDate.after(today)) {
            return false;
        }
        if (this.fExpireDate != null && this.fExpireDate.before(today)) {
            return false;
        }
        return true;
    }

    public Boolean checkExpiredDate() {
        Date today = new Date();
        if (today.before(Constants.cRefDate) || this.fIssueDate.after(today)) {
            return false;
        }
        if (this.fExpireDate != null && this.fExpireDate.before(today)) {
            return false;
        }
        return true;
    }

    public Boolean checkHost() {
        for (String hostId : this.fHostIds) {
            if (!this.checkHostId(hostId).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean checkHostId(String hostID) {
        if (Constants.gHostIdType.equals((Object)Constants.THostIdType.AWS)) {
            String hostAWS = TLicense.getHostId();
            if (hostAWS != null && hostAWS.equals(hostID)) {
                return true;
            }
            return false;
        }
        return this.checkLocalHostId(hostID);
    }

    private Boolean checkLocalHostId(String hostID) {
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                String result;
                byte[] mac;
                NetworkInterface network = nics.nextElement();
                if (network.isVirtual() || network.isLoopback() || (mac = network.getHardwareAddress()) == null || !(result = Util.formatHostId(mac)).equals(hostID)) continue;
                return true;
            }
            return false;
        }
        catch (SocketException uhe) {
            return false;
        }
    }

    public static String getHostId() {
        if (Constants.gHostIdType.equals((Object)Constants.THostIdType.AWS)) {
            byte[] instanceId = TLicense.aws_instanceId();
            if (instanceId != null && instanceId.length > 0) {
                return Util.formatHostId(instanceId);
            }
            return null;
        }
        return TLicense.getLocalHostId();
    }

    private static byte[] aws_instanceId() {
        byte[] cAWSInstanceIdURLEnc = new byte[]{-104, 2, -83, -78, 68, -109, 125, -38, 54, -94, 104, -101, 74, -2, -1, -52, -107, 0, 74, 66, 16, -31, 89, -32, 109, -105, 66, -124, 110, 47, -23, 108, 2, 82, -77, -126, 93, 119, -24, -12, -8, 126, -107, -51, -74, 79, -50, 10, -1, -73, 44};
        RC4 rc4 = new RC4(Constants.cMnovaPluginCryptKey.getBytes());
        byte[] urlEncRC4 = rc4.encrypt(cAWSInstanceIdURLEnc);
        try {
            URL url = new URL(new String(urlEncRC4));
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            Util.sendRequest(c);
            byte[] instanceId = Util.getResponseData(c);
            return instanceId;
        }
        catch (MalformedURLException e) {
            logger.error("AWS ID check: " + e.getLocalizedMessage());
            return null;
        }
        catch (IOException e) {
            logger.error("AWS ID check: " + e.getLocalizedMessage());
            return null;
        }
    }

    private static String getLocalHostId() {
        try {
            InetAddress hostAddress = null;
            hostAddress = Util.isUnix() ? TLicense.getLocalHostLANAddress() : InetAddress.getLocalHost();
            NetworkInterface hostNIC = NetworkInterface.getByInetAddress(hostAddress);
            byte[] mac = hostNIC.getHardwareAddress();
            if (mac != null) {
                return Util.formatHostId(mac);
            }
            return null;
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage());
            return null;
        }
        catch (SocketException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (iface.isLoopback() || iface.isVirtual()) continue;
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (!inetAddr.isLoopbackAddress()) {
                        if (!inetAddr.isSiteLocalAddress()) continue;
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public String toString() {
        String result = "\nLicID: " + this.fLicId + "\nType: " + (Object)((Object)this.fLicType);
        for (int i = 0; i < this.fHostIds.length; ++i) {
            result = result + "\nHostID: " + this.fHostIds[i];
        }
        result = result + "\nVendor: " + this.fVendor + "\nPurchaser: " + this.fPurchaser + "\nProduct: " + this.fName + "\nVersion: " + this.fVer + "\nUuid: " + this.fUuid + "\nCount: " + this.fCount + "\nIssue date: " + this.dateFormat.format(this.fIssueDate) + "\nExpire date: " + this.dateFormat.format(this.fExpireDate) + "\nUpdate date: " + this.dateFormat.format(this.fUpdateDate) + "\nSignature: " + Base64.encodeBase64String((byte[])this.fSign);
        return result;
    }

    public static enum TLicType {
        LIC_DEBUG(-10),
        LIC_INVALID(-1),
        LIC_DEMO(0),
        LIC_SINGLE(1),
        LIC_FLOATING(2),
        LIC_CAMPUS(3);

        private int value;

        private TLicType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

