/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.saas.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static String BCRYPT_HEADER_SPRING4 = "$2a$10$";
    public static String BCRYPT_HEADER_SPRING5 = "$2b$12$";
    static final String HEX_CHR = "0123456789ABCDEF";

    public static Map<String, String> getParametros(String peticion) {
        String total = peticion;
        HashMap<String, String> hash = new HashMap<String, String>();
        String clave = null;
        String valor = null;
        int index1 = 0;
        while ((index1 = total.indexOf("><")) != -1) {
            try {
                clave = total.substring(1, total.indexOf(">"));
                valor = total.substring(total.indexOf(">") + 1, total.indexOf("</"));
                log.info("*************************" + clave + "  " + valor);
                hash.put(clave, valor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            total = total.substring(index1 + 1, total.length());
        }
        return hash;
    }

    public static String hex(int num) {
        String str = "";
        for (int j = 7; j >= 0; --j) {
            str = str + HEX_CHR.charAt(num >> j * 4 & 0xF);
        }
        return str;
    }

    public static int safe_add(int x, int y) {
        int lsw = (x & 0xFFFF) + (y & 0xFFFF);
        int msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return msw << 16 | lsw & 0xFFFF;
    }

    public static int rol(int num, int cnt) {
        return num << cnt | num >>> 32 - cnt;
    }

    public static int ft(int t, int b, int c, int d) {
        if (t < 20) {
            return b & c | ~b & d;
        }
        if (t < 40) {
            return b ^ c ^ d;
        }
        if (t < 60) {
            return b & c | b & d | c & d;
        }
        return b ^ c ^ d;
    }

    public static int kt(int t) {
        return t < 20 ? 1518500249 : (t < 40 ? 1859775393 : (t < 60 ? -1894007588 : -899497514));
    }

    public static String getSHA1(String str) {
        Integer[] x = Utils.str2blks_SHA1(str);
        Integer[] w = new Integer[80];
        int a = 1732584193;
        int b = -271733879;
        int c = -1732584194;
        int d = 271733878;
        int e = -1009589776;
        for (int i = 0; i < x.length; i += 16) {
            int olda = a;
            int oldb = b;
            int oldc = c;
            int oldd = d;
            int olde = e;
            for (int j = 0; j < 80; ++j) {
                w[j] = j < 16 ? x[i + j] : new Integer(Utils.rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1));
                int t = Utils.safe_add(Utils.safe_add(Utils.rol(a, 5), Utils.ft(j, b, c, d)), Utils.safe_add(Utils.safe_add(e, w[j]), Utils.kt(j)));
                e = d;
                d = c;
                c = Utils.rol(b, 30);
                b = a;
                a = t;
            }
            a = Utils.safe_add(a, olda);
            b = Utils.safe_add(b, oldb);
            c = Utils.safe_add(c, oldc);
            d = Utils.safe_add(d, oldd);
            e = Utils.safe_add(e, olde);
        }
        return "u" + Utils.hex(a) + Utils.hex(b) + Utils.hex(c) + Utils.hex(d) + Utils.hex(e);
    }

    public static Integer[] str2blks_SHA1(String str) {
        int i;
        int nblk = (str.length() + 8 >> 6) + 1;
        Integer[] blks = new Integer[nblk * 16];
        for (i = 0; i < nblk * 16; ++i) {
            blks[i] = new Integer(0);
        }
        i = 0;
        for (i = 0; i < str.length(); ++i) {
            blks[i >> 2] = new Integer(blks[i >> 2] | new Character(str.charAt(i)).hashCode() << 24 - i % 4 * 8);
        }
        blks[i >> 2] = new Integer(blks[i >> 2] | 128 << 24 - i % 4 * 8);
        blks[nblk * 16 - 1] = new Integer(str.length() * 8);
        return blks;
    }

    public static String desofuscarPalabraSecreta(String palabraSecOfuscHex, String claveOfuscadoraLong) throws UnsupportedEncodingException {
        try {
            byte[] claveOfuscadoraLongBytes = claveOfuscadoraLong.getBytes("ISO-8859-1");
            byte[] palabraSecOfuscBytes = Utils.hexStringToByteArray(palabraSecOfuscHex, ";");
            byte[] palabraSecretaBytes = Utils.xorArrayBytes(claveOfuscadoraLongBytes, palabraSecOfuscBytes);
            String palabraSecreta = new String(palabraSecretaBytes, "ISO-8859-1");
            return palabraSecreta;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] xorArrayBytes(byte[] operador1, byte[] operador2) throws IllegalArgumentException {
        if (operador1.length > operador2.length) {
            throw new IllegalArgumentException("El operador1 es de longitud mayor que el operador2");
        }
        byte[] resultado = new byte[operador1.length];
        for (int cont = 0; cont < operador1.length; ++cont) {
            resultado[cont] = (byte)(operador1[cont] ^ operador2[cont]);
        }
        return resultado;
    }

    public static byte[] hexStringToByteArray(String lista, String separador) throws NumberFormatException {
        StringTokenizer parser = new StringTokenizer(lista, separador);
        byte[] buffer = new byte[parser.countTokens()];
        int index = 0;
        while (parser.hasMoreTokens()) {
            buffer[index] = (byte)Integer.parseInt(parser.nextToken(), 16);
            ++index;
        }
        return buffer;
    }

    public static String replaceNoNum(String cadena) {
        StringBuffer buffer = new StringBuffer(cadena);
        int cont = 0;
        while (cont < buffer.length()) {
            if (!Character.isDigit(buffer.charAt(cont))) {
                buffer.deleteCharAt(cont);
                continue;
            }
            ++cont;
        }
        return buffer.toString();
    }

    public static String replaceNoNumWhithoutComma(String cadena) {
        StringBuffer buffer = new StringBuffer(cadena);
        int cont = 0;
        while (cont < buffer.length()) {
            if (buffer.charAt(cont) == ',') {
                buffer.deleteCharAt(cont);
                continue;
            }
            ++cont;
        }
        return buffer.toString();
    }

    public static boolean isJSONValid(String jsonInString) {
        try {
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Gson gson = new Gson();
            gson.fromJson(jsonInString, type);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    public static Map<String, String> jsonToMap(String jsonInString) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Gson gson = new Gson();
        return (Map)gson.fromJson(jsonInString, type);
    }

    public static String mapToJson(Map<String, String> map) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Gson gson = new Gson();
        return gson.toJson(map, type);
    }
}

