/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.saas.to;

import com.mestrelab.saas.Constants;
import com.mestrelab.saas.to.LicenseTO;
import com.mestrelab.saas.to.ResponseTO;
import com.mestrelab.saas.to.UserTO;
import com.mestrelab.saas.util.Utils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TenantTO
extends ResponseTO
implements Serializable {
    private String id;
    private Long tenantId;
    private String name;
    private String parameters;
    private String appName;
    private String notifications;
    private String comments;
    private Boolean enabled;
    private List<UserTO> userTOs;
    private List<LicenseTO> licenseTOs;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParameters() {
        return this.parameters;
    }

    public Map<String, String> getMapParameters() {
        return TenantTO.getMapParameters(this.parameters);
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getNotifications() {
        return this.notifications;
    }

    public void setNotifications(String notifications) {
        this.notifications = notifications;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public List<UserTO> getUserTOs() {
        return this.userTOs;
    }

    public void setUserTOs(List<UserTO> userTOs) {
        this.userTOs = userTOs;
    }

    public List<LicenseTO> getLicenseTOs() {
        return this.licenseTOs;
    }

    public void setLicenseTOs(List<LicenseTO> licenseTOs) {
        this.licenseTOs = licenseTOs;
    }

    @Override
    public String toString() {
        return super.toString() + "TenantTO [id=" + this.id + ", name=" + this.name + ", parameters=" + this.parameters + ", appName=" + this.appName + ", notifications=" + this.notifications + ", comments=" + this.comments + ", enabled=" + this.enabled + ", userTOs=" + this.userTOs + ", licenseTOs=" + this.licenseTOs + "]";
    }

    public int getUsersAllowed() {
        Map<String, String> mapParameters = TenantTO.getMapParameters(this.parameters);
        if (mapParameters.isEmpty() || mapParameters.keySet().size() < 2) {
            return 0;
        }
        int usersEnabled = 0;
        if (mapParameters.containsKey(Constants.USER_COUNT_LIMIT)) {
            usersEnabled = Integer.valueOf(mapParameters.get(Constants.USER_COUNT_LIMIT));
        }
        return usersEnabled;
    }

    public static Map<String, String> getMapParameters(String parameters) {
        Map<String, String> result = new HashMap<String, String>();
        if (!Utils.isJSONValid(parameters)) {
            if (parameters != null) {
                String[] params;
                for (String param : params = parameters.split(",")) {
                    if (param == null) continue;
                    String[] keyValue = param.split(":");
                    if (keyValue.length == 1) {
                        result.put(keyValue[0].trim(), "");
                        continue;
                    }
                    if (keyValue.length <= 1 || keyValue[1].trim().isEmpty()) continue;
                    result.put(keyValue[0].trim(), keyValue[1].trim());
                }
            }
        } else {
            result = Utils.jsonToMap(parameters);
        }
        return result;
    }

    public static String parametersToString(Map<String, String> parametersMap) {
        if (parametersMap != null) {
            if (!parametersMap.containsKey(Constants.USER_STORAGE_LIMIT)) {
                parametersMap.put(Constants.USER_STORAGE_LIMIT, "0M");
            }
            if (!parametersMap.containsKey(Constants.USER_COUNT_LIMIT)) {
                parametersMap.put(Constants.USER_COUNT_LIMIT, "0");
            }
            if (!parametersMap.containsKey(Constants.DOMAIN_RESTRICTION)) {
                parametersMap.put(Constants.DOMAIN_RESTRICTION, "");
            }
            return Utils.mapToJson(parametersMap);
        }
        return "";
    }

    public UserTO getUser(String username) {
        for (UserTO user : this.userTOs) {
            if (!user.getUsername().toLowerCase().equals(username.toLowerCase())) continue;
            return user;
        }
        return null;
    }
}

