/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.saas;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.mestrelab.saas.Constants;
import com.mestrelab.saas.TenantDAO;
import com.mestrelab.saas.exception.DuplicateInstanceException;
import com.mestrelab.saas.exception.HwInstanceNotFoundException;
import com.mestrelab.saas.exception.InstanceNotFoundException;
import com.mestrelab.saas.exception.InternalErrorException;
import com.mestrelab.saas.exception.UserInstanceNotFoundException;
import com.mestrelab.saas.to.HwOEMTO;
import com.mestrelab.saas.to.LicenseTO;
import com.mestrelab.saas.to.MopsTO;
import com.mestrelab.saas.to.TenantTO;
import com.mestrelab.saas.to.TypeError;
import com.mestrelab.saas.to.UserTO;
import com.mestrelab.saas.util.Utils;
import com.sforce.soap.enterprise.sobject.wsc.Asset;
import com.sforce.soap.enterprise.sobject.wsc.CampaignMember;
import com.sforce.soap.enterprise.sobject.wsc.Contact;
import com.sforce.soap.enterprise.sobject.wsc.EmailTemplate;
import com.sforce.soap.enterprise.sobject.wsc.Host_ID__c;
import com.sforce.soap.enterprise.sobject.wsc.Lead;
import com.sforce.soap.enterprise.sobject.wsc.LicenseHostAssociation__c;
import com.sforce.soap.enterprise.sobject.wsc.License__c;
import com.sforce.soap.enterprise.sobject.wsc.MOPSLog__c;
import com.sforce.soap.enterprise.sobject.wsc.MOrder__c;
import com.sforce.soap.enterprise.sobject.wsc.Note;
import com.sforce.soap.enterprise.sobject.wsc.OrgWideEmailAddress;
import com.sforce.soap.enterprise.sobject.wsc.PricebookEntry;
import com.sforce.soap.enterprise.sobject.wsc.Product2;
import com.sforce.soap.enterprise.sobject.wsc.ProductMap__c;
import com.sforce.soap.enterprise.sobject.wsc.SObject;
import com.sforce.soap.enterprise.sobject.wsc.SaaSForm__c;
import com.sforce.soap.enterprise.sobject.wsc.SaasUserHostAssociation__c;
import com.sforce.soap.enterprise.sobject.wsc.Saas_Tenant__c;
import com.sforce.soap.enterprise.sobject.wsc.Saas_User__c;
import com.sforce.soap.enterprise.wsc.Connector;
import com.sforce.soap.enterprise.wsc.DeleteResult;
import com.sforce.soap.enterprise.wsc.Email;
import com.sforce.soap.enterprise.wsc.EnterpriseConnection;
import com.sforce.soap.enterprise.wsc.QueryResult;
import com.sforce.soap.enterprise.wsc.SaveResult;
import com.sforce.soap.enterprise.wsc.SendEmailResult;
import com.sforce.soap.enterprise.wsc.SingleEmailMessage;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.StringUtils;

public class TenantDAOSFImpl
implements TenantDAO {
    private final Logger log = LoggerFactory.getLogger(TenantDAOSFImpl.class);
    private static final int numberDevices = 3;
    private static final String purchaseData = "purchaseData";
    private final List<String> productListpercert = new ArrayList<String>();
    private static final double percent = 0.7;
    private static final String anonymousAddressFormat = "@anonymous.mestrelab.com";
    private static final String appNameTablet = "MNVTAB010101";
    private static final long dateCompare = 86400000L;
    static final Semaphore semaphore = new Semaphore(1);
    private static final String PARAMETERS_PK = "USER_STORAGE_LIMIT:0M,USER_COUNT_LIMIT:1,DOMAIN_RESTRICTION:";
    private static final String LEAD_SOURCE = "ChemDraw User";
    private static final String MNOVALITEPK_CAMPAIGN_ID = "70157000001aR3g";
    private static final String MNOVALITEPK_STATUS_NOT_CONTACTED = "Not contacted";
    private static final String MNOVA_LITE_LICENSE_NAME = "Mnova Lite ChemDraw Edition";
    private static final String MNOVA_LITE_LICENSE_CODE = "LITCH060101";
    private static final String MNOVA_LITE_LICENSE_ID = "01t57000006kY0Q";
    private static final String MNOVA_LITE_CAMPUS_LICENSE_NAME = "Mnova Lite ChemDraw Campus Edition";
    private static final String MNOVA_LITE_CAMPUS_LICENSE_CODE = "LITCH060199";
    private static final String MNOVA_LITE_CAMPUS_LICENSE_ID = "01t57000006kYFF";
    private static final String MNOVALITEPK_TEMPLATE_REGISTER = "00X570000027R5UEAU";
    private static final String MNOVALITEPK_CAMPUS_TEMPLATE_REGISTER = "00X570000027R5ZEAU";
    private static final String MNOVALITEPK_TEMPLATE_REVOKEHW = "00X570000027R3xEAE";
    private static final String EMAIL_SALESFORCE = "api.salesforce@mestrelab.com";

    public TenantDAOSFImpl() {
        this.productListpercert.add(appNameTablet);
    }

    public EnterpriseConnection getSFconnection() {
        try {
            ConnectorConfig config = new ConnectorConfig();
            config.setUsername(Constants.cUSERNAME_SF);
            config.setPassword(Constants.cPASSWORD_SF);
            EnterpriseConnection connection = Connector.newConnection((ConnectorConfig)config);
            return connection;
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            return this.getSFconnection();
        }
    }

    @Override
    public Long createTenant(String name, String parameters, String appNameKey, Boolean isEnabled, String notifications, String email) throws InternalErrorException {
        return this.createTenant(name, parameters, appNameKey, "", isEnabled, notifications, email);
    }

    @Override
    public Long createTenant(String name, String parameters, String appNameKey, String comment, Boolean isEnabled, String notifications, String email) throws InternalErrorException {
        EnterpriseConnection connection = this.getSFconnection();
        return this.createTenant(connection, name, parameters, appNameKey, comment, isEnabled, notifications, email);
    }

    private Long createTenant(EnterpriseConnection connection, String name, String parameters, String appNameKey, String comment, Boolean isEnabled, String notifications, String email) throws InternalErrorException {
        block6: {
            try {
                ProductMap__c productMap = this.getProductMap(connection, appNameKey);
                if (productMap == null) {
                    throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
                }
                Saas_Tenant__c saasTenant = new Saas_Tenant__c();
                saasTenant.setParameters__c(Utils.mapToJson(TenantTO.getMapParameters(parameters)));
                saasTenant.setAppName__c(appNameKey);
                saasTenant.setComment__c(comment);
                saasTenant.setEnabled__c(isEnabled);
                saasTenant.setNotifications__c(notifications);
                Saas_Tenant__c[] records = new Saas_Tenant__c[]{saasTenant};
                SaveResult[] saveResults = connection.create((SObject[])records);
                if (saveResults != null && saveResults.length > 0) {
                    if (saveResults[0].isSuccess()) {
                        QueryResult queryResults = connection.query("SELECT Id, IdTenant__c  FROM Saas_Tenant__c where Id = '" + saveResults[0].getId() + "' LIMIT 1");
                        if (queryResults.getSize() > 0) {
                            Saas_Tenant__c tenantRet = (Saas_Tenant__c)queryResults.getRecords()[0];
                            return Long.valueOf(tenantRet.getIdTenant__c());
                        }
                        break block6;
                    }
                    throw new InternalErrorException((Object)saveResults[0].getErrors()[0].getMessage(), this.getClass().getName());
                }
                throw new InternalErrorException(saveResults, "SaveResult array is null");
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
        return null;
    }

    private Saas_Tenant__c createTenantReturnObject(EnterpriseConnection connection, String name, String parameters, String appNameKey, String comment, Boolean isEnabled, String notifications) throws InternalErrorException {
        block6: {
            try {
                ProductMap__c productMap = this.getProductMap(connection, appNameKey);
                if (productMap == null) {
                    throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
                }
                Saas_Tenant__c saasTenant = new Saas_Tenant__c();
                saasTenant.setParameters__c(Utils.mapToJson(TenantTO.getMapParameters(parameters)));
                saasTenant.setAppName__c(appNameKey);
                saasTenant.setComment__c(comment);
                saasTenant.setEnabled__c(isEnabled);
                saasTenant.setNotifications__c(notifications);
                Saas_Tenant__c[] records = new Saas_Tenant__c[]{saasTenant};
                SaveResult[] saveResults = connection.create((SObject[])records);
                if (saveResults != null && saveResults.length > 0) {
                    if (saveResults[0].isSuccess()) {
                        QueryResult queryResults = connection.query("SELECT Id, IdTenant__c  FROM Saas_Tenant__c where Id = '" + saveResults[0].getId() + "' LIMIT 1");
                        if (queryResults.getSize() > 0) {
                            Saas_Tenant__c tenantRet = (Saas_Tenant__c)queryResults.getRecords()[0];
                            return tenantRet;
                        }
                        break block6;
                    }
                    throw new InternalErrorException(saveResults[0].getErrors(), this.getClass().getName());
                }
                throw new InternalErrorException(saveResults, "SaveResult array is null");
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
        return null;
    }

    private String createUserCopy(EnterpriseConnection connection, Long tenantId, String username, String passwd, String comments, Boolean enabled) throws InternalErrorException {
        block6: {
            try {
                if (!this.isValidEmailAddress(username)) {
                    throw new InternalErrorException(tenantId, username + ": is not a valid email address");
                }
                Saas_User__c saasUser = new Saas_User__c();
                saasUser.setUsername__c(username);
                saasUser.setPasswd__c(passwd == null ? "" : passwd);
                saasUser.setComment__c(comments == null ? "" : comments);
                String userId = this.generateUserId();
                saasUser.setUserId__c(userId.toLowerCase());
                saasUser.setName(username);
                saasUser.setEnabled__c(enabled);
                QueryResult queryResults = connection.query("SELECT Id, IdTenant__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
                if (queryResults.getSize() > 0) {
                    Saas_Tenant__c tenantRet = (Saas_Tenant__c)queryResults.getRecords()[0];
                    saasUser.setTenantId__c(tenantRet.getId());
                    Saas_User__c[] records = new Saas_User__c[]{saasUser};
                    SaveResult[] saveResults = connection.create((SObject[])records);
                    if (saveResults != null && saveResults.length > 0) {
                        if (saveResults[0].isSuccess()) {
                            return saasUser.getUserId__c();
                        }
                        throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
                    }
                    break block6;
                }
                throw new InternalErrorException(tenantId, "IdTenant does not exist");
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
        return null;
    }

    private String createUser(EnterpriseConnection connection, Long tenantId, String username, String passwd, String comments, Boolean enabled) throws InternalErrorException {
        block9: {
            try {
                if (!this.isValidEmailAddress(username)) {
                    throw new InternalErrorException(tenantId, username + ": is not a valid email address");
                }
                Saas_User__c saasUser = new Saas_User__c();
                saasUser.setUsername__c(username);
                if (passwd == null) {
                    passwd = "";
                }
                if (this.isAlreadyEncoded(passwd)) {
                    saasUser.setPasswd__c(passwd);
                } else {
                    saasUser.setPasswd__c(this.encryptPassword(passwd));
                }
                saasUser.setComment__c(comments == null ? "" : comments);
                String userId = this.generateUserId();
                saasUser.setUserId__c(userId.toLowerCase());
                saasUser.setName(username);
                saasUser.setEnabled__c(enabled);
                QueryResult queryResults = connection.query("SELECT Id, IdTenant__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
                if (queryResults.getSize() > 0) {
                    Saas_Tenant__c tenantRet = (Saas_Tenant__c)queryResults.getRecords()[0];
                    saasUser.setTenantId__c(tenantRet.getId());
                    Saas_User__c[] records = new Saas_User__c[]{saasUser};
                    SaveResult[] saveResults = connection.create((SObject[])records);
                    if (saveResults != null && saveResults.length > 0) {
                        if (saveResults[0].isSuccess()) {
                            return saasUser.getUserId__c();
                        }
                        throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
                    }
                    break block9;
                }
                throw new InternalErrorException(tenantId, "IdTenant does not exist");
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
        return null;
    }

    @Override
    public String createUser(Long tenantId, String username, String passwd, String comments, Boolean enabled) throws InternalErrorException {
        EnterpriseConnection connection = this.getSFconnection();
        return this.createUser(connection, tenantId, username, passwd, comments, enabled);
    }

    @Override
    public void moveUserTenant(Long tenantId, String username, String appNameKey, String comments) throws InternalErrorException, InstanceNotFoundException {
        EnterpriseConnection connection = this.getSFconnection();
        this.moveUserTenant(connection, tenantId, username, appNameKey, comments);
    }

    private void moveUserTenant(EnterpriseConnection connection, Long tenantId, String username, String appNameKey, String comments) throws InternalErrorException, InstanceNotFoundException {
        block8: {
            try {
                if (!this.isValidEmailAddress(username)) {
                    throw new InternalErrorException(tenantId, username + ": is not a valid email address");
                }
                Saas_User__c saasUser = new Saas_User__c();
                UserTO currentUserTO = this.getUser(connection, username, appNameKey);
                QueryResult queryResults = connection.query("SELECT Id,Name,AppName__c, IdTenant__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
                if (queryResults.getSize() > 0) {
                    Saas_Tenant__c tenantRet = (Saas_Tenant__c)queryResults.getRecords()[0];
                    saasUser.setTenantId__c(tenantRet.getId());
                    saasUser.setId(currentUserTO.getId());
                    Saas_User__c[] records = new Saas_User__c[]{saasUser};
                    SaveResult[] saveResults = connection.update((SObject[])records);
                    if (saveResults == null || saveResults.length <= 0) break block8;
                    if (saveResults[0].isSuccess()) {
                        LicenseTO newLicense = this.getLicense(connection, tenantId);
                        List<HwOEMTO> currentUserHw = currentUserTO.getHwOEMTOs();
                        String ids = "";
                        LicenseTO currentLicense = this.getLicense(connection, (long)currentUserTO.getTenantId());
                        for (HwOEMTO hw : currentUserHw) {
                            ids = ids + "'" + hw.getHwOEMId() + "',";
                        }
                        if ((ids = ids.substring(0, ids.length() - 1)).length() > 0 && (queryResults = connection.query("SELECT Id,Name, Host_ID__c,License__c,Host_ID__r.hwOEMId__c  FROM LicenseHostAssociation__c where Host_ID__r.hwOEMId__c  in (" + ids + ") and license__c='" + currentLicense.getId() + "'")).getSize() > 0) {
                            ArrayList<LicenseHostAssociation__c> licUpdate = new ArrayList<LicenseHostAssociation__c>();
                            ArrayList<String> idToRemove = new ArrayList<String>();
                            for (SObject object : queryResults.getRecords()) {
                                LicenseHostAssociation__c newlicHost = new LicenseHostAssociation__c();
                                LicenseHostAssociation__c lic_Host = (LicenseHostAssociation__c)object;
                                newlicHost.setLicense__c(newLicense.getId());
                                newlicHost.setHost_ID__c(lic_Host.getHost_ID__c());
                                newlicHost.setName(tenantRet.getName() + lic_Host.getHost_ID__r().getHwOEMId__c());
                                newlicHost.setEnabled__c(Boolean.valueOf(true));
                                licUpdate.add(newlicHost);
                                idToRemove.add(lic_Host.getId());
                            }
                            connection.create((SObject[])licUpdate.toArray(new LicenseHostAssociation__c[0]));
                            connection.delete(idToRemove.toArray(new String[0]));
                        }
                        break block8;
                    }
                    throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
                }
                throw new InternalErrorException(tenantId, "IdTenant does not exist");
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
    }

    @Override
    public Boolean deleteTenant(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        block4: {
            try {
                EnterpriseConnection connection = this.getSFconnection();
                QueryResult queryResults = connection.query("SELECT Id, IdTenant__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
                if (queryResults.getSize() > 0) {
                    String[] ids = new String[]{queryResults.getRecords()[0].getId()};
                    DeleteResult[] deleteResults = connection.delete(ids);
                    if (deleteResults.length > 0) {
                        return deleteResults[0].getSuccess();
                    }
                    break block4;
                }
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
        return false;
    }

    @Override
    public Boolean deleteUser(String idUser) throws InstanceNotFoundException, InternalErrorException {
        block4: {
            try {
                EnterpriseConnection connection = this.getSFconnection();
                QueryResult queryResults = connection.query("SELECT Id, username__c  FROM Saas_User__c where userId__c='" + idUser + "' LIMIT 1");
                if (queryResults.getSize() > 0) {
                    String[] ids = new String[]{queryResults.getRecords()[0].getId()};
                    DeleteResult[] deleteResults = connection.delete(ids);
                    if (deleteResults.length > 0) {
                        return deleteResults[0].getSuccess();
                    }
                    break block4;
                }
                throw new InstanceNotFoundException((Object)idUser, this.getClass().getName());
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
        return false;
    }

    @Override
    public Boolean enableSaaS() {
        return Constants.cENABLE_SAAS.equals("1");
    }

    @Override
    public String getTenantComments(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, IdTenant__c,comment__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                return saasTenant.getComment__c();
            }
            throw new InstanceNotFoundException(tenantId, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public String getUserComments(String userId__c) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, comment__c  FROM Saas_User__c where userId__c='" + userId__c + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasTenant = (Saas_User__c)queryResults.getRecords()[0];
                return saasTenant.getComment__c();
            }
            throw new InstanceNotFoundException((Object)userId__c, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public String getTenantAppName(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, IdTenant__c,appName__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                return saasTenant.getAppName__c();
            }
            throw new InstanceNotFoundException(tenantId, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public String getTenantNotifications(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, IdTenant__c,notifications__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                return saasTenant.getNotifications__c();
            }
            throw new InstanceNotFoundException(tenantId, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public Long getTenantId(String username, String appNameKey) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            QueryResult queryResults = connection.query("SELECT Id, username__c , tenantId__r.IdTenant__c  FROM Saas_User__c where username__c='" + username + "' and tenantId__r.appName__c ='" + appNameKey + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasUser = (Saas_User__c)queryResults.getRecords()[0];
                return Long.valueOf(saasUser.getTenantId__r().getIdTenant__c());
            }
            throw new InstanceNotFoundException((Object)username, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public Map<String, String> getTenantParameters(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, IdTenant__c,parameters__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                return TenantTO.getMapParameters(saasTenant.getParameters__c());
            }
            throw new InstanceNotFoundException(tenantId, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public String getTenantName(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, IdTenant__c,name  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                return saasTenant.getName();
            }
            throw new InstanceNotFoundException(tenantId, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public String getUserId(String username, String appNameKey) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            QueryResult queryResults = connection.query("SELECT Id, username__c , userId__c,passwd__c, comment__c,tenantId__r.IdTenant__c,enabled__c   FROM Saas_User__c where username__c='" + username + "' and tenantId__r.appName__c ='" + appNameKey + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasUser = (Saas_User__c)queryResults.getRecords()[0];
                return saasUser.getUserId__c();
            }
            throw new InstanceNotFoundException((Object)username, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private String getUserName(EnterpriseConnection connection, String userId) throws InstanceNotFoundException, InternalErrorException {
        try {
            QueryResult queryResults = connection.query("SELECT Id, username__c , userId__c  FROM Saas_User__c where userId__c='" + userId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasUser = (Saas_User__c)queryResults.getRecords()[0];
                return saasUser.getUsername__c();
            }
            throw new InstanceNotFoundException((Object)userId, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public String getUserName(String userId) throws InstanceNotFoundException, InternalErrorException {
        EnterpriseConnection connection = this.getSFconnection();
        return this.getUserName(connection, userId);
    }

    @Override
    public Boolean isEnabled(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, IdTenant__c,enabled__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                return saasTenant.getEnabled__c();
            }
            throw new InstanceNotFoundException(tenantId, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public void setTenant(Long tenantId, String name, String parameters, String appNameKey, Boolean isEnabled, String notifications) throws InstanceNotFoundException, InternalErrorException {
        this.setTenant(tenantId, name, parameters, appNameKey, "", isEnabled, notifications);
    }

    @Override
    public void setTenant(Long tenantId, String name, String parameters, String appNameKey, String comment, Boolean isEnabled, String notifications) throws InstanceNotFoundException, InternalErrorException {
        block5: {
            try {
                EnterpriseConnection connection = this.getSFconnection();
                ProductMap__c productMap = this.getProductMap(connection, appNameKey);
                if (productMap == null) {
                    throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
                }
                QueryResult queryResults = connection.query("SELECT Id, enabled__c,comment__c,parameters__c,appName__c,notifications__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
                if (queryResults.getSize() > 0) {
                    Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                    saasTenant.setName(name);
                    saasTenant.setParameters__c(Utils.mapToJson(TenantTO.getMapParameters(parameters)));
                    saasTenant.setAppName__c(appNameKey);
                    saasTenant.setComment__c(comment);
                    saasTenant.setEnabled__c(isEnabled);
                    saasTenant.setNotifications__c(notifications);
                    Saas_Tenant__c[] objs = new Saas_Tenant__c[]{saasTenant};
                    SaveResult[] saveResults = connection.update((SObject[])objs);
                    if (saveResults.length > 0 && !saveResults[0].getSuccess()) {
                        throw new InternalErrorException(saveResults[0].getErrors()[0], "error saving Tenant");
                    }
                    break block5;
                }
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
    }

    @Override
    public void setUser(String userId, Long tenantId, String username, String passwd, String comments, Boolean enabled) throws InstanceNotFoundException, InternalErrorException {
        block8: {
            try {
                if (!this.isValidEmailAddress(username)) {
                    throw new InternalErrorException(tenantId, username + ": is not a valid email address");
                }
                EnterpriseConnection connection = this.getSFconnection();
                QueryResult queryResults = connection.query("SELECT Id, username__c ,passwd__c, comment__c,tenantId__c,enabled__c   FROM Saas_User__c where userId__c='" + userId + "' LIMIT 1");
                QueryResult queryResultsUser = connection.query("SELECT Id, IdTenant__c,enabled__c  FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
                if (queryResults.getSize() > 0 && queryResultsUser.getSize() > 0) {
                    Saas_User__c saasUser = (Saas_User__c)queryResults.getRecords()[0];
                    Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResultsUser.getRecords()[0];
                    saasUser.setTenantId__c(saasTenant.getId());
                    saasUser.setUsername__c(username);
                    if (passwd != null && !passwd.isEmpty()) {
                        if (!this.isAlreadyEncoded(passwd)) {
                            saasUser.setPasswd__c(this.encryptPassword(passwd));
                        } else {
                            saasUser.setPasswd__c(passwd);
                        }
                    }
                    saasUser.setComment__c(comments);
                    saasUser.setEnabled__c(enabled);
                    Saas_User__c[] objs = new Saas_User__c[]{saasUser};
                    SaveResult[] saveResults = connection.update((SObject[])objs);
                    if (saveResults.length > 0 && !saveResults[0].getSuccess()) {
                        throw new InternalErrorException(saveResults[0].getErrors()[0], "error saving User");
                    }
                    break block8;
                }
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
    }

    private boolean isAlreadyEncoded(String pass) {
        return StringUtils.startsWithIgnoreCase((String)pass, (String)Utils.BCRYPT_HEADER_SPRING4) || StringUtils.startsWithIgnoreCase((String)pass, (String)Utils.BCRYPT_HEADER_SPRING5);
    }

    @Override
    @Deprecated
    public String getUserPasswd(String userId__c) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, passwd__c  FROM Saas_User__c where userId__c='" + userId__c + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasTenant = (Saas_User__c)queryResults.getRecords()[0];
                return this.decryptPassword(saasTenant.getPasswd__c());
            }
            throw new InstanceNotFoundException((Object)userId__c, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    @Deprecated
    public String decryptPassword(String password) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(Constants.cPASSENCRYPT);
        String result = password;
        try {
            return encryptor.decrypt(result);
        }
        catch (EncryptionOperationNotPossibleException e) {
            return "";
        }
    }

    @Override
    public String encryptPassword(String password) {
        BCryptPasswordEncoder encryptEncoder = new BCryptPasswordEncoder();
        return encryptEncoder.encode((CharSequence)password);
    }

    @Override
    public Boolean checkPassword(String password, String passwordUser) throws InstanceNotFoundException, InternalErrorException {
        BCryptPasswordEncoder encryptEncoder = new BCryptPasswordEncoder();
        return encryptEncoder.matches((CharSequence)password, passwordUser);
    }

    @Override
    public void setRegistryLogin(UserTO userTO, Boolean result) throws InstanceNotFoundException, InternalErrorException {
        EnterpriseConnection connection = this.getSFconnection();
        this.setRegistryLogin(connection, userTO, result);
    }

    private void setRegistryLogin(EnterpriseConnection connection, UserTO userTO, Boolean result) throws InstanceNotFoundException, InternalErrorException {
        try {
            Saas_User__c saasUser = new Saas_User__c();
            saasUser.setId(userTO.getId());
            saasUser.setName(userTO.getName());
            Saas_User__c[] objs = new Saas_User__c[]{saasUser};
            SaveResult[] saveResults = connection.update((SObject[])objs);
            if (saveResults.length > 0 && !saveResults[0].getSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public Boolean isUserEnabled(String userId__c) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, enabled__c  FROM Saas_User__c where userId__c='" + userId__c + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasTenant = (Saas_User__c)queryResults.getRecords()[0];
                return saasTenant.getEnabled__c();
            }
            throw new InstanceNotFoundException((Object)userId__c, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private boolean isValidEmailAddress(String email) {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    @Override
    public TenantTO getTenantFaster(String username, String appNameKey) throws InstanceNotFoundException, InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            UserTO userTO = this.getUserFaster(connection, username, appNameKey);
            QueryResult queryResults = connection.query("SELECT Id,Name, IdTenant__c,appName__c,comment__c,enabled__c,notifications__c,parameters__c,(select Id, Name, enabled__c,comment__c,passwd__c,tenantId__r.IdTenant__c ,userId__c,username__c from Saas_Tenant__c.Saas_Users__r ),(select Id, Name,Asset__c,Enable_SaaS__c,LicenseId__c,MOPS__c,notifyExpiredTrial__c,Saas_Tenant__c,usageEndDate__c,usageStartDate__c  from Saas_Tenant__c.Licenses__r  where Enable_SaaS__c=true order by usageEndDate__c desc,CreatedDate desc)  FROM Saas_Tenant__c where IdTenant__c='" + userTO.getTenantId() + "'");
            if (queryResults.getSize() > 0) {
                int i;
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                TenantTO tenant = new TenantTO();
                tenant.setAppName(appNameKey);
                tenant.setComments(saasTenant.getComment__c());
                tenant.setEnabled(saasTenant.getEnabled__c());
                tenant.setId(saasTenant.getId());
                tenant.setName(saasTenant.getName());
                tenant.setNotifications(saasTenant.getNotifications__c());
                tenant.setParameters(saasTenant.getParameters__c());
                tenant.setTenantId(Long.valueOf(saasTenant.getIdTenant__c()));
                tenant.setUserTOs(new ArrayList<UserTO>());
                if (saasTenant.getSaas_Users__r() != null) {
                    SObject[] usersTenant = saasTenant.getSaas_Users__r().getRecords();
                    for (i = 0; i < usersTenant.length; ++i) {
                        Saas_User__c userTenant = (Saas_User__c)usersTenant[i];
                        UserTO u = new UserTO();
                        u.setComments(userTenant.getComment__c());
                        u.setEnabled(userTenant.getEnabled__c());
                        u.setId(userTenant.getId());
                        u.setUserId(userTenant.getUserId__c());
                        u.setName(userTenant.getName());
                        u.setUsername(userTenant.getUsername__c());
                        u.setPassword(userTenant.getPasswd__c());
                        u.setTenantId(Long.valueOf(userTenant.getTenantId__r().getIdTenant__c()));
                        u.setTypeResponse(TypeError.NoError);
                        List<UserTO> users = tenant.getUserTOs();
                        if (userTO.getId().equals(u.getId())) {
                            users.add(userTO);
                        } else {
                            users.add(u);
                        }
                        tenant.setUserTOs(users);
                    }
                }
                tenant.setLicenseTOs(new ArrayList<LicenseTO>());
                if (saasTenant.getLicenses__r() != null) {
                    SObject[] licensesTenant = saasTenant.getLicenses__r().getRecords();
                    for (i = 0; i < licensesTenant.length; ++i) {
                        License__c licenseTenant = (License__c)licensesTenant[i];
                        LicenseTO l = new LicenseTO();
                        l.setAssetId(licenseTenant.getAsset__c());
                        l.setEnableSaaS(licenseTenant.getEnable_SaaS__c());
                        l.setId(licenseTenant.getId());
                        l.setMops(licenseTenant.getMOPS__c());
                        l.setTenantId(licenseTenant.getSaas_Tenant__c());
                        l.setName(licenseTenant.getName());
                        l.setNotifyExpiredTrial(licenseTenant.getNotifyExpiredTrial__c());
                        l.setUsageEndDate(licenseTenant.getUsageEndDate__c());
                        l.setUsageStartDate(licenseTenant.getUsageStartDate__c());
                        l.setTypeResponse(TypeError.NoError);
                        List<LicenseTO> licenses = tenant.getLicenseTOs();
                        licenses.add(l);
                        tenant.setLicenseTOs(licenses);
                    }
                }
                tenant.setTypeResponse(TypeError.NoError);
                return tenant;
            }
            throw new InstanceNotFoundException((Object)username, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public UserTO getUserFaster(EnterpriseConnection connection, String username, String appNameKey) throws InstanceNotFoundException, InternalErrorException {
        try {
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            QueryResult queryResults = connection.query("SELECT Id, Name, enabled__c,comment__c,passwd__c,tenantId__r.IdTenant__c ,userId__c,username__c,(select id, Name,enabled__c, hostId__r.Id,hostId__r.Name,hostId__r.hwOEMId__c,hostId__r.hwOEMName__c,hostId__r.mobile__c from Saas_User__c.SaasUserHostAssociations__r)  FROM Saas_User__c where username__c='" + username + "' and tenantId__r.appName__c ='" + appNameKey + "'");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasUser = (Saas_User__c)queryResults.getRecords()[0];
                UserTO u = new UserTO();
                u.setComments(saasUser.getComment__c());
                u.setEnabled(saasUser.getEnabled__c());
                u.setId(saasUser.getId());
                u.setName(saasUser.getName());
                u.setUsername(saasUser.getUsername__c());
                u.setPassword(saasUser.getPasswd__c());
                u.setTenantId(Long.valueOf(saasUser.getTenantId__r().getIdTenant__c()));
                u.setUserId(saasUser.getUserId__c());
                u.setHwOEMTOs(new ArrayList<HwOEMTO>());
                if (saasUser.getSaasUserHostAssociations__r() != null) {
                    SObject[] hostsUser = saasUser.getSaasUserHostAssociations__r().getRecords();
                    for (int i = 0; i < hostsUser.length; ++i) {
                        SaasUserHostAssociation__c hostUser = (SaasUserHostAssociation__c)hostsUser[i];
                        HwOEMTO hw = new HwOEMTO();
                        hw.setCreatedDate(hostUser.getHostId__r().getCreatedDate());
                        hw.setHostUserId(hostUser.getId());
                        hw.setHwOEMId(hostUser.getHostId__r().getHwOEMId__c());
                        hw.setHwOEMName(hostUser.getHostId__r().getHwOEMName__c());
                        hw.setId(hostUser.getHostId__r().getId());
                        hw.setMobile(hostUser.getHostId__r().getMobile__c());
                        hw.setEnabled(hostUser.getEnabled__c());
                        List<HwOEMTO> hws = u.getHwOEMTOs();
                        hws.add(hw);
                        u.setHwOEMTOs(hws);
                    }
                }
                u.setTypeResponse(TypeError.NoError);
                return u;
            }
            throw new InstanceNotFoundException((Object)username, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public TenantTO getTenant(String username, String appNameKey) throws InstanceNotFoundException, InternalErrorException {
        EnterpriseConnection connection = this.getSFconnection();
        return this.getTenant(connection, username, appNameKey);
    }

    private TenantTO getTenant(EnterpriseConnection connection, String idLicense) throws InstanceNotFoundException, InternalErrorException {
        LicenseTO currentLicenseTO = this.getLicense(connection, idLicense);
        try {
            QueryResult queryResults = connection.query("SELECT Id,Name, IdTenant__c,appName__c,comment__c,enabled__c,notifications__c,parameters__c,(select Id, Name, enabled__c,comment__c,passwd__c,tenantId__r.IdTenant__c ,userId__c,username__c from Saas_Tenant__c.Saas_Users__r order by CreatedDate asc),(select Id, Name,Asset__c,Enable_SaaS__c,LicenseId__c,MOPS__c,notifyExpiredTrial__c,Saas_Tenant__c,usageEndDate__c,usageStartDate__c  from Saas_Tenant__c.Licenses__r  where Enable_SaaS__c=true order by usageEndDate__c desc,CreatedDate desc)  FROM Saas_Tenant__c where id='" + currentLicenseTO.getTenantId() + "'");
            if (queryResults.getSize() > 0) {
                int i;
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                TenantTO tenant = new TenantTO();
                tenant.setAppName(saasTenant.getAppName__c());
                tenant.setComments(saasTenant.getComment__c());
                tenant.setEnabled(saasTenant.getEnabled__c());
                tenant.setId(saasTenant.getId());
                tenant.setName(saasTenant.getName());
                tenant.setNotifications(saasTenant.getNotifications__c());
                tenant.setParameters(saasTenant.getParameters__c());
                tenant.setTenantId(Long.valueOf(saasTenant.getIdTenant__c()));
                tenant.setUserTOs(new ArrayList<UserTO>());
                if (saasTenant.getSaas_Users__r() != null) {
                    SObject[] usersTenant = saasTenant.getSaas_Users__r().getRecords();
                    for (i = 0; i < usersTenant.length; ++i) {
                        Saas_User__c userTenant = (Saas_User__c)usersTenant[i];
                        UserTO u = new UserTO();
                        u.setComments(userTenant.getComment__c());
                        u.setEnabled(userTenant.getEnabled__c());
                        u.setId(userTenant.getId());
                        u.setUserId(userTenant.getUserId__c());
                        u.setName(userTenant.getName());
                        u.setUsername(userTenant.getUsername__c());
                        u.setPassword(userTenant.getPasswd__c());
                        u.setTenantId(Long.valueOf(userTenant.getTenantId__r().getIdTenant__c()));
                        u.setTypeResponse(TypeError.NoError);
                        List<UserTO> users = tenant.getUserTOs();
                        users.add(u);
                        tenant.setUserTOs(users);
                    }
                }
                tenant.setLicenseTOs(new ArrayList<LicenseTO>());
                if (saasTenant.getLicenses__r() != null) {
                    SObject[] licensesTenant = saasTenant.getLicenses__r().getRecords();
                    for (i = 0; i < licensesTenant.length; ++i) {
                        License__c licenseTenant = (License__c)licensesTenant[i];
                        LicenseTO l = new LicenseTO();
                        l.setAssetId(licenseTenant.getAsset__c());
                        l.setEnableSaaS(licenseTenant.getEnable_SaaS__c());
                        l.setId(licenseTenant.getId());
                        l.setMops(licenseTenant.getMOPS__c());
                        l.setTenantId(licenseTenant.getSaas_Tenant__c());
                        l.setName(licenseTenant.getName());
                        l.setNotifyExpiredTrial(licenseTenant.getNotifyExpiredTrial__c());
                        l.setUsageEndDate(licenseTenant.getUsageEndDate__c());
                        l.setUsageStartDate(licenseTenant.getUsageStartDate__c());
                        l.setTypeResponse(TypeError.NoError);
                        List<LicenseTO> licenses = tenant.getLicenseTOs();
                        if (currentLicenseTO.getId().equals(l.getId())) {
                            licenses.add(currentLicenseTO);
                        } else {
                            licenses.add(l);
                        }
                        tenant.setLicenseTOs(licenses);
                    }
                } else {
                    List<LicenseTO> licenses = tenant.getLicenseTOs();
                    licenses.add(currentLicenseTO);
                }
                tenant.setTypeResponse(TypeError.NoError);
                return tenant;
            }
            throw new InstanceNotFoundException((Object)idLicense, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private TenantTO getTenant(EnterpriseConnection connection, String username, String appNameKey) throws InstanceNotFoundException, InternalErrorException {
        UserTO userTO = this.getUser(connection, username, appNameKey);
        LicenseTO currentLicenseTO = this.getLicense(connection, userTO.getTenantId());
        try {
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            QueryResult queryResults = connection.query("SELECT Id,Name, IdTenant__c,appName__c,comment__c,enabled__c,notifications__c,parameters__c,(select Id, Name, enabled__c,comment__c,passwd__c,tenantId__r.IdTenant__c ,userId__c,username__c from Saas_Tenant__c.Saas_Users__r ),(select Id, Name,Asset__c,Enable_SaaS__c,LicenseId__c,MOPS__c,notifyExpiredTrial__c,Saas_Tenant__c,usageEndDate__c,usageStartDate__c  from Saas_Tenant__c.Licenses__r  where Enable_SaaS__c=true order by usageEndDate__c desc,CreatedDate desc)  FROM Saas_Tenant__c where IdTenant__c='" + userTO.getTenantId() + "'");
            if (queryResults.getSize() > 0) {
                int i;
                Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                TenantTO tenant = new TenantTO();
                tenant.setAppName(appNameKey);
                tenant.setComments(saasTenant.getComment__c());
                tenant.setEnabled(saasTenant.getEnabled__c());
                tenant.setId(saasTenant.getId());
                tenant.setName(saasTenant.getName());
                tenant.setNotifications(saasTenant.getNotifications__c());
                tenant.setParameters(saasTenant.getParameters__c());
                tenant.setTenantId(Long.valueOf(saasTenant.getIdTenant__c()));
                tenant.setUserTOs(new ArrayList<UserTO>());
                if (saasTenant.getSaas_Users__r() != null) {
                    SObject[] usersTenant = saasTenant.getSaas_Users__r().getRecords();
                    for (i = 0; i < usersTenant.length; ++i) {
                        Saas_User__c userTenant = (Saas_User__c)usersTenant[i];
                        UserTO u = new UserTO();
                        u.setComments(userTenant.getComment__c());
                        u.setEnabled(userTenant.getEnabled__c());
                        u.setId(userTenant.getId());
                        u.setUserId(userTenant.getUserId__c());
                        u.setName(userTenant.getName());
                        u.setUsername(userTenant.getUsername__c());
                        u.setPassword(userTenant.getPasswd__c());
                        u.setTenantId(Long.valueOf(userTenant.getTenantId__r().getIdTenant__c()));
                        u.setTypeResponse(TypeError.NoError);
                        List<UserTO> users = tenant.getUserTOs();
                        if (userTO.getId().equals(u.getId())) {
                            users.add(userTO);
                        } else {
                            users.add(u);
                        }
                        tenant.setUserTOs(users);
                    }
                }
                tenant.setLicenseTOs(new ArrayList<LicenseTO>());
                if (saasTenant.getLicenses__r() != null) {
                    SObject[] licensesTenant = saasTenant.getLicenses__r().getRecords();
                    for (i = 0; i < licensesTenant.length; ++i) {
                        License__c licenseTenant = (License__c)licensesTenant[i];
                        LicenseTO l = new LicenseTO();
                        l.setAssetId(licenseTenant.getAsset__c());
                        l.setEnableSaaS(licenseTenant.getEnable_SaaS__c());
                        l.setId(licenseTenant.getId());
                        l.setMops(licenseTenant.getMOPS__c());
                        l.setTenantId(licenseTenant.getSaas_Tenant__c());
                        l.setName(licenseTenant.getName());
                        l.setNotifyExpiredTrial(licenseTenant.getNotifyExpiredTrial__c());
                        l.setUsageEndDate(licenseTenant.getUsageEndDate__c());
                        l.setUsageStartDate(licenseTenant.getUsageStartDate__c());
                        l.setTypeResponse(TypeError.NoError);
                        List<LicenseTO> licenses = tenant.getLicenseTOs();
                        if (currentLicenseTO.getId().equals(l.getId())) {
                            licenses.add(currentLicenseTO);
                        } else {
                            licenses.add(l);
                        }
                        tenant.setLicenseTOs(licenses);
                    }
                } else {
                    List<LicenseTO> licenses = tenant.getLicenseTOs();
                    licenses.add(currentLicenseTO);
                }
                tenant.setTypeResponse(TypeError.NoError);
                return tenant;
            }
            throw new InstanceNotFoundException((Object)username, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private ProductMap__c getProductMap(EnterpriseConnection connection, String appNameKey) throws InternalErrorException {
        try {
            QueryResult queryResults = connection.query("SELECT Name,key__c,Value__c,EvaluationParameters__c,ProductionParameters__c,IncrMemoryByAsset__c,IncrCoinsByAsset__c,IncrUserByAsset__c from ProductMap__c where key__c='" + appNameKey + "' limit 1");
            if (queryResults.getSize() > 0) {
                return (ProductMap__c)queryResults.getRecords()[0];
            }
            return null;
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private ProductMap__c getProductMapByValue(EnterpriseConnection connection, String appNameValue) throws InternalErrorException {
        try {
            QueryResult queryResults = connection.query("SELECT Name,key__c,Value__c,EvaluationParameters__c,ProductionParameters__c,IncrMemoryByAsset__c,IncrCoinsByAsset__c,IncrUserByAsset__c from ProductMap__c where value__c='" + appNameValue + "' limit 1");
            if (queryResults.getSize() > 0) {
                return (ProductMap__c)queryResults.getRecords()[0];
            }
            return null;
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public UserTO getUser(String username, String appNameKey) throws InstanceNotFoundException, InternalErrorException {
        EnterpriseConnection connection = this.getSFconnection();
        return this.getUser(connection, username, appNameKey);
    }

    private UserTO getUser(EnterpriseConnection connection, String username, String appNameKey) throws InstanceNotFoundException, InternalErrorException {
        try {
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            QueryResult queryResults = connection.query("SELECT Id, Name, enabled__c,comment__c,passwd__c,tenantId__r.IdTenant__c ,userId__c,username__c,(select id, Name,enabled__c, hostId__r.Id,hostId__r.Name,hostId__r.hwOEMId__c,hostId__r.hwOEMName__c,hostId__r.mobile__c from Saas_User__c.SaasUserHostAssociations__r)  FROM Saas_User__c where username__c='" + username + "' and tenantId__r.appName__c ='" + appNameKey + "'");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasUser = (Saas_User__c)queryResults.getRecords()[0];
                UserTO u = new UserTO();
                u.setComments(saasUser.getComment__c());
                u.setEnabled(saasUser.getEnabled__c());
                u.setId(saasUser.getId());
                u.setName(saasUser.getName());
                u.setUsername(saasUser.getUsername__c());
                u.setPassword(saasUser.getPasswd__c());
                u.setTenantId(Long.valueOf(saasUser.getTenantId__r().getIdTenant__c()));
                u.setUserId(saasUser.getUserId__c());
                u.setHwOEMTOs(new ArrayList<HwOEMTO>());
                if (saasUser.getSaasUserHostAssociations__r() != null) {
                    SObject[] hostsUser = saasUser.getSaasUserHostAssociations__r().getRecords();
                    for (int i = 0; i < hostsUser.length; ++i) {
                        SaasUserHostAssociation__c hostUser = (SaasUserHostAssociation__c)hostsUser[i];
                        HwOEMTO hw = new HwOEMTO();
                        hw.setCreatedDate(hostUser.getHostId__r().getCreatedDate());
                        hw.setHostUserId(hostUser.getId());
                        hw.setHwOEMId(hostUser.getHostId__r().getHwOEMId__c());
                        hw.setHwOEMName(hostUser.getHostId__r().getHwOEMName__c());
                        hw.setId(hostUser.getHostId__r().getId());
                        hw.setMobile(hostUser.getHostId__r().getMobile__c());
                        hw.setEnabled(hostUser.getEnabled__c());
                        List<HwOEMTO> hws = u.getHwOEMTOs();
                        hws.add(hw);
                        u.setHwOEMTOs(hws);
                    }
                }
                u.setTypeResponse(TypeError.NoError);
                return u;
            }
            throw new InstanceNotFoundException((Object)username, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private UserTO getUser(EnterpriseConnection connection, String userID) throws InstanceNotFoundException, InternalErrorException {
        try {
            QueryResult queryResults = connection.query("SELECT Id, Name, enabled__c,comment__c,passwd__c,tenantId__r.IdTenant__c ,userId__c,username__c,(select id, Name,enabled__c, hostId__r.Id,hostId__r.Name,hostId__r.hwOEMId__c,hostId__r.hwOEMName__c,hostId__r.mobile__c from Saas_User__c.SaasUserHostAssociations__r)  FROM Saas_User__c where userId__c='" + userID + "'");
            if (queryResults.getSize() > 0) {
                Saas_User__c saasUser = (Saas_User__c)queryResults.getRecords()[0];
                UserTO u = new UserTO();
                u.setComments(saasUser.getComment__c());
                u.setEnabled(saasUser.getEnabled__c());
                u.setId(saasUser.getId());
                u.setName(saasUser.getName());
                u.setUsername(saasUser.getUsername__c());
                u.setPassword(saasUser.getPasswd__c());
                u.setTenantId(Long.valueOf(saasUser.getTenantId__r().getIdTenant__c()));
                u.setUserId(saasUser.getUserId__c());
                u.setHwOEMTOs(new ArrayList<HwOEMTO>());
                if (saasUser.getSaasUserHostAssociations__r() != null) {
                    SObject[] hostsUser = saasUser.getSaasUserHostAssociations__r().getRecords();
                    for (int i = 0; i < hostsUser.length; ++i) {
                        SaasUserHostAssociation__c hostUser = (SaasUserHostAssociation__c)hostsUser[i];
                        HwOEMTO hw = new HwOEMTO();
                        hw.setCreatedDate(hostUser.getHostId__r().getCreatedDate());
                        hw.setHostUserId(hostUser.getId());
                        hw.setHwOEMId(hostUser.getHostId__r().getHwOEMId__c());
                        hw.setHwOEMName(hostUser.getHostId__r().getHwOEMName__c());
                        hw.setId(hostUser.getHostId__r().getId());
                        hw.setMobile(hostUser.getHostId__r().getMobile__c());
                        hw.setEnabled(hostUser.getEnabled__c());
                        List<HwOEMTO> hws = u.getHwOEMTOs();
                        hws.add(hw);
                        u.setHwOEMTOs(hws);
                    }
                }
                u.setTypeResponse(TypeError.NoError);
                return u;
            }
            throw new InstanceNotFoundException((Object)userID, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public LicenseTO getLicense(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        EnterpriseConnection connection = this.getSFconnection();
        return this.getLicense(connection, tenantId);
    }

    public List<LicenseTO> getLicenses(EnterpriseConnection connection, Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        ArrayList<LicenseTO> licenses;
        block9: {
            licenses = new ArrayList<LicenseTO>();
            try {
                QueryResult queryResults = connection.query("SELECT Id, Name,Asset__c,Enable_SaaS__c,LicenseId__c,MOPS__c,notifyExpiredTrial__c,Saas_Tenant__c,Saas_Tenant__r.AppName__c,usageEndDate__c,usageStartDate__c,(select id, Name,enabled__c,Host_ID__r.Id,Host_ID__r.Name,Host_ID__r.hwOEMId__c,Host_ID__r.hwOEMName__c,Host_ID__r.mobile__c from License__c.LicenseHostAssociations__r)   FROM License__c where Saas_Tenant__r.IdTenant__c='" + tenantId + "' order by usageEndDate__c desc, CreatedDate desc ");
                if (queryResults.getSize() > 0) {
                    for (SObject licenseTenantObject : queryResults.getRecords()) {
                        QueryResult queryNotes;
                        License__c licenseTenant = (License__c)licenseTenantObject;
                        LicenseTO l = new LicenseTO();
                        l.setAssetId(licenseTenant.getAsset__c());
                        l.setEnableSaaS(licenseTenant.getEnable_SaaS__c());
                        l.setId(licenseTenant.getId());
                        l.setMops(licenseTenant.getMOPS__c());
                        l.setTenantId(licenseTenant.getSaas_Tenant__c());
                        l.setName(licenseTenant.getName());
                        l.setNotifyExpiredTrial(licenseTenant.getNotifyExpiredTrial__c());
                        l.setUsageEndDate(licenseTenant.getUsageEndDate__c());
                        l.setUsageStartDate(licenseTenant.getUsageStartDate__c());
                        if (licenseTenant.getAsset__c() != null && (queryNotes = connection.query("select Id,Title,Body,ParentId from Note where ParentId='" + licenseTenant.getAsset__c() + "' and Title='" + purchaseData + "'")).getSize() > 0) {
                            Note notePurchase = (Note)queryNotes.getRecords()[0];
                            l.setAssetNote(notePurchase.getBody());
                        }
                        if (licenseTenant.getSaas_Tenant__c() != null) {
                            Product2 p;
                            ProductMap__c prodMap = this.getProductMap(connection, licenseTenant.getSaas_Tenant__r().getAppName__c());
                            l.setProductName(prodMap.getName());
                            QueryResult queryProduct = connection.query("select Id,Name,UUID__c from Product2 where ProductCode='" + prodMap.getValue__c() + "' ");
                            if (queryProduct.getSize() > 0 && (p = (Product2)queryProduct.getRecords()[0]).getUUID__c() != null) {
                                l.setProductUUID(p.getUUID__c());
                            }
                        }
                        l.setHwOEMTOs(new ArrayList<HwOEMTO>());
                        if (licenseTenant.getLicenseHostAssociations__r() != null) {
                            SObject[] hostsLicense = licenseTenant.getLicenseHostAssociations__r().getRecords();
                            for (int i = 0; i < hostsLicense.length; ++i) {
                                LicenseHostAssociation__c hostLicense = (LicenseHostAssociation__c)hostsLicense[i];
                                HwOEMTO hw = new HwOEMTO();
                                hw.setCreatedDate(hostLicense.getHost_ID__r().getCreatedDate());
                                hw.setHostLicenseId(hostLicense.getId());
                                hw.setHwOEMId(hostLicense.getHost_ID__r().getHwOEMId__c());
                                hw.setHwOEMName(hostLicense.getHost_ID__r().getHwOEMName__c());
                                hw.setId(hostLicense.getHost_ID__r().getId());
                                hw.setMobile(hostLicense.getHost_ID__r().getMobile__c());
                                hw.setEnabled(hostLicense.getEnabled__c());
                                List<HwOEMTO> hws = l.getHwOEMTOs();
                                hws.add(hw);
                                l.setHwOEMTOs(hws);
                            }
                        }
                        l.setTypeResponse(TypeError.NoError);
                        licenses.add(l);
                    }
                    break block9;
                }
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
        return licenses;
    }

    public LicenseTO getLicense(EnterpriseConnection connection, Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        try {
            QueryResult queryResults = connection.query("SELECT Id, Name,Asset__c,Enable_SaaS__c,LicenseId__c,MOPS__c,notifyExpiredTrial__c,Saas_Tenant__c,Saas_Tenant__r.AppName__c,usageEndDate__c,usageStartDate__c,(select id, Name,enabled__c,Host_ID__r.Id,Host_ID__r.Name,Host_ID__r.hwOEMId__c,Host_ID__r.hwOEMName__c,Host_ID__r.mobile__c from License__c.LicenseHostAssociations__r),Product__r.Name,Product__r.UUID__c   FROM License__c where Saas_Tenant__r.IdTenant__c='" + tenantId + "' order by usageEndDate__c desc, CreatedDate desc LIMIT 1 ");
            if (queryResults.getSize() > 0) {
                QueryResult queryNotes;
                License__c licenseTenant = (License__c)queryResults.getRecords()[0];
                LicenseTO l = new LicenseTO();
                l.setAssetId(licenseTenant.getAsset__c());
                l.setEnableSaaS(licenseTenant.getEnable_SaaS__c());
                l.setId(licenseTenant.getId());
                l.setMops(licenseTenant.getMOPS__c());
                l.setTenantId(licenseTenant.getSaas_Tenant__c());
                l.setName(licenseTenant.getName());
                l.setNotifyExpiredTrial(licenseTenant.getNotifyExpiredTrial__c());
                l.setUsageEndDate(licenseTenant.getUsageEndDate__c());
                l.setUsageStartDate(licenseTenant.getUsageStartDate__c());
                if (licenseTenant.getAsset__c() != null && (queryNotes = connection.query("select Id,Title,Body,ParentId from Note where ParentId='" + licenseTenant.getAsset__c() + "' and Title='" + purchaseData + "'")).getSize() > 0) {
                    Note notePurchase = (Note)queryNotes.getRecords()[0];
                    l.setAssetNote(notePurchase.getBody());
                }
                if (licenseTenant.getSaas_Tenant__c() != null) {
                    Product2 p;
                    ProductMap__c prodMap = this.getProductMap(connection, licenseTenant.getSaas_Tenant__r().getAppName__c());
                    l.setProductName(prodMap.getName());
                    QueryResult queryProduct = connection.query("select Id,Name,UUID__c from Product2 where ProductCode='" + prodMap.getValue__c() + "' ");
                    if (queryProduct.getSize() > 0 && (p = (Product2)queryProduct.getRecords()[0]).getUUID__c() != null) {
                        l.setProductUUID(p.getUUID__c());
                    }
                }
                if (licenseTenant.getProduct__r() != null) {
                    l.setProductName(licenseTenant.getProduct__r().getName());
                    l.setProductUUID(licenseTenant.getProduct__r().getUUID__c());
                }
                l.setHwOEMTOs(new ArrayList<HwOEMTO>());
                if (licenseTenant.getLicenseHostAssociations__r() != null) {
                    SObject[] hostsLicense = licenseTenant.getLicenseHostAssociations__r().getRecords();
                    for (int i = 0; i < hostsLicense.length; ++i) {
                        LicenseHostAssociation__c hostLicense = (LicenseHostAssociation__c)hostsLicense[i];
                        HwOEMTO hw = new HwOEMTO();
                        hw.setCreatedDate(hostLicense.getHost_ID__r().getCreatedDate());
                        hw.setHostLicenseId(hostLicense.getId());
                        hw.setHwOEMId(hostLicense.getHost_ID__r().getHwOEMId__c());
                        hw.setHwOEMName(hostLicense.getHost_ID__r().getHwOEMName__c());
                        hw.setId(hostLicense.getHost_ID__r().getId());
                        hw.setMobile(hostLicense.getHost_ID__r().getMobile__c());
                        hw.setEnabled(hostLicense.getEnabled__c());
                        List<HwOEMTO> hws = l.getHwOEMTOs();
                        hws.add(hw);
                        l.setHwOEMTOs(hws);
                    }
                }
                l.setTypeResponse(TypeError.NoError);
                return l;
            }
            throw new InstanceNotFoundException(tenantId, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    public LicenseTO getLicense(EnterpriseConnection connection, String licenseID) throws InstanceNotFoundException, InternalErrorException {
        try {
            QueryResult queryResults = connection.query("SELECT Id, Name,Asset__c,Enable_SaaS__c,LicenseId__c,MOPS__c,notifyExpiredTrial__c,Saas_Tenant__c,Saas_Tenant__r.AppName__c,usageEndDate__c,usageStartDate__c,(select id, Name,enabled__c,Host_ID__r.Id,Host_ID__r.Name,Host_ID__r.hwOEMId__c,Host_ID__r.hwOEMName__c,Host_ID__r.mobile__c,Host_ID__r.createdDate from License__c.LicenseHostAssociations__r),Product__r.Name,Product__r.UUID__c FROM License__c where id='" + licenseID + "' order by usageEndDate__c desc, CreatedDate desc LIMIT 1 ");
            if (queryResults.getSize() > 0) {
                QueryResult queryNotes;
                License__c licenseTenant = (License__c)queryResults.getRecords()[0];
                LicenseTO l = new LicenseTO();
                l.setAssetId(licenseTenant.getAsset__c());
                l.setEnableSaaS(licenseTenant.getEnable_SaaS__c());
                l.setId(licenseTenant.getId());
                l.setMops(licenseTenant.getMOPS__c());
                l.setTenantId(licenseTenant.getSaas_Tenant__c());
                l.setName(licenseTenant.getName());
                l.setNotifyExpiredTrial(licenseTenant.getNotifyExpiredTrial__c());
                l.setUsageEndDate(licenseTenant.getUsageEndDate__c());
                l.setUsageStartDate(licenseTenant.getUsageStartDate__c());
                if (licenseTenant.getAsset__c() != null && (queryNotes = connection.query("select Id,Title,Body,ParentId from Note where ParentId='" + licenseTenant.getAsset__c() + "' and Title='" + purchaseData + "'")).getSize() > 0) {
                    Note notePurchase = (Note)queryNotes.getRecords()[0];
                    l.setAssetNote(notePurchase.getBody());
                }
                if (licenseTenant.getSaas_Tenant__c() != null) {
                    Product2 p;
                    ProductMap__c prodMap = this.getProductMap(connection, licenseTenant.getSaas_Tenant__r().getAppName__c());
                    l.setProductName(prodMap.getName());
                    QueryResult queryProduct = connection.query("select Id,Name,UUID__c from Product2 where ProductCode='" + prodMap.getValue__c() + "' ");
                    if (queryProduct.getSize() > 0 && (p = (Product2)queryProduct.getRecords()[0]).getUUID__c() != null) {
                        l.setProductUUID(p.getUUID__c());
                    }
                }
                if (licenseTenant.getProduct__r() != null) {
                    l.setProductName(licenseTenant.getProduct__r().getName());
                    l.setProductUUID(licenseTenant.getProduct__r().getUUID__c());
                }
                l.setHwOEMTOs(new ArrayList<HwOEMTO>());
                if (licenseTenant.getLicenseHostAssociations__r() != null) {
                    SObject[] hostsLicense = licenseTenant.getLicenseHostAssociations__r().getRecords();
                    for (int i = 0; i < hostsLicense.length; ++i) {
                        LicenseHostAssociation__c hostLicense = (LicenseHostAssociation__c)hostsLicense[i];
                        HwOEMTO hw = new HwOEMTO();
                        hw.setCreatedDate(hostLicense.getHost_ID__r().getCreatedDate());
                        hw.setHostLicenseId(hostLicense.getId());
                        hw.setHwOEMId(hostLicense.getHost_ID__r().getHwOEMId__c());
                        hw.setHwOEMName(hostLicense.getHost_ID__r().getHwOEMName__c());
                        hw.setId(hostLicense.getHost_ID__r().getId());
                        hw.setMobile(hostLicense.getHost_ID__r().getMobile__c());
                        hw.setEnabled(hostLicense.getEnabled__c());
                        List<HwOEMTO> hws = l.getHwOEMTOs();
                        hws.add(hw);
                        l.setHwOEMTOs(hws);
                    }
                }
                l.setTypeResponse(TypeError.NoError);
                return l;
            }
            throw new InstanceNotFoundException((Object)licenseID, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    @Override
    public TenantTO loginDesktop(String email, String password, String appName, Boolean isWeb, String hwid, String hwname) {
        TenantTO tenantTO = new TenantTO();
        EnterpriseConnection connection = this.getSFconnection();
        try {
            tenantTO = isWeb == false ? this.checkLogin(connection, email, appName, hwid, hwname) : this.getTenant(connection, email, appName);
            if (tenantTO.getTypeResponse() != TypeError.NoError.getErrorCode()) {
                return tenantTO;
            }
            UserTO user = null;
            for (UserTO u : tenantTO.getUserTOs()) {
                if (!u.getUsername().equals(email)) continue;
                user = u;
                break;
            }
            if (user == null) {
                throw new InstanceNotFoundException((Object)email, this.getClass().getName());
            }
            if (isWeb.booleanValue() && !this.checkPassword(password, user.getPassword()).booleanValue()) {
                throw new InstanceNotFoundException((Object)("check password for " + email), this.getClass().getName());
            }
            Map<String, String> parameters = TenantTO.getMapParameters(tenantTO.getParameters());
            if (parameters.containsKey(Constants.USER_COUNT_LIMIT) && tenantTO.getUserTOs().size() > tenantTO.getUsersAllowed()) {
                tenantTO.setTypeResponse(TypeError.ManyUsers);
                tenantTO.setMessage("This instance " + tenantTO.getName() + " has " + tenantTO.getUsersAllowed() + " users allowed. Please, contact our sales team at sales@mestrelab.com");
                return tenantTO;
            }
            if (isWeb.booleanValue()) {
                this.setRegistryLogin(connection, user, true);
            }
            return tenantTO;
        }
        catch (InstanceNotFoundException instance) {
            tenantTO.setTypeResponse(TypeError.NoRegister);
            StringWriter error = new StringWriter();
            instance.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
        catch (InternalErrorException internal) {
            tenantTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
    }

    @Override
    public TenantTO login(String email, String appNameKey, String hw_oem_id, String hw_oem_name) {
        EnterpriseConnection connection = this.getSFconnection();
        return this.login(connection, email, appNameKey, hw_oem_id, hw_oem_name, true, "Tablet-" + email);
    }

    private LicenseTO searchLicense(List<LicenseTO> list, String licenseId) {
        for (LicenseTO l : list) {
            if (!l.getId().substring(0, 15).equals(licenseId.substring(0, 15))) continue;
            return l;
        }
        return null;
    }

    @Override
    public TenantTO login(String licenseId, String hwid, String username) {
        EnterpriseConnection connection = this.getSFconnection();
        TenantTO tenantTO = new TenantTO();
        try {
            LicenseTO license;
            tenantTO = this.getTenant(connection, licenseId);
            HwOEMTO hwSearch = new HwOEMTO();
            hwSearch.setHwOEMId(hwid);
            if (tenantTO.getAppName().endsWith("99") && (username == null || username.isEmpty())) {
                tenantTO.setUserTOs(new ArrayList<UserTO>());
                throw new UserInstanceNotFoundException((Object)licenseId, this.getClass().getName());
            }
            if (username != null && !username.trim().equals("")) {
                UserTO userWithHw;
                UserTO user = null;
                for (UserTO u : tenantTO.getUserTOs()) {
                    if (!u.getUsername().toLowerCase().equals(username.toLowerCase())) continue;
                    user = u;
                    break;
                }
                if (user == null) {
                    tenantTO.setUserTOs(new ArrayList<UserTO>());
                    throw new UserInstanceNotFoundException((Object)username, this.getClass().getName());
                }
                if (tenantTO.getAppName().endsWith("99") && !(userWithHw = this.getUser(user.getUsername(), tenantTO.getAppName())).getHwOEMTOsEnabled().contains(hwSearch)) {
                    tenantTO.getLicenseTOs().get(0).setHwOEMTOs(new ArrayList<HwOEMTO>());
                    throw new HwInstanceNotFoundException((Object)hwid, this.getClass().getName());
                }
            }
            if ((license = this.searchLicense(tenantTO.getLicenseTOs(), licenseId)) != null && !license.getHwOEMTOsEnabled().contains(hwSearch)) {
                tenantTO.getLicenseTOs().get(0).setHwOEMTOs(new ArrayList<HwOEMTO>());
                throw new HwInstanceNotFoundException((Object)hwid, this.getClass().getName());
            }
            if (username != null && !username.isEmpty() && tenantTO.getUserTOs().size() != 1) {
                tenantTO.setUserTOs(new ArrayList<UserTO>());
            }
            for (UserTO u : tenantTO.getUserTOs()) {
                u.setPassword("");
            }
            for (UserTO u : tenantTO.getUserTOs()) {
                u.setHwOEMTOs(new ArrayList<HwOEMTO>());
            }
            for (LicenseTO l : tenantTO.getLicenseTOs()) {
                l.setHwOEMTOs(new ArrayList<HwOEMTO>());
            }
            tenantTO.getLicenseTOs().clear();
            tenantTO.getLicenseTOs().add(license);
            return tenantTO;
        }
        catch (HwInstanceNotFoundException instance) {
            tenantTO.setTypeResponse(TypeError.HwNotFound);
            StringWriter error = new StringWriter();
            instance.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
        catch (UserInstanceNotFoundException instance) {
            tenantTO.setTypeResponse(TypeError.UserNotFound);
            StringWriter error = new StringWriter();
            instance.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
        catch (InstanceNotFoundException instance) {
            tenantTO.setTypeResponse(TypeError.NoRegister);
            StringWriter error = new StringWriter();
            instance.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
        catch (InternalErrorException internal) {
            tenantTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
    }

    private TenantTO login(EnterpriseConnection connection, String email, String appNameKey, String hw_oem_id, String hw_oem_name, Boolean mobile, String formName) {
        TenantTO tenantTO = new TenantTO();
        try {
            this.log.debug("Login: [" + email + "," + appNameKey + "," + hw_oem_id + "," + hw_oem_name);
            tenantTO = this.getTenant(connection, email, appNameKey);
            HwOEMTO hwSearch = new HwOEMTO();
            hwSearch.setHwOEMId(hw_oem_id);
            UserTO currentUser = new UserTO();
            for (UserTO u : tenantTO.getUserTOs()) {
                if (!u.getName().equals(email)) continue;
                currentUser = u;
                break;
            }
            if (!currentUser.getHwOEMTOs().contains(hwSearch)) {
                int sizeHwAssociated = currentUser.getHwOEMTOsEnabled().size();
                if (sizeHwAssociated < 3) {
                    this.registerUser(connection, email, appNameKey, hw_oem_id, hw_oem_name, mobile, formName, null, null);
                    tenantTO.setTypeResponse(TypeError.NoConfirmed);
                    tenantTO.setMessage("user " + email + " to be confirmed with device:" + hw_oem_id);
                } else {
                    tenantTO.setTypeResponse(TypeError.ManyDevices);
                    tenantTO.setMessage("User has " + sizeHwAssociated + " devices associated to " + email + ". Please, contact our sales team at sales@mestrelab.com");
                    this.log.error(tenantTO.getMessage());
                }
            } else {
                SaasUserHostAssociation__c[] usersHost = this.getUserwithSameHW(connection, hw_oem_id, appNameKey);
                int sizeUserAssociated = usersHost.length;
                if (sizeUserAssociated <= 3) {
                    tenantTO.setTypeResponse(TypeError.NoError);
                } else {
                    tenantTO.setTypeResponse(TypeError.ManyUsers);
                    tenantTO.setMessage("OEM id has " + sizeUserAssociated + " users associated to " + hw_oem_id + ". Please, contact our sales team at sales@mestrelab.com");
                    this.log.error(tenantTO.getMessage());
                }
            }
            return tenantTO;
        }
        catch (InstanceNotFoundException e) {
            block20: {
                try {
                    if (email.contains(anonymousAddressFormat)) {
                        String deviceUUID = hw_oem_id.trim().replaceAll("-", "").replaceAll("\\{", "").replaceAll("\\}", "");
                        String nameEmail = email.replaceAll(anonymousAddressFormat, "");
                        if (nameEmail.equals(deviceUUID)) {
                            tenantTO.setTypeResponse(TypeError.NoRegister);
                            StringWriter error = new StringWriter();
                            e.printStackTrace(new PrintWriter(error));
                            tenantTO.setMessage(error.toString());
                            this.log.error(tenantTO.getMessage());
                            return tenantTO;
                        }
                        break block20;
                    }
                    String appNCampus = appNameKey.substring(0, appNameKey.length() - 2).concat("99");
                    TenantTO tenantInCampus = null;
                    try {
                        tenantInCampus = this.getTenant(connection, email, appNCampus);
                    }
                    catch (InstanceNotFoundException e1) {
                        return this.registerUser(connection, email, appNameKey, hw_oem_id, hw_oem_name, mobile, formName, null, null);
                    }
                    tenantInCampus = this.checkLogin(connection, email, appNCampus, hw_oem_id, hw_oem_name);
                    if (tenantInCampus.getTypeResponse() != TypeError.NoError.getErrorCode()) {
                        return this.registerUser(connection, email, appNCampus, hw_oem_id, hw_oem_name, mobile, formName, null, null);
                    }
                    return tenantInCampus;
                }
                catch (DuplicateInstanceException duplicate) {
                    tenantTO.setTypeResponse(TypeError.NoConfirmed);
                    StringWriter error = new StringWriter();
                    duplicate.printStackTrace(new PrintWriter(error));
                    tenantTO.setMessage(error.toString());
                    this.log.error(tenantTO.getMessage());
                    return tenantTO;
                }
                catch (InternalErrorException e1) {
                    tenantTO.setTypeResponse(TypeError.InternalError);
                    StringWriter error = new StringWriter();
                    e1.printStackTrace(new PrintWriter(error));
                    tenantTO.setMessage(error.toString());
                    this.log.error(tenantTO.getMessage());
                    return tenantTO;
                }
            }
            tenantTO.setTypeResponse(TypeError.NoConfirmed);
            return tenantTO;
        }
        catch (DuplicateInstanceException duplicate) {
            tenantTO.setTypeResponse(TypeError.NoConfirmed);
            StringWriter error = new StringWriter();
            duplicate.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
        catch (InternalErrorException internal) {
            tenantTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
        catch (ConnectionException con) {
            tenantTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            con.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
    }

    @Override
    public TenantTO registerUser(String email, String appNameKey, String hw_oem_id, String hw_oem_name, Boolean mobile, String name, String idTenant, String emailRegistered) throws InternalErrorException, DuplicateInstanceException {
        EnterpriseConnection connection = this.getSFconnection();
        return this.registerUser(connection, email, appNameKey, hw_oem_id, hw_oem_name, mobile, name, idTenant, emailRegistered);
    }

    private TenantTO registerUser(EnterpriseConnection connection, String email, String appNameKey, String hw_oem_id, String hw_oem_name, Boolean mobile, String name, String idTenant, String emailRegistered) throws InternalErrorException, DuplicateInstanceException {
        TenantTO checkLogin;
        block9: {
            checkLogin = new TenantTO();
            try {
                SaaSForm__c[] records;
                SaveResult[] saveResults;
                checkLogin = this.checkLogin(connection, email, appNameKey, hw_oem_id, hw_oem_name);
                if (checkLogin.getTypeResponse() != TypeError.NoRegister.getErrorCode()) {
                    return checkLogin;
                }
                ProductMap__c productMap = this.getProductMap(connection, appNameKey);
                if (productMap == null) {
                    throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
                }
                PricebookEntry pricebookEntry = this.getProduct(connection, appNameKey);
                SaaSForm__c form = new SaaSForm__c();
                form.setAppName__c(appNameKey);
                form.setEmail__c(email);
                form.setName(name);
                form.setHwOEM__c(hw_oem_id);
                form.setHwOEMName__c(hw_oem_name);
                form.setMobileDevice__c(mobile);
                form.setProduct__c(pricebookEntry.getProduct2().getId());
                if (idTenant != null && !idTenant.trim().isEmpty()) {
                    TenantTO tenantRegistered = this.getTenant(emailRegistered, appNameKey);
                    if (tenantRegistered.getUserTOs().size() >= tenantRegistered.getUsersAllowed()) {
                        throw new InternalErrorException((Object)"There are more active users that users allowed", this.getClass().getName());
                    }
                    form.setTenant__c(idTenant.trim());
                }
                if ((saveResults = connection.create((SObject[])(records = new SaaSForm__c[]{form}))) != null && saveResults.length > 0) {
                    if (!saveResults[0].isSuccess()) {
                        throw new DuplicateInstanceException(saveResults[0].getErrors()[0], this.getClass().getName());
                    }
                    break block9;
                }
                throw new InternalErrorException((Object)("Error registering :{" + email + ", " + appNameKey + ", " + hw_oem_id + "}"), this.getClass().getName());
            }
            catch (ConnectionException e) {
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
            catch (InstanceNotFoundException e) {
                throw new InternalErrorException((Object)("Email used to register new user(" + emailRegistered + ") isn't valid"), this.getClass().getName());
            }
        }
        checkLogin.setTypeResponse(TypeError.NoConfirmed);
        checkLogin.setMessage("user " + email + " to be confirmed with device:" + hw_oem_id);
        return checkLogin;
    }

    @Override
    public Boolean deleteSaaSForm(SaaSForm__c form) throws InstanceNotFoundException, InternalErrorException {
        block4: {
            try {
                EnterpriseConnection connection = this.getSFconnection();
                QueryResult queryResults = connection.query("SELECT Id FROM SaaSForm__c where email__c='" + form.getEmail__c() + "' and appName__c='" + form.getAppName__c() + "' and hwOEM__c='" + form.getHwOEM__c() + "' and confirmed__c=false LIMIT 1");
                if (queryResults.getSize() > 0) {
                    String[] ids = new String[]{queryResults.getRecords()[0].getId()};
                    DeleteResult[] deleteResults = connection.delete(ids);
                    if (deleteResults.length > 0) {
                        return deleteResults[0].getSuccess();
                    }
                    break block4;
                }
                throw new InstanceNotFoundException((Object)form.getEmail__c(), this.getClass().getName());
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
        return false;
    }

    @Override
    public void deleteSaaSForm(int year) throws InternalErrorException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id,CreatedDate FROM SaaSForm__c where CALENDAR_YEAR(CreatedDate) = " + year + " and confirmed__c=false ");
            if (queryResults.getSize() > 0) {
                ArrayList<String> ids = new ArrayList<String>();
                for (SObject record : queryResults.getRecords()) {
                    ids.add(record.getId());
                }
                this.log.error("list ids to delete " + ids.toArray(new String[0]));
                SObject[] sObjectArray = connection.delete(ids.toArray(new String[0]));
            }
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private TenantTO checkLogin(EnterpriseConnection connection, String email, String appNameKey, String hw_oem_id, String hw_oem_name) {
        TenantTO tenantTO = new TenantTO();
        try {
            tenantTO = this.getTenant(connection, email, appNameKey);
            HwOEMTO hwSearch = new HwOEMTO();
            hwSearch.setHwOEMId(hw_oem_id);
            UserTO currentUser = new UserTO();
            for (UserTO u : tenantTO.getUserTOs()) {
                if (!u.getName().equals(email)) continue;
                currentUser = u;
                break;
            }
            if (!currentUser.getHwOEMTOs().contains(hwSearch)) {
                int sizeHwAssociated = currentUser.getHwOEMTOsEnabled().size();
                if (sizeHwAssociated < 3) {
                    tenantTO.setTypeResponse(TypeError.NoRegister);
                    tenantTO.setMessage("user " + email + " to be registered with device:" + hw_oem_id);
                } else {
                    tenantTO.setTypeResponse(TypeError.ManyDevices);
                    tenantTO.setMessage("User has " + sizeHwAssociated + " devices associated to " + email + ". Please, contact our sales team at sales@mestrelab.com");
                    this.log.error(tenantTO.getMessage());
                }
            } else {
                SaasUserHostAssociation__c[] usersHost = this.getUserwithSameHW(connection, hw_oem_id, appNameKey);
                int sizeUserAssociated = usersHost.length;
                if (sizeUserAssociated <= 3) {
                    tenantTO.setTypeResponse(TypeError.NoError);
                } else {
                    tenantTO.setTypeResponse(TypeError.ManyUsers);
                    tenantTO.setMessage("OEM id has " + sizeUserAssociated + " users associated to " + hw_oem_id + ". Please, contact our sales team at sales@mestrelab.com");
                    this.log.error(tenantTO.getMessage());
                }
            }
            return tenantTO;
        }
        catch (InstanceNotFoundException e) {
            tenantTO.setTypeResponse(TypeError.NoRegister);
            return tenantTO;
        }
        catch (InternalErrorException internal) {
            tenantTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
        catch (ConnectionException con) {
            tenantTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            con.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
    }

    @Override
    public synchronized TenantTO createOrder(String nameContact, String email, String appNameKey, String idTenant, String idTransaction, Calendar dateTransaction, String platform, String note) {
        EnterpriseConnection connection = this.getSFconnection();
        TenantTO tenantTO = new TenantTO();
        try {
            semaphore.acquire();
            tenantTO = this.createOrder(connection, nameContact, email, appNameKey, idTenant, idTransaction, dateTransaction, platform, note, true);
            semaphore.release();
            return tenantTO;
        }
        catch (InterruptedException e) {
            tenantTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            e.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
    }

    public synchronized TenantTO createOrder(EnterpriseConnection connection, String nameContact, String email, String appNameKey, String idTenant, String idTransaction, Calendar dateTransaction, String platform, String note, Boolean recalculateDates) {
        TenantTO tenantTO = new TenantTO();
        appNameKey = appNameKey.substring(0, appNameKey.length() - 2).concat("01");
        try {
            this.log.debug("Creating order");
            this.log.debug("Data:[" + nameContact + "," + email + "," + appNameKey + "," + idTenant + "," + idTransaction + "," + platform + "," + note + "," + recalculateDates.toString() + "]");
            tenantTO = this.getTenant(connection, email, appNameKey);
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            String appName = productMap.getValue__c();
            PricebookEntry pricebookEntry = this.getProduct(connection, appNameKey);
            MOrder__c orderStored = this.searchOrderByTransaction(connection, idTransaction);
            if (orderStored != null) {
                return tenantTO;
            }
            if (!tenantTO.getId().equals(idTenant)) {
                this.log.error("Error comparing identification of  tenant for user" + email);
            }
            Contact contact = this.getContact(connection, email, "", nameContact, "Customers", true);
            MOrder__c order = this.createOrder(connection, email, nameContact, idTransaction, platform, dateTransaction, this.calculePrice(pricebookEntry.getUnitPrice(), appName), contact);
            Asset assetTablet = this.createAsset(connection, appNameKey, this.calculePrice(pricebookEntry.getUnitPrice(), appNameKey), 1.0, order, contact, tenantTO, note, recalculateDates);
            LicenseTO licenseTO = tenantTO.getLicenseTOs().get(0);
            License__c licenseSF = this.createLicense(connection, tenantTO, licenseTO);
            this.updateLicense(connection, assetTablet, licenseSF, productMap);
            tenantTO = this.getTenant(connection, email, appNameKey);
            return tenantTO;
        }
        catch (InstanceNotFoundException e) {
            if (email.contains(anonymousAddressFormat)) {
                try {
                    String token;
                    Saas_Tenant__c tenant = this.createTenantReturnObject(connection, null, "", appNameKey, "tenant generated by purchase with anonymous user", true, "");
                    SecureRandom random = new SecureRandom();
                    String plainPwd = token = new BigInteger(130, random).toString(32);
                    this.createUser(connection, Long.valueOf(tenant.getIdTenant__c()), email, plainPwd, "Anonymous user", true);
                    String digits = email.replaceAll(anonymousAddressFormat, "");
                    String uuid = digits.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "{$1-$2-$3-$4-$5}");
                    this.addHw(email, appNameKey, uuid, uuid, true);
                    return this.createOrder(connection, nameContact, email, appNameKey, tenant.getId(), idTransaction, dateTransaction, platform, note, false);
                }
                catch (InternalErrorException e1) {
                    tenantTO.setTypeResponse(TypeError.InternalError);
                    StringWriter error = new StringWriter();
                    e1.printStackTrace(new PrintWriter(error));
                    tenantTO.setMessage(error.toString());
                    this.log.error(tenantTO.getMessage());
                    return tenantTO;
                }
            }
            try {
                String appNCampus = appNameKey.substring(0, appNameKey.length() - 2).concat("99");
                UserTO userCampus = this.getUser(connection, email, appNCampus);
                Saas_Tenant__c tenant = this.createTenantReturnObject(connection, null, "", appNameKey, "tenant generated by purchase with user moved from campus:" + userCampus.getTenantId(), true, "");
                this.moveUserTenant(connection, Long.valueOf(tenant.getIdTenant__c()), userCampus.getUsername(), appNCampus, "user moved from campus" + userCampus.getTenantId());
                return this.createOrder(connection, nameContact, email, appNameKey, tenant.getId(), idTransaction, dateTransaction, platform, note, false);
            }
            catch (InstanceNotFoundException e1) {
                tenantTO.setTypeResponse(TypeError.NoRegister);
                StringWriter error = new StringWriter();
                e1.printStackTrace(new PrintWriter(error));
                tenantTO.setMessage(error.toString());
                this.log.error(tenantTO.getMessage());
                return tenantTO;
            }
            catch (InternalErrorException internal) {
                tenantTO.setTypeResponse(TypeError.FailOrder);
                StringWriter error = new StringWriter();
                internal.printStackTrace(new PrintWriter(error));
                tenantTO.setMessage(error.toString());
                this.log.error(tenantTO.getMessage());
                return tenantTO;
            }
        }
        catch (InternalErrorException internal) {
            tenantTO.setTypeResponse(TypeError.FailOrder);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
        catch (ConnectionException con) {
            tenantTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            con.printStackTrace(new PrintWriter(error));
            tenantTO.setMessage(error.toString());
            this.log.error(tenantTO.getMessage());
            return tenantTO;
        }
    }

    @Override
    public UserTO removeHw(String email, String appNameKey, String hw_oem_id) {
        UserTO userTO = new UserTO();
        try {
            EnterpriseConnection connection = this.getSFconnection();
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            String appName = productMap.getValue__c();
            userTO = this.getUser(email, appNameKey);
            HwOEMTO searchHW = new HwOEMTO();
            searchHW.setHwOEMId(hw_oem_id);
            if (userTO.getHwOEMTOs().contains(searchHW)) {
                searchHW.setId(userTO.getHwOEMTOs().get(userTO.getHwOEMTOs().indexOf(searchHW)).getId());
                this.setAssociationHostUser(connection, userTO, searchHW, false);
                LicenseTO licenseTO = this.getLicense(userTO.getTenantId());
                this.setAssociationHostLicense(connection, searchHW, licenseTO, false);
                userTO = this.getUser(email, appNameKey);
                userTO.setTypeResponse(TypeError.NoError);
                return userTO;
            }
            throw new InstanceNotFoundException((Object)("Error removing hardware :{" + email + ", " + appNameKey + ", " + hw_oem_id + "}"), this.getClass().getName());
        }
        catch (InstanceNotFoundException instance) {
            userTO.setTypeResponse(TypeError.NoRegister);
            StringWriter error = new StringWriter();
            instance.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
        catch (InternalErrorException internal) {
            userTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
        catch (ConnectionException e) {
            userTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            e.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
    }

    @Override
    public UserTO addHw(String email, String appNameKey, String hw_oem_id, String hw_oem_name) {
        return this.addHw(email, appNameKey, hw_oem_id, hw_oem_name, true);
    }

    @Override
    public UserTO addHw(String email, String appNameKey, String hw_oem_id, String hw_oem_name, Boolean isMobile) {
        EnterpriseConnection connection = this.getSFconnection();
        UserTO userTO = new UserTO();
        try {
            userTO = this.getUser(connection, email, appNameKey);
            return this.addHw(connection, userTO, appNameKey, hw_oem_id, hw_oem_name, isMobile, null);
        }
        catch (InternalErrorException internal) {
            userTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
        catch (InstanceNotFoundException instance) {
            userTO.setTypeResponse(TypeError.NoRegister);
            StringWriter error = new StringWriter();
            instance.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
    }

    public UserTO addHw(EnterpriseConnection connection, UserTO userTO, String appNameKey, String hw_oem_id, String hw_oem_name, Boolean isMobile, String licenseId) {
        try {
            String email = userTO.getUsername();
            int sizeHwAssociated = userTO.getHwOEMTOsEnabled().size();
            if (sizeHwAssociated >= 3) {
                userTO.setTypeResponse(TypeError.ManyDevices);
                userTO.setMessage("User has " + sizeHwAssociated + " devices associated to " + email + ". Please, contact our sales team at sales@mestrelab.com");
                this.log.error(userTO.getMessage());
                return userTO;
            }
            HwOEMTO searchHW = new HwOEMTO();
            searchHW.setHwOEMId(hw_oem_id);
            if (userTO.getHwOEMTOs() == null) {
                userTO.setHwOEMTOs(new ArrayList<HwOEMTO>());
            }
            if (!userTO.getHwOEMTOs().contains(searchHW)) {
                Host_ID__c host = this.getHostId(connection, hw_oem_id, hw_oem_name, isMobile);
                searchHW.setId(host.getId());
            } else {
                searchHW.setId(userTO.getHwOEMTOs().get(userTO.getHwOEMTOs().indexOf(searchHW)).getId());
            }
            this.setAssociationHostUser(connection, userTO, searchHW, true);
            LicenseTO licenseTO = licenseId == null ? this.getLicense(connection, userTO.getTenantId()) : this.getLicense(connection, licenseId);
            this.setAssociationHostLicense(connection, searchHW, licenseTO, true);
            userTO = this.getUser(connection, email, appNameKey);
            userTO.setTypeResponse(TypeError.NoError);
            userTO.setMessage(TypeError.NoError.getMessage());
            return userTO;
        }
        catch (ConnectionException e) {
            userTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            e.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
        catch (InternalErrorException internal) {
            userTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
        catch (InstanceNotFoundException instance) {
            userTO.setTypeResponse(TypeError.NoRegister);
            StringWriter error = new StringWriter();
            instance.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
    }

    private Lead getLead(EnterpriseConnection connection, String email) throws ConnectionException {
        QueryResult queryResults = connection.query("SELECT Id, email, name, firstName, lastName from Lead where email ='" + email + "' and IsConverted = false LIMIT 1");
        if (queryResults.getSize() > 0) {
            Lead lead = (Lead)queryResults.getRecords()[0];
            return lead;
        }
        return null;
    }

    private Lead getLeadCaseInsensitive(EnterpriseConnection connection, String email) throws ConnectionException {
        QueryResult queryResults = connection.query("SELECT Id, email, name, firstName, lastName from Lead where email LIKE '" + email + "' and IsConverted = false LIMIT 1");
        if (queryResults.getSize() > 0) {
            Lead lead = (Lead)queryResults.getRecords()[0];
            return lead;
        }
        return null;
    }

    private Lead getLeadById(EnterpriseConnection connection, String id) throws ConnectionException {
        QueryResult queryResults = connection.query("SELECT Id, email, name, firstName, lastName from Lead where id ='" + id + "' and IsConverted = false LIMIT 1");
        if (queryResults.getSize() > 0) {
            Lead lead = (Lead)queryResults.getRecords()[0];
            return lead;
        }
        return null;
    }

    private Contact getContactById(EnterpriseConnection connection, String id) throws ConnectionException, InternalErrorException {
        QueryResult queryResults = connection.query("SELECT Id, email, name, firstname, lastname from Contact where Id ='" + id + "' LIMIT 1");
        if (queryResults.getSize() > 0) {
            Contact contact = (Contact)queryResults.getRecords()[0];
            return contact;
        }
        return null;
    }

    private Contact getContact(EnterpriseConnection connection, String email, String nameContact, String recordType, Boolean toupdate) throws ConnectionException, InternalErrorException {
        QueryResult queryResults = connection.query("SELECT Id, email,AccountId,RecordTypeId from Contact where email ='" + email + "' LIMIT 1");
        if (queryResults.getSize() > 0) {
            Contact contact = (Contact)queryResults.getRecords()[0];
            queryResults = connection.query("select Id,Name,SobjectType,DeveloperName from RecordType where SobjectType='Contact' and DeveloperName='" + recordType + "' ");
            String recordTypeId = queryResults.getRecords()[0].getId();
            if (!recordTypeId.equals(contact.getRecordTypeId()) && toupdate.booleanValue()) {
                contact.setRecordTypeId(recordTypeId);
                Contact[] recortypeContact = new Contact[]{contact};
                SaveResult[] saveResults = connection.update((SObject[])recortypeContact);
                if (saveResults != null && saveResults.length > 0) {
                    if (!saveResults[0].isSuccess()) {
                        throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
                    }
                } else {
                    throw new InternalErrorException((Object)("Error update contact :{" + email + ", " + nameContact + "}"), this.getClass().getName());
                }
            }
            return contact;
        }
        return null;
    }

    private Contact getContact(EnterpriseConnection connection, String email, String nameContact, String lastNameContact, String recordType, Boolean toupdate) throws ConnectionException, InternalErrorException {
        QueryResult queryResults = connection.query("SELECT Id, email,AccountId,RecordTypeId from Contact where email ='" + email + "' LIMIT 1");
        if (queryResults.getSize() > 0) {
            Contact contact = (Contact)queryResults.getRecords()[0];
            queryResults = connection.query("select Id,Name,SobjectType,DeveloperName from RecordType where SobjectType='Contact' and DeveloperName='" + recordType + "' ");
            String recordTypeId = queryResults.getRecords()[0].getId();
            if (!recordTypeId.equals(contact.getRecordTypeId()) && toupdate.booleanValue()) {
                contact.setRecordTypeId(recordTypeId);
                Contact[] recortypeContact = new Contact[]{contact};
                SaveResult[] saveResults = connection.update((SObject[])recortypeContact);
                if (saveResults != null && saveResults.length > 0) {
                    if (!saveResults[0].isSuccess()) {
                        throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
                    }
                } else {
                    throw new InternalErrorException((Object)("Error update contact :{" + email + ", " + nameContact + "}"), this.getClass().getName());
                }
            }
            return contact;
        }
        queryResults = connection.query("select Id,Name,SobjectType,DeveloperName from RecordType where SobjectType='Contact' and DeveloperName='" + recordType + "' ");
        String recordTypeId = queryResults.getRecords()[0].getId();
        if (queryResults.getSize() > 0) {
            Contact contact = new Contact();
            contact.setEmail(email);
            contact.setLastName(lastNameContact);
            contact.setFirstName(nameContact);
            contact.setRecordTypeId(recordTypeId);
            QueryResult queryResultsAccount = connection.query("select Id,Name from Account where Id='001D000001Sw7N1'");
            if (queryResultsAccount.getSize() <= 0) {
                throw new InternalErrorException((Object)"Error searching account StoreMestrelab", this.getClass().getName());
            }
            contact.setAccountId(queryResultsAccount.getRecords()[0].getId());
            Contact[] newContact = new Contact[]{contact};
            SaveResult[] saveResults = connection.create((SObject[])newContact);
            if (saveResults != null && saveResults.length > 0) {
                if (!saveResults[0].isSuccess()) {
                    throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
                }
            } else {
                throw new InternalErrorException((Object)("Error creating contact :{" + email + ", " + nameContact + "}"), this.getClass().getName());
            }
            contact.setId(saveResults[0].getId());
            return contact;
        }
        throw new InternalErrorException((Object)"Error searching recordtype customer", this.getClass().getName());
    }

    private PricebookEntry getProduct(EnterpriseConnection connection, String appNameKey) throws InternalErrorException, ConnectionException {
        ProductMap__c productMap = this.getProductMap(connection, appNameKey);
        if (productMap == null) {
            throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
        }
        String appName = productMap.getValue__c();
        QueryResult queryResults = connection.query("select id,UnitPrice, pricebook2.name,product2.Id,product2.Name,product2.StoreProductName__c,product2.StoreProductShortDescription__c,product2.StoreProductDescription__c,product2.ProductCode, product2.product_group__c,product2.LicenceDuration__c,product2.LicencePackage__c,product2.LicenceType__c,product2.License_Groupings__c ,product2.EndUserType__c,product2.IsActive from PricebookEntry where product2.ProductCode='" + appName + "' and IsActive=true order by CreatedDate desc LIMIT 1");
        if (queryResults.getSize() > 0) {
            PricebookEntry pricebookEntry = (PricebookEntry)queryResults.getRecords()[0];
            return pricebookEntry;
        }
        throw new InternalErrorException((Object)("Error searching product :{" + appName + ", " + appName + "}"), this.getClass().getName());
    }

    public Host_ID__c getHostId(EnterpriseConnection connection, String id) throws InternalErrorException, ConnectionException {
        QueryResult queryResults = connection.query("SELECT Id, Name, Mobile__c,HwOEMId__c,HwOEMName__c,(select Id,Name from Host_ID__c.SaasUserHostAssociations__r) from Host_ID__c where Id ='" + id + "' ");
        Host_ID__c host = (Host_ID__c)queryResults.getRecords()[0];
        return host;
    }

    private Host_ID__c getHostId(EnterpriseConnection connection, String hw_oem_id, String hw_oem_name, Boolean isMobile) throws InternalErrorException, ConnectionException {
        QueryResult queryResults = connection.query("SELECT Id, Name, Mobile__c,HwOEMId__c,HwOEMName__c from Host_ID__c where HwOEMId__c ='" + hw_oem_id + "' ");
        if (queryResults.getSize() > 0) {
            if (queryResults.getSize() > 1) {
                throw new InternalErrorException((Object)("Exists " + queryResults.getSize() + " with the same hw:{" + hw_oem_id + "}"), this.getClass().getName());
            }
            Host_ID__c host = (Host_ID__c)queryResults.getRecords()[0];
            return host;
        }
        Host_ID__c host = new Host_ID__c();
        host.setMobile__c(isMobile);
        host.setName(hw_oem_id);
        host.setHwOEMId__c(hw_oem_id);
        host.setHwOEMName__c(hw_oem_name);
        Host_ID__c[] records = new Host_ID__c[]{host};
        SaveResult[] saveResults = connection.create((SObject[])records);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error adding hardware :{" + hw_oem_id + "}"), this.getClass().getName());
        }
        host.setId(saveResults[0].getId());
        return host;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAssociationHostUser(EnterpriseConnection connection, UserTO userTO, HwOEMTO searchHW, Boolean enabled) throws ConnectionException, InternalErrorException {
        SaasUserHostAssociation__c[] records;
        SaveResult[] saveResults;
        QueryResult queryResults = connection.query("SELECT Id, Name,Enabled__c from SaasUserHostAssociation__c where HostId__c ='" + searchHW.getId() + "' and SaasUser__c='" + userTO.getId() + "'");
        if (queryResults.getSize() > 0) {
            if (queryResults.getSize() > 1) {
                throw new InternalErrorException((Object)("Exists  " + queryResults.getSize() + " with the same hw/user:{" + searchHW.getHwOEMId() + "," + userTO.getName() + "}"), this.getClass().getName());
            }
            SaasUserHostAssociation__c userHost = (SaasUserHostAssociation__c)queryResults.getRecords()[0];
            if (userHost.getEnabled__c().equals(enabled)) return;
            userHost.setEnabled__c(enabled);
            SaasUserHostAssociation__c[] records2 = new SaasUserHostAssociation__c[]{userHost};
            SaveResult[] saveResults2 = connection.update((SObject[])records2);
            if (saveResults2 == null || saveResults2.length <= 0) throw new InternalErrorException((Object)("Error updating hardware to user :{" + userTO.getName() + ", " + searchHW.getHwOEMId() + "}"), this.getClass().getName());
            if (saveResults2[0].isSuccess()) return;
            throw new InternalErrorException(saveResults2[0].getErrors()[0], this.getClass().getName());
        }
        SaasUserHostAssociation__c userHost = new SaasUserHostAssociation__c();
        userHost.setSaasUser__c(userTO.getId());
        userHost.setHostId__c(searchHW.getId());
        userHost.setEnabled__c(enabled);
        userHost.setName(userTO.getName() + "(" + searchHW.getHwOEMId() + ")");
        if (userHost.getName().length() > 79) {
            userHost.setName(userHost.getName().substring(0, 78));
        }
        if ((saveResults = connection.create((SObject[])(records = new SaasUserHostAssociation__c[]{userHost}))) == null || saveResults.length <= 0) throw new InternalErrorException((Object)("Error adding hardware to user :{" + userTO.getName() + ", " + searchHW.getHwOEMId() + "}"), this.getClass().getName());
        if (saveResults[0].isSuccess()) return;
        throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAssociationHostLicense(EnterpriseConnection connection, HwOEMTO searchHW, LicenseTO licenseTO, Boolean enabled) throws ConnectionException, InternalErrorException {
        LicenseHostAssociation__c[] recordsLic;
        SaveResult[] saveResults;
        QueryResult queryResults = connection.query("SELECT Id, Name,Enabled__c from LicenseHostAssociation__c where Host_ID__c ='" + searchHW.getId() + "' and License__c='" + licenseTO.getId() + "'");
        if (queryResults.getSize() > 0) {
            if (queryResults.getSize() > 1) {
                throw new InternalErrorException((Object)("Exists  " + queryResults.getSize() + " with the same hw/license:{" + searchHW.getHwOEMId() + "," + licenseTO.getName() + "}"), this.getClass().getName());
            }
            LicenseHostAssociation__c licenseHost = (LicenseHostAssociation__c)queryResults.getRecords()[0];
            if (licenseHost.getEnabled__c().equals(enabled)) return;
            licenseHost.setEnabled__c(enabled);
            LicenseHostAssociation__c[] records = new LicenseHostAssociation__c[]{licenseHost};
            SaveResult[] saveResults2 = connection.update((SObject[])records);
            if (saveResults2 == null || saveResults2.length <= 0) throw new InternalErrorException((Object)("Error updating hardware to license :{" + licenseTO.getName() + ", " + searchHW.getHwOEMId() + "}"), this.getClass().getName());
            if (saveResults2[0].isSuccess()) return;
            throw new InternalErrorException(saveResults2[0].getErrors()[0], this.getClass().getName());
        }
        LicenseHostAssociation__c licenseHost = new LicenseHostAssociation__c();
        licenseHost.setLicense__c(licenseTO.getId());
        licenseHost.setHost_ID__c(searchHW.getId());
        licenseHost.setEnabled__c(enabled);
        licenseHost.setName(licenseTO.getName() + "(" + searchHW.getHwOEMId() + ")");
        if (licenseHost.getName().length() > 79) {
            licenseHost.setName(licenseHost.getName().substring(0, 78));
        }
        if ((saveResults = connection.create((SObject[])(recordsLic = new LicenseHostAssociation__c[]{licenseHost}))) == null || saveResults.length <= 0) throw new InternalErrorException((Object)("Error adding hardware to license :{" + licenseTO.getName() + ", " + searchHW.getHwOEMId() + "}"), this.getClass().getName());
        if (saveResults[0].isSuccess()) return;
        throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
    }

    private SaasUserHostAssociation__c[] getUserwithSameHW(EnterpriseConnection connection, String hw, String appNameKey) throws ConnectionException {
        QueryResult queryResults = connection.query("SELECT Id, Name, HostId__r.hwOEMId__c,Enabled__c from SaasUserHostAssociation__c where HostId__r.hwOEMId__c ='" + hw + "'");
        ArrayList<SaasUserHostAssociation__c> usersByHost = new ArrayList<SaasUserHostAssociation__c>();
        for (SObject a : queryResults.getRecords()) {
            SaasUserHostAssociation__c u = (SaasUserHostAssociation__c)a;
            usersByHost.add(u);
        }
        return usersByHost.toArray(new SaasUserHostAssociation__c[0]);
    }

    private MOrder__c createOrder(EnterpriseConnection connection, String email, String nameContact, String idTransaction, String platform, Calendar dateTransaction, Double price, Contact contact) throws InternalErrorException, ConnectionException {
        MOrder__c order = new MOrder__c();
        order.setName(idTransaction);
        order.setPaid__c(Boolean.valueOf(true));
        order.setPayment_Method__c(platform);
        order.setAmount_Opp__c(price);
        order.setVAT_percent__c(Double.valueOf(0.0));
        order.setTransaction_Number__c(idTransaction);
        order.setTransaction_Date__c(dateTransaction);
        order.setContact_Purchase__c(contact.getId());
        order.setAccount_Purchase__c(contact.getAccountId());
        order.setContact_Billing__c(contact.getId());
        order.setAccount_Billing__c(contact.getAccountId());
        MOrder__c[] recordsOrder = new MOrder__c[]{order};
        SaveResult[] saveResults = connection.create((SObject[])recordsOrder);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error creating order :{" + email + ", " + idTransaction + "}"), this.getClass().getName());
        }
        order.setId(saveResults[0].getId());
        return order;
    }

    @Override
    public boolean createOrderWithoutTenant(String nameContact, String email, String appNameKey, Double quantity, String idTransaction, Calendar dateTransaction, String platform, String note) {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            ProductMap__c productMap = this.getProductMap(connection, appNameKey);
            if (productMap == null) {
                throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
            }
            String appName = productMap.getValue__c();
            PricebookEntry pricebookEntry = this.getProduct(connection, appNameKey);
            MOrder__c orderStored = this.searchOrderByTransaction(connection, idTransaction);
            if (orderStored != null) {
                return true;
            }
            Contact contact = this.getContact(connection, email, "", nameContact, "Customers", true);
            MOrder__c order = this.createOrder(connection, email, nameContact, idTransaction, platform, dateTransaction, this.calculePrice(pricebookEntry.getUnitPrice(), appName) * quantity, contact);
            this.createAsset(connection, appNameKey, this.calculePrice(pricebookEntry.getUnitPrice() * quantity, appNameKey), quantity, order, contact, null, note, true);
            return true;
        }
        catch (InternalErrorException internal) {
            this.log.error(internal.getMessage());
            return false;
        }
        catch (ConnectionException con) {
            this.log.error(con.getMessage());
            return false;
        }
    }

    private Asset createAsset(EnterpriseConnection connection, String appNameKey, Double price, Double quantity, MOrder__c order, Contact contact, TenantTO tenantTO, String note, Boolean recalculateDates) throws InternalErrorException, ConnectionException {
        ProductMap__c productMap = this.getProductMap(connection, appNameKey);
        if (productMap == null) {
            throw new InternalErrorException((Object)appNameKey, this.getClass().getName());
        }
        String appName = productMap.getValue__c();
        Asset assetTablet = new Asset();
        PricebookEntry pricebookEntry = this.getProduct(connection, appNameKey);
        assetTablet.setName(pricebookEntry.getProduct2().getName());
        assetTablet.setPrice(price);
        assetTablet.setQuantity(quantity);
        assetTablet.setOrder__c(order.getId());
        assetTablet.setProduct2Id(pricebookEntry.getProduct2().getId());
        assetTablet.setAccountId(contact.getAccountId());
        assetTablet.setContactId(contact.getId());
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar dateStartLicense = Calendar.getInstance(utc);
        assetTablet.setPurchaseDate(dateStartLicense);
        Calendar dateEndLicense = (Calendar)dateStartLicense.clone();
        dateEndLicense.add(1, 1);
        Calendar start = null;
        if (tenantTO != null && tenantTO.getLicenseTOs() != null && recalculateDates.booleanValue()) {
            for (LicenseTO licTO : tenantTO.getLicenseTOs()) {
                start = (Calendar)dateStartLicense.clone();
                while (start.before(licTO.getUsageEndDate())) {
                    start.add(5, 1);
                    dateEndLicense.add(5, 1);
                }
            }
        }
        dateEndLicense.add(5, 1);
        assetTablet.setUsageEndDate(dateEndLicense);
        Asset[] recordsAsset = new Asset[]{assetTablet};
        SaveResult[] saveResults = connection.create((SObject[])recordsAsset);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error creating asset for order:{" + order.getName() + ", " + appName + " }"), this.getClass().getName());
        }
        assetTablet.setId(saveResults[0].getId());
        Note dataPurchase = new Note();
        dataPurchase.setParentId(assetTablet.getId());
        dataPurchase.setTitle(purchaseData);
        dataPurchase.setBody(note);
        Note[] recordsNote = new Note[]{dataPurchase};
        SaveResult[] saveResultsNote = connection.create((SObject[])recordsNote);
        if (saveResultsNote != null && saveResultsNote.length > 0) {
            if (!saveResultsNote[0].isSuccess()) {
                throw new InternalErrorException(saveResultsNote[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error creating note for order:{" + order.getName() + ", " + appName + " }"), this.getClass().getName());
        }
        return assetTablet;
    }

    public String createInitialLicense(EnterpriseConnection connection, TenantTO tenantTO, LicenseTO licenseTO) throws InternalErrorException, InstanceNotFoundException, ConnectionException {
        License__c licenseSF = new License__c();
        licenseSF.setSaas_Tenant__c(tenantTO.getId());
        licenseSF.setName(licenseTO.getName());
        licenseSF.setAsset__c(licenseTO.getAssetId());
        licenseSF.setMOPS__c(licenseTO.getMops());
        licenseSF.setUsageStartDate__c(licenseTO.getUsageStartDate());
        licenseSF.setUsageEndDate__c(licenseTO.getUsageEndDate());
        licenseSF.setProduct__c(licenseTO.getProductName());
        License__c[] records = new License__c[]{licenseSF};
        SaveResult[] saveResults = connection.create((SObject[])records);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error creating license :{" + licenseTO.getName() + "}"), this.getClass().getName());
        }
        String idLicense = saveResults[0].getId();
        License__c[] toUpdate = new License__c[]{new License__c()};
        toUpdate[0].setId(idLicense);
        connection.update((SObject[])toUpdate);
        return idLicense;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private License__c createLicense(EnterpriseConnection connection, TenantTO tenantTO, LicenseTO licenseTO) throws InternalErrorException, ConnectionException, InstanceNotFoundException {
        License__c licenseSF = new License__c();
        licenseSF.setSaas_Tenant__c(tenantTO.getId());
        licenseSF.setName(licenseTO.getName());
        License__c[] records = new License__c[]{licenseSF};
        SaveResult[] saveResults = connection.create((SObject[])records);
        if (saveResults == null || saveResults.length <= 0) throw new InternalErrorException((Object)("Error creating license :{" + licenseTO.getName() + "}"), this.getClass().getName());
        if (!saveResults[0].isSuccess()) {
            throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
        }
        licenseSF.setId(saveResults[0].getId());
        ArrayList<LicenseHostAssociation__c> licenseHost = new ArrayList<LicenseHostAssociation__c>();
        QueryResult queryResults = connection.query("SELECT Id, Name,Asset__c,Enable_SaaS__c,LicenseId__c,MOPS__c,notifyExpiredTrial__c,Saas_Tenant__c,usageEndDate__c,usageStartDate__c,(select id, Name,enabled__c,Host_ID__c,Host_ID__r.Id,Host_ID__r.Name,Host_ID__r.hwOEMId__c,Host_ID__r.mobile__c from License__c.LicenseHostAssociations__r)   FROM License__c where Id='" + licenseTO.getId() + "' order by usageEndDate__c desc,CreatedDate desc LIMIT 1 ");
        if (queryResults.getSize() <= 0) throw new InstanceNotFoundException((Object)("Error searching license :{" + licenseTO.getName() + ", " + licenseTO.getId() + "}"), this.getClass().getName());
        License__c licenseTenant = (License__c)queryResults.getRecords()[0];
        if (licenseTenant.getLicenseHostAssociations__r() != null) {
            SObject[] hostsLicense = licenseTenant.getLicenseHostAssociations__r().getRecords();
            for (int i = 0; i < hostsLicense.length; ++i) {
                LicenseHostAssociation__c hostLicense = (LicenseHostAssociation__c)hostsLicense[i];
                LicenseHostAssociation__c newHostLicense = new LicenseHostAssociation__c();
                newHostLicense.setName(hostLicense.getName());
                newHostLicense.setLicense__c(licenseSF.getId());
                newHostLicense.setHost_ID__c(hostLicense.getHost_ID__c());
                newHostLicense.setEnabled__c(hostLicense.getEnabled__c());
                licenseHost.add(newHostLicense);
            }
        }
        if (licenseHost.size() > 0) {
            saveResults = connection.create((SObject[])licenseHost.toArray(new LicenseHostAssociation__c[0]));
            if (saveResults == null || saveResults.length <= 0) throw new InternalErrorException((Object)("Error creating licensehost associate to license :{" + licenseSF.getName() + ", " + licenseSF.getId() + "}"), this.getClass().getName());
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        }
        Note noteLicense = new Note();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/M/yyyy");
        noteLicense.setParentId(licenseTenant.getId());
        noteLicense.setTitle("Disabled by new license: " + licenseSF.getId());
        noteLicense.setBody("Info:\nstartDate:" + sdf.format(licenseTenant.getUsageStartDate__c().getTime()) + "\n endDate:" + sdf.format(licenseTenant.getUsageEndDate__c().getTime()));
        Note[] saveNote = new Note[]{noteLicense};
        saveResults = connection.create((SObject[])saveNote);
        if (saveResults == null || saveResults.length <= 0) throw new InternalErrorException((Object)("Error update previous license :{" + licenseTenant.getName() + ", " + licenseTenant.getId() + "}"), this.getClass().getName());
        if (!saveResults[0].isSuccess()) {
            throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
        }
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar calendar = Calendar.getInstance(utc);
        calendar.add(5, -1);
        if (licenseTenant.getAsset__c() != null) {
            Asset assetUpdate = new Asset();
            assetUpdate.setId(licenseTenant.getAsset__c());
            assetUpdate.setUsageEndDate(calendar);
            Asset[] recordsAsset = new Asset[]{assetUpdate};
            saveResults = connection.update((SObject[])recordsAsset);
            if (saveResults == null || saveResults.length <= 0) throw new InternalErrorException((Object)("Error update previous asset :{" + licenseTenant.getName() + ", " + licenseTenant.getAsset__c() + "}"), this.getClass().getName());
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        }
        License__c licenseUpdate = new License__c();
        licenseUpdate.setId(licenseTenant.getId());
        licenseUpdate.setUsageEndDate__c(calendar);
        records = new License__c[]{licenseUpdate};
        saveResults = connection.update((SObject[])records);
        if (saveResults == null || saveResults.length <= 0) throw new InternalErrorException((Object)("Error update previous license :{" + licenseTenant.getName() + ", " + licenseTenant.getId() + "}"), this.getClass().getName());
        if (saveResults[0].isSuccess()) return licenseSF;
        throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
    }

    private Boolean updateLicense(EnterpriseConnection connection, Asset asset, License__c licenseSF, ProductMap__c productMap) throws InternalErrorException, ConnectionException {
        License__c[] records;
        SaveResult[] saveResults;
        int incrCoins;
        licenseSF.setAsset__c(asset.getId());
        if (productMap.getIncrCoinsByAsset__c() != null && !productMap.getIncrCoinsByAsset__c().trim().isEmpty() && (incrCoins = new Integer(productMap.getIncrCoinsByAsset__c()).intValue()) > 0 && (asset.getName().contains("coin") || asset.getName().contains("Coin"))) {
            licenseSF.setMOPS__c(Double.valueOf((licenseSF.getMOPS__c() == null ? 0.0 : licenseSF.getMOPS__c()) + new Double(incrCoins * asset.getQuantity().intValue())));
        }
        if ((saveResults = connection.update((SObject[])(records = new License__c[]{licenseSF}))) != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error updating license with asset :{" + asset.getId() + "}"), this.getClass().getName());
        }
        return true;
    }

    private MOrder__c searchOrderByTransaction(EnterpriseConnection connection, String idTransaction) throws ConnectionException {
        QueryResult queryResults = connection.query("SELECT Id,Name,Transaction_Number__c from MOrder__c where Transaction_Number__c='" + idTransaction + "' ");
        if (queryResults.getSize() > 0) {
            return (MOrder__c)queryResults.getRecords()[0];
        }
        return null;
    }

    private Double calculePrice(Double price, String appName) {
        if (this.productListpercert.contains(appName.trim())) {
            return price * 0.7;
        }
        return price;
    }

    @Override
    public void createEntryLog(String name, String licenseId, String comment, Double quantity, String type, Double currentMops) throws InternalErrorException, ConnectionException {
        EnterpriseConnection connection = this.getSFconnection();
        this.createEntryLog(connection, name, licenseId, comment, quantity, type, currentMops);
    }

    @Override
    public List<MopsTO> getListMops(String licenseId) {
        ArrayList<MopsTO> results = new ArrayList<MopsTO>();
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id, Name,CreateDate__c,Quantity__c,Type__c,comment__c from MOPSLog__c where License__c ='" + licenseId + "' order by CreateDate__c desc");
            if (queryResults.getSize() > 0) {
                for (int i = 0; i < queryResults.getSize(); ++i) {
                    MOPSLog__c log = (MOPSLog__c)queryResults.getRecords()[i];
                    MopsTO to = new MopsTO(log.getName(), log.getType__c(), log.getQuantity__c(), log.getComment__c(), log.getCreateDate__c().getTime());
                    results.add(to);
                }
            }
        }
        catch (ConnectionException con) {
            this.log.error(con.getMessage());
        }
        return results;
    }

    private void createEntryLog(EnterpriseConnection connection, String name, String licenseId, String comment, Double quantity, String type, Double currentMops) throws InternalErrorException, ConnectionException {
        MOPSLog__c logEntry = new MOPSLog__c();
        logEntry.setComment__c(comment);
        logEntry.setLicense__c(licenseId);
        logEntry.setQuantity__c(quantity);
        logEntry.setType__c(type);
        logEntry.setName(name);
        logEntry.setCurrentMOPS__c(currentMops);
        MOPSLog__c[] records = new MOPSLog__c[]{logEntry};
        SaveResult[] saveResults = connection.create((SObject[])records);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error creating log :{" + licenseId + ", " + name + "}"), this.getClass().getName());
        }
    }

    @Override
    public String updateMops(String id, double newMops) throws InternalErrorException, ConnectionException {
        EnterpriseConnection connection = this.getSFconnection();
        return this.updateMops(connection, id, newMops);
    }

    private String updateMops(EnterpriseConnection connection, String id, double newMops) throws InternalErrorException, ConnectionException {
        License__c license = new License__c();
        license.setId(id);
        license.setMOPS__c(Double.valueOf(newMops));
        License__c[] records = new License__c[]{license};
        SaveResult[] saveResults = connection.update((SObject[])records);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
            return saveResults[0].getId();
        }
        throw new InternalErrorException((Object)("Error updateMops :{" + id + "}"), this.getClass().getName());
    }

    private void copyEnvironment(EnterpriseConnection connection, String username, String appNameKeyFrom, String appNameKeyTO, Boolean allusers) throws InternalErrorException, InstanceNotFoundException, ConnectionException {
        TenantTO tenantToCopy = this.getTenant(connection, username, appNameKeyFrom);
        Saas_Tenant__c saasTenant = this.createTenantReturnObject(connection, null, tenantToCopy.getParameters(), appNameKeyTO, " copy environment from " + tenantToCopy.getName(), true, "");
        ArrayList<UserTO> users = new ArrayList<UserTO>();
        if (!allusers.booleanValue()) {
            for (UserTO u : tenantToCopy.getUserTOs()) {
                if (!u.getUsername().equals(username)) continue;
                users.add(u);
            }
        } else {
            users.addAll(tenantToCopy.getUserTOs());
        }
        this.copyUsersToTenant(connection, saasTenant.getId(), users, "user copy from " + tenantToCopy.getName());
        this.copyHwToUser(connection, username, appNameKeyTO, users);
        this.copyHwToLicense(connection, username, appNameKeyTO, users);
    }

    private void copyUsersToTenant(EnterpriseConnection connection, String tenantId, List<UserTO> userTOs, String comment) throws ConnectionException, InternalErrorException {
        ArrayList<Saas_User__c> saasUsers = new ArrayList<Saas_User__c>();
        for (UserTO userTO : userTOs) {
            Saas_User__c saasUser = new Saas_User__c();
            saasUser.setName(userTO.getName());
            saasUser.setTenantId__c(tenantId);
            saasUser.setUsername__c(userTO.getUsername());
            saasUser.setComment__c(comment);
            String userId = this.generateUserId();
            saasUser.setUserId__c(userId.toLowerCase());
            saasUser.setEnabled__c(userTO.getEnabled());
            saasUser.setPasswd__c(userTO.getPassword());
            saasUsers.add(saasUser);
        }
        SaveResult[] saveResults = connection.create((SObject[])saasUsers.toArray(new Saas_User__c[0]));
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error copyUsersToTenant to tenant:{" + tenantId + "}"), this.getClass().getName());
        }
    }

    private void copyHwToUser(EnterpriseConnection connection, String username, String appNameKeyTO, List<UserTO> usersTOFrom) throws InstanceNotFoundException, InternalErrorException, ConnectionException {
        TenantTO tenantTO = this.getTenant(connection, username, appNameKeyTO);
        HashMap<UserTO, List<HwOEMTO>> userHostMap = new HashMap<UserTO, List<HwOEMTO>>();
        ArrayList<SaasUserHostAssociation__c> userHostToCreate = new ArrayList<SaasUserHostAssociation__c>();
        for (UserTO userTO_From : usersTOFrom) {
            userHostMap.put(userTO_From, userTO_From.getHwOEMTOs());
        }
        for (UserTO userTO_To : tenantTO.getUserTOs()) {
            List hwsOEMTO_From = (List)userHostMap.get(userTO_To);
            if (hwsOEMTO_From == null) continue;
            for (HwOEMTO hw : hwsOEMTO_From) {
                SaasUserHostAssociation__c userHost = new SaasUserHostAssociation__c();
                userHost.setEnabled__c(hw.getEnabled());
                userHost.setHostId__c(hw.getId());
                userHost.setSaasUser__c(userTO_To.getId());
                userHost.setName(userTO_To.getName().concat("(").concat(hw.getHwOEMId()).concat(")"));
                userHostToCreate.add(userHost);
            }
        }
        SaveResult[] saveResults = connection.create((SObject[])userHostToCreate.toArray(new SaasUserHostAssociation__c[0]));
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error copyHwToUser to user:{" + username + "}"), this.getClass().getName());
        }
    }

    private void copyHwToLicense(EnterpriseConnection connection, String username, String appNameKeyTO, List<UserTO> usersTOFrom) throws InstanceNotFoundException, InternalErrorException, ConnectionException {
        TenantTO tenantTO = this.getTenant(connection, username, appNameKeyTO);
        ArrayList<LicenseHostAssociation__c> licenseHostToCreate = new ArrayList<LicenseHostAssociation__c>();
        LicenseTO currentLicenseTO = tenantTO.getLicenseTOs().get(0);
        for (UserTO userTO_To : tenantTO.getUserTOs()) {
            for (HwOEMTO hw : userTO_To.getHwOEMTOs()) {
                LicenseHostAssociation__c licenseHost = new LicenseHostAssociation__c();
                licenseHost.setEnabled__c(hw.getEnabled());
                licenseHost.setHost_ID__c(hw.getId());
                licenseHost.setLicense__c(currentLicenseTO.getId());
                licenseHost.setName(currentLicenseTO.getName().concat("(").concat(hw.getHwOEMId()).concat(")"));
                licenseHostToCreate.add(licenseHost);
            }
        }
        SaveResult[] saveResults = connection.create((SObject[])licenseHostToCreate.toArray(new LicenseHostAssociation__c[0]));
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error copyHwToLicense to user:{" + username + "}"), this.getClass().getName());
        }
    }

    @Override
    public String newTenantAndCopyUser(String userId, String appNamekeyFrom, String appNamekeyTO) throws InternalErrorException, InstanceNotFoundException {
        EnterpriseConnection connection = this.getSFconnection();
        String username = this.getUserName(connection, userId);
        UserTO userTO = this.getUser(connection, username, appNamekeyFrom);
        Saas_Tenant__c tenant = this.createTenantReturnObject(connection, null, "", appNamekeyTO, " copy environment from " + userTO.getTenantId(), true, "");
        Long tenantId = new Long(tenant.getIdTenant__c());
        String idUser = this.createUserCopy(connection, tenantId, userTO.getUsername(), userTO.getPassword(), userTO.getComments(), userTO.getEnabled());
        this.createSaaSForm(connection, userTO.getUsername(), appNamekeyTO, true, true, true);
        return idUser;
    }

    private void createSaaSForm(EnterpriseConnection connection, String username, String appNameKey, Boolean confirmed, Boolean tenantGenerated, Boolean welcomeEmail) throws InstanceNotFoundException, InternalErrorException {
        block4: {
            UserTO userTO = this.getUser(connection, username, appNameKey);
            try {
                SaaSForm__c saasForm = new SaaSForm__c();
                saasForm.setName(appNameKey + "-" + userTO.getName());
                saasForm.setEmail__c(userTO.getUsername());
                saasForm.setAppName__c(appNameKey);
                saasForm.setConfirmed__c(confirmed);
                saasForm.setTenantGenerated__c(tenantGenerated);
                saasForm.setWelcomeEmail__c(welcomeEmail);
                saasForm.setToken__c(userTO.getPassword());
                StringBuffer message = new StringBuffer();
                message.append("CreateSaaSForm automatic:\n");
                message.append("------------------------\n");
                message.append("TenantApp:" + appNameKey + "\n");
                message.append("TenantId:" + userTO.getTenantId() + "\n");
                message.append("UserId:" + userTO.getUserId() + "\n");
                message.append("PlainPwd:" + saasForm.getToken__c() + "\n");
                message.append("Email:" + username + "\n");
                saasForm.setServerMessage__c(message.toString());
                SaaSForm__c[] records = new SaaSForm__c[]{saasForm};
                SaveResult[] saveResults = connection.create((SObject[])records);
                if (saveResults != null && saveResults.length > 0) {
                    if (!saveResults[0].isSuccess()) {
                        throw new InternalErrorException(saveResults[0].getErrors(), this.getClass().getName());
                    }
                    break block4;
                }
                throw new InternalErrorException(saveResults, "SaveResult array is null");
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
    }

    @Override
    public boolean processAssetFromSaasUser(String userId, String usernameParam, String appNamekey, String idAssetParam) throws InternalErrorException, InstanceNotFoundException {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            String username = usernameParam;
            if (userId != null) {
                username = this.getUserName(connection, userId);
            }
            TenantTO tenantTO = this.getTenant(connection, username, appNamekey);
            LicenseTO licenseTO = tenantTO.getLicenseTOs().get(0);
            ProductMap__c productMap = this.getProductMap(connection, appNamekey);
            if (licenseTO.getAssetId() == null) {
                tenantTO.setParameters(productMap.getProductionParameters__c());
            }
            Asset asset = this.getAsset(connection, idAssetParam);
            License__c newLicense = this.createLicense(connection, tenantTO, licenseTO);
            this.updateParametersTenant(connection, tenantTO, productMap, asset);
            return this.updateLicense(connection, asset, newLicense, productMap);
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private void updateParametersTenant(EnterpriseConnection connection, TenantTO tenantTO, ProductMap__c productMap, Asset asset) throws InternalErrorException, InstanceNotFoundException {
        block6: {
            Map<String, String> mapParameters = TenantTO.getMapParameters(tenantTO.getParameters());
            if (mapParameters.containsKey(Constants.USER_STORAGE_LIMIT)) {
                Long currentStorage = new Long(mapParameters.get(Constants.USER_STORAGE_LIMIT).split("M")[0]);
                currentStorage = currentStorage + (long)(new Integer(productMap.getIncrMemoryByAsset__c()) * asset.getQuantity().intValue());
                mapParameters.put(Constants.USER_STORAGE_LIMIT, currentStorage + "M");
            }
            if (!asset.getName().contains("storage") && !asset.getName().contains("Storage") && mapParameters.containsKey(Constants.USER_COUNT_LIMIT)) {
                Integer currentUser = new Integer(mapParameters.get(Constants.USER_COUNT_LIMIT));
                currentUser = currentUser + new Integer(new Integer(productMap.getIncrUserByAsset__c()) * asset.getQuantity().intValue());
                mapParameters.put(Constants.USER_COUNT_LIMIT, currentUser.toString());
            }
            tenantTO.setParameters(TenantTO.parametersToString(mapParameters));
            try {
                QueryResult queryResults = connection.query("SELECT Id, parameters__c FROM Saas_Tenant__c where IdTenant__c='" + tenantTO.getTenantId() + "' LIMIT 1");
                if (queryResults.getSize() > 0) {
                    Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                    saasTenant.setParameters__c(Utils.mapToJson(TenantTO.getMapParameters(tenantTO.getParameters())));
                    Saas_Tenant__c[] objs = new Saas_Tenant__c[]{saasTenant};
                    SaveResult[] saveResults = connection.update((SObject[])objs);
                    if (saveResults.length > 0 && !saveResults[0].getSuccess()) {
                        throw new InternalErrorException(saveResults[0].getErrors()[0], "error saving Tenant");
                    }
                    break block6;
                }
                throw new InstanceNotFoundException(tenantTO.getTenantId(), this.getClass().getName());
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
    }

    private Asset getAsset(EnterpriseConnection connection, String idAsset) throws InstanceNotFoundException, InternalErrorException {
        try {
            QueryResult queryResults = connection.query("SELECT Id, Name, Quantity, Product2.ProductCode  FROM Asset where id='" + idAsset + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                Asset asset = (Asset)queryResults.getRecords()[0];
                return asset;
            }
            throw new InstanceNotFoundException((Object)idAsset, this.getClass().getName());
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private String generateUserId() {
        Random r = new Random();
        return Utils.getSHA1("" + Math.abs(r.nextInt(10000000))).substring(0, 12);
    }

    @Override
    public Double retrieveBatchSize(String licenseId, String hwid) {
        try {
            License__c lic;
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id,Name,UMOPS__c,MOPS__c FROM License__c where id='" + licenseId + "' LIMIT 1");
            if (queryResults.getSize() > 0 && (lic = (License__c)queryResults.getRecords()[0]).getUMOPS__c() != null && lic.getMOPS__c() != null) {
                Double newMops = lic.getMOPS__c() - lic.getUMOPS__c() < 0.0 ? new Double(0.0) : lic.getMOPS__c() - lic.getUMOPS__c();
                Double batch = newMops > 0.0 ? lic.getUMOPS__c() : lic.getMOPS__c();
                String idLic = this.updateMops(connection, licenseId, newMops);
                this.createEntryLog(connection, hwid, idLic, "retrieve from Batch:[" + hwid + "]", batch, lic.getName(), lic.getMOPS__c());
                return batch;
            }
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
        }
        catch (InternalErrorException e) {
            this.log.error(e.getMessage());
        }
        return new Double(0.0);
    }

    @Override
    public Double retrieveBatchSize(String licenseId, String hwid, Double batchSize) {
        try {
            License__c lic;
            if (batchSize == null || batchSize.equals(new Double(0.0))) {
                return this.retrieveBatchSize(licenseId, hwid);
            }
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id,Name,UMOPS__c,MOPS__c FROM License__c where id='" + licenseId + "' LIMIT 1");
            if (queryResults.getSize() > 0 && (lic = (License__c)queryResults.getRecords()[0]).getUMOPS__c() != null && lic.getMOPS__c() != null) {
                Double newMops = lic.getMOPS__c() - batchSize < 0.0 ? new Double(0.0) : lic.getMOPS__c() - batchSize;
                Double batch = newMops > 0.0 ? batchSize : lic.getMOPS__c();
                String idLic = this.updateMops(connection, licenseId, newMops);
                this.createEntryLog(connection, hwid, idLic, "retrieve from Batch:[" + hwid + "]", batch, lic.getName(), lic.getMOPS__c());
                return batch;
            }
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
        }
        catch (InternalErrorException e) {
            this.log.error(e.getMessage());
        }
        return new Double(0.0);
    }

    @Override
    public Double retrieveMOPS(String licenseId) {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id,Name,UMOPS__c,MOPS__c FROM License__c where id='" + licenseId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                License__c lic = (License__c)queryResults.getRecords()[0];
                return lic.getMOPS__c();
            }
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
        }
        return new Double(0.0);
    }

    @Override
    public void releaseBatch(String licenseId, String hwid, Calendar time, Double quantity) {
        try {
            QueryResult queryResults;
            EnterpriseConnection connection = this.getSFconnection();
            if (this.inLastDay(time.getTime()) && (queryResults = connection.query("SELECT Id,Name,UMOPS__c,MOPS__c FROM License__c where id='" + licenseId + "' LIMIT 1")).getSize() > 0) {
                License__c lic = (License__c)queryResults.getRecords()[0];
                String idLic = this.updateMops(connection, licenseId, lic.getMOPS__c() + quantity);
                this.createEntryLog(connection, hwid, idLic, "release to Batch:[" + hwid + "]", new Double(-quantity.doubleValue()), lic.getName(), lic.getMOPS__c());
            }
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
        }
        catch (InternalErrorException e) {
            this.log.error(e.getMessage());
        }
    }

    @Override
    public void sendEmail(String address, String subj, String bodyString) {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials("AKIAI5AOZEZGYO4NJ6LQ", "LEi4OrzpMTMFgMz4Bvh8hl68Dj8mSm6SoXRJD32L");
        AmazonSimpleEmailServiceClient sesClient = new AmazonSimpleEmailServiceClient((AWSCredentials)awsCreds);
        sesClient.setRegion(Region.getRegion((Regions)Regions.US_EAST_1));
        Destination destination = new Destination().withToAddresses(new String[]{address});
        Content subject = new Content().withData(subj);
        Content textBody = new Content().withData(bodyString);
        Body body = new Body().withText(textBody);
        Message message = new Message().withSubject(subject).withBody(body);
        SendEmailRequest request = new SendEmailRequest().withSource("sales@mestrelab.com").withDestination(destination).withMessage(message);
        sesClient.sendEmail(request);
    }

    @Override
    public void sendEmailNoReply(List<String> addresses, String subj, String HTMLBODY) throws InternalErrorException {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials("AKIAI5AOZEZGYO4NJ6LQ", "LEi4OrzpMTMFgMz4Bvh8hl68Dj8mSm6SoXRJD32L");
        AmazonSimpleEmailServiceClient sesClient = new AmazonSimpleEmailServiceClient((AWSCredentials)awsCreds);
        sesClient.setRegion(Region.getRegion((Regions)Regions.US_EAST_1));
        if (addresses == null || addresses.isEmpty()) {
            throw new InternalErrorException((Object)"Addresses field is empty", this.getClass().getName());
        }
        Destination destination = new Destination().withBccAddresses(addresses);
        Content subject = new Content().withData(subj);
        Body body = new Body().withHtml(new Content().withCharset("UTF-8").withData(HTMLBODY));
        Message message = new Message().withSubject(subject).withBody(body);
        SendEmailRequest request = new SendEmailRequest().withSource("no-reply@mestrelab.com").withDestination(destination).withMessage(message);
        sesClient.sendEmail(request);
    }

    @Override
    public double consumeService(String licenseId, Double quantity, String consumerName, String serviceId, String serviceName, String serviceType) {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            QueryResult queryResults = connection.query("SELECT Id,Name,UMOPS__c,MOPS__c FROM License__c where id='" + licenseId + "' LIMIT 1");
            if (queryResults.getSize() > 0) {
                License__c license = (License__c)queryResults.getRecords()[0];
                Double mops = license.getMOPS__c();
                if (mops - quantity >= 0.0) {
                    String idLic = this.updateMops(connection, license.getId(), mops - quantity);
                    this.createEntryLog(connection, "Service: " + serviceId, idLic, consumerName + " consumes " + quantity + " credits associated to service: " + serviceName, quantity, serviceType, mops - quantity);
                }
                return mops - quantity;
            }
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
        }
        catch (InternalErrorException e) {
            this.log.error(e.getMessage());
        }
        return -1.0;
    }

    private boolean inLastDay(Date aDate) {
        return aDate.getTime() > System.currentTimeMillis() - 86400000L;
    }

    @Override
    public String checkLead(String email, String name, String surname, String company) {
        try {
            EnterpriseConnection connection = this.getSFconnection();
            Lead lead = this.getLead(connection, email);
            if (lead == null) {
                lead = this.createLead(connection, email, name, surname, company);
            }
            return lead.getId();
        }
        catch (ConnectionException connect) {
            this.log.debug("Communication error: please retry");
            return "Communication error: please retry";
        }
        catch (InternalErrorException internal) {
            this.log.debug("InternalErrorException error: ", (Throwable)internal);
            this.sendMailToMestrelab("checkLead:" + email + ", " + company, internal);
            return "Unidentified error: please retry or contact support@mestrelab.com";
        }
    }

    @Override
    public String registerUserPKI(String name, String surname, String company, String email, String comment, String license, String licenseDuration, boolean isCampus, String note, String startDate) {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        try {
            this.log.debug("Register user PKI");
            this.log.debug("Data:[" + name + "," + surname + "," + company + "," + email + "," + license + "," + licenseDuration + "," + startDate + "," + comment + "]");
            String appNameKey = MNOVA_LITE_LICENSE_CODE;
            String template = MNOVALITEPK_TEMPLATE_REGISTER;
            Integer licensesNum = 1;
            try {
                licensesNum = Integer.parseInt(license);
            }
            catch (NumberFormatException e) {
                this.log.debug("registerUserPKI: 'license or Device Count' is not numeric: " + license + ". This license will saved like normal license (not campus).");
            }
            if (isCampus) {
                appNameKey = MNOVA_LITE_CAMPUS_LICENSE_CODE;
                template = MNOVALITEPK_CAMPUS_TEMPLATE_REGISTER;
            }
            EnterpriseConnection connection = this.getSFconnection();
            boolean newLead = false;
            String leadId = "";
            String contactId = null;
            Contact contact = this.getContact(connection, email, "", "Customers", true);
            if (contact != null) {
                leadId = contact.getId();
                contactId = contact.getId();
                this.log.debug("registerUserPKI: existing contact " + leadId);
            } else {
                Lead lead = this.getLeadCaseInsensitive(connection, email);
                if (lead != null) {
                    leadId = lead.getId();
                    this.log.debug("registerUserPKI: existing lead " + leadId);
                } else {
                    lead = this.createLead(connection, email, name, surname, company);
                    leadId = lead.getId();
                    newLead = true;
                    this.log.debug("registerUserPKI: created lead " + leadId);
                }
            }
            this.createCampaignMember(connection, leadId, contactId, newLead);
            TenantTO tenantTO = null;
            Long tenantId = null;
            try {
                tenantTO = this.getTenant(connection, email, appNameKey);
                tenantId = tenantTO.getTenantId();
            }
            catch (InstanceNotFoundException e) {
                tenantId = this.createTenant(connection, null, "", appNameKey, comment, true, "", email);
                this.log.debug("registerUserPKI: created tenant: tenantId " + tenantId);
                String parameters = isCampus ? PARAMETERS_PK.replace("USER_COUNT_LIMIT:1", "USER_COUNT_LIMIT:1000").concat(this.getDomain(email)) : PARAMETERS_PK.replace("USER_COUNT_LIMIT:1", "USER_COUNT_LIMIT:".concat(licensesNum + ""));
                this.updateParametersTenant(connection, tenantId, parameters);
            }
            String userId = null;
            try {
                UserTO user = this.getUser(email, appNameKey);
                userId = user.getUserId();
            }
            catch (InstanceNotFoundException e) {
                userId = this.createUser(connection, tenantId, email, "", "", true);
                this.log.debug("registerUserPKI: created user: userId " + userId);
            }
            if (tenantTO == null) {
                tenantTO = this.getTenantFaster(email, appNameKey);
            }
            this.createNote(connection, tenantTO.getId(), comment, note);
            Calendar dateEndTransaction = this.getDateEnd(licenseDuration);
            List<LicenseTO> licenses = this.getLicenses(connection, tenantId);
            if (tenantTO.getAppName().equals(appNameKey) && !this.existingLicense(licenses, dateEndTransaction)) {
                this.disabledLicenses(connection, licenses);
                String licenseId = "";
                LicenseTO licenseTO = new LicenseTO();
                licenseTO.setTenantId(tenantId.toString());
                licenseTO.setAssetId(null);
                licenseTO.setEnableSaaS(true);
                licenseTO.setNotifyExpiredTrial(true);
                if (appNameKey.equals(MNOVA_LITE_CAMPUS_LICENSE_CODE)) {
                    licenseTO.setName(MNOVA_LITE_CAMPUS_LICENSE_NAME);
                    licenseTO.setProductName(MNOVA_LITE_CAMPUS_LICENSE_ID);
                } else {
                    licenseTO.setName(MNOVA_LITE_LICENSE_NAME);
                    licenseTO.setProductName(MNOVA_LITE_LICENSE_ID);
                }
                Calendar startDateCalendar = Calendar.getInstance(utc);
                if (startDate != null) {
                    try {
                        startDateCalendar = this.getDateFormatUS(startDate);
                    }
                    catch (ParseException e) {
                        startDateCalendar = Calendar.getInstance();
                    }
                }
                licenseTO.setUsageStartDate(startDateCalendar);
                licenseTO.setUsageEndDate(dateEndTransaction);
                licenseTO.setTypeResponse(TypeError.NoError);
                licenseId = this.createInitialLicense(connection, tenantTO, licenseTO);
                this.log.debug("registerUserPKI: licenseId " + licenseId);
                this.sendSalesforceEmail(connection, licenseId, email, leadId, contactId, null, template, userId);
                return "OK";
            }
            this.sendMailToMestrelab("registerUserPKI:" + email + ", " + company + ", " + license + ", " + licenseDuration, "Existing license to tenant " + tenantTO.getId());
            return "Existing license";
        }
        catch (ConnectionException connect) {
            this.log.debug("Communication error: please retry");
            return "Communication error: please retry";
        }
        catch (InternalErrorException internal) {
            this.log.debug("InternalErrorException error: ", (Throwable)internal);
            this.sendMailToMestrelab("registerUserPKI:" + email + ", " + company + ", " + license + ", " + licenseDuration, internal);
            return "Unidentified error: please retry or contact support@mestrelab.com";
        }
        catch (InstanceNotFoundException instance) {
            this.log.debug("InstanceNotFoundException error: ", (Throwable)instance);
            this.sendMailToMestrelab("registerUserPKI:" + email + ", " + company + ", " + license + ", " + licenseDuration, instance);
            return "Unidentified error: please retry or contact support@mestrelab.com";
        }
    }

    private void disabledLicenses(EnterpriseConnection connection, List<LicenseTO> licenses) throws ConnectionException, InternalErrorException {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar calendar = Calendar.getInstance(utc);
        calendar.add(5, -1);
        ArrayList<License__c> toUpdate = new ArrayList<License__c>();
        for (LicenseTO lic : licenses) {
            License__c licenseUpdate = new License__c();
            licenseUpdate.setId(lic.getId());
            licenseUpdate.setUsageEndDate__c(calendar);
            licenseUpdate.setSaaS_Enable__c(Boolean.valueOf(false));
            toUpdate.add(licenseUpdate);
        }
        License__c[] records = toUpdate.toArray(new License__c[0]);
        SaveResult[] saveResults = connection.update((SObject[])records);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error update disabledLicenses :{" + licenses + "}"), this.getClass().getName());
        }
    }

    private void createNote(EnterpriseConnection connection, String tenantId, String title, String note) {
        if (note != null) {
            try {
                Note noteLicense = new Note();
                SimpleDateFormat sdf = new SimpleDateFormat("dd/M/yyyy");
                String date = sdf.format(Calendar.getInstance().getTime());
                noteLicense.setParentId(tenantId);
                noteLicense.setTitle(title + " - " + date);
                noteLicense.setBody(note);
                Note[] saveNote = new Note[]{noteLicense};
                SaveResult[] saveResults = connection.create((SObject[])saveNote);
                if (saveResults == null || saveResults.length <= 0) {
                    this.log.debug("Error create note by tenant " + tenantId + ": " + note);
                }
            }
            catch (Exception e) {
                this.log.debug("Error create note by tenant " + tenantId + ": " + note, (Throwable)e);
            }
        }
    }

    private void updateParametersTenant(EnterpriseConnection connection, Long tenantId, String parameters) throws InternalErrorException, InstanceNotFoundException {
        block4: {
            try {
                QueryResult queryResults = connection.query("SELECT Id, parameters__c FROM Saas_Tenant__c where IdTenant__c='" + tenantId + "' LIMIT 1");
                if (queryResults.getSize() > 0) {
                    Saas_Tenant__c saasTenant = (Saas_Tenant__c)queryResults.getRecords()[0];
                    saasTenant.setParameters__c(Utils.mapToJson(TenantTO.getMapParameters(parameters)));
                    Saas_Tenant__c[] objs = new Saas_Tenant__c[]{saasTenant};
                    SaveResult[] saveResults = connection.update((SObject[])objs);
                    if (saveResults.length > 0 && !saveResults[0].getSuccess()) {
                        throw new InternalErrorException(saveResults[0].getErrors()[0], "error saving Tenant");
                    }
                    break block4;
                }
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (ConnectionException e) {
                this.log.error(e.getMessage());
                throw new InternalErrorException((Object)e, this.getClass().getName());
            }
        }
    }

    private boolean existingLicense(List<LicenseTO> licenses, Calendar dateEndTransaction) {
        for (LicenseTO license : licenses) {
            if (!this.compareDates(license.getUsageEndDate(), dateEndTransaction)) continue;
            return true;
        }
        return false;
    }

    private boolean compareDates(Calendar cal1, Calendar cal2) {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        boolean sameDay = cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        return sameDay;
    }

    private void sendMailToMestrelab(String job, Exception e) {
        this.log.error(e.getMessage());
        StringWriter error = new StringWriter();
        e.printStackTrace(new PrintWriter(error));
        this.sendEmail(EMAIL_SALESFORCE, "Error Processing:" + job, error.toString());
    }

    private void sendMailToMestrelab(String job, String message) {
        this.log.error(message);
        this.sendEmail(EMAIL_SALESFORCE, "Error Processing: " + job, message);
    }

    private Calendar getDateEnd(String licenseDuration) {
        try {
            if (licenseDuration.equals("Perpetual")) {
                return this.addYearsToDate(4);
            }
            return this.getDateFormatUS(licenseDuration);
        }
        catch (Exception e) {
            this.log.debug("registerUserPKI: 'License Duration or License Expiry Date' is not date: " + licenseDuration + ". This license is activated during 1 year.");
            return this.addYearsToDate(1);
        }
    }

    private Calendar getDateFormatUS(String date) throws ParseException {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar dateEndTransaction = Calendar.getInstance(utc);
        SimpleDateFormat sdf = new SimpleDateFormat("M/dd/yyyy");
        dateEndTransaction.setTime(sdf.parse(date));
        return dateEndTransaction;
    }

    private Calendar addYearsToDate(int years) {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar date = Calendar.getInstance(utc);
        date.add(1, years);
        date.set(10, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        date.set(9, 0);
        return date;
    }

    private void sendSalesforceEmail(EnterpriseConnection connection, String licenseId, String email, String leadId, String contactId, String hwId, String templateId, String userId) {
        try {
            SingleEmailMessage message = new SingleEmailMessage();
            message.setOrgWideEmailAddressId(this.getFromEmailSalesforce(connection));
            EmailTemplate template = this.getEmailTemplate(connection, templateId);
            if (template != null) {
                String body = template.getHtmlValue();
                if (body == null) {
                    body = template.getBody();
                }
                if (templateId.equals(MNOVALITEPK_TEMPLATE_REGISTER) || templateId.equals(MNOVALITEPK_CAMPUS_TEMPLATE_REGISTER)) {
                    body = body.replace("#licenseId#", licenseId);
                    body = body.replace("XXXXXXX", licenseId);
                } else if (templateId.equals(MNOVALITEPK_TEMPLATE_REVOKEHW)) {
                    body = body.replace("#licenseId#", licenseId);
                    body = body.replace("#hwId#", hwId);
                    body = body.replace("#email#", email);
                    body = body.replace("#userId#", userId);
                }
                if (body.indexOf("Dear ,") > 0) {
                    String name = "";
                    if (contactId != null) {
                        Contact contact = this.getContactById(connection, contactId);
                        name = contact.getName() == null ? contact.getFirstName() + " " + contact.getLastName() : contact.getName();
                    } else if (leadId != null) {
                        Lead lead = this.getLeadById(connection, leadId);
                        name = lead.getName() == null ? lead.getFirstName() + " " + lead.getLastName() : lead.getName();
                    }
                    if (!name.equals("")) {
                        body = body.replace("Dear ,", "Dear " + name + ",");
                    }
                }
                message.setToAddresses(new String[]{email});
                message.setTemplateId(templateId);
                if (leadId != null) {
                    message.setTargetObjectId(leadId);
                }
                if (contactId != null) {
                    message.setTargetObjectId(contactId);
                }
                message.setSaveAsActivity(Boolean.valueOf(true));
                message.setSubject(template.getSubject());
                message.setHtmlBody(body);
                SingleEmailMessage[] messages = new SingleEmailMessage[]{message};
                SendEmailResult[] mailResults = connection.sendEmail((Email[])messages);
                if (mailResults[0].getErrors().length > 0) {
                    this.log.error("sendMail: mail results error: " + mailResults[0].getErrors()[0].getStatusCode() + " " + mailResults[0].getErrors()[0].getMessage());
                    this.sendMailToMestrelab("sendSalesforceEmailPKI:" + email + ", " + licenseId + ", " + leadId + ", " + templateId, "Error to send mail: " + mailResults[0].getErrors()[0].getStatusCode() + " " + mailResults[0].getErrors()[0].getMessage());
                }
            } else {
                this.log.error("template " + templateId + "does not exist");
                this.sendMailToMestrelab("sendSalesforceEmailPKI:" + email + ", " + licenseId + ", " + leadId + ", " + templateId, "Error to send mail: Template '" + templateId + "' not found");
            }
        }
        catch (ConnectionException e) {
            this.log.error("connectionException in sendSalesforceEmail", (Throwable)e);
            this.sendMailToMestrelab("sendSalesforceEmailPKI:" + email + ", " + licenseId + ", " + leadId + ", " + templateId, (Exception)((Object)e));
        }
        catch (InternalErrorException e) {
            this.log.error("InternalErrorException in sendSalesforceEmail", (Throwable)e);
            this.sendMailToMestrelab("sendSalesforceEmailPKI:" + email + ", " + licenseId + ", " + leadId + ", " + templateId, e);
        }
    }

    private String getFromEmailSalesforce(EnterpriseConnection connection) throws InternalErrorException {
        try {
            QueryResult queryResults = connection.query("select Id from OrgWideEmailAddress where Address = 'support@mestrelab.com'");
            if (queryResults.getSize() > 0) {
                OrgWideEmailAddress organizationEmail = (OrgWideEmailAddress)queryResults.getRecords()[0];
                return organizationEmail.getId();
            }
        }
        catch (ConnectionException e) {
            this.log.error("ConnectionException in getFromEmailSalesforce", (Throwable)e);
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
        return null;
    }

    private EmailTemplate getEmailTemplate(EnterpriseConnection connection, String templateId) throws InternalErrorException {
        try {
            QueryResult queryResults = connection.query("SELECT Id, Name, Subject, HtmlValue, Body from EmailTemplate where Id ='" + templateId + "'");
            if (queryResults.getSize() > 0) {
                EmailTemplate emailTemplate = (EmailTemplate)queryResults.getRecords()[0];
                return emailTemplate;
            }
        }
        catch (ConnectionException e) {
            this.log.error("ConnectionException in getEmailTemplate", (Throwable)e);
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
        return null;
    }

    private Lead createLead(EnterpriseConnection connection, String email, String name, String surname, String company) throws InternalErrorException {
        try {
            Lead lead = new Lead();
            lead.setEmail(email);
            lead.setFirstName(name);
            lead.setLastName(surname);
            lead.setCompany(company);
            lead.setLeadSource(LEAD_SOURCE);
            Lead[] newLeads = new Lead[]{lead};
            SaveResult[] saveResults = connection.create((SObject[])newLeads);
            if (saveResults != null && saveResults.length > 0) {
                if (!saveResults[0].isSuccess()) {
                    throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
                }
            } else {
                throw new InternalErrorException((Object)("Error creating lead :{" + email + ", " + name + "}"), this.getClass().getName());
            }
            lead.setId(saveResults[0].getId());
            return lead;
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private void createCampaignMember(EnterpriseConnection connection, String leadId, String contactId, boolean newLead) throws InternalErrorException {
        try {
            CampaignMember memberCampaign = this.getCampaignMember(connection, leadId, contactId, MNOVALITEPK_CAMPAIGN_ID);
            if (memberCampaign == null) {
                memberCampaign = new CampaignMember();
                if (contactId != null) {
                    memberCampaign.setContactId(contactId);
                } else {
                    memberCampaign.setLeadId(leadId);
                    memberCampaign.setNew_Lead__c(Boolean.valueOf(true));
                }
                memberCampaign.setCampaignId(MNOVALITEPK_CAMPAIGN_ID);
                memberCampaign.setStatus(MNOVALITEPK_STATUS_NOT_CONTACTED);
                memberCampaign.setPromo_activation_date__c(Calendar.getInstance());
                CampaignMember[] newMemberCampaigns = new CampaignMember[]{memberCampaign};
                SaveResult[] saveResults = connection.create((SObject[])newMemberCampaigns);
                if (saveResults != null && saveResults.length > 0) {
                    if (!saveResults[0].isSuccess()) {
                        throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
                    }
                } else {
                    throw new InternalErrorException((Object)("Error creating member campaign :{" + leadId + "}"), this.getClass().getName());
                }
                memberCampaign.setId(saveResults[0].getId());
                this.log.debug("registerUserPKI: created member campaign " + leadId + " or " + contactId);
            } else {
                this.log.debug("registerUserPKI: existing member campaign " + leadId + " or " + contactId);
            }
        }
        catch (ConnectionException e) {
            this.log.error(e.getMessage());
            throw new InternalErrorException((Object)e, this.getClass().getName());
        }
    }

    private CampaignMember getCampaignMember(EnterpriseConnection connection, String leadId, String contactId, String campaignId) throws ConnectionException {
        String sql = null;
        sql = contactId != null ? "SELECT Id, leadId,campaignId from CampaignMember where contactId ='" + contactId + "' and campaignId ='" + campaignId + "' LIMIT 1" : "SELECT Id, leadId,campaignId from CampaignMember where leadId ='" + leadId + "' and campaignId ='" + campaignId + "' LIMIT 1";
        QueryResult queryResults = connection.query(sql);
        if (queryResults.getSize() > 0) {
            CampaignMember campaignMember = (CampaignMember)queryResults.getRecords()[0];
            return campaignMember;
        }
        return null;
    }

    @Override
    public UserTO addHwByLicense(String licenseId, String hw_oem_id, String hw_oem_name, String username) throws HwInstanceNotFoundException {
        EnterpriseConnection connection = this.getSFconnection();
        this.log.debug("Add HW by License PKI");
        this.log.debug("Data:[" + licenseId + "," + hw_oem_id + "," + hw_oem_name + "]");
        if (hw_oem_name == null || hw_oem_name.equals("")) {
            hw_oem_name = hw_oem_id;
        }
        UserTO userTO = new UserTO();
        try {
            TenantTO tenantTO = this.getTenant(connection, licenseId);
            HwOEMTO hwOEMTO = this.getHwOEMTOwithLicense(connection, licenseId, hw_oem_id, false);
            UserTO user = this.getUserFaster(connection, username, tenantTO.getAppName());
            if (user == null) {
                userTO.setTypeResponse(TypeError.UserNotFound);
                return userTO;
            }
            userTO = user;
            if (hwOEMTO == null) {
                userTO = this.addHw(connection, userTO, tenantTO.getAppName(), hw_oem_id, hw_oem_name, true, licenseId);
                this.log.debug("created HW: " + userTO.getHwOEMTOs().size());
                String leadId = null;
                String contactId = null;
                Lead lead = this.getLeadCaseInsensitive(connection, tenantTO.getUserTOs().get(0).getUsername());
                if (lead == null) {
                    Contact contact = this.getContact(connection, username, "", "Customers", false);
                    if (contact != null) {
                        contactId = contact.getId();
                    }
                } else {
                    leadId = lead.getId();
                }
                this.sendSalesforceEmail(connection, licenseId, username, leadId, contactId, hw_oem_id, MNOVALITEPK_TEMPLATE_REVOKEHW, userTO.getUserId());
                return userTO;
            }
            if (!hwOEMTO.getEnabled().booleanValue()) {
                throw new HwInstanceNotFoundException((Object)new String("Hardware " + hw_oem_id + " is revoked"), this.getClass().getName());
            }
            return tenantTO.getUserTOs().get(0);
        }
        catch (InternalErrorException internal) {
            userTO.setTypeResponse(TypeError.InternalError);
            StringWriter error = new StringWriter();
            internal.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
        catch (InstanceNotFoundException instance) {
            userTO.setTypeResponse(TypeError.NoRegister);
            StringWriter error = new StringWriter();
            instance.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
        catch (ConnectionException connect) {
            userTO.setTypeResponse(TypeError.NoRegister);
            StringWriter error = new StringWriter();
            connect.printStackTrace(new PrintWriter(error));
            userTO.setMessage(error.toString());
            this.log.error(userTO.getMessage());
            return userTO;
        }
    }

    @Override
    public void revokeHW(String licenseId, String hwid, String userId) {
        EnterpriseConnection connection = this.getSFconnection();
        this.log.debug("Revoke HW");
        this.log.debug("Data:[" + licenseId + "," + hwid + "]");
        HwOEMTO hwOEMTO = this.getHwOEMTOwithLicense(connection, licenseId, hwid, true);
        if (hwOEMTO != null) {
            try {
                this.setStatusLicenseHostAssociation(connection, hwOEMTO, false);
            }
            catch (InternalErrorException | ConnectionException e) {
                this.sendMailToMestrelab("Error revokeHWLicense:" + licenseId + ", " + hwid, (Exception)e);
            }
        }
        if ((hwOEMTO = this.getHwOEMTOwithUser(connection, userId, hwid, true)) != null) {
            try {
                this.setStatusUserHostAssociation(connection, hwOEMTO, false);
            }
            catch (InternalErrorException | ConnectionException e) {
                this.sendMailToMestrelab("Error revokeHWUser:" + licenseId + ", " + hwid, (Exception)e);
            }
        }
    }

    @Override
    public HwOEMTO getHwOEMTOwithLicense(String licenseId, String hwId) {
        EnterpriseConnection connection = this.getSFconnection();
        return this.getHwOEMTOwithLicense(connection, licenseId, hwId, false);
    }

    private HwOEMTO getHwOEMTOwithLicense(EnterpriseConnection connection, String licenseId, String hwId, boolean onlyEnabled) {
        try {
            LicenseTO licenseTO = this.getLicense(connection, licenseId);
            List<HwOEMTO> list = licenseTO.getHwOEMTOs();
            if (onlyEnabled) {
                list = licenseTO.getHwOEMTOsEnabled();
            }
            if (list != null && list.size() > 0) {
                for (HwOEMTO hw : list) {
                    if (!hw.getHwOEMId().equals(hwId)) continue;
                    return hw;
                }
            }
        }
        catch (InstanceNotFoundException e) {
            this.log.error("getHwOEMTO " + licenseId + " " + hwId, (Throwable)e);
        }
        catch (InternalErrorException e) {
            this.log.error("getHwOEMTO " + licenseId + " " + hwId, (Throwable)e);
        }
        return null;
    }

    private HwOEMTO getHwOEMTOwithUser(EnterpriseConnection connection, String userId, String hwId, boolean onlyEnabled) {
        try {
            UserTO userTO = this.getUser(connection, userId);
            List<HwOEMTO> list = userTO.getHwOEMTOs();
            if (onlyEnabled) {
                list = userTO.getHwOEMTOsEnabled();
            }
            if (list != null && list.size() > 0) {
                for (HwOEMTO hw : list) {
                    if (!hw.getHwOEMId().equals(hwId)) continue;
                    return hw;
                }
            }
        }
        catch (InstanceNotFoundException | InternalErrorException e) {
            this.log.error("getHwOEMTO " + userId + " " + hwId, (Throwable)e);
        }
        return null;
    }

    private void setStatusLicenseHostAssociation(EnterpriseConnection connection, HwOEMTO hw, boolean status) throws ConnectionException, InternalErrorException {
        LicenseHostAssociation__c hostLicense = new LicenseHostAssociation__c();
        hostLicense.setId(hw.getHostLicenseId());
        hostLicense.setEnabled__c(Boolean.valueOf(status));
        LicenseHostAssociation__c[] records = new LicenseHostAssociation__c[]{hostLicense};
        SaveResult[] saveResults = connection.update((SObject[])records);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error updating HwOEM :{" + hw.getHwOEMId() + "," + hw.getHwOEMName() + "}"), this.getClass().getName());
        }
    }

    private void setStatusUserHostAssociation(EnterpriseConnection connection, HwOEMTO hwOEMTO, boolean status) throws ConnectionException, InternalErrorException {
        SaasUserHostAssociation__c hostUser = new SaasUserHostAssociation__c();
        hostUser.setId(hwOEMTO.getHostUserId());
        hostUser.setEnabled__c(Boolean.valueOf(status));
        SaasUserHostAssociation__c[] records = new SaasUserHostAssociation__c[]{hostUser};
        SaveResult[] saveResults = connection.update((SObject[])records);
        if (saveResults != null && saveResults.length > 0) {
            if (!saveResults[0].isSuccess()) {
                throw new InternalErrorException(saveResults[0].getErrors()[0], this.getClass().getName());
            }
        } else {
            throw new InternalErrorException((Object)("Error updating HwOEM :{" + hwOEMTO.getHwOEMId() + "," + hwOEMTO.getHwOEMName() + "}"), this.getClass().getName());
        }
    }

    @Override
    public boolean checkUserPKI(String licenseId, String username) {
        try {
            this.log.debug("checkUserPKI HW");
            this.log.debug("Data:[" + licenseId + "," + username + "]");
            EnterpriseConnection connection = this.getSFconnection();
            LicenseTO license = this.getLicense(connection, licenseId);
            TenantTO tenant = this.getTenant(connection, licenseId);
            if (license != null && tenant.getAppName().endsWith("99") && this.emailIsSimilar(tenant.getUserTOs().get(0).getUsername(), username, tenant.getMapParameters().get(Constants.DOMAIN_RESTRICTION))) {
                if (this.existingUser(tenant.getUserTOs(), username)) {
                    return true;
                }
                String userId = this.createUser(connection, tenant.getTenantId(), username, "", "", true);
                this.log.debug("checkUserPKI: created user: userId " + userId);
                return true;
            }
        }
        catch (InternalErrorException e) {
            this.sendMailToMestrelab("checkUserPKI:" + licenseId + ", " + username, e);
        }
        catch (InstanceNotFoundException e) {
            this.sendMailToMestrelab("checkUserPKI:" + licenseId + ", " + username, e);
        }
        return false;
    }

    private boolean existingUser(List<UserTO> userTOs, String username) {
        for (UserTO user : userTOs) {
            if (!user.getUsername().toLowerCase().equals(username.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean emailIsSimilar(String emailTenant, String emailUser, String parameterDomains) {
        if (parameterDomains != null && !parameterDomains.isEmpty()) {
            String[] domains = parameterDomains.split(";");
            String searchDomain = this.getDomain(emailUser);
            for (int i = 0; i < domains.length; ++i) {
                if (!searchDomain.equals(domains[i])) continue;
                return true;
            }
        }
        return this.getDomain(emailTenant).equals(this.getDomain(emailUser));
    }

    private String getDomain(String email) {
        return email.substring(email.indexOf("@") + 1).toLowerCase();
    }
}

