/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.saas;

import com.mestrelab.saas.Constants;
import com.mestrelab.saas.DataSourceLocator;
import com.mestrelab.saas.TenantDAO;
import com.mestrelab.saas.exception.HwInstanceNotFoundException;
import com.mestrelab.saas.exception.InstanceNotFoundException;
import com.mestrelab.saas.exception.InternalErrorException;
import com.mestrelab.saas.to.FileTO;
import com.mestrelab.saas.to.HwOEMTO;
import com.mestrelab.saas.to.JobStatus;
import com.mestrelab.saas.to.LicenseTO;
import com.mestrelab.saas.to.MopsTO;
import com.mestrelab.saas.to.TenantTO;
import com.mestrelab.saas.to.UserTO;
import com.mestrelab.saas.util.Utils;
import com.sforce.soap.enterprise.sobject.wsc.SaaSForm__c;
import com.sforce.soap.enterprise.wsc.EnterpriseConnection;
import com.sforce.ws.ConnectionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantDAOImpl
implements TenantDAO {
    private DataSource dataSource;
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public TenantDAOImpl() {
        try {
            this.dataSource = DataSourceLocator.getDataSource("saasDB");
        }
        catch (InternalErrorException e) {
            log.error(this.getClass().getName(), (Throwable)e);
        }
    }

    public TenantDAOImpl(DataSource source) {
        this.dataSource = source;
    }

    @Override
    public Map<String, String> getTenantParameters(Long tenantId) throws InternalErrorException, InstanceNotFoundException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (tenantId == null) {
            throw new InternalErrorException((Object)"TenantId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select parameters from tenants where id = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setLong(++j, tenantId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Map<String, String> map = TenantTO.getMapParameters(resultSet.getString("parameters"));
                return map;
            }
            try {
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public String getTenantName(Long tenantId) throws InternalErrorException, InstanceNotFoundException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (tenantId == null) {
            throw new InternalErrorException((Object)"TenantId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select name from tenants where id = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setLong(++j, tenantId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString("name");
                return string;
            }
            try {
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public String getTenantAppName(Long tenantId) throws InternalErrorException, InstanceNotFoundException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (tenantId == null) {
            throw new InternalErrorException((Object)"TenantId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select appName from tenants where id = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setLong(++j, tenantId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString("appName");
                return string;
            }
            try {
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public String getTenantNotifications(Long tenantId) throws InternalErrorException, InstanceNotFoundException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (tenantId == null) {
            throw new InternalErrorException((Object)"TenantId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select notifications from tenants where id = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setLong(++j, tenantId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString("notifications");
                return string;
            }
            try {
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public String getTenantComments(Long tenantId) throws InternalErrorException, InstanceNotFoundException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (tenantId == null) {
            throw new InternalErrorException((Object)"TenantId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select comments from tenants where id = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setLong(++j, tenantId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString("comments");
                return string;
            }
            try {
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public String getUserComments(String userId) throws InternalErrorException, InstanceNotFoundException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (userId == null) {
            throw new InternalErrorException((Object)"userId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select comments from users where userId = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, userId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString("comments");
                return string;
            }
            try {
                throw new InstanceNotFoundException((Object)userId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public Long getTenantId(String username, String appName) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (username == null) {
            throw new InternalErrorException((Object)"Username is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select tenantId from users join tenants on users.tenantId= tenants.id where users.username = ? and tenants.appName= ?";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, username.trim());
            preparedStatement.setString(++j, appName.trim());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Long l = resultSet.getLong("tenantId");
                return l;
            }
            try {
                throw new InstanceNotFoundException((Object)username, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public String getUserId(String username, String appName) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (username == null) {
            throw new InternalErrorException((Object)"Username is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = "select users.userId from users join tenants on users.tenantId= tenants.id where users.username = ? and tenants.appName= ?";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, username.trim());
            preparedStatement.setString(++j, appName.trim());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString("userId");
                return string;
            }
            try {
                throw new InstanceNotFoundException((Object)username, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public String getUserName(String userId) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (userId == null) {
            throw new InternalErrorException((Object)"Userid is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = "select username from users where userId = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, userId.trim());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString("username");
                return string;
            }
            try {
                throw new InstanceNotFoundException((Object)userId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public Boolean isEnabled(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (tenantId == null) {
            throw new InternalErrorException((Object)"tenantId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select enabled from tenants where id = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setLong(++j, tenantId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Boolean bl = resultSet.getInt("enabled") == 1;
                return bl;
            }
            try {
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public Long createTenant(String name, String parameters, String appName, Boolean isEnabled, String notifications, String email) throws InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        int insertedRows = 0;
        if (name == null || isEnabled == null) {
            throw new InternalErrorException((Object)"Same parameters are null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            int count = this.rowsCounterTenants(connection);
            String queryString = " insert into tenants(id,name,parameters,appName,enabled,notifications) values(?,?,?,?,?,?) ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            long id = ++count;
            preparedStatement.setLong(++j, id);
            preparedStatement.setString(++j, name.trim());
            preparedStatement.setString(++j, parameters == null ? "" : parameters.trim());
            preparedStatement.setString(++j, appName == null ? "" : appName.trim());
            preparedStatement.setInt(++j, isEnabled != false ? 1 : 0);
            preparedStatement.setString(++j, notifications == null ? "" : notifications.trim());
            insertedRows = preparedStatement.executeUpdate();
            if (insertedRows == 1) {
                Long l = id;
                return l;
            }
            connection.rollback();
            new InternalErrorException((Object)"createTenant method", this.getClass().getName());
            Long l = null;
            return l;
        }
        catch (SQLException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            throw new InternalErrorException(e, this.getClass().getName());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public Long createTenant(String name, String parameters, String appName, String comment, Boolean isEnabled, String notifications, String email) throws InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        int insertedRows = 0;
        if (name == null || isEnabled == null) {
            throw new InternalErrorException((Object)"Same parameters are null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            int count = this.rowsCounterTenants(connection);
            String queryString = " insert into tenants(id,name,parameters,appName,comments,enabled,notifications) values(?,?,?,?,?,?,?) ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            long id = ++count;
            preparedStatement.setLong(++j, id);
            preparedStatement.setString(++j, name.trim());
            preparedStatement.setString(++j, parameters == null ? "" : parameters.trim());
            preparedStatement.setString(++j, appName == null ? "" : appName.trim());
            preparedStatement.setString(++j, comment == null ? "" : comment.trim());
            preparedStatement.setInt(++j, isEnabled != false ? 1 : 0);
            preparedStatement.setString(++j, notifications == null ? "" : notifications.trim());
            insertedRows = preparedStatement.executeUpdate();
            if (insertedRows == 1) {
                Long l = id;
                return l;
            }
            connection.rollback();
            new InternalErrorException((Object)"createTenant method", this.getClass().getName());
            Long l = null;
            return l;
        }
        catch (SQLException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            throw new InternalErrorException(e, this.getClass().getName());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public String createUser(Long tenantId, String username, String passwd, String comments, Boolean enabled) throws InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        int insertedRows = 0;
        if (tenantId == null || username == null) {
            throw new InternalErrorException((Object)"Some parameters are null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
            encryptor.setPassword(Constants.cPASSENCRYPT);
            Random r = new Random();
            String userId = Utils.getSHA1("" + Math.abs(r.nextInt(10000000))).substring(0, 12);
            String queryString = " insert into users(userId,tenantId,username,passwd,comments,enabled) values(?,?,?,?,?,?) ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, userId.toLowerCase());
            preparedStatement.setLong(++j, tenantId);
            preparedStatement.setString(++j, username.trim());
            preparedStatement.setString(++j, passwd != null ? encryptor.encrypt(passwd.trim()) : passwd);
            preparedStatement.setString(++j, comments != null ? comments.trim() : comments);
            preparedStatement.setInt(++j, enabled != false ? 1 : 0);
            insertedRows = preparedStatement.executeUpdate();
            if (insertedRows == 1) {
                String string = userId.toLowerCase();
                return string;
            }
            connection.rollback();
            new InternalErrorException((Object)"createUser method", this.getClass().getName());
            String string = null;
            return string;
        }
        catch (SQLException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            throw new InternalErrorException(e, this.getClass().getName());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public void setTenant(Long tenantId, String name, String parameters, String appName, Boolean isEnabled, String notifications) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        int insertedRows = 0;
        if (tenantId == null || name == null || parameters == null || isEnabled == null) {
            throw new InternalErrorException((Object)"Same parameters are null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " update tenants set name = ?, parameters = ?, appName = ?, enabled = ?, notifications = ? where id = ?";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, name.trim());
            preparedStatement.setString(++j, parameters.trim());
            preparedStatement.setString(++j, appName.trim());
            preparedStatement.setInt(++j, isEnabled != false ? 1 : 0);
            preparedStatement.setString(++j, notifications == null ? "" : notifications.trim());
            preparedStatement.setLong(++j, tenantId);
            insertedRows = preparedStatement.executeUpdate();
            if (insertedRows != 1) {
                connection.rollback();
                new InternalErrorException((Object)"setTenant method", this.getClass().getName());
            }
        }
        catch (SQLException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            throw new InternalErrorException(e, this.getClass().getName());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public void setTenant(Long tenantId, String name, String parameters, String appName, String comments, Boolean isEnabled, String notifications) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        int insertedRows = 0;
        if (tenantId == null || name == null || parameters == null || isEnabled == null) {
            throw new InternalErrorException((Object)"Same parameters are null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " update tenants set name = ?, parameters = ?, appName = ?, comments = ?, enabled = ?, notifications = ? where id = ?";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, name.trim());
            preparedStatement.setString(++j, parameters.trim());
            preparedStatement.setString(++j, appName.trim());
            preparedStatement.setString(++j, comments != null ? comments.trim() : "");
            preparedStatement.setInt(++j, isEnabled != false ? 1 : 0);
            preparedStatement.setString(++j, notifications == null ? "" : notifications.trim());
            preparedStatement.setLong(++j, tenantId);
            insertedRows = preparedStatement.executeUpdate();
            if (insertedRows != 1) {
                connection.rollback();
                new InternalErrorException((Object)"setTenant method", this.getClass().getName());
            }
        }
        catch (SQLException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            throw new InternalErrorException(e, this.getClass().getName());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public void setUser(String userId, Long tenantId, String username, String passwd, String comments, Boolean enabled) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        int insertedRows = 0;
        if (tenantId == null || username == null || userId == null) {
            throw new InternalErrorException((Object)"Some parameters are null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
            encryptor.setPassword(Constants.cPASSENCRYPT);
            String queryString = " update users set tenantId = ?, username = ?, passwd = ?, comments = ?, enabled = ? where userId = ?";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setLong(++j, tenantId);
            preparedStatement.setString(++j, username.trim());
            preparedStatement.setString(++j, passwd != null ? encryptor.encrypt(passwd.trim()) : passwd);
            preparedStatement.setString(++j, comments != null ? comments.trim() : comments);
            preparedStatement.setInt(++j, enabled != false ? 1 : 0);
            preparedStatement.setString(++j, userId.trim());
            insertedRows = preparedStatement.executeUpdate();
            if (insertedRows != 1) {
                connection.rollback();
                new InternalErrorException((Object)"setUser method", this.getClass().getName());
            }
        }
        catch (SQLException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            throw new InternalErrorException(e, this.getClass().getName());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public Boolean deleteTenant(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        int deletedRows = 0;
        if (tenantId == null) {
            throw new InternalErrorException((Object)"TenantId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select id from tenants  where id= ?";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setLong(++j, tenantId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Long idTenantId = resultSet.getLong("id");
                queryString = "delete from users where tenantId = ?";
                log.debug(queryString);
                preparedStatement = connection.prepareStatement(queryString);
                j = 0;
                preparedStatement.setLong(++j, idTenantId);
                deletedRows = preparedStatement.executeUpdate();
                queryString = "delete from tenants where id = ?";
                log.debug(queryString);
                preparedStatement = connection.prepareStatement(queryString);
                j = 0;
                preparedStatement.setLong(++j, idTenantId);
                deletedRows = preparedStatement.executeUpdate();
                if (deletedRows != 1) {
                    throw new InternalErrorException((Object)(" delete :" + deletedRows), this.getClass().getName());
                }
                Boolean bl = true;
                return bl;
            }
            try {
                throw new InstanceNotFoundException(tenantId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public Boolean deleteUser(String idUser) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        int deletedRows = 0;
        if (idUser == null) {
            throw new InternalErrorException((Object)"Username is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select userId from users  where userId = ?";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, idUser.trim());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String userId = resultSet.getString("userId");
                queryString = "delete from users where userId = ?";
                log.debug(queryString);
                preparedStatement = connection.prepareStatement(queryString);
                j = 0;
                preparedStatement.setString(++j, userId.trim());
                deletedRows = preparedStatement.executeUpdate();
                if (deletedRows != 1) {
                    throw new InternalErrorException((Object)(" delete :" + deletedRows), this.getClass().getName());
                }
                Boolean bl = true;
                return bl;
            }
            try {
                throw new InstanceNotFoundException((Object)idUser, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    private int rowsCounterTenants(Connection con) throws InternalErrorException {
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String queryString = " select count(*) from tenants";
            log.debug(queryString);
            preparedStatement = con.prepareStatement(queryString);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            try {
                throw new InternalErrorException(resultSet, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public Boolean enableSaaS() {
        return Constants.cENABLE_SAAS.equals("1");
    }

    /*
     * Loose catch block
     */
    @Override
    public String getUserPasswd(String userId) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (userId == null) {
            throw new InternalErrorException((Object)"userId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select passwd from users where userId = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, userId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
                encryptor.setPassword(Constants.cPASSENCRYPT);
                String result = resultSet.getString("passwd");
                try {
                    String string = encryptor.decrypt(result);
                    return string;
                }
                catch (EncryptionOperationNotPossibleException e) {
                    String string = "";
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException e2) {
                        log.error(this.getClass().getName(), (Throwable)e2);
                        throw new InternalErrorException(e2, this.getClass().getName());
                    }
                    return string;
                }
            }
            throw new InstanceNotFoundException((Object)userId, this.getClass().getName());
            {
                catch (SQLException e) {
                    log.error(this.getClass().getName(), (Throwable)e);
                    throw new InternalErrorException(e, this.getClass().getName());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public Boolean checkPassword(String password, String passwordUser) throws InstanceNotFoundException, InternalErrorException {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(Constants.cPASSENCRYPT);
        Boolean result = password.equals(encryptor.decrypt(passwordUser));
        return result;
    }

    @Override
    public Boolean isUserEnabled(String userId) throws InstanceNotFoundException, InternalErrorException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        if (userId == null) {
            throw new InternalErrorException((Object)"userId is null", this.getClass().getName());
        }
        try {
            connection = this.dataSource.getConnection();
            String queryString = " select enabled from users where userId = ? ";
            log.debug(queryString);
            preparedStatement = connection.prepareStatement(queryString);
            int j = 0;
            preparedStatement.setString(++j, userId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Boolean bl = resultSet.getInt("enabled") == 1;
                return bl;
            }
            try {
                throw new InstanceNotFoundException((Object)userId, this.getClass().getName());
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(this.getClass().getName(), (Throwable)e);
                throw new InternalErrorException(e, this.getClass().getName());
            }
        }
    }

    @Override
    public UserTO getUser(String username, String appName) throws InstanceNotFoundException, InternalErrorException {
        throw new InternalErrorException((Object)"Method not implemented", this.getClass().getName());
    }

    @Override
    public TenantTO getTenant(String username, String appName) throws InstanceNotFoundException, InternalErrorException {
        throw new InternalErrorException((Object)"Method not implemented", this.getClass().getName());
    }

    @Override
    public LicenseTO getLicense(Long tenantId) throws InstanceNotFoundException, InternalErrorException {
        throw new InternalErrorException((Object)"Method not implemented", this.getClass().getName());
    }

    public TenantTO login(String email, String appName, String hw_oem_id, Boolean mobile, String formName) {
        return null;
    }

    @Override
    public TenantTO registerUser(String email, String appName, String hw_oem_id, String hw_oem_name, Boolean mobile, String formName, String idTenant, String emailRegistered) throws InternalErrorException {
        return null;
    }

    @Override
    public UserTO addHw(String email, String appName, String hw_oem_id, String hw_oem_name, Boolean isMobile) {
        return null;
    }

    @Override
    public TenantTO login(String email, String appName, String hw_oem_id, String hw_oem_name) {
        return null;
    }

    @Override
    public UserTO addHw(String email, String appName, String hw_oem_id, String hw_oem_name) {
        return null;
    }

    @Override
    public UserTO removeHw(String email, String appName, String hw_oem_id) {
        return null;
    }

    @Override
    public TenantTO createOrder(String nameContact, String email, String appName, String idTenant, String idTransaction, Calendar dateTransaction, String platform, String note) {
        return null;
    }

    @Override
    public void setRegistryLogin(UserTO userTO, Boolean result) throws InstanceNotFoundException, InternalErrorException {
    }

    @Override
    public TenantTO getTenantFaster(String username, String appName) throws InstanceNotFoundException, InternalErrorException {
        return null;
    }

    @Override
    public UserTO getUserFaster(EnterpriseConnection connection, String username, String appName) throws InstanceNotFoundException, InternalErrorException {
        return null;
    }

    @Override
    public Boolean deleteSaaSForm(SaaSForm__c form) throws InstanceNotFoundException, InternalErrorException {
        return null;
    }

    public String uploadInputFile(String jobPath, String fileName) {
        return null;
    }

    public String downloadInputFile(String jobPath, String fileName) {
        return null;
    }

    public String uploadOutputFile(String jobPath, String fileName) {
        return null;
    }

    public String downloadOutputFile(String jobPath, String fileName) {
        return null;
    }

    public List<FileTO> getListInputFiles(String jobPath) {
        return null;
    }

    public List<FileTO> getListOutputFiles(String jobPath) {
        return null;
    }

    public String downloadFile(String key) {
        return null;
    }

    @Override
    public void sendEmail(String address, String subject, String body) {
    }

    @Override
    public void sendEmailNoReply(List<String> addresses, String subject, String body) throws InternalErrorException {
    }

    @Override
    public void moveUserTenant(Long tenantId, String username, String appNameKey, String comments) throws InternalErrorException, InstanceNotFoundException {
    }

    @Override
    public boolean createOrderWithoutTenant(String nameContact, String email, String appName, Double quantity, String idTransaction, Calendar dateTransaction, String platform, String note) {
        return false;
    }

    public JobStatus payWithCoins(String userId, String email, String appName, String jobPath, Double quantity) {
        return null;
    }

    @Override
    public String newTenantAndCopyUser(String idSaaSUserParam, String appNameFrom, String appNameTo) throws InternalErrorException, InstanceNotFoundException {
        return null;
    }

    @Override
    public boolean processAssetFromSaasUser(String idSaaSUserParam, String usernameParam, String appNameKey, String idAssetParam) throws InternalErrorException, InstanceNotFoundException {
        return false;
    }

    @Override
    public TenantTO loginDesktop(String email, String password, String appName, Boolean isWeb, String hwid, String hwname) {
        return null;
    }

    @Override
    public List<MopsTO> getListMops(String licenseId) {
        return null;
    }

    @Override
    public Double retrieveBatchSize(String licenseId, String hwid) {
        return null;
    }

    @Override
    public Double retrieveBatchSize(String licenseId, String hwid, Double batchSize) {
        return null;
    }

    @Override
    public void releaseBatch(String licenseId, String hwid, Calendar time, Double quantity) {
    }

    @Override
    public TenantTO login(String licenseId, String hwid, String username) {
        return null;
    }

    @Override
    public Double retrieveMOPS(String licenseId) {
        return null;
    }

    @Override
    public String decryptPassword(String password) {
        return null;
    }

    @Override
    public String encryptPassword(String password) {
        return null;
    }

    @Override
    public void createEntryLog(String name, String licenseId, String comment, Double quantity, String type, Double currentMops) throws InternalErrorException, ConnectionException {
    }

    @Override
    public String updateMops(String id, double newMops) throws InternalErrorException, ConnectionException {
        return null;
    }

    @Override
    public double consumeService(String licenseId, Double quantity, String consumerName, String serviceId, String serviceName, String serviceType) {
        return 0.0;
    }

    @Override
    public String registerUserPKI(String name, String surname, String company, String email, String cdSerialNumber, String license, String licenseDuration, boolean isCampus, String note, String startDate) {
        return null;
    }

    @Override
    public UserTO addHwByLicense(String licenseId, String hw_oem_id, String hw_oem_name, String username) throws HwInstanceNotFoundException {
        return null;
    }

    @Override
    public void revokeHW(String licenseId, String hwid, String userId) {
    }

    @Override
    public boolean checkUserPKI(String licenseId, String username) {
        return false;
    }

    @Override
    public HwOEMTO getHwOEMTOwithLicense(String licenseId, String hwId) {
        return null;
    }

    @Override
    public String checkLead(String email, String name, String surname, String company) {
        return null;
    }

    @Override
    public void deleteSaaSForm(int year) throws InternalErrorException {
    }
}

