/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.saas;

import com.mestrelab.saas.Constants;
import com.mestrelab.saas.TenantDAO;
import com.mestrelab.saas.exception.InternalErrorException;

public class TenantDAOFactory {
    private static final String DAO_CLASS_NAME_PARAMETER = "DAOCLASSNAME";
    private static final Class daoClass = TenantDAOFactory.getDAOClass();

    private TenantDAOFactory() {
    }

    private static Class getDAOClass() {
        Class<?> theClass = null;
        try {
            String daoClassName = Constants.getParameter(DAO_CLASS_NAME_PARAMETER);
            theClass = Class.forName(daoClassName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return theClass;
    }

    public static TenantDAO getDAO() throws InternalErrorException {
        try {
            return (TenantDAO)daoClass.newInstance();
        }
        catch (Exception e) {
            throw new InternalErrorException(e, "daoClass");
        }
    }
}

