/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.saas;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    private static final Logger log = LoggerFactory.getLogger(Constants.class);
    private static final String CONFIGURATION_FILE = "ConfigurationParameters.properties";
    private static Map parameters;
    public static final String cDRIVER_CLASS_NAME_PARAMETER;
    public static final String cURL_PARAMETER;
    public static final String cUSER_PARAMETER;
    public static final String cPASSWORD_PARAMETER;
    public static String cENABLE_SAAS;
    public static String cUSERNAME_SF;
    public static String cPASSWORD_SF;
    public static String cPASSENCRYPT;
    public static String accessKEY;
    public static String secaccessKEY;
    public static String jobBucker;
    public static String canonicalID;
    public static String mestrelabSQS;
    public static String USER_STORAGE_LIMIT;
    public static String USER_COUNT_LIMIT;
    public static String DOMAIN_RESTRICTION;

    public static String getParameter(String name) {
        String value = (String)parameters.get(name);
        if (value == null && name.equals("DAOCLASSNAME")) {
            value = "com.mestrelab.saas.TenantDAOImpl";
            log.info("Using TenantDAOImpl by default. Add ConfigurationParameter.properties file with DAOCLASSNAME=com.mestrelab.saas.TenantDAOSFImpl in order to enable Salesforce connector");
        }
        return value;
    }

    static {
        try {
            Class<Constants> constantsClass = Constants.class;
            ClassLoader classLoader = constantsClass.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(CONFIGURATION_FILE);
            Properties properties = new Properties();
            if (inputStream != null) {
                properties.load(inputStream);
                inputStream.close();
            } else {
                properties.put("ENABLE_SAAS", "1");
                log.info("Using multi tenant support by default. Add ConfigurationParameter.properties file with ENABLE_SAAS=0 in order to disable it");
            }
            parameters = new HashMap<Object, Object>(properties);
            if (log.isInfoEnabled()) {
                if ("1".equals(parameters.get("ENABLE_SAAS"))) {
                    log.info("Using multi tenant support");
                } else {
                    log.info("Did not use multi tenant support");
                }
            }
        }
        catch (Exception e) {
            log.error("Error loading configuration parameters", (Throwable)e);
        }
        cDRIVER_CLASS_NAME_PARAMETER = (String)parameters.get("DRIVER_CLASS_NAME_PARAMETER");
        cURL_PARAMETER = (String)parameters.get("URL_PARAMETER");
        cUSER_PARAMETER = (String)parameters.get("USER_PARAMETER");
        cPASSWORD_PARAMETER = (String)parameters.get("PASSWORD_PARAMETER");
        cENABLE_SAAS = (String)parameters.get("ENABLE_SAAS");
        cUSERNAME_SF = (String)parameters.get("USERNAME_SF");
        cPASSWORD_SF = (String)parameters.get("PASSWORD_SF");
        cPASSENCRYPT = (String)parameters.get("PASSWORD_ENCRYPT");
        accessKEY = (String)parameters.get("accessKEY");
        secaccessKEY = (String)parameters.get("secaccessKEY");
        jobBucker = (String)parameters.get("jobBucker");
        canonicalID = (String)parameters.get("canonicalID");
        mestrelabSQS = (String)parameters.get("mestrelabSQS");
        USER_STORAGE_LIMIT = "USER_STORAGE_LIMIT";
        USER_COUNT_LIMIT = "USER_COUNT_LIMIT";
        DOMAIN_RESTRICTION = "DOMAIN_RESTRICTION";
    }
}

