function base64ArrayBuffer(arrayBuffer) {
	  var base64    = ''
	  var encodings = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'

	  var bytes         = new Uint8Array(arrayBuffer)
	  var byteLength    = bytes.byteLength
	  var byteRemainder = byteLength % 3
	  var mainLength    = byteLength - byteRemainder

	  var a, b, c, d
	  var chunk

	  // Main loop deals with bytes in chunks of 3
	  for (var i = 0; i < mainLength; i = i + 3) {
	    // Combine the three bytes into a single integer
	    chunk = (bytes[i] << 16) | (bytes[i + 1] << 8) | bytes[i + 2]

	    // Use bitmasks to extract 6-bit segments from the triplet
	    a = (chunk & 16515072) >> 18 // 16515072 = (2^6 - 1) << 18
	    b = (chunk & 258048)   >> 12 // 258048   = (2^6 - 1) << 12
	    c = (chunk & 4032)     >>  6 // 4032     = (2^6 - 1) << 6
	    d = chunk & 63               // 63       = 2^6 - 1

	    // Convert the raw binary segments to the appropriate ASCII encoding
	    base64 += encodings[a] + encodings[b] + encodings[c] + encodings[d]
	  }

	  // Deal with the remaining bytes and padding
	  if (byteRemainder == 1) {
	    chunk = bytes[mainLength]

	    a = (chunk & 252) >> 2 // 252 = (2^6 - 1) << 2

	    // Set the 4 least significant bits to zero
	    b = (chunk & 3)   << 4 // 3   = 2^2 - 1

	    base64 += encodings[a] + encodings[b] + '=='
	  } else if (byteRemainder == 2) {
	    chunk = (bytes[mainLength] << 8) | bytes[mainLength + 1]

	    a = (chunk & 64512) >> 10 // 64512 = (2^6 - 1) << 10
	    b = (chunk & 1008)  >>  4 // 1008  = (2^6 - 1) << 4

	    // Set the 2 least significant bits to zero
	    c = (chunk & 15)    <<  2 // 15    = 2^4 - 1

	    base64 += encodings[a] + encodings[b] + encodings[c] + '='
	  }
	  
	  return base64
	}
/**
* The method to view the document data.
* REQUIRED
*/
var spectrum =null;

function retrieveMnovaDocument(){
	$("body").addClass("loading");
	Extension.Document.getBinaryData(function(array) {
		Extension.Document.getAttribute('caption', function(name) {
			$.ajax({
				url : location.protocol + "//" + location.hostname
						+ ":9091/mnova/uploadJQ",
				type : "POST",
				data : JSON.stringify({
					'content' : base64ArrayBuffer(array),
					'nameFile' : name
				}),
				processData : false,
				contentType : 'application/json',
				cache : false,
				beforeSend: function(){
					$("body").addClass("loading");
				},
				success : function(thdocument) {
					spectrum = thdocument;
					addCarousel(spectrum);
					$("body").removeClass("loading");
				},
				error : function(jqXHR, textStatus, errorThrown) {
					alert("Error: " + errorThrown);
					$("body").removeClass("loading");
				}
			});
		});
	});	
}

function checkMnovaDocument(id){
	var path=location.protocol+"//"+location.hostname+":9091/?id="+id;
	$.ajax({
		url : location.protocol + "//" + location.hostname
				+ ":9091/mnova/document/"+id+"/info",
		type : "GET",
		data : null,
		processData : false,
		contentType : 'application/json',
		cache : false,
		success : function(metadata) {
			if(!metadata)
				retrieveMnovaDocument();
			window.open(path,'name','width=950,height=900');
		},
		error : function(jqXHR, textStatus, errorThrown) {
			alert("Error: " + errorThrown);
		}
	});
	return false;
}

function addCarousel(data){
	 
	   for (var i = 0; i < data.fPages.length; i++) {
  	     if (i==0)
  	    	 var $div = $('<div class="item active"> <a href="#" target="popup" onclick="return checkMnovaDocument(\''+data.key+'\')"><img src="'+data.fPages[i].fPreview+'"  class=" tales" ></a></div>');
  	     else
  	    	 var $div = $('<div class="item"> <a href="#" target="popup" onclick="return checkMnovaDocument(\''+data.key+'\')"><img src="'+data.fPages[i].fPreview+'"  class=" tales" ></a></div>');
			 $('.carousel-inner').append($div);
  	    }
	   var $buttons=$('<a class="left carousel-control" href="#myCarousel" role="button" data-slide="prev"><span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span><span class="sr-only">Previous</span></a><a class="right carousel-control" href="#myCarousel" role="button" data-slide="next"><span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span><span class="sr-only">Next</span></a>');
	   $('.carousel-inner').append($buttons);
	   $('.myCarousel').carousel();
}

CustomPanel.view = function (text) {
	document.body.innerHTML='<div class="container" ><br><div id="myCarousel" class="carousel slide" data-ride="carousel"><div class="carousel-inner" role="listbox" id="carousel-inner"></div></div><div class="modal"></div>';
	if (!spectrum){ 
		retrieveMnovaDocument();		
	}else{
		addCarousel(spectrum);
	}    
}

/**
 * Must call this method to notify that the custom panel has finished it's
 * initialize
 */
CustomPanel.ready();