/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * Contains some contributions under the Thrift Software License.
 * Please see doc/old-thrift-license.txt in the Thrift distribution for
 * details.
 */
 
/*
* Versioning/Compatibility
*
* https://diwakergupta.github.io/thrift-missing-guide/#_versioning_compatibility
*
* Don’t change the numeric tags for any existing fields. 
* Any new fields that you add should be optional
* Non-required fields can be removed, as long as the tag number is not used again in your updated message type 
* Changing a default value is generally OK, as long as you remember that default values are never sent over the wire. Thus, if a program receives a message in which a particular field isn’t set, the program will see the default value as it was defined in that program’s version of the protocol. It will NOT see the default value that was defined in the sender’s code. 
*   
*/

namespace java com.mestrelab.ws.wrapper
namespace cpp Thrift

exception ThMnovaException {
    1: required i32 fErrorCode,
    2: required string fMessage
}

enum ThIntesityOperation {
    FIT_INTENSITY = 0,
    INCREASE_INTENSITY = 1,
    DECREASE_INTENSITY = 2
} 

struct ThRect
{
    1: required double fX
    2: required double fY
    3: required double fWidth
    4: required double fHeight
}

struct ThItem
{
    1: required string fUuid
    2: required string fName
    3: required ThRect fRect
    4: required double fZ
    5: required ThRect fPlotRect
    6: required string fType
    7: required string fSubtype
}

struct ThPage
{
    1: required string fUuid,
    2: required list<ThItem> fItems
    3: required binary fPreview
}

struct ThMnovaDocument
{
    1: required string fUuid
    2: required string fFileName = ""
    3: required ThRect fPaperSizeMm
    4: required list<ThPage> fPages
}

struct MnovaDocumentMetadataWrapper
{
    1: string uuid,
    2: string fileName
}

struct MnovaDocumentWrapper
{
    1: MnovaDocumentMetadataWrapper metadata,
    2: binary image
}

exception MnovaException {
    1: i32 errorCode,
    2: string message
}
 
service MnovaTCPService {
    ThMnovaDocument open(1: required binary aData, 2: required string aSessionId, 3: string aDocName, 4: i32 aPreviewCount, 5: i32 aImageDpi) throws(1: ThMnovaException aErr)
    binary save(1: required string aDocId, 2: required string aSessionId) throws(1: ThMnovaException aErr)
    void close(1: required string aDocId, 2: required string aSessionId) throws(1: ThMnovaException aErr)
    ThPage zoom(1: required string aDocId, 2: required string aSessionId, 3: required string aItemId, 4: required ThRect aRect) throws(1: ThMnovaException aErr)
    ThPage intensity(1: required string aDocId, 2: required string aSessionId, 3: required string aItemId, 4: required ThIntesityOperation aOperation, 5: double aFactor) throws(1: ThMnovaException aErr)
    ThPage pan(1: required string aDocId, 2: required string aSessionId, 3: required string aItemId, 4: required double aDx, 5: required double aDy) throws(1: ThMnovaException aErr)

    MnovaDocumentWrapper openDocument(1: binary mnovaDocument)  throws(1: MnovaException err1)
}
