/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.ws.mnova.service;

import com.mestrelab.ws.mnova.configuration.ConnectionSettings;
import com.mestrelab.ws.mnova.shared.MnovaDocument;
import com.mestrelab.ws.mnova.shared.MnovaDocumentMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.core.io.FileSystemResource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ArchiveServiceClient {
    private static final Logger log = Logger.getLogger(ArchiveServiceClient.class);
    private ConnectionSettings settings = new ConnectionSettings();
    RestTemplate restTemplate;

    public MnovaDocument save(MnovaDocument document) {
        try {
            return this.doSave(document);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        return null;
    }

    public MnovaDocumentMetadata getDocumentFile(String uuid) {
        return (MnovaDocumentMetadata)this.getRestTemplate().getForObject(this.getServiceUrl() + "/document/{id}/info", MnovaDocumentMetadata.class, new Object[]{uuid});
    }

    public MnovaDocument getDocumentStructure(String uuid) {
        return (MnovaDocument)this.getRestTemplate().getForObject(this.getServiceUrl() + "/document/{id}", MnovaDocument.class, new Object[]{uuid});
    }

    public byte[] getMnovaDocument(String id) {
        return (byte[])this.getRestTemplate().getForObject(this.getServiceUrl() + "/document/{id}/raw", byte[].class, new Object[]{id});
    }

    public List<MnovaDocumentMetadata> findDocuments() {
        MnovaDocumentMetadata[] result = (MnovaDocumentMetadata[])this.getRestTemplate().getForObject(this.getServiceUrl() + "/documents", MnovaDocumentMetadata[].class, new Object[0]);
        return Arrays.asList(result);
    }

    private MnovaDocument doSave(MnovaDocument document) throws IOException, FileNotFoundException {
        String tempFilePath = this.writeDocumentToTempFile(document);
        MultiValueMap<String, Object> parts = this.createMultipartFileParam(tempFilePath);
        MnovaDocument documentMetadata = (MnovaDocument)this.getRestTemplate().postForObject(this.getServiceUrl() + "/upload", parts, MnovaDocument.class, new Object[0]);
        return documentMetadata;
    }

    private MultiValueMap<String, Object> createMultipartFileParam(String tempFilePath) {
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"file", (Object)new FileSystemResource(tempFilePath));
        return parts;
    }

    private String writeDocumentToTempFile(MnovaDocument document) throws IOException, FileNotFoundException {
        Path path = Files.createTempDirectory(document.getUuid(), new FileAttribute[0]);
        String tempDirPath = path.toString();
        File file = new File(tempDirPath, document.getFileName());
        FileOutputStream fo = new FileOutputStream(file);
        fo.write(document.getMnovaDocument());
        fo.close();
        return file.getPath();
    }

    public String getServiceUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProtocol()).append("://");
        sb.append(this.getHostname());
        if (this.getPort() != null) {
            sb.append(":").append(this.getPort());
        }
        sb.append("/").append(this.getBaseUrl()).append("/");
        return sb.toString();
    }

    public String getProtocol() {
        return this.getSettings().getProtocol();
    }

    public String getHostname() {
        return this.getSettings().getHostname();
    }

    public Integer getPort() {
        return this.getSettings().getPort();
    }

    public String getBaseUrl() {
        return this.getSettings().getBaseUrl();
    }

    public RestTemplate getRestTemplate() {
        if (this.restTemplate == null) {
            this.restTemplate = this.createRestTemplate();
        }
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private RestTemplate createRestTemplate() {
        this.restTemplate = new RestTemplate();
        return this.restTemplate;
    }

    public ConnectionSettings getSettings() {
        this.settings.setProtocol("http");
        this.settings.setHostname("localhost");
        this.settings.setPort(9091);
        this.settings.setBaseUrl("mnova");
        this.settings.setMnovahost("192.168.2.30");
        this.settings.setMnovaport("9090");
        return this.settings;
    }

    public void setSettings(ConnectionSettings settings) {
        this.settings = settings;
    }
}

