/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.ws.mnova.server.service;

import com.mestrelab.ws.mnova.server.dao.IMnovaDao;
import com.mestrelab.ws.mnova.server.service.IArchiveService;
import com.mestrelab.ws.mnova.shared.IntesityOperation;
import com.mestrelab.ws.mnova.shared.MnovaDocument;
import com.mestrelab.ws.mnova.shared.MnovaDocumentMetadata;
import com.mestrelab.ws.mnova.shared.Page;
import com.mestrelab.ws.mnova.shared.Rect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import net.sf.ehcache.Ehcache;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service(value="archiveService")
public class ArchiveService
implements IArchiveService,
Serializable {
    private static final long serialVersionUID = 8119784722798361327L;
    private static final Logger log = Logger.getLogger(ArchiveService.class);
    @Autowired
    private IMnovaDao MnovaDao;
    @Resource
    private CacheManager cacheManager;

    @Override
    public MnovaDocument save(MnovaDocument document) {
        MnovaDocument mnovaDocument = this.getMnovaDao().open(document);
        if (mnovaDocument.getError().getfErrorCode() == 0) {
            this.getCacheManager().getCache("documents").put((Object)document.getKey(), (Object)mnovaDocument);
        }
        return mnovaDocument;
    }

    @Override
    public MnovaDocumentMetadata getDocumentFile(String key) {
        MnovaDocument doc = this.getDocument(key);
        if (doc != null) {
            return doc.getMetadata();
        }
        this.closeMnova(key);
        return null;
    }

    @Override
    public byte[] getMnovaDocument(String key) {
        MnovaDocument doc = this.getDocument(key);
        if (doc != null) {
            return doc.getMnovaDocument();
        }
        this.closeMnova(key);
        return null;
    }

    @Override
    public List<MnovaDocumentMetadata> findDocuments() {
        ArrayList<MnovaDocumentMetadata> list = new ArrayList<MnovaDocumentMetadata>();
        Ehcache cache = (Ehcache)this.getCacheManager().getCache("documents").getNativeCache();
        for (Object key : cache.getKeys()) {
            if (cache.get(key) == null) {
                log.info((Object)"closing mnova document");
                this.closeMnova((String)key);
                continue;
            }
            MnovaDocument doc = (MnovaDocument)cache.get(key).getObjectValue();
            if (doc == null) continue;
            list.add(((MnovaDocument)cache.get(key).getObjectValue()).getMetadata());
        }
        return list;
    }

    @Override
    public MnovaDocument getDocumentStructure(String key) {
        MnovaDocument document = this.getDocument(key);
        if (document != null) {
            document.setMnovaDocument(null);
        } else {
            this.closeMnova(key);
        }
        return document;
    }

    @Override
    public Page getZoomImage(String key, int pageIndex, String item, double fX, double fY, double fWidth, double fHeight) {
        MnovaDocument doc = this.getDocument(key);
        if (doc != null) {
            Page page = this.getMnovaDao().zoom(doc, item, new Rect(fX, fY, fWidth, fHeight));
            doc.getfPages().set(pageIndex, page);
            this.updateDocument(key, doc);
            return page;
        }
        this.closeMnova(key);
        return null;
    }

    @Override
    public Page getIntensityImage(String key, int pageIndex, String item, IntesityOperation aOperation) {
        MnovaDocument doc = this.getDocument(key);
        if (doc != null) {
            Page page = this.getMnovaDao().intensity(doc, item, aOperation);
            doc.getfPages().set(pageIndex, page);
            this.updateDocument(key, doc);
            return page;
        }
        this.closeMnova(key);
        return null;
    }

    @Override
    public Page getPanImage(String key, int pageIndex, String item, double fWidth, double fHeight) {
        MnovaDocument doc = this.getDocument(key);
        if (doc != null) {
            Page page = this.getMnovaDao().pan(doc, item, fWidth, fHeight);
            doc.getfPages().set(pageIndex, page);
            this.updateDocument(key, doc);
            return page;
        }
        this.closeMnova(key);
        return null;
    }

    public IMnovaDao getMnovaDao() {
        return this.MnovaDao;
    }

    public void setMnovaDao(IMnovaDao mnovaDao) {
        this.MnovaDao = mnovaDao;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private MnovaDocument getDocument(String key) {
        if (this.cacheManager.getCache("documents").get((Object)key) != null) {
            return (MnovaDocument)this.cacheManager.getCache("documents").get((Object)key).get();
        }
        return null;
    }

    private boolean updateDocument(String key, MnovaDocument doc) {
        if (this.cacheManager.getCache("documents").get((Object)key) != null) {
            this.cacheManager.getCache("documents").put((Object)key, (Object)doc);
            return true;
        }
        return false;
    }

    private void closeMnova(String key) {
        MnovaDocument document = new MnovaDocument();
        document.setKey(key);
        this.getMnovaDao().close(document);
    }
}

