/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.ws.mnova.server.rest;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class HashGeneratorUtils {
    private static final Logger LOG = Logger.getLogger(HashGeneratorUtils.class);
    public static final String headerName = "x-mnovaweah-key";

    private HashGeneratorUtils() {
    }

    public static String generateSHA256(String message) {
        return HashGeneratorUtils.hashString(message, "SHA-256");
    }

    private static String hashString(String message, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hashedBytes = digest.digest(message.getBytes("UTF-8"));
            return HashGeneratorUtils.convertByteArrayToHexString(hashedBytes);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    private static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayBytes.length; ++i) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }
}

