/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.ws.mnova.server.rest;

import com.mestrelab.ws.mnova.server.dao.IDocumentDao;
import com.mestrelab.ws.mnova.server.rest.HashGeneratorUtils;
import com.mestrelab.ws.mnova.server.service.IArchiveService;
import com.mestrelab.ws.mnova.shared.FileVO;
import com.mestrelab.ws.mnova.shared.IntesityOperation;
import com.mestrelab.ws.mnova.shared.MnovaDocument;
import com.mestrelab.ws.mnova.shared.MnovaDocumentMetadata;
import com.mestrelab.ws.mnova.shared.MnovaException;
import com.mestrelab.ws.mnova.shared.Page;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/mnova"})
public class ArchiveController {
    private static final Logger LOG = Logger.getLogger(ArchiveController.class);
    @Autowired
    IArchiveService archiveService;
    @Autowired
    IDocumentDao documentDAO;

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public MnovaDocumentMetadata handleFileUpload(@RequestParam(value="file", required=true) MultipartFile file) {
        try {
            MnovaDocumentMetadata metadata = new MnovaDocumentMetadata(UUID.randomUUID().toString(), file.getOriginalFilename(), null, new MnovaException(0));
            MnovaDocument document = new MnovaDocument(file.getBytes(), metadata);
            document = this.getArchiveService().save(document);
            return document.getMetadata();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            MnovaDocumentMetadata metadata = new MnovaDocumentMetadata();
            metadata.setError(new MnovaException(500));
            return metadata;
        }
    }

    @RequestMapping(value={"/uploadJQ"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public MnovaDocument handleFileUploadJquery(@RequestBody FileVO file) {
        MnovaDocumentMetadata metadata = new MnovaDocumentMetadata(UUID.randomUUID().toString(), file.getNameFile(), null, new MnovaException(0));
        MnovaDocument document = new MnovaDocument(Base64.decodeBase64((String)file.getContent()), metadata);
        document = this.getArchiveService().save(document);
        document = this.getArchiveService().getDocumentStructure(document.getKey());
        if (document == null) {
            document = new MnovaDocument();
            document.setError(new MnovaException(502));
            document.setfErrorCodeInternal(502);
        }
        return document;
    }

    @RequestMapping(value={"/uploadBinary"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public MnovaDocument handleUpload(@RequestBody FileVO file) {
        MnovaDocumentMetadata metadata = new MnovaDocumentMetadata(UUID.randomUUID().toString(), file.getNameFile(), null, new MnovaException(0));
        MnovaDocument document = new MnovaDocument(Base64.decodeBase64((String)file.getContent()), metadata);
        this.getArchiveService().save(document);
        return this.getArchiveService().getDocumentStructure(document.getKey());
    }

    @RequestMapping(value={"/uploadURL/{nameFile}"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public MnovaDocument handleUploadURL(@RequestBody String urlLocation, @PathVariable String nameFile) {
        MnovaDocument result = new MnovaDocument();
        try {
            String urlLocationFiltered = urlLocation.replaceFirst("https:", "http:");
            LOG.info((Object)urlLocationFiltered);
            URL url = new URL(urlLocation);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestProperty("x-mnovaweah-key", HashGeneratorUtils.generateSHA256("Mn4v1W21h:" + urlLocationFiltered));
            InputStream input = huc.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
            MnovaDocumentMetadata metadata = new MnovaDocumentMetadata(UUID.randomUUID().toString(), nameFile + ".mnova", UUID.randomUUID().toString(), new MnovaException(0));
            MnovaDocument document = new MnovaDocument(output.toByteArray(), metadata);
            document = this.getArchiveService().save(document);
            return this.getArchiveService().getDocumentStructure(document.getKey());
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e);
            result.setError(new MnovaException(500));
            result.setfErrorCodeInternal(500);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            result.setError(new MnovaException(500));
            result.setfErrorCodeInternal(500);
        }
        return result;
    }

    @RequestMapping(value={"/document/{id}/info"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public MnovaDocumentMetadata getDocumentInfo(@PathVariable String id) {
        return this.getArchiveService().getDocumentFile(id);
    }

    @RequestMapping(value={"/document/{id}/raw"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    public HttpEntity<byte[]> getDocumentImage(@PathVariable String id) {
        MnovaDocument doc = this.getArchiveService().getDocumentStructure(id);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        httpHeaders.add("content-disposition", "attachment; filename=" + doc.getMetadata().getFileName());
        return new ResponseEntity((Object)this.getArchiveService().getMnovaDocument(id), (MultiValueMap)httpHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/document/{id}"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public MnovaDocument getDocumentStructure(@PathVariable String id) {
        MnovaDocument doc = this.getArchiveService().getDocumentStructure(id);
        if (doc == null) {
            doc = new MnovaDocument();
            doc.setError(new MnovaException(502));
            doc.setfErrorCodeInternal(502);
            return doc;
        }
        return doc;
    }

    @RequestMapping(value={"/documentRaw/{id}"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public MnovaDocument getDocumentRaw(@PathVariable String id) {
        MnovaDocument doc = this.getArchiveService().getDocumentStructure(id);
        if (doc == null) {
            doc = new MnovaDocument();
            doc.setError(new MnovaException(502));
            doc.setfErrorCodeInternal(502);
            return doc;
        }
        doc.setMnovaDocument(this.getArchiveService().getMnovaDocument(id));
        return doc;
    }

    @RequestMapping(value={"/documents"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    public HttpEntity<List<MnovaDocumentMetadata>> findDocument() {
        HttpHeaders httpHeaders = new HttpHeaders();
        return new ResponseEntity(this.getArchiveService().findDocuments(), (MultiValueMap)httpHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/document/{id}/page/{pageIndex}/item/{item}/zoomImage/{fX}/{fY}/{fWidth}/{fHeight}"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public Page getZoomImage(@PathVariable String id, @PathVariable int pageIndex, @PathVariable String item, @PathVariable double fX, @PathVariable double fY, @PathVariable double fWidth, @PathVariable double fHeight) {
        Page page = this.getArchiveService().getZoomImage(id, pageIndex, item, fX, fY, fWidth, fHeight);
        if (page == null) {
            page = new Page();
            page.setfErrorCodeInternal(502);
        }
        return page;
    }

    @RequestMapping(value={"/document/{id}/page/{pageIndex}/item/{item}/intensityImage/{aOperation}"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public Page getIntensityImage(@PathVariable String id, @PathVariable int pageIndex, @PathVariable String item, @PathVariable int aOperation) {
        Page page = this.getArchiveService().getIntensityImage(id, pageIndex, item, IntesityOperation.findByValue(aOperation));
        if (page == null) {
            page = new Page();
            page.setfErrorCodeInternal(502);
        }
        return page;
    }

    @RequestMapping(value={"/document/{id}/page/{pageIndex}/item/{item}/panImage/{fWidth}/{fHeight}"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    @ResponseBody
    public Page getPanImage(@PathVariable String id, @PathVariable int pageIndex, @PathVariable String item, @PathVariable double fWidth, @PathVariable double fHeight) {
        Page page = this.getArchiveService().getPanImage(id, pageIndex, item, fWidth, fHeight);
        if (page == null) {
            page = new Page();
            page.setfErrorCodeInternal(502);
        }
        return page;
    }

    public IArchiveService getArchiveService() {
        return this.archiveService;
    }

    public void setArchiveService(IArchiveService archiveService) {
        this.archiveService = archiveService;
    }

    public IDocumentDao getDocumentDAO() {
        return this.documentDAO;
    }

    public void setDocumentDAO(IDocumentDao documentDAO) {
        this.documentDAO = documentDAO;
    }
}

