/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.ws.mnova.server.dao;

import com.mestrelab.ws.mnova.configuration.ConnectionSettings;
import com.mestrelab.ws.mnova.configuration.MbookSetting;
import com.mestrelab.ws.mnova.server.dao.IMnovaDao;
import com.mestrelab.ws.mnova.shared.IntesityOperation;
import com.mestrelab.ws.mnova.shared.Item;
import com.mestrelab.ws.mnova.shared.MnovaDocument;
import com.mestrelab.ws.mnova.shared.MnovaException;
import com.mestrelab.ws.mnova.shared.Page;
import com.mestrelab.ws.mnova.shared.Rect;
import com.mestrelab.ws.wrapper.MnovaTCPService;
import com.mestrelab.ws.wrapper.ThIntesityOperation;
import com.mestrelab.ws.wrapper.ThItem;
import com.mestrelab.ws.wrapper.ThMnovaDocument;
import com.mestrelab.ws.wrapper.ThPage;
import com.mestrelab.ws.wrapper.ThRect;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mnovaDao")
public class ThriftMnovaDao
implements IMnovaDao {
    private TTransport transport;
    private static int dpiImage = 96;
    @Autowired
    private ConnectionSettings settings;
    @Autowired
    private MbookSetting mbookSettings;
    private static final Logger log = Logger.getLogger(ThriftMnovaDao.class);

    @PostConstruct
    public void openConnection() {
        this.transport = new TSocket(this.settings.getMnovahost(), new Integer(this.settings.getMnovaport()).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MnovaDocument open(MnovaDocument document) {
        try {
            this.transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            MnovaTCPService.Client client = new MnovaTCPService.Client((TProtocol)protocol);
            ThMnovaDocument doc = client.open(ByteBuffer.wrap(document.getMnovaDocument()), document.getUuid(), document.getFileName(), -1, dpiImage);
            document.setfFileName(doc.fFileName);
            document.setfPages(this.processThPages(doc.fPages));
            document.setfPaperSizeMm(this.proceThRect(doc.fPaperSizeMm));
            document.setfUuid(doc.fUuid);
            MnovaDocument mnovaDocument = document;
            return mnovaDocument;
        }
        catch (TException e) {
            log.error((Object)e);
            MnovaDocument doc = new MnovaDocument();
            doc.setError(new MnovaException(500));
            MnovaDocument mnovaDocument = doc;
            return mnovaDocument;
        }
        finally {
            this.transport.close();
        }
    }

    private Rect proceThRect(ThRect fPaperSizeMm) {
        Rect result = new Rect();
        result.setfHeight(fPaperSizeMm.fHeight);
        result.setfWidth(fPaperSizeMm.fWidth);
        result.setfX(fPaperSizeMm.fX);
        result.setfY(fPaperSizeMm.fY);
        return result;
    }

    private List<Page> processThPages(List<ThPage> fPages) {
        ArrayList<Page> result = new ArrayList<Page>();
        if (fPages != null) {
            for (ThPage page : fPages) {
                if (!this.containsSpectrum(page)) continue;
                Page p = this.convertPage(page);
                result.add(p);
            }
        }
        return result;
    }

    private boolean containsSpectrum(ThPage page) {
        if (!this.mbookSettings.getOnlySpectrum().booleanValue()) {
            return true;
        }
        if (page.fItems == null || page.fItems.size() == 0) {
            return false;
        }
        for (ThItem item : page.fItems) {
            if (!item.getFName().contains("Spectrum")) continue;
            return true;
        }
        return false;
    }

    private Page convertPage(ThPage page) {
        Page p = new Page();
        try {
            p.setfPreview("data:image/png;base64," + new String(Base64.encodeBase64((byte[])page.fPreview.array()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            p.setfErrorCodeInternal(500);
        }
        p.setfUuid(page.fUuid);
        p.setItems(this.processThItems(page.fItems));
        return p;
    }

    private List<Item> processThItems(List<ThItem> fItems) {
        ArrayList<Item> result = new ArrayList<Item>();
        if (fItems != null) {
            for (ThItem item : fItems) {
                Item i = new Item();
                i.setfRect(this.proceThRect(item.fRect));
                i.setfType(item.fType);
                i.setfSubtype(item.fSubtype);
                i.setfUuid(item.fUuid);
                i.setfName(item.fName);
                i.setfPlotRect(this.proceThRect(item.fPlotRect));
                i.setfZ(item.fZ);
                result.add(i);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] save(MnovaDocument document) {
        try {
            byte[] result;
            this.transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            MnovaTCPService.Client client = new MnovaTCPService.Client((TProtocol)protocol);
            byte[] byArray = result = client.save(document.getfUuid(), document.getUuid()).array();
            return byArray;
        }
        catch (TException e) {
            log.error((Object)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.transport.close();
        }
    }

    @Override
    public void close(MnovaDocument document) {
        try {
            this.transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            MnovaTCPService.Client client = new MnovaTCPService.Client((TProtocol)protocol);
            client.close(document.getfUuid(), document.getUuid());
            this.transport.close();
        }
        catch (TException e) {
            log.error((Object)e);
            this.transport.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page zoom(MnovaDocument document, String aItemId, Rect aRect) {
        try {
            this.transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            MnovaTCPService.Client client = new MnovaTCPService.Client((TProtocol)protocol);
            ThPage page = client.zoom(document.getfUuid(), document.getUuid(), aItemId, new ThRect(aRect.getfX(), aRect.getfY(), aRect.getfWidth(), aRect.getfHeight()));
            Page page2 = this.convertPage(page);
            return page2;
        }
        catch (TException e) {
            log.error((Object)e);
            Page p = new Page();
            p.setfErrorCodeInternal(501);
            Page page = p;
            return page;
        }
        finally {
            this.transport.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page pan(MnovaDocument document, String item, double fWidth, double fHeight) {
        try {
            this.transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            MnovaTCPService.Client client = new MnovaTCPService.Client((TProtocol)protocol);
            ThPage page = client.pan(document.getfUuid(), document.getUuid(), item, fWidth, fHeight);
            Page page2 = this.convertPage(page);
            return page2;
        }
        catch (TException e) {
            log.error((Object)e);
            Page p = new Page();
            p.setfErrorCodeInternal(501);
            Page page = p;
            return page;
        }
        finally {
            this.transport.close();
        }
    }

    public ConnectionSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ConnectionSettings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page intensity(MnovaDocument document, String aItemId, IntesityOperation aOperation) {
        try {
            this.transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            MnovaTCPService.Client client = new MnovaTCPService.Client((TProtocol)protocol);
            ThPage page = client.intensity(document.getfUuid(), document.getUuid(), aItemId, ThIntesityOperation.findByValue(aOperation.getValue()), 5.0);
            Page page2 = this.convertPage(page);
            return page2;
        }
        catch (TException e) {
            log.error((Object)e);
            Page p = new Page();
            p.setfErrorCodeInternal(501);
            Page page = p;
            return page;
        }
        finally {
            this.transport.close();
        }
    }
}

