/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.ws.mnova.server.dao;

import com.mestrelab.ws.mnova.server.dao.IDocumentDao;
import com.mestrelab.ws.mnova.shared.MnovaDocument;
import com.mestrelab.ws.mnova.shared.MnovaDocumentMetadata;
import com.mestrelab.ws.mnova.shared.MnovaException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="documentDao")
public class FileSystemDocumentDao
implements IDocumentDao {
    private static final Logger LOG = Logger.getLogger(FileSystemDocumentDao.class);
    public static final String DIRECTORY = "archive";
    public static final String META_DATA_FILE_NAME = "metadata.properties";

    @PostConstruct
    public void init() {
    }

    @Override
    public void insert(MnovaDocument document) {
        try {
            this.createDirectory(document);
            this.saveFileData(document);
            this.saveMetaData(document);
        }
        catch (IOException e) {
            String message = "Error while inserting document";
            LOG.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    @Cacheable(value={"documents"})
    public MnovaDocument load(String uuid) {
        try {
            return this.loadFromFileSystem(uuid);
        }
        catch (IOException e) {
            String message = "Error while loading document with id: " + uuid;
            LOG.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public boolean delete(String uuid) {
        return this.deleteFile(uuid);
    }

    @Override
    public List<MnovaDocumentMetadata> findByName(String searchName) {
        try {
            return this.findInFileSystem(searchName);
        }
        catch (IOException e) {
            String message = "Error while finding document, searchName name: " + searchName;
            LOG.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    private List<MnovaDocumentMetadata> findInFileSystem(String searchName) throws IOException {
        LOG.info((Object)("searching by " + searchName));
        List<String> uuidList = this.getUuidList();
        LOG.info((Object)("size " + uuidList.size()));
        ArrayList<MnovaDocumentMetadata> metadataList = new ArrayList<MnovaDocumentMetadata>(uuidList.size());
        for (String uuid : uuidList) {
            LOG.info((Object)("uuid " + uuid));
            MnovaDocumentMetadata metadata = this.loadMetadataFromFileSystem(uuid);
            if (!this.isMatched(metadata, searchName)) continue;
            metadataList.add(metadata);
        }
        return metadataList;
    }

    private boolean isMatched(MnovaDocumentMetadata metadata, String searchName) {
        if (metadata == null) {
            return false;
        }
        boolean match = true;
        if (searchName != null) {
            match = searchName.equals(metadata.getFileName());
        }
        return match;
    }

    private MnovaDocumentMetadata loadMetadataFromFileSystem(String uuid) throws IOException {
        MnovaDocumentMetadata document = null;
        String dirPath = this.getDirectoryPath(uuid);
        File file = new File(dirPath);
        if (file.exists()) {
            Properties properties = this.readProperties(uuid);
            document = new MnovaDocumentMetadata(properties.getProperty("uuid"), properties.getProperty("file-name"), null, new MnovaException(0));
        }
        return document;
    }

    private MnovaDocument loadFromFileSystem(String uuid) throws IOException {
        MnovaDocumentMetadata metadata = this.loadMetadataFromFileSystem(uuid);
        if (metadata == null) {
            return null;
        }
        Path path = Paths.get(this.getFilePath(metadata), new String[0]);
        MnovaDocument document = new MnovaDocument(metadata);
        document.setMnovaDocument(Files.readAllBytes(path));
        return document;
    }

    private String getFilePath(MnovaDocumentMetadata metadata) {
        String dirPath = this.getDirectoryPath(metadata.getUuid());
        StringBuilder sb = new StringBuilder();
        sb.append(dirPath).append(File.separator).append(metadata.getFileName());
        return sb.toString();
    }

    private void saveFileData(MnovaDocument document) throws IOException {
        String path = this.getDirectoryPath(document);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(new File(new File(path), document.getFileName())));
        stream.write(document.getMnovaDocument());
        stream.close();
    }

    public void saveMetaData(MnovaDocument document) throws IOException {
        String path = this.getDirectoryPath(document);
        Properties props = new Properties();
        props.setProperty("uuid", document.getUuid());
        props.setProperty("file-name", document.getFileName());
        File f = new File(new File(path), META_DATA_FILE_NAME);
        FileOutputStream out = new FileOutputStream(f);
        props.store(out, "Document meta data");
    }

    private List<String> getUuidList() {
        File file = new File(DIRECTORY);
        String[] directories = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        });
        LOG.info((Object)directories);
        return Arrays.asList(directories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(String uuid) throws IOException {
        Properties prop = new Properties();
        InputStream input = null;
        try {
            input = new FileInputStream(new File(this.getDirectoryPath(uuid), META_DATA_FILE_NAME));
            prop.load(input);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop;
    }

    private String createDirectory(MnovaDocument document) {
        String path = this.getDirectoryPath(document);
        this.createDirectory(path);
        return path;
    }

    private String getDirectoryPath(MnovaDocument document) {
        return this.getDirectoryPath(document.getUuid());
    }

    private String getDirectoryPath(String uuid) {
        StringBuilder sb = new StringBuilder();
        sb.append(DIRECTORY).append(File.separator).append(uuid);
        String path = sb.toString();
        return path;
    }

    private void createDirectory(String path) {
        File file = new File(path);
        file.mkdirs();
    }

    public boolean deleteFile(String uuid) {
        try {
            MnovaDocumentMetadata metadata = this.loadMetadataFromFileSystem(uuid);
            if (metadata == null) {
                return false;
            }
            File file = new File(this.getFilePath(metadata));
            return file.delete();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
            return false;
        }
    }
}

