/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.ws.mnova.client;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.CanvasPixelArray;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.canvas.dom.client.FillStrokeStyle;
import com.google.gwt.canvas.dom.client.ImageData;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadElement;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.LinkElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DragEnterEvent;
import com.google.gwt.event.dom.client.DragEnterHandler;
import com.google.gwt.event.dom.client.DragLeaveEvent;
import com.google.gwt.event.dom.client.DragLeaveHandler;
import com.google.gwt.event.dom.client.DragOverEvent;
import com.google.gwt.event.dom.client.DragOverHandler;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.event.dom.client.DropHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.ws.mnova.client.AboutDialog;
import com.mestrelab.ws.mnova.client.ArchiveControllerService;
import com.mestrelab.ws.mnova.client.icons.Images;
import com.mestrelab.ws.mnova.shared.FileVO;
import com.mestrelab.ws.mnova.shared.IntesityOperation;
import com.mestrelab.ws.mnova.shared.Item;
import com.mestrelab.ws.mnova.shared.MnovaDocument;
import com.mestrelab.ws.mnova.shared.MnovaException;
import com.mestrelab.ws.mnova.shared.Page;
import com.mestrelab.ws.mnova.shared.Rect;
import com.mestrelab.ws.mnova.shared.event.MnovaChangePageEvent;
import com.mestrelab.ws.mnova.shared.event.MnovaDocumentEvent;
import com.mestrelab.ws.mnova.shared.event.MnovaExceptionEvent;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.restygwt.client.Defaults;
import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.MethodCallback;
import org.vectomatic.dnd.DataTransferExt;
import org.vectomatic.dnd.DropPanel;
import org.vectomatic.file.Blob;
import org.vectomatic.file.File;
import org.vectomatic.file.FileList;
import org.vectomatic.file.FileReader;
import org.vectomatic.file.events.ErrorEvent;
import org.vectomatic.file.events.ErrorHandler;
import org.vectomatic.file.events.LoadEndEvent;
import org.vectomatic.file.events.LoadEndHandler;

public class MnovaWidget
extends Composite
implements MouseDownHandler,
MouseMoveHandler,
MouseUpHandler,
MouseOutHandler {
    private static final ArchiveControllerService controller = (ArchiveControllerService)GWT.create(ArchiveControllerService.class);
    private HandlerManager eventBus = null;
    private ZoomType zoomSelected = ZoomType.HORIZONTAL;
    private CommandEditor cmdSelected = CommandEditor.SELECT;
    private String id;
    private String mnovaServiceUrl;
    private String mnovaDocument;
    private boolean editDocument;
    private MnovaDocument document;
    private int currentPage;
    private Rect areaZoom;
    private Item itemSelected;
    private static HeadElement head;
    final VerticalPanel containerEditor;
    final FocusPanel panelFocus;
    final MenuBar menuBar;
    final HorizontalPanel buttonPanel;
    final HorizontalPanel paginationPanel;
    final VerticalPanel cont_draw;
    final HorizontalPanel notificationPanel;
    final List<MenuItem> items = new ArrayList<MenuItem>();
    final Canvas canvasBack;
    final Canvas canvasFront;
    final TabBar barPages = new TabBar();
    final ToggleButton bPan;
    final ToggleButton bZoom;
    final HorizontalPanel imagesPanel;
    final Image imageBG = new Image();
    private FileReader reader = null;
    private String nameFile = "";
    final Images images = (Images)GWT.create(Images.class);
    boolean mouseDown = false;
    boolean zoom = false;
    int mouseDownXPos = 0;
    int mouseDownYPos = 0;

    public HandlerManager getEventBus() {
        return this.eventBus;
    }

    public MnovaWidget(String idElement, int width, int height, boolean editor) {
        this(idElement, width, height, editor, false);
    }

    public MnovaWidget(String idElement, int width, int height, boolean editor, boolean remove) {
        this.id = idElement;
        this.eventBus = new HandlerManager((Object)this);
        this.bPan = new ToggleButton();
        this.bPan.addStyleName("PanButton");
        this.bZoom = new ToggleButton();
        this.bZoom.addStyleName("ZoomButton");
        RootPanel root = RootPanel.get((String)this.id);
        this.containerEditor = new VerticalPanel();
        this.containerEditor.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        this.containerEditor.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.cont_draw = new VerticalPanel();
        this.cont_draw.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        this.containerEditor.add((Widget)this.cont_draw);
        this.menuBar = this.createMenu();
        this.menuBar.setVisible(editor);
        this.buttonPanel = this.createButtonPanel();
        this.buttonPanel.setVisible(editor);
        this.paginationPanel = this.createPaginationPanel();
        this.paginationPanel.setVisible(true);
        this.notificationPanel = new HorizontalPanel();
        this.notificationPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.notificationPanel.setWidth(width + "px");
        this.notificationPanel.setHeight("20px");
        this.notificationPanel.setVisible(true);
        this.imagesPanel = new HorizontalPanel();
        this.panelFocus = new FocusPanel();
        this.imagesPanel.setVisible(!editor);
        this.canvasBack = Canvas.createIfSupported();
        this.canvasFront = Canvas.createIfSupported();
        this.panelFocus.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 90) {
                    MnovaWidget.this.zoomSelected = MnovaWidget.this.zoomSelected.getNext();
                }
            }
        });
        this.reader = new FileReader();
        this.reader.addLoadEndHandler(new LoadEndHandler(){

            public void onLoadEnd(LoadEndEvent event) {
                if (MnovaWidget.this.reader.getError() == null) {
                    ArrayBuffer text = MnovaWidget.this.reader.getArrayBufferResult();
                    FileVO f = new FileVO();
                    f.setNameFile(MnovaWidget.this.nameFile);
                    MnovaException e = new MnovaException(500);
                    e.setfMessage(f.getNameFile());
                    MnovaWidget.this.processError(e);
                    f.setContent(MnovaWidget.b64encode(text));
                    MnovaWidget.this.setMnovaDocument(f.getContent(), MnovaWidget.this.nameFile, false);
                }
            }
        });
        this.reader.addErrorHandler(new ErrorHandler(){

            public void onError(ErrorEvent event) {
            }
        });
        this.addCanvasToEdit(editor, width, height);
        this.imagesPanel.clear();
        this.imagesPanel.add((Widget)this.imageBG);
        this.containerEditor.add((Widget)this.imagesPanel);
        this.containerEditor.add((Widget)this.notificationPanel);
        this.initWidget((Widget)this.containerEditor);
        if (root != null) {
            if (remove) {
                root.clear();
            }
            root.add((Widget)this);
        } else {
            this.getElement().setId(this.id);
            if (remove) {
                Document.get().getBody().removeAllChildren();
                Document.get().getBody().appendChild((Node)this.getElement());
            } else {
                RootPanel.get().add((Widget)this);
            }
        }
    }

    public void setEnablePan(boolean value) {
        this.bPan.setVisible(value);
    }

    public void setEnableZoom(boolean value) {
        this.bZoom.setVisible(value);
    }

    public void notificationBar(boolean value) {
        this.notificationPanel.setVisible(value);
    }

    private void addCanvasToEdit(boolean edit, int width, int height) {
        if (!edit) {
            return;
        }
        if (this.canvasBack == null) {
            RootPanel.get().add((Widget)new Label("Sorry, your browser doesn't support the HTML5 Canvas element"));
            return;
        }
        this.canvasBack.setWidth(width + "px");
        this.canvasBack.setHeight(height + "px");
        this.canvasBack.setCoordinateSpaceWidth(width);
        this.canvasBack.setCoordinateSpaceHeight(height);
        this.canvasBack.setVisible(false);
        this.canvasBack.getElement().getStyle().setDisplay(Style.Display.NONE);
        this.canvasFront.setWidth(width + "px");
        this.canvasFront.setHeight(height + "px");
        this.canvasFront.setCoordinateSpaceWidth(width);
        this.canvasFront.setCoordinateSpaceHeight(height);
        this.canvasFront.addMouseMoveHandler((MouseMoveHandler)this);
        this.canvasFront.addMouseDownHandler((MouseDownHandler)this);
        this.canvasFront.addMouseUpHandler((MouseUpHandler)this);
        this.cont_draw.add((Widget)this.menuBar);
        this.cont_draw.add((Widget)this.buttonPanel);
        DropPanel droppanel = new DropPanel();
        droppanel.addDropHandler(new DropHandler(){

            public void onDrop(DropEvent event) {
                event.preventDefault();
                event.stopPropagation();
                MnovaWidget.this.processFiles(((DataTransferExt)event.getDataTransfer().cast()).getFiles());
            }
        });
        droppanel.addDragEnterHandler(new DragEnterHandler(){

            public void onDragEnter(DragEnterEvent event) {
                event.preventDefault();
                event.stopPropagation();
            }
        });
        droppanel.addDragLeaveHandler(new DragLeaveHandler(){

            public void onDragLeave(DragLeaveEvent event) {
                event.preventDefault();
                event.stopPropagation();
            }
        });
        droppanel.addDragOverHandler(new DragOverHandler(){

            public void onDragOver(DragOverEvent event) {
                event.preventDefault();
                event.stopPropagation();
                MnovaWidget.this.canvasFront.setFocus(true);
            }
        });
        droppanel.add((Widget)this.canvasFront);
        this.panelFocus.add((Widget)droppanel);
        this.cont_draw.add((Widget)this.panelFocus);
        this.cont_draw.add((Widget)this.canvasBack);
        this.cont_draw.add((Widget)this.paginationPanel);
    }

    private void processResponse(MnovaDocument doc) {
        this.document = doc;
        this.repaint();
        this.createPagination();
        this.barPages.selectTab(this.currentPage);
        this.getEventBus().fireEvent((GwtEvent)new MnovaDocumentEvent(doc));
    }

    public void repaint() {
        this.cleanCanvas();
        this.drawPage();
        this.drawItems();
        this.mainDraw(0, 0);
    }

    private void processError(MnovaException exception) {
        this.notificationPanel.clear();
        this.notificationPanel.add((Widget)new Label(exception.getfMessage()));
        this.document = null;
        this.getEventBus().fireEvent((GwtEvent)new MnovaExceptionEvent(exception));
    }

    private void processFiles(FileList files) {
        if (this.reader != null) {
            for (File file : files) {
                try {
                    File blob = file;
                    this.nameFile = file.getName();
                    this.reader.readAsArrayBuffer((Blob)blob);
                }
                catch (Throwable t) {
                    MnovaException e = new MnovaException(500);
                    e.setfMessage(t.getMessage());
                    this.processError(e);
                }
            }
        }
    }

    private MenuBar createMenu() {
        MenuBar menu = new MenuBar();
        this.items.clear();
        MenuBar helpMenu = new MenuBar(true);
        helpMenu.addItem("About", (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AboutDialog aboutBox = new AboutDialog(MnovaWidget.this.getPanel());
                aboutBox.show();
            }
        });
        menu.addItem("Help", helpMenu);
        return menu;
    }

    private boolean validPageResponse(Page response) {
        return 502 != response.getfErrorCodeInternal() && 501 != response.getfErrorCodeInternal();
    }

    private HorizontalPanel createButtonPanel() {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        PushButton bFull = new PushButton("", new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (MnovaWidget.this.getItemSelected() == null) {
                    Window.alert((String)"You should select an item");
                    return;
                }
                controller.getZoomImage(MnovaWidget.this.getDocument().getKey(), MnovaWidget.this.getCurrentPage(), MnovaWidget.this.getItemSelected().getfUuid(), 0.0, 0.0, 0.0, 0.0, new MethodCallback<Page>(){

                    public void onSuccess(Method method, Page response) {
                        if (MnovaWidget.this.validPageResponse(response)) {
                            MnovaWidget.this.getDocument().getfPages().set(MnovaWidget.this.getCurrentPage(), response);
                            MnovaWidget.this.repaint();
                        } else {
                            MnovaException e = new MnovaException(response.getfErrorCodeInternal());
                            MnovaWidget.this.processError(e);
                        }
                    }

                    public void onFailure(Method method, Throwable exception) {
                        MnovaException e = new MnovaException(500);
                        e.setfMessage(exception.getMessage());
                        MnovaWidget.this.processError(e);
                    }
                });
            }
        });
        bFull.setWidth("32px");
        bFull.setHeight("32px");
        bFull.addStyleName("fullButton");
        PushButton bUp = new PushButton("", new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (MnovaWidget.this.getItemSelected() == null) {
                    Window.alert((String)"You should select an item");
                    return;
                }
                controller.getIntensityImage(MnovaWidget.this.getDocument().getKey(), MnovaWidget.this.getCurrentPage(), MnovaWidget.this.getItemSelected().getfUuid(), IntesityOperation.INCREASE_INTENSITY.getValue(), new MethodCallback<Page>(){

                    public void onSuccess(Method method, Page response) {
                        if (MnovaWidget.this.validPageResponse(response)) {
                            MnovaWidget.this.getDocument().getfPages().set(MnovaWidget.this.getCurrentPage(), response);
                            MnovaWidget.this.repaint();
                        } else {
                            MnovaException e = new MnovaException(response.getfErrorCodeInternal());
                            MnovaWidget.this.processError(e);
                        }
                    }

                    public void onFailure(Method method, Throwable exception) {
                        MnovaException e = new MnovaException(500);
                        e.setfMessage(exception.getMessage());
                        MnovaWidget.this.processError(e);
                    }
                });
            }
        });
        bUp.setWidth("32px");
        bUp.setHeight("32px");
        bUp.addStyleName("IncreaseIntensityButton");
        PushButton bDown = new PushButton("", new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (MnovaWidget.this.getItemSelected() == null) {
                    Window.alert((String)"You should select an item");
                    return;
                }
                controller.getIntensityImage(MnovaWidget.this.getDocument().getKey(), MnovaWidget.this.getCurrentPage(), MnovaWidget.this.getItemSelected().getfUuid(), IntesityOperation.DECREASE_INTENSITY.getValue(), new MethodCallback<Page>(){

                    public void onSuccess(Method method, Page response) {
                        if (MnovaWidget.this.validPageResponse(response)) {
                            MnovaWidget.this.getDocument().getfPages().set(MnovaWidget.this.getCurrentPage(), response);
                            MnovaWidget.this.repaint();
                        } else {
                            MnovaException e = new MnovaException(response.getfErrorCodeInternal());
                            MnovaWidget.this.processError(e);
                        }
                    }

                    public void onFailure(Method method, Throwable exception) {
                        MnovaException e = new MnovaException(500);
                        e.setfMessage(exception.getMessage());
                        MnovaWidget.this.processError(e);
                    }
                });
            }
        });
        bDown.setWidth("32px");
        bDown.setHeight("32px");
        bDown.addStyleName("DecreaseIntensityButton");
        PushButton bFit = new PushButton("", new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (MnovaWidget.this.getItemSelected() == null) {
                    Window.alert((String)"You should select an item");
                    return;
                }
                controller.getIntensityImage(MnovaWidget.this.getDocument().getKey(), MnovaWidget.this.getCurrentPage(), MnovaWidget.this.getItemSelected().getfUuid(), IntesityOperation.FIT_INTENSITY.getValue(), new MethodCallback<Page>(){

                    public void onSuccess(Method method, Page response) {
                        if (MnovaWidget.this.validPageResponse(response)) {
                            MnovaWidget.this.getDocument().getfPages().set(MnovaWidget.this.getCurrentPage(), response);
                            MnovaWidget.this.repaint();
                        } else {
                            MnovaException e = new MnovaException(response.getfErrorCodeInternal());
                            MnovaWidget.this.processError(e);
                        }
                    }

                    public void onFailure(Method method, Throwable exception) {
                        MnovaException e = new MnovaException(500);
                        e.setfMessage(exception.getMessage());
                        MnovaWidget.this.processError(e);
                    }
                });
            }
        });
        bFit.setWidth("32px");
        bFit.setHeight("32px");
        bFit.addStyleName("FitIntensityButton");
        this.bPan.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (MnovaWidget.this.bPan.isDown()) {
                    MnovaWidget.this.setCmdSelected(CommandEditor.PAN);
                    MnovaWidget.this.bZoom.setDown(false);
                } else {
                    MnovaWidget.this.setCmdSelected(CommandEditor.SELECT);
                }
            }
        });
        this.bZoom.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (MnovaWidget.this.bZoom.isDown()) {
                    MnovaWidget.this.setCmdSelected(CommandEditor.ZOOM);
                    MnovaWidget.this.bPan.setDown(false);
                } else {
                    MnovaWidget.this.setCmdSelected(CommandEditor.SELECT);
                }
            }
        });
        this.bPan.setWidth("32px");
        this.bPan.setHeight("32px");
        this.bZoom.setWidth("32px");
        this.bZoom.setHeight("32px");
        panel.add((Widget)bFull);
        panel.add((Widget)bUp);
        panel.add((Widget)bDown);
        panel.add((Widget)bFit);
        panel.add((Widget)this.bPan);
        panel.add((Widget)this.bZoom);
        return panel;
    }

    private HorizontalPanel createPaginationPanel() {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        panel.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        panel.setHeight("20px");
        this.barPages.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                MnovaWidget.this.setCurrentPage((Integer)event.getSelectedItem());
                MnovaWidget.this.repaint();
            }
        });
        panel.add((Widget)this.barPages);
        return panel;
    }

    public MnovaWidget getPanel() {
        return this;
    }

    public String getMnovaServiceUrl() {
        return this.mnovaServiceUrl;
    }

    public String getMnovaDocument() {
        return this.mnovaDocument;
    }

    public void setMnovaServiceUrl(String mnovaServiceUrl) {
        this.mnovaServiceUrl = mnovaServiceUrl;
        this.useCorrectRequestBaseUrl();
    }

    public void sendMnovaDocument(String mnovaDocument, String nameDocument) {
        this.setMnovaDocument(mnovaDocument, nameDocument, false);
    }

    public void sendMnovaDocumentURL(String url, String nameDocument) {
        controller.uploadURL(url, nameDocument, new MethodCallback<MnovaDocument>(){

            public void onSuccess(Method method, MnovaDocument response) {
                MnovaWidget.this.processResponse(response);
            }

            public void onFailure(Method method, Throwable exception) {
                MnovaException e = new MnovaException(500);
                e.setfMessage(exception.getMessage());
                MnovaWidget.this.processError(e);
            }
        });
    }

    public void setMnovaDocument(String mnovaDocument, String nameDocument, boolean test) {
        if (this.document == null) {
            FileVO f = new FileVO();
            f.setNameFile(nameDocument);
            f.setContent(mnovaDocument);
            if (!test) {
                controller.uploadBinary(f, new MethodCallback<MnovaDocument>(){

                    public void onSuccess(Method method, MnovaDocument response) {
                        MnovaWidget.this.processResponse(response);
                    }

                    public void onFailure(Method method, Throwable exception) {
                        MnovaException e = new MnovaException(500);
                        e.setfMessage(exception.getMessage());
                        MnovaWidget.this.processError(e);
                    }
                });
            }
        } else {
            controller.getDocumentStructure(this.document.getKey(), new MethodCallback<MnovaDocument>(){

                public void onSuccess(Method method, MnovaDocument response) {
                    MnovaWidget.this.processResponse(response);
                }

                public void onFailure(Method method, Throwable exception) {
                    MnovaException e = new MnovaException(500);
                    e.setfMessage(exception.getMessage());
                    MnovaWidget.this.processError(e);
                }
            });
        }
    }

    public void getDocumentStructure(String key) {
        controller.getDocumentStructure(key, new MethodCallback<MnovaDocument>(){

            public void onSuccess(Method method, MnovaDocument response) {
                if (502 == response.getfErrorCodeInternal() || 501 == response.getfErrorCodeInternal()) {
                    MnovaException e = new MnovaException(response.getfErrorCodeInternal());
                    MnovaWidget.this.processError(e);
                } else {
                    MnovaWidget.this.processResponse(response);
                }
            }

            public void onFailure(Method method, Throwable exception) {
                MnovaException e = new MnovaException(500);
                e.setfMessage(exception.getMessage());
                MnovaWidget.this.processError(e);
            }
        });
    }

    public boolean isEditDocument() {
        return this.editDocument;
    }

    public void setEditDocument(boolean editDocument) {
        this.editDocument = editDocument;
    }

    public void onMouseUp(MouseUpEvent event) {
        this.mouseDown = false;
        int xPos = event.getRelativeX((Element)this.canvasFront.getElement());
        int yPos = event.getRelativeY((Element)this.canvasFront.getElement());
        this.ajustAreaZoom();
        if (this.getItemSelected() != null && this.getItemSelected().getfUuid() != null) {
            if (this.cmdSelected == CommandEditor.ZOOM) {
                controller.getZoomImage(this.getDocument().getKey(), this.getCurrentPage(), this.getItemSelected().getfUuid(), this.getAreaZoom().getfX(), this.getAreaZoom().getfY(), this.getAreaZoom().getfWidth(), this.getAreaZoom().getfHeight(), new MethodCallback<Page>(){

                    public void onSuccess(Method method, Page response) {
                        if (response != null) {
                            if (MnovaWidget.this.validPageResponse(response)) {
                                MnovaWidget.this.getDocument().getfPages().set(MnovaWidget.this.getCurrentPage(), response);
                                MnovaWidget.this.repaint();
                            } else {
                                MnovaException e = new MnovaException(response.getfErrorCodeInternal());
                                MnovaWidget.this.processError(e);
                            }
                        }
                    }

                    public void onFailure(Method method, Throwable exception) {
                        MnovaException e = new MnovaException(500);
                        e.setfMessage(exception.getMessage());
                        MnovaWidget.this.processError(e);
                    }
                });
                this.mainDraw(0, 0);
            }
            if (this.cmdSelected == CommandEditor.PAN) {
                controller.getPanImage(this.getDocument().getKey(), this.getCurrentPage(), this.getItemSelected().getfUuid(), this.getAreaZoom().getfWidth(), this.getAreaZoom().getfHeight(), new MethodCallback<Page>(){

                    public void onSuccess(Method method, Page response) {
                        if (response != null) {
                            if (MnovaWidget.this.validPageResponse(response)) {
                                MnovaWidget.this.getDocument().getfPages().set(MnovaWidget.this.getCurrentPage(), response);
                                MnovaWidget.this.repaint();
                            } else {
                                MnovaException e = new MnovaException(response.getfErrorCodeInternal());
                                MnovaWidget.this.processError(e);
                            }
                        }
                    }

                    public void onFailure(Method method, Throwable exception) {
                        MnovaException e = new MnovaException(500);
                        e.setfMessage(exception.getMessage());
                        MnovaWidget.this.processError(e);
                    }
                });
                this.mainDraw(xPos - this.mouseDownXPos, yPos - this.mouseDownYPos);
            }
            if (this.cmdSelected == CommandEditor.SELECT) {
                this.mainDraw(0, 0);
            }
            this.drawItemSelection(this.canvasFront.getContext2d(), this.mouseDownXPos, this.mouseDownYPos);
        }
    }

    public void onMouseOut(MouseOutEvent event) {
        this.canvasFront.setFocus(false);
    }

    public void onMouseMove(MouseMoveEvent event) {
        if (this.getItemSelected() == null) {
            return;
        }
        this.canvasFront.setFocus(true);
        if (this.document == null) {
            return;
        }
        Context2d ctx = this.canvasFront.getContext2d();
        int xPos = event.getRelativeX((Element)this.canvasFront.getElement());
        int yPos = event.getRelativeY((Element)this.canvasFront.getElement());
        this.canvasFront.setStyleName("");
        if (this.cmdSelected == CommandEditor.ZOOM && this.zoomSelected == ZoomType.FREE) {
            this.canvasFront.addStyleName("zoomBoth");
        }
        if (this.cmdSelected == CommandEditor.ZOOM && this.zoomSelected == ZoomType.HORIZONTAL) {
            this.canvasFront.addStyleName("zoomHorizontal");
        }
        if (this.cmdSelected == CommandEditor.ZOOM && this.zoomSelected == ZoomType.VERTICAL) {
            this.canvasFront.addStyleName("zoomVertical");
        }
        if (this.cmdSelected == CommandEditor.PAN) {
            this.canvasFront.addStyleName("panning");
        }
        if (this.cmdSelected == CommandEditor.SELECT) {
            this.canvasFront.setStyleName("");
        }
        if (this.mouseDown) {
            if (this.cmdSelected == CommandEditor.ZOOM) {
                this.mainDraw(0, 0);
                this.drawAreaSelection(ctx, xPos, yPos);
            }
            if (this.cmdSelected == CommandEditor.PAN) {
                this.canvasFront.addStyleName("panningMove");
                this.drawArrowSelection(ctx, xPos, yPos);
                this.mainDraw(xPos - this.mouseDownXPos, yPos - this.mouseDownYPos);
            }
        }
    }

    private void drawItemSelection(Context2d ctx, int xPos, int yPos) {
        if (this.getItemSelected() == null) {
            return;
        }
        ctx.save();
        ctx.setStrokeStyle((FillStrokeStyle)CssColor.make((int)255, (int)0, (int)0));
        ctx.setGlobalAlpha(0.5);
        ctx.strokeRect((double)this.displayX((int)this.itemSelected.getfRect().getfX()), (double)this.displayY((int)this.itemSelected.getfRect().getfY()), (double)this.displayX((int)this.itemSelected.getfRect().getfWidth()), (double)this.displayY((int)this.itemSelected.getfRect().getfHeight()));
        ctx.restore();
    }

    private void drawArrowSelection(Context2d ctx, int tox, int toy) {
        ctx.save();
        ctx.setFillStyle((FillStrokeStyle)CssColor.make((int)255, (int)0, (int)0));
        ctx.setGlobalAlpha(0.5);
        ctx.fillRect(0.0, 0.0, (double)this.canvasFront.getCoordinateSpaceWidth(), (double)this.canvasFront.getCoordinateSpaceHeight());
        ctx.restore();
        int startX = tox - this.mouseDownXPos < 0 ? tox : this.mouseDownXPos;
        int startY = toy - this.mouseDownYPos < 0 ? toy : this.mouseDownYPos;
        int width = tox - this.mouseDownXPos;
        int height = toy - this.mouseDownYPos;
        Rect area = new Rect();
        area.setfX(this.modelX(startX));
        area.setfY(this.modelY(startY));
        area.setfWidth(this.modelX(width));
        area.setfHeight(this.modelY(height));
        this.setAreaZoom(area);
    }

    private void drawAreaSelection(Context2d ctx, int xPos, int yPos) {
        int width = Math.abs(xPos - this.mouseDownXPos);
        int height = Math.abs(yPos - this.mouseDownYPos);
        int startX = 0;
        int startY = 0;
        startX = xPos - this.mouseDownXPos < 0 ? xPos : this.mouseDownXPos;
        startY = yPos - this.mouseDownYPos < 0 ? yPos : this.mouseDownYPos;
        ctx.save();
        ctx.beginPath();
        ctx.setFillStyle((FillStrokeStyle)CssColor.make((int)255, (int)0, (int)0));
        ctx.setGlobalAlpha(0.5);
        this.zoomSelected = this.getItemSelected() != null && this.getItemSelected().getfType().equals("2D") ? ZoomType.FREE : ZoomType.HORIZONTAL;
        if (this.zoomSelected.equals((Object)ZoomType.HORIZONTAL)) {
            startY = 0;
            height = this.canvasFront.getCoordinateSpaceHeight();
        }
        if (this.zoomSelected.equals((Object)ZoomType.VERTICAL)) {
            startX = 0;
            width = this.canvasFront.getCoordinateSpaceWidth();
        }
        ctx.fillRect((double)startX, (double)startY, (double)width, (double)height);
        ctx.closePath();
        ctx.restore();
        Rect area = new Rect();
        area.setfX(this.modelX(startX));
        area.setfY(this.modelY(startY));
        area.setfWidth(this.modelX(width));
        area.setfHeight(this.modelY(height));
        this.setAreaZoom(area);
    }

    public void onMouseDown(MouseDownEvent event) {
        this.mouseDown = true;
        this.mouseDownXPos = event.getRelativeX((Element)this.canvasFront.getElement());
        this.mouseDownYPos = event.getRelativeY((Element)this.canvasFront.getElement());
        this.itemSelected = this.insideItem(this.modelX(this.mouseDownXPos), this.modelY(this.mouseDownYPos));
    }

    private Item insideItem(double xPos, double yPos) {
        if (this.document != null && !this.document.getfPages().isEmpty()) {
            for (Item item : this.document.getfPages().get(this.currentPage).getItems()) {
                if (!(xPos >= item.getfPlotRect().getfX()) || !(xPos <= item.getfPlotRect().getfX() + item.getfPlotRect().getfWidth()) || !(yPos >= item.getfPlotRect().getfY()) || !(yPos <= item.getfPlotRect().getfY() + item.getfPlotRect().getfHeight())) continue;
                return item;
            }
        }
        return null;
    }

    private void cleanCanvas() {
        this.canvasBack.getContext2d().beginPath();
        this.canvasBack.getContext2d().clearRect(0.0, 0.0, (double)this.canvasBack.getCoordinateSpaceWidth(), (double)this.canvasBack.getCoordinateSpaceHeight());
        this.canvasBack.getContext2d().restore();
    }

    private void drawPage() {
        this.imageBG.setUrl(this.document.getfPages().get(this.currentPage).getfPreview());
        this.imageBG.addLoadHandler(new LoadHandler(){

            public void onLoad(LoadEvent event) {
                MnovaWidget.this.canvasBack.getContext2d().drawImage(ImageElement.as((Element)MnovaWidget.this.imageBG.getElement()), 0.0, 0.0, (double)MnovaWidget.this.canvasBack.getCoordinateSpaceWidth(), (double)MnovaWidget.this.canvasBack.getCoordinateSpaceHeight());
                MnovaWidget.this.buffer(MnovaWidget.this.canvasBack, MnovaWidget.this.canvasFront, 0.0, 0.0);
                MnovaWidget.this.updatePagination();
            }
        });
    }

    private void updatePagination() {
    }

    private void createPagination() {
        if (this.getDocument() != null && this.barPages.getTabCount() == 0) {
            for (int i = 0; i < this.getDocument().getfPages().size(); ++i) {
                this.barPages.addTab("Page " + (i + 1));
            }
        }
    }

    public void mainDraw(int x, int y) {
        this.buffer(this.canvasBack, this.canvasFront, x, y);
    }

    public void drawItems() {
        if (this.document != null && !this.document.getfPages().isEmpty()) {
            Page thisPage = this.document.getfPages().get(this.currentPage);
            for (Item item : thisPage.getItems()) {
                if (!item.getfType().equals("MS")) continue;
                this.buttonPanel.setVisible(false);
                return;
            }
            this.buttonPanel.setVisible(true);
        }
    }

    public void buffer(Canvas back, Canvas front, double x, double y) {
        front.getContext2d().save();
        front.getContext2d().beginPath();
        front.getContext2d().clearRect(0.0, 0.0, (double)front.getCoordinateSpaceWidth(), (double)front.getCoordinateSpaceHeight());
        if (x != 0.0) {
            front.getContext2d().setGlobalAlpha(0.5);
            front.getContext2d().arc((double)this.mouseDownXPos + x, (double)this.mouseDownYPos + y, 200.0, 0.0, Math.PI * 2, true);
            front.getContext2d().clip();
        }
        front.getContext2d().drawImage(back.getContext2d().getCanvas(), x, y);
        front.getContext2d().closePath();
        front.getContext2d().restore();
    }

    public MnovaDocument getDocument() {
        return this.document;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setDocument(MnovaDocument document) {
        this.document = document;
        this.setCurrentPage(0);
        this.createPagination();
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 0) {
            currentPage = 0;
        }
        if (currentPage >= this.getDocument().getfPages().size()) {
            currentPage = this.getDocument().getfPages().size() - 1;
        }
        this.currentPage = currentPage;
        this.itemSelected = null;
        this.getEventBus().fireEvent((GwtEvent)new MnovaChangePageEvent(this.currentPage));
    }

    public Rect getAreaZoom() {
        return this.areaZoom;
    }

    public void setAreaZoom(Rect areaZoom) {
        this.areaZoom = areaZoom;
    }

    public void ajustAreaZoom() {
        if (this.areaZoom == null) {
            return;
        }
        this.itemSelected = this.insideItem(this.areaZoom.getfX(), this.areaZoom.getfY());
        if (this.itemSelected != null) {
            Rect intersection = new Rect();
            if (Rect.intersection(this.areaZoom, this.itemSelected.getfPlotRect(), intersection)) {
                this.areaZoom = intersection;
            }
        }
    }

    public Item getItemSelected() {
        return this.itemSelected;
    }

    public void setCmdSelected(CommandEditor cmd) {
        this.cmdSelected = cmd;
    }

    public long modelX(int displayX) {
        return Math.round((double)displayX * ((double)this.imageBG.getWidth() * 1.0 / (double)this.canvasFront.getCanvasElement().getWidth()));
    }

    public long modelY(int displayY) {
        return Math.round((double)displayY * ((double)this.imageBG.getHeight() * 1.0 / (double)this.canvasFront.getCanvasElement().getHeight()));
    }

    public long displayX(int modelX) {
        return Math.round((double)modelX * ((double)this.canvasFront.getCanvasElement().getWidth() * 1.0 / (double)this.imageBG.getWidth()));
    }

    public long displayY(int modelY) {
        return Math.round((double)modelY * ((double)this.canvasFront.getCanvasElement().getHeight() * 1.0 / (double)this.imageBG.getHeight()));
    }

    public static void injectResourceCssAsFile(String filename) {
        LinkElement link = Document.get().createLinkElement();
        link.setType("text/css");
        link.setRel("stylesheet");
        link.setHref(filename);
        MnovaWidget.getHead().appendChild((Node)link);
    }

    private static HeadElement getHead() {
        if (head == null) {
            Element elt = (Element)Document.get().getElementsByTagName("head").getItem(0);
            assert (elt != null) : "The host HTML page does not have a <head> element which is required by StyleInjector";
            head = HeadElement.as((Element)elt);
        }
        return head;
    }

    private static native String b64decode(String var0);

    private static native String b64encode(ArrayBuffer var0);

    private void useCorrectRequestBaseUrl() {
        if (MnovaWidget.isDevelopmentMode()) {
            Defaults.setServiceRoot((String)"http://localhost:8080");
        } else {
            Defaults.setServiceRoot((String)this.mnovaServiceUrl);
        }
    }

    private static native boolean isDevelopmentMode();

    private static native boolean fileReaderSupport();

    public ImageData downScaleImage(ImageElement img, int tw) {
        Canvas imgCV = Canvas.createIfSupported();
        imgCV.getCanvasElement().setWidth(img.getWidth());
        imgCV.getCanvasElement().setHeight(img.getHeight());
        imgCV.getContext2d().drawImage(img, 0.0, 0.0);
        return this.downloadScale(imgCV, tw);
    }

    private ImageData downloadScale(Canvas imgCV, int tw) {
        int sw = imgCV.getCanvasElement().getWidth();
        int sh = imgCV.getCanvasElement().getHeight();
        double scale = (double)tw * 1.0 / (double)sw;
        int th = (int)Math.floor((double)sh * scale);
        Canvas resCV = Canvas.createIfSupported();
        resCV.getCanvasElement().setWidth(tw);
        resCV.getCanvasElement().setHeight(th);
        Context2d resCtx = resCV.getContext2d();
        ImageData imgRes = resCtx.getImageData(0.0, 0.0, (double)tw, (double)th);
        CanvasPixelArray sBuffer = imgCV.getContext2d().getImageData(0.0, 0.0, (double)sw, (double)sh).getData();
        CanvasPixelArray tByteBuffer = imgRes.getData();
        MnovaWidget.getBufferR(sBuffer, tByteBuffer, tw, th, sw, sh, scale);
        resCtx.putImageData(imgRes, 0.0, 0.0);
        return resCtx.getImageData(0.0, 0.0, (double)tw, (double)th);
    }

    public static native void getBufferR(CanvasPixelArray var0, CanvasPixelArray var1, double var2, double var4, double var6, double var8, double var10);

    private static enum CommandEditor {
        ZOOM,
        PAN,
        SELECT;

    }

    private static enum ZoomType {
        HORIZONTAL,
        VERTICAL,
        FREE;


        public ZoomType getNext() {
            return ZoomType.values()[(this.ordinal() + 1) % ZoomType.values().length];
        }
    }
}

