/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.ws.mnova;

import com.mestrelab.ws.mnova.configuration.ConnectionSettings;
import com.mestrelab.ws.mnova.server.service.IArchiveService;
import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.embedded.MultipartConfigFactory;
import org.springframework.boot.context.web.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@SpringBootApplication
@EnableCaching
@EnableScheduling
public class Application
extends SpringBootServletInitializer {
    @Autowired
    private ConnectionSettings settings;
    @Autowired
    IArchiveService archiveService;
    private static Class<Application> applicationClass = Application.class;

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(this.getSettings().getMaxFileSize());
        factory.setMaxRequestSize(this.getSettings().getMaxRequestSize());
        return factory.createMultipartConfig();
    }

    @Scheduled(fixedRate=600000L)
    public void cleanCache() {
        this.getArchiveService().findDocuments();
    }

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{applicationClass});
    }

    public ConnectionSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ConnectionSettings settings) {
        this.settings = settings;
    }

    public IArchiveService getArchiveService() {
        return this.archiveService;
    }
}

