/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.images;

import com.mestrelab.images.ImageInfo;
import com.mestrelab.images.exception.ImageException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextMeasurer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class ImageTools {
    private static List<BufferedImage> GetPDFImages(byte[] data) throws ImageException {
        try {
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            PDDocument document = PDDocument.load((InputStream)bis);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage image = pdfRenderer.renderImage(i);
                images.add(image);
            }
            document.close();
            bis.close();
            return images;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean FillFileContent(String fileName, byte[] fileContent, String fileExtension) throws ImageException {
        if (fileName == null || fileExtension == null || fileContent == null) {
            return false;
        }
        try {
            String filePath = fileName.concat(".").concat(fileExtension);
            try (FileOutputStream stream = new FileOutputStream(filePath);){
                stream.write(fileContent);
            }
            return true;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] GetFileContent(File file) throws IOException, ImageException {
        if (file == null) {
            return null;
        }
        byte[] res = null;
        try {
            FileInputStream is = new FileInputStream(file);
            res = IOUtils.toByteArray((InputStream)is);
            ((InputStream)is).close();
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
        return res;
    }

    public static void ImageToPath(String imageName, String imageExtension, BufferedImage image) throws ImageException {
        if (imageName == null || imageExtension == null || image == null) {
            return;
        }
        try {
            File outFile = new File(imageName + "." + imageExtension);
            ImageIO.write((RenderedImage)image, imageExtension, outFile);
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ImageToPath(String imageName, String imageExtension, byte[] data) throws ImageException {
        if (imageName == null || imageExtension == null || data == null) {
            return;
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File(String.format("%s.%s", imageName, imageExtension)), (byte[])data);
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ImageToPath(URI imageUri, byte[] data) throws ImageException {
        if (imageUri == null || data == null) {
            return;
        }
        try {
            FileUtils.writeByteArrayToFile((File)new File(imageUri), (byte[])data);
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static BufferedImage AdjustImageSize(BufferedImage image, int widthBase, int heightBase) throws ImageException {
        int height = Math.max(heightBase, image.getHeight());
        int width = Math.max(widthBase, image.getWidth());
        try {
            BufferedImage combined = new BufferedImage(width, height, 2);
            Graphics g = combined.getGraphics();
            g.drawImage(image, (width - image.getWidth()) / 2, (height - image.getHeight()) / 2, null);
            g.dispose();
            return combined;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static BufferedImage GenerateTextImage(String text) throws ImageException {
        if (text == null) {
            text = " ";
        }
        try {
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D g2d = img.createGraphics();
            Font font = new Font("Arial", 1, 13);
            g2d.setFont(font);
            FontMetrics fm = g2d.getFontMetrics();
            int width = fm.stringWidth(text.replace("^", ""));
            int height = fm.getHeight();
            g2d.dispose();
            img = new BufferedImage(width + 5, height, 2);
            g2d = img.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setFont(font);
            fm = g2d.getFontMetrics();
            g2d.setColor(Color.BLACK);
            g2d.drawString(text, 0, fm.getAscent());
            g2d.dispose();
            return img;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static BufferedImage GenerateHTMLTextImage(String text) throws ImageException {
        if (text == null) {
            text = " ";
        }
        try {
            AttributedString as = ImageTools.GenerateTextIndex(text);
            as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D g2d = img.createGraphics();
            Font font = new Font("Arial", 1, 13);
            g2d.setFont(font);
            FontMetrics fm = g2d.getFontMetrics();
            AttributedCharacterIterator characterIterator = as.getIterator();
            FontRenderContext fontRenderContext = g2d.getFontRenderContext();
            TextMeasurer tm = new TextMeasurer(characterIterator, fontRenderContext);
            int height = fm.getHeight() + 5;
            int width = (int)Math.ceil(tm.getLayout(0, characterIterator.getEndIndex()).getBounds().getWidth());
            width += (int)Math.ceil((double)width / 5.0);
            g2d.dispose();
            img = new BufferedImage(width, height, 2);
            g2d = img.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setFont(font);
            fm = g2d.getFontMetrics();
            g2d.setColor(Color.BLACK);
            g2d.drawString(as.getIterator(), 0, fm.getAscent());
            g2d.dispose();
            return img;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static AttributedString GenerateTextIndex(String text) throws ImageException {
        try {
            int i;
            Pattern p = Pattern.compile("((\\^\\d+\\^)?[A-Z][a-z]*\\d*)");
            Matcher m = p.matcher(text);
            ArrayList<Integer> supStart = new ArrayList<Integer>();
            ArrayList<Integer> supEnd = new ArrayList<Integer>();
            ArrayList<Integer> subStart = new ArrayList<Integer>();
            ArrayList<Integer> subEnd = new ArrayList<Integer>();
            while (m.find()) {
                String element;
                String group;
                int end;
                int start;
                if (m.group().contains("^")) {
                    String element2;
                    start = m.start();
                    end = m.end();
                    group = m.group();
                    String superindex = group.substring(group.indexOf("^") + 1, group.lastIndexOf("^"));
                    String rest = group.substring(group.lastIndexOf("^") + 1);
                    String subindex = rest.substring(rest.lastIndexOf(element2 = rest.split("\\d+")[0]) + element2.length());
                    if (subindex != null && !subindex.isEmpty()) {
                        supEnd.add(start + superindex.length() - supStart.size() * 2);
                        supStart.add(start - supStart.size() * 2);
                        subStart.add(start + element2.length() + superindex.length() + 2 - supStart.size() * 2);
                        subEnd.add(end - supStart.size() * 2);
                        continue;
                    }
                    supEnd.add(start + superindex.length() - supStart.size() * 2);
                    supStart.add(start - supStart.size() * 2);
                    continue;
                }
                start = m.start();
                end = m.end();
                group = m.group();
                String subindex = group.substring(group.lastIndexOf(element = group.split("\\d+")[0]) + element.length());
                if (subindex == null || subindex.isEmpty()) continue;
                subStart.add(start + element.length() - supStart.size() * 2);
                subEnd.add(end - supStart.size() * 2);
            }
            AttributedString as = new AttributedString(text.replace("^", ""));
            for (i = 0; i < supStart.size(); ++i) {
                as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, (Integer)supStart.get(i), (Integer)supEnd.get(i));
            }
            for (i = 0; i < subStart.size(); ++i) {
                as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, (Integer)subStart.get(i), (Integer)subEnd.get(i));
            }
            return as;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ConvertImage(BufferedImage bufferedImage) throws ImageException {
        try {
            if (bufferedImage == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String formatName = ImageInfo.GetFormatName(bufferedImage);
            ImageIO.write((RenderedImage)bufferedImage, formatName, baos);
            byte[] res = baos.toByteArray();
            baos.flush();
            baos.close();
            return res;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ConvertImage(BufferedImage bufferedImage, String formatName) throws ImageException {
        try {
            if (bufferedImage == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, formatName, baos);
            byte[] res = baos.toByteArray();
            baos.flush();
            baos.close();
            return res;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static BufferedImage applyVerticalPadding(BufferedImage image, Integer fixedHeight) {
        if (image == null || fixedHeight <= 0) {
            return image;
        }
        if (image.getHeight() >= fixedHeight) {
            return image;
        }
        int padding = Math.round((fixedHeight - image.getHeight()) / 2);
        BufferedImage res = new BufferedImage(image.getWidth(), fixedHeight, 2);
        Graphics g = res.getGraphics();
        int offset = fixedHeight - padding - image.getHeight();
        g.drawImage(image, 0, offset, null);
        g.dispose();
        return res;
    }

    public static BufferedImage ConvertImage(byte[] imageByteContent) throws ImageException {
        try {
            if (imageByteContent == null) {
                return null;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(imageByteContent);
            return ImageIO.read(in);
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }
}

