/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.images;

import com.mestrelab.images.ImageInfo;
import com.mestrelab.images.exception.ImageException;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ImageResizer {
    public static void ResizeFromPathToPath(String inImagePath, String outImagePath, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (inImagePath == null || inImagePath.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image path: '%s'", inImagePath));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            File inputFile = new File(inImagePath);
            BufferedImage inputImage = ImageIO.read(inputFile);
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            String formatName = outImagePath.substring(outImagePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)outputImage, formatName, new File(outImagePath));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromPathToBinary(String inImagePath, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (inImagePath == null || inImagePath.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image path: '%s'", inImagePath));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            File inputFile = new File(inImagePath);
            BufferedImage inputImage = ImageIO.read(inputFile);
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outputImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromPathToBase64(String inImagePath, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (inImagePath == null || inImagePath.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image path: '%s'", inImagePath));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            if (ImageResizer.ResizeFromPathToBinary(inImagePath, fileFormat, scaledWidth, scaledHeight) == null) {
                return null;
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromPathToBinary(inImagePath, fileFormat, scaledWidth, scaledHeight));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ResizeFromPathToPath(String inImagePath, String outImagePath, double percent) throws ImageException {
        try {
            if (inImagePath == null || inImagePath.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image path: '%s'", inImagePath));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            File inputFile = new File(inImagePath);
            BufferedImage inputImage = ImageIO.read(inputFile);
            int scaledWidth = (int)((double)inputImage.getWidth() * percent);
            int scaledHeight = (int)((double)inputImage.getHeight() * percent);
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            String formatName = outImagePath.substring(outImagePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)outputImage, formatName, new File(outImagePath));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromPathToBinary(String inImagePath, String fileFormat, double percent) throws ImageException {
        try {
            if (inImagePath == null || inImagePath.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image path: '%s'", inImagePath));
            }
            File inputFile = new File(inImagePath);
            BufferedImage inputImage = ImageIO.read(inputFile);
            int scaledWidth = (int)((double)inputImage.getWidth() * percent);
            int scaledHeight = (int)((double)inputImage.getHeight() * percent);
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outputImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromPathToBase64(String inImagePath, String fileFormat, double percent) throws ImageException {
        try {
            if (inImagePath == null || inImagePath.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image path: '%s'", inImagePath));
            }
            if (ImageResizer.ResizeFromPathToBinary(inImagePath, fileFormat, percent) == null) {
                return null;
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromPathToBinary(inImagePath, fileFormat, percent));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromFileToBinary(File inputFile, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (inputFile == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image '%s'", inputFile.getName()));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            BufferedImage inputImage = ImageIO.read(inputFile);
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outputImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromFileToBase64(File inputFile, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (inputFile == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image '%s'", inputFile.getName()));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromFileToBinary(inputFile, fileFormat, scaledWidth, scaledHeight));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromFileToBinary(File inputFile, String fileFormat, double percent) throws ImageException {
        try {
            if (inputFile == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image '%s'", inputFile.getName()));
            }
            BufferedImage inputImage = ImageIO.read(inputFile);
            int scaledWidth = (int)((double)inputImage.getWidth() * percent);
            int scaledHeight = (int)((double)inputImage.getHeight() * percent);
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outputImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromFileToBase64(File inputFile, String fileFormat, double percent) throws ImageException {
        try {
            if (inputFile == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image '%s'", inputFile.getName()));
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromFileToBinary(inputFile, fileFormat, percent));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ResizeFromBufferToPath(BufferedImage inputImage, String outImagePath, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (inputImage == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input buffered image", new Object[0]));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            String formatName = outImagePath.substring(outImagePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)outputImage, formatName, new File(outImagePath));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromBufferToBinary(BufferedImage inputImage, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (inputImage == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input buffered image", new Object[0]));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outputImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromBufferToBase64(BufferedImage inputImage, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (inputImage == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input buffered image", new Object[0]));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromBufferToBinary(inputImage, fileFormat, scaledWidth, scaledHeight));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ResizeFromBufferToPath(BufferedImage inputImage, String outImagePath, double percent) throws ImageException {
        try {
            if (inputImage == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input buffered image", new Object[0]));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            int scaledWidth = (int)((double)inputImage.getWidth() * percent);
            int scaledHeight = (int)((double)inputImage.getHeight() * percent);
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            String formatName = outImagePath.substring(outImagePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)outputImage, formatName, new File(outImagePath));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromBufferToBinary(BufferedImage inputImage, String fileFormat, double percent) throws ImageException {
        try {
            if (inputImage == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input buffered image", new Object[0]));
            }
            int scaledWidth = (int)((double)inputImage.getWidth() * percent);
            int scaledHeight = (int)((double)inputImage.getHeight() * percent);
            BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
            Graphics2D g2d = outputImage.createGraphics();
            g2d.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outputImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromBufferToBase64(BufferedImage inputImage, String fileFormat, double percent) throws ImageException {
        try {
            if (inputImage == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input buffered image", new Object[0]));
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromBufferToBinary(inputImage, fileFormat, percent));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ResizeFromBinaryToPath(byte[] contentBinary, String outImagePath, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (contentBinary == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize to '%s' file not performed [not content received]", outImagePath));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            ByteArrayInputStream in = new ByteArrayInputStream(contentBinary);
            BufferedImage inImage = ImageIO.read(in);
            BufferedImage outImage = new BufferedImage(scaledWidth, scaledHeight, inImage.getType());
            Graphics2D g2d = outImage.createGraphics();
            g2d.drawImage(inImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            String formatName = outImagePath.substring(outImagePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)outImage, formatName, new File(outImagePath));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromBinaryToBinary(byte[] contentBinary, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (contentBinary == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Resize not performed [not content received]", new Object[0]));
            }
            if (fileFormat == null || fileFormat.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Resize not performed [wrong file format '%s']", fileFormat));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            ByteArrayInputStream in = new ByteArrayInputStream(contentBinary);
            BufferedImage inImage = ImageIO.read(in);
            BufferedImage outImage = new BufferedImage(scaledWidth, scaledHeight, inImage.getType());
            Graphics2D g2d = outImage.createGraphics();
            g2d.drawImage(inImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromBinaryToBase64(byte[] contentBinary, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (contentBinary == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Resize not performed [not content received]", new Object[0]));
            }
            if (fileFormat == null || fileFormat.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Resize not performed [wrong file format '%s']", fileFormat));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromBinaryToBinary(contentBinary, fileFormat, scaledWidth, scaledHeight));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ResizeFromBinaryToPath(byte[] contentBinary, String outImagePath, double percent) throws ImageException {
        try {
            if (contentBinary == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize to '%s' file not performed [not content received]", outImagePath));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            ByteArrayInputStream in = new ByteArrayInputStream(contentBinary);
            BufferedImage inImage = ImageIO.read(in);
            int scaledWidth = (int)((double)inImage.getWidth() * percent);
            int scaledHeight = (int)((double)inImage.getHeight() * percent);
            BufferedImage outImage = new BufferedImage(scaledWidth, scaledHeight, inImage.getType());
            Graphics2D g2d = outImage.createGraphics();
            g2d.drawImage(inImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            String formatName = outImagePath.substring(outImagePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)outImage, formatName, new File(outImagePath));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromBinaryToBinary(byte[] contentBinary, String fileFormat, double percent) throws ImageException {
        try {
            if (contentBinary == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize not performed [not content received]", new Object[0]));
            }
            if (fileFormat == null || fileFormat.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize not performed [wrong file format '%s']", fileFormat));
            }
            ByteArrayInputStream in = new ByteArrayInputStream(contentBinary);
            BufferedImage inImage = ImageIO.read(in);
            int scaledWidth = (int)((double)inImage.getWidth() * percent);
            int scaledHeight = (int)((double)inImage.getHeight() * percent);
            BufferedImage outImage = new BufferedImage(scaledWidth, scaledHeight, inImage.getType());
            Graphics2D g2d = outImage.createGraphics();
            g2d.drawImage(inImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromBinaryToBase64(byte[] contentBinary, String fileFormat, double percent) throws ImageException {
        try {
            if (contentBinary == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize not performed [not content received]", new Object[0]));
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromBinaryToBinary(contentBinary, fileFormat, percent));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ResizeFromBase64ToPath(String contentBase64, String outImagePath, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (contentBase64 == null || contentBase64.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Resize to '%s' file not performed [not content received]", outImagePath));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((String)contentBase64));
            BufferedImage inImage = ImageIO.read(in);
            BufferedImage outImage = new BufferedImage(scaledWidth, scaledHeight, inImage.getType());
            Graphics2D g2d = outImage.createGraphics();
            g2d.drawImage(inImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            String formatName = outImagePath.substring(outImagePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)outImage, formatName, new File(outImagePath));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromBase64ToBase64(String contentBase64, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (contentBase64 == null || contentBase64.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize not performed [not content received]", new Object[0]));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            return Base64.encodeBase64String((byte[])ImageResizer.ResizeFromBase64ToBinary(contentBase64, fileFormat, scaledWidth, scaledHeight));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromBase64ToBinary(String contentBase64, String fileFormat, int scaledWidth, int scaledHeight) throws ImageException {
        try {
            if (contentBase64 == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Resize not performed [not content received]", new Object[0]));
            }
            if (fileFormat == null || fileFormat.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize not performed [wrong file format '%s']", fileFormat));
            }
            if (!ImageInfo.CheckDimension(scaledWidth, scaledHeight)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong scaling dimensions for given image [%d x %s]", scaledWidth, scaledHeight));
            }
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((String)contentBase64));
            BufferedImage inImage = ImageIO.read(in);
            BufferedImage outImage = new BufferedImage(scaledWidth, scaledHeight, inImage.getType());
            Graphics2D g2d = outImage.createGraphics();
            g2d.drawImage(inImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outImage, fileFormat, baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static void ResizeFromBase64ToPath(String contentBase64, String outImagePath, double percent) throws ImageException {
        try {
            if (contentBase64 == null || contentBase64.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize to '%s' file not performed [not content received]", outImagePath));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((String)contentBase64));
            BufferedImage inImage = ImageIO.read(in);
            int scaledWidth = (int)((double)inImage.getWidth() * percent);
            int scaledHeight = (int)((double)inImage.getHeight() * percent);
            BufferedImage outImage = new BufferedImage(scaledWidth, scaledHeight, inImage.getType());
            Graphics2D g2d = outImage.createGraphics();
            g2d.drawImage(inImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            String formatName = outImagePath.substring(outImagePath.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)outImage, formatName, new File(outImagePath));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String ResizeFromBase64ToBase64(String contentBase64, String fileFormat, double percent) throws ImageException {
        try {
            if (contentBase64 == null || contentBase64.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize not performed [not content received]", new Object[0]));
            }
            if (fileFormat == null || fileFormat.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize not performed [wrong file format '%s']", fileFormat));
            }
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((String)contentBase64));
            BufferedImage inImage = ImageIO.read(in);
            int scaledWidth = (int)((double)inImage.getWidth() * percent);
            int scaledHeight = (int)((double)inImage.getHeight() * percent);
            BufferedImage outImage = new BufferedImage(scaledWidth, scaledHeight, inImage.getType());
            Graphics2D g2d = outImage.createGraphics();
            g2d.drawImage(inImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outImage, fileFormat, baos);
            baos.flush();
            return Base64.encodeBase64String((byte[])baos.toByteArray());
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] ResizeFromBase64ToBinary(String contentBase64, String fileFormat, double percent) throws ImageException {
        try {
            if (contentBase64 == null || contentBase64.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Percent resize to '%s' file not performed [not content received]", new Object[0]));
            }
            return Base64.decodeBase64((String)ImageResizer.ResizeFromBase64ToBase64(contentBase64, fileFormat, percent));
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    private static BufferedImage Scale(BufferedImage sbi, int dWidth, int dHeight, double fWidth, double fHeight) throws ImageException {
        try {
            BufferedImage dbi = null;
            if (sbi != null) {
                dbi = new BufferedImage(dWidth, dHeight, sbi.getType());
                Graphics2D g = dbi.createGraphics();
                AffineTransform at = AffineTransform.getScaleInstance(fWidth, fHeight);
                g.drawRenderedImage(sbi, at);
                g.dispose();
            }
            return dbi;
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    private static BufferedImage Rotate(BufferedImage sbi) throws ImageException {
        try {
            BufferedImage rotated = null;
            if (sbi != null) {
                int width = sbi.getWidth();
                int height = sbi.getHeight();
                rotated = new BufferedImage(height, width, sbi.getType());
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        rotated.setRGB(y, width - x - 1, sbi.getRGB(x, y));
                    }
                }
            }
            return rotated;
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }
}

