/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.images;

import com.mestrelab.images.exception.ImageException;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class ImageManager {
    public static BufferedImage MergeHorizontalImages(BufferedImage left, BufferedImage right) throws ImageException {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        try {
            int w = left.getWidth() + right.getWidth();
            int h = left.getHeight() > right.getHeight() ? left.getHeight() : right.getHeight();
            BufferedImage combined = new BufferedImage(w, h, 2);
            Graphics g = combined.getGraphics();
            g.drawImage(left, 0, 0, null);
            g.drawImage(right, left.getWidth(), 0, null);
            return combined;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static BufferedImage MergeVerticalImages(BufferedImage up, BufferedImage down) throws ImageException {
        if (up == null && down == null) {
            return null;
        }
        if (up == null) {
            return down;
        }
        if (down == null) {
            return up;
        }
        try {
            int w = up.getWidth() > down.getWidth() ? up.getWidth() : down.getWidth();
            int h = up.getHeight() + down.getHeight();
            BufferedImage combined = new BufferedImage(w, h, 2);
            Graphics g = combined.getGraphics();
            if (up.getWidth() > down.getWidth()) {
                g.drawImage(up, 0, 0, null);
                g.drawImage(down, up.getWidth() / 2 - down.getWidth() / 2, up.getHeight(), null);
            } else {
                g.drawImage(up, down.getWidth() / 2 - up.getWidth() / 2, 0, null);
                g.drawImage(down, 0, up.getHeight(), null);
            }
            return combined;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static BufferedImage Rotate(BufferedImage sbi) throws ImageException {
        try {
            BufferedImage rotated = null;
            if (sbi != null) {
                int width = sbi.getWidth();
                int height = sbi.getHeight();
                rotated = new BufferedImage(height, width, sbi.getType());
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        rotated.setRGB(y, width - x - 1, sbi.getRGB(x, y));
                    }
                }
            }
            return rotated;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }
}

