/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.images;

import com.mestrelab.images.common.ImageType;
import com.mestrelab.images.exception.ImageException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.codec.binary.Base64;

public class ImageInfo {
    private static String GetImageFormat(String flFormat) throws ImageException {
        if (flFormat == null || flFormat.isEmpty()) {
            return null;
        }
        try {
            if (flFormat.trim().toLowerCase().startsWith("image/")) {
                return flFormat.trim().toLowerCase().substring(flFormat.trim().toLowerCase().indexOf("/") + 1);
            }
            return flFormat;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static int GetImageWidth(byte[] imageContent) throws IOException, ImageException {
        if (imageContent == null) {
            return 0;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(imageContent);
            BufferedImage bi = ImageIO.read(in);
            return bi.getWidth();
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static int GetImageWidth(String imageContent) throws IOException, ImageException {
        if (imageContent == null || imageContent.isEmpty()) {
            return 0;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((String)imageContent));
            BufferedImage bi = ImageIO.read(in);
            return bi.getWidth();
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static int GetImageHeight(byte[] imageContent) throws IOException, ImageException {
        if (imageContent == null) {
            return 0;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(imageContent);
            BufferedImage bi = ImageIO.read(in);
            return bi.getHeight();
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static int GetImageHeight(String imageContent) throws IOException, ImageException {
        if (imageContent == null || imageContent.isEmpty()) {
            return 0;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((String)imageContent));
            BufferedImage bi = ImageIO.read(in);
            return bi.getHeight();
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String GetImageMimeType(InputStream is) throws ImageException {
        try {
            String mimeType = "";
            int c1 = is.read();
            int c2 = is.read();
            int c3 = is.read();
            int c4 = is.read();
            if (c1 == 71 && c2 == 73 && c3 == 70) {
                mimeType = "image/gif";
            } else if (c1 == 255 && c2 == 216) {
                mimeType = "image/jpeg";
            } else if (c1 == 137 && c2 == 80 && c3 == 78) {
                mimeType = "image/png";
            } else if (c1 == 66 && c2 == 77) {
                mimeType = "image/bmp";
            } else if (c1 == 77 && c2 == 77 && c3 == 0 && c4 == 42 || c1 == 73 && c2 == 73 && c3 == 42 && c4 == 0) {
                mimeType = "image/tiff";
            }
            return mimeType;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static ImageType ImageType(InputStream is) throws ImageException {
        try {
            int c1 = is.read();
            int c2 = is.read();
            int c3 = is.read();
            int c4 = is.read();
            if (c1 == 71 && c2 == 73 && c3 == 70) {
                return ImageType.GIF;
            }
            if (c1 == 255 && c2 == 216) {
                return ImageType.JPG;
            }
            if (c1 == 137 && c2 == 80 && c3 == 78) {
                return ImageType.PNG;
            }
            if (c1 == 66 && c2 == 77) {
                return ImageType.BMP;
            }
            if (c1 == 77 && c2 == 77 && c3 == 0 && c4 == 42 || c1 == 73 && c2 == 73 && c3 == 42 && c4 == 0) {
                return ImageType.TIFF;
            }
            return ImageType.NOT_SUPPORTED;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static boolean isJPG(String imagePath) throws ImageException {
        try {
            if (imagePath == null || imagePath.isEmpty()) {
                return false;
            }
            String imageExtension = imagePath.substring(imagePath.lastIndexOf(".") + 1);
            if (imageExtension == null || imageExtension.isEmpty()) {
                return false;
            }
            return imageExtension.trim().toLowerCase().equals("jpg") || imageExtension.trim().toLowerCase().equals("jpeg");
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String GetExtension(String imagePath) throws ImageException {
        if (imagePath == null || imagePath.isEmpty()) {
            return "";
        }
        try {
            return imagePath.substring(imagePath.lastIndexOf(".") + 1);
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static int GetImageSize(String imagePath) throws ImageException {
        try {
            if (imagePath == null) {
                return 0;
            }
            File inputFile = new File(imagePath);
            return new Long(inputFile.length()).intValue();
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static int GetImageSize(Path filePath) throws ImageException {
        try {
            if (filePath == null) {
                return 0;
            }
            File inputFile = new File(filePath.toUri());
            return new Long(inputFile.length()).intValue();
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static Integer GetImageCompressionLevel(String imagePath) throws ImageException {
        try {
            File inputFile = new File(imagePath);
            BufferedImage inputImage = ImageIO.read(inputFile);
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("jpeg");
            ImageReader reader = it.next();
            ImageReadParam readParam = reader.getDefaultReadParam();
            return 0;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static boolean CheckWith(int width) {
        return width >= 0;
    }

    public static boolean CheckHeight(int height) {
        return height >= 0;
    }

    public static boolean CheckDimension(int width, int height) {
        return width >= 0 && height >= 0;
    }

    public static String GetFormatName(File imageFile) throws ImageException {
        if (imageFile == null) {
            return "";
        }
        try {
            String formatName = "";
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(imageFile);
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
            if (!imageReaders.hasNext()) {
                throw new RuntimeException("No readers found!");
            }
            ImageReader reader = imageReaders.next();
            formatName = reader.getFormatName();
            imageInputStream.close();
            return formatName;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String GetFormatName(BufferedImage bufferedImage) throws ImageException {
        if (bufferedImage == null) {
            return "";
        }
        try {
            String formatName = "";
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(bufferedImage);
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
            if (!imageReaders.hasNext()) {
                throw new RuntimeException("No readers found!");
            }
            ImageReader reader = imageReaders.next();
            formatName = reader.getFormatName();
            imageInputStream.close();
            return formatName;
        }
        catch (Exception ex) {
            throw new ImageException("ImageTools", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }
}

