/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.images;

import com.mestrelab.images.ImageInfo;
import com.mestrelab.images.ImageTools;
import com.mestrelab.images.exception.ImageException;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.apache.commons.io.FileUtils;

public class ImageCompressor {
    public static boolean UpdateCompressionFromPathToPath(String inImagePath, String outImagePath, Float compressionLevel) throws ImageException {
        try {
            if (inImagePath == null || inImagePath.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image path: '%s'", inImagePath));
            }
            if (outImagePath == null || outImagePath.isEmpty()) {
                outImagePath = "";
            }
            if (!ImageInfo.isJPG(inImagePath)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image extension: '%s'", ImageInfo.GetExtension(inImagePath)));
            }
            if (!ImageInfo.isJPG(outImagePath) && ImageInfo.isJPG(inImagePath)) {
                outImagePath = outImagePath.concat(".jpg");
            }
            if (compressionLevel.floatValue() < 0.0f || compressionLevel.floatValue() > 1.0f) {
                compressionLevel = Float.valueOf(0.7f);
            }
            File inputFile = new File(inImagePath);
            byte[] fileContent = ImageTools.GetFileContent(inputFile);
            byte[] compressedFileContent = ImageCompressor.UpdateCompressionFromBinaryToBinary(fileContent, compressionLevel);
            FileUtils.writeByteArrayToFile((File)new File(outImagePath), (byte[])compressedFileContent);
            return true;
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] UpdateCompressionFromPathToBinary(String inImagePath, Float compressionLevel) throws ImageException {
        try {
            if (inImagePath == null || inImagePath.isEmpty()) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image path: '%s'", inImagePath));
            }
            if (!ImageInfo.isJPG(inImagePath)) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong input image extension: '%s'", ImageInfo.GetExtension(inImagePath)));
            }
            if (compressionLevel.floatValue() < 0.0f || compressionLevel.floatValue() > 1.0f) {
                compressionLevel = Float.valueOf(0.7f);
            }
            File inputFile = new File(inImagePath);
            byte[] fileContent = ImageTools.GetFileContent(inputFile);
            return ImageCompressor.UpdateCompressionFromBinaryToBinary(fileContent, compressionLevel);
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static byte[] UpdateCompressionFromBinaryToBinary(byte[] contentBinary, Float compressionLevel) throws ImageException {
        try {
            if (contentBinary == null) {
                throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), String.format("Wrong image content", new Object[0]));
            }
            if (compressionLevel.floatValue() < 0.0f || compressionLevel.floatValue() > 1.0f) {
                compressionLevel = Float.valueOf(0.5f);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(contentBinary);
            BufferedImage inputImage = ImageIO.read(in);
            Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = it.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(compressionLevel.floatValue());
            File outFile = new File("temp.mbook.jpg");
            FileImageOutputStream output = new FileImageOutputStream(outFile);
            writer.setOutput(output);
            IIOImage image = new IIOImage(inputImage, null, null);
            writer.write(null, image, iwp);
            writer.dispose();
            byte[] res = ImageTools.GetFileContent(outFile);
            return res;
        }
        catch (Exception ex) {
            throw new ImageException("ImageResizer", new Object(){}.getClass().getEnclosingMethod().getName(), ex.getMessage());
        }
    }

    public static String UpdateCompressionFromBinaryToBase64(byte[] contentBinary, Float compressionLevel) throws ImageException {
        return Base64.encode(ImageCompressor.UpdateCompressionFromBinaryToBinary(contentBinary, compressionLevel));
    }

    public static String UpdateCompressionFromBase64toBase64(String contentBase64, Float compressionLevel) throws ImageException {
        byte[] contentBinary = Base64.decode(contentBase64);
        return ImageCompressor.UpdateCompressionFromBinaryToBase64(contentBinary, compressionLevel);
    }
}

