/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.shared.domain.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;

public class JacksonUtil {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String fromObjectToJSON(Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String jsonInString = mapper.writeValueAsString(obj);
            return jsonInString;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Boolean fromObjectToJSON(Object obj, String fileName) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue(new File(fileName), obj);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T> T fromString(String string, Class<T> clazz) {
        try {
            OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return (T)OBJECT_MAPPER.readValue(string, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value: " + string + " cannot be transformed to Json object");
        }
    }

    public static String toString(Object value) {
        try {
            OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value: " + value + " cannot be transformed to a String");
        }
    }

    public static JsonNode toJsonNode(String value) {
        try {
            return OBJECT_MAPPER.readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T clone(T value) {
        return (T)JacksonUtil.fromString(JacksonUtil.toString(value), value.getClass());
    }
}

