/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.shared.domain.tools;

import com.mestrelab.eln.shared.domain.base.SharedObject;
import com.mestrelab.shared.domain.base.SharedTO;
import com.mestrelab.shared.domain.tools.exceptions.DomainOperationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DomainTools {
    public static Object BuildBaseTO(Object sourceView, Class targetClass) throws DomainOperationException {
        if (sourceView == null || targetClass == null) {
            throw new DomainOperationException("Wrong parameters", "NULL parameters provided", new Object(){}.getClass().getEnclosingMethod().getName());
        }
        return DomainTools.BuildTO(sourceView, targetClass, true);
    }

    public static Object BuildFastTO(Object sourceView, Class targetClass) throws DomainOperationException {
        if (sourceView == null || targetClass == null) {
            throw new DomainOperationException("Wrong parameters", "NULL parameters provided", new Object(){}.getClass().getEnclosingMethod().getName());
        }
        return DomainTools.BuildTO(sourceView, targetClass, false);
    }

    public static Object BuildTO(Object sourceView, Class targetClass, boolean fast) throws DomainOperationException {
        try {
            if (sourceView == null || targetClass == null) {
                throw new DomainOperationException("Wrong parameters", "NULL parameters provided", new Object(){}.getClass().getEnclosingMethod().getName());
            }
            Class<?> sourceClass = sourceView.getClass();
            Class<?> clazz = Class.forName(targetClass.getName());
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object targetObject = constructor.newInstance(new Object[0]);
            List<Field> sourceFields = DomainTools.GetAllFields(sourceClass);
            for (Field f : sourceFields) {
                Object value;
                String fieldName = f.getName();
                if (Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                if (f.getType() == byte[].class) {
                    value = DomainTools.GetValue(sourceView, fieldName);
                    if (value == null) continue;
                    DomainTools.SetValue(targetObject, f.getName(), value, targetClass);
                    continue;
                }
                if (f.getType().isAssignableFrom(List.class) || f.getType().isAssignableFrom(ArrayList.class) || f.getType().isArray() || f.getType().getName().equalsIgnoreCase("java.util.ArrayList")) {
                    if (fast) continue;
                    System.out.println(" - List : " + f.getType().getSimpleName());
                    List listAsObject = (List)DomainTools.GetValue(sourceView, fieldName);
                    if (listAsObject == null) continue;
                    System.out.println(" - - Elements : " + listAsObject.size());
                    if (listAsObject.isEmpty()) continue;
                    System.out.println(" - - Content type : " + listAsObject.get(0).getClass().getName());
                    ArrayList<SharedTO> targetInnerList = new ArrayList<SharedTO>();
                    for (Object currentObject : listAsObject) {
                        SharedTO currentTO = new SharedTO();
                        currentTO.setId((Integer)DomainTools.GetValue(currentObject, "id"));
                        System.out.println(" - - ID : " + currentTO.getId());
                        if (!DomainTools.containsField(currentObject, "id")) continue;
                        targetInnerList.add(currentTO);
                    }
                    DomainTools.SetValue(targetObject, f.getName(), targetInnerList, targetClass);
                    continue;
                }
                if (f.getType().getSimpleName().toLowerCase().contains("view")) {
                    SharedObject innerValue;
                    if (fast || (innerValue = (SharedObject)DomainTools.GetValue(sourceView, fieldName)) == null) continue;
                    String targetFullClass = DomainTools.ResolveInnerTargetClass(targetClass, f);
                    Class<?> clazzInner = Class.forName(targetFullClass);
                    Constructor<?> constructorInner = clazzInner.getConstructor(new Class[0]);
                    SharedTO targetInnerObject = (SharedTO)constructorInner.newInstance(new Object[0]);
                    targetInnerObject.setId(innerValue.getId());
                    DomainTools.SetValue(targetObject, f.getName(), targetInnerObject, targetClass);
                    continue;
                }
                if (f.getType().getSimpleName().contains("TO")) {
                    SharedTO baseTO;
                    if (fast || (baseTO = (SharedTO)DomainTools.GetValue(sourceView, fieldName)) == null) continue;
                    DomainTools.SetValue(targetObject, f.getName(), baseTO.getId(), targetClass);
                    continue;
                }
                value = DomainTools.GetValue(sourceView, fieldName);
                if (value == null) continue;
                DomainTools.SetValue(targetObject, f.getName(), value, targetClass);
            }
            return targetObject;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static boolean containsField(Object object, String fieldName) {
        try {
            if (fieldName == null || object == null) {
                return false;
            }
            for (Field f : DomainTools.GetAllFields(object.getClass())) {
                if (!f.getName().equalsIgnoreCase(fieldName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean SetValue(Object targetInstance, String fieldName, Object fieldValue, Class clazz) throws DomainOperationException {
        try {
            if (clazz != null) {
                Field field = DomainTools.ResolveField(targetInstance, fieldName);
                field.setAccessible(true);
                field.set(targetInstance, fieldValue);
                return true;
            }
            return false;
        }
        catch (IllegalStateException ie) {
            throw new DomainOperationException(String.format("Field %s nof found on class '%s' : %s", fieldName, targetInstance.getClass().getName(), ie.getMessage()), ie.getMessage());
        }
        catch (Exception ex) {
            throw new DomainOperationException(String.format("Error setting value '%s' into field '%s' of type '%s'", fieldValue, fieldName, clazz.getSimpleName()), ex.getMessage());
        }
    }

    public static Object GetValue(Object sourceObject, String fieldName) throws DomainOperationException {
        try {
            Class<?> clazz = sourceObject.getClass();
            if (clazz != null) {
                Field field = DomainTools.ResolveField(clazz, fieldName);
                field.setAccessible(true);
                return field.get(sourceObject);
            }
            throw new DomainOperationException(String.format("Error getting value from field : %s", fieldName), String.format("Wrong class provided for field '%s' : %s", fieldName, clazz.getName()));
        }
        catch (DomainOperationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String ResolveInnerTargetClass(Class targetClass, Field sourceInnerField) {
        try {
            String targetClassName = targetClass.getName();
            String targetPackageName = targetClassName.substring(0, targetClassName.lastIndexOf("."));
            String targetSimpleName = sourceInnerField.getType().getSimpleName().replace("View", "TO");
            return targetPackageName + "." + targetSimpleName;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Field ResolveField(Object obj, String fieldName) throws DomainOperationException {
        try {
            Class<?> current = obj.getClass();
            while (true) {
                try {
                    return current.getDeclaredField(fieldName);
                }
                catch (Exception exception) {
                    if ((current = current.getSuperclass()) != null) continue;
                    throw new DomainOperationException(String.format("Error resolving field : %s", fieldName), String.format("Field '%s' not available for class '%s'", fieldName, current.getName()));
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new DomainOperationException(String.format("Error resolving field : %s", fieldName), String.format("Field '%s' not available for class '%s'", fieldName, obj.getClass().getName()));
        }
    }

    public static Field ResolveField(Class clazz, String fieldName) throws DomainOperationException {
        try {
            Class current = clazz;
            while (true) {
                try {
                    return current.getDeclaredField(fieldName);
                }
                catch (Exception exception) {
                    if ((current = current.getSuperclass()) != null) continue;
                    throw new DomainOperationException(String.format("Error resolving field : %s", fieldName), String.format("Field '%s' not available for class '%s'", fieldName, clazz.getName()));
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new DomainOperationException(String.format("Error resolving field : %s", fieldName), String.format("Field '%s' not available for class '%s'", fieldName, clazz.getName()));
        }
    }

    public static List<Field> GetFields(Class clazz) {
        ArrayList<Field> res = new ArrayList<Field>();
        try {
            while (clazz != null) {
                res.addAll(Arrays.asList(clazz.getDeclaredFields()));
                clazz = clazz.getSuperclass();
            }
            return res;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<Field> GetAllFields(Class clazz) {
        ArrayList<Field> res = new ArrayList<Field>();
        try {
            while (clazz != null) {
                res.addAll(Arrays.asList(clazz.getDeclaredFields()));
                clazz = clazz.getSuperclass();
            }
            return res;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

